# How to contribute to cloud-init

Thank you for wanting to help us improve cloud-init! There are a variety of
ways you can contribute to this project, including no-code and low-code options.
This documentation will help orient you with our processes.

Please make sure that you read this guide before starting to contribute. It
contains all the details you need to know to give your contribution the best
chance of being accepted.

Cloud-init is hosted and managed on [GitHub](https://github.com). If you're not
familiar with how GitHub works, their
[quickstart documentation](https://docs.github.com/en/get-started/quickstart)
provides an excellent introduction to all the tools and processes you'll need
to know.

## Prerequisites

Before you can begin, you will need to:

* Read and agree to abide by our
  [Code of Conduct](https://ubuntu.com/community/code-of-conduct).

* Sign the Canonical
  [contributor license agreement](https://ubuntu.com/legal/contributors). This
  grants us your permission to use your contributions in the project.

* Create (or have) a GitHub account. We will refer to your GitHub username as
  `GH_USER`.

## Getting help

We use IRC and have a dedicated `#cloud-init` channel where you can contact
us for help and guidance. This link will take you directly to our
[IRC channel on Libera](https://kiwiirc.com/nextclient/irc.libera.chat/cloud-init).
Please don't be afraid to reach out if you need help constructing your pull
request.

## Instructions for contributors

The best way to get started is by checking out the
["Development" section](https://cloudinit.readthedocs.io/en/latest/development/index.html)
in our documentation. This covers everything; from how to find issues to work
on, to how cloud-init is structured and useful resources, through to making your
first PR and getting it accepted.
