%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 1997-2011. All Rights Reserved.
%%
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%%
%% %CopyrightEnd%
%%
-module(win32reg_SUITE).

-export([all/0, suite/0,groups/0,init_per_suite/1, end_per_suite/1, 
	 init_per_group/2,end_per_group/2,long/1,evil_write/1]).

-include_lib("test_server/include/test_server.hrl").

suite() -> [{ct_hooks,[ts_install_cth]}].

all() -> 
    [long, evil_write].

groups() -> 
    [].

init_per_group(_GroupName, Config) ->
    Config.

end_per_group(_GroupName, Config) ->
    Config.


init_per_suite(Config) when is_list(Config) ->
    case os:type() of
	{win32, _} ->
	    Config;
	_ ->
	    {skip,"Doesn't run on UNIX."}
    end.
end_per_suite(Config) when is_list(Config) ->
    Config.

long(doc) -> "Test long keys and entries (OTP-3446).";
long(Config) when is_list(Config) ->
    ?line Dog = test_server:timetrap(test_server:seconds(10)),

    ?line LongKey = "software\\" ++
	lists:flatten(lists:duplicate(10, "..\\software\\")) ++
	"Ericsson\\Erlang",
    ?line {ok,Reg} = win32reg:open([read,write]),
    ?line ok = win32reg:change_key(Reg, "\\hklm"),
    ?line ok = win32reg:change_key(Reg, LongKey),
    ?line {ok,ErlangKey} = win32reg:current_key(Reg),
    io:format("Erlang key: ~s", [ErlangKey]),

    %% Write a long value and read it back.
    ?line TestKey = "test_key",
    ?line LongValue = lists:concat(["This is a long value generated by the test case ",?MODULE,":long/1. "|lists:duplicate(128, "a")]),
    ?line ok = win32reg:set_value(Reg, TestKey, LongValue),
    ?line {ok,LongValue} = win32reg:value(Reg, TestKey),

    %% Done.

    ?line ok = win32reg:close(Reg),
    ?line test_server:timetrap_cancel(Dog),
    ok.

evil_write(Config) when is_list(Config) ->
    ?line Dog = test_server:timetrap(test_server:seconds(10)),

    ?line Key = "Software\\Ericsson\\Erlang",
    ?line {ok,Reg} = win32reg:open([read,write]),
    ?line ok = win32reg:change_key(Reg, "\\hklm"),
    ?line ok = win32reg:change_key(Reg, Key),
    ?line {ok,ErlangKey} = win32reg:current_key(Reg),
    io:format("Erlang key: ~s", [ErlangKey]),

    %% Write keys with different length and read it back.
    ?line TestKey = "test_key " ++ lists:duplicate(128, $a),
    evil_write_1(Reg, TestKey),

    %% Done.
    ?line ok = win32reg:close(Reg),
    ?line test_server:timetrap_cancel(Dog),
    ok.

evil_write_1(Reg, [_|[_|_]=Key]=Key0) ->
    ?line io:format("Key = ~p\n", [Key0]),
    ?line ok = win32reg:set_value(Reg, Key0, "A good value for me"),
    ?line {ok,_Val} = win32reg:value(Reg, Key0),
    ?line ok = win32reg:delete_value(Reg, Key0),
    evil_write_1(Reg, Key);
evil_write_1(_, [_]) -> ok.
