package cognitiveservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// KeyName enumerates the values for key name.
type KeyName string

const (
	// Key1 specifies the key 1 state for key name.
	Key1 KeyName = "Key1"
	// Key2 specifies the key 2 state for key name.
	Key2 KeyName = "Key2"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// ComputerVision specifies the computer vision state for kind.
	ComputerVision Kind = "ComputerVision"
	// Emotion specifies the emotion state for kind.
	Emotion Kind = "Emotion"
	// Face specifies the face state for kind.
	Face Kind = "Face"
	// LUIS specifies the luis state for kind.
	LUIS Kind = "LUIS"
	// Recommendations specifies the recommendations state for kind.
	Recommendations Kind = "Recommendations"
	// Speech specifies the speech state for kind.
	Speech Kind = "Speech"
	// TextAnalytics specifies the text analytics state for kind.
	TextAnalytics Kind = "TextAnalytics"
	// WebLM specifies the web lm state for kind.
	WebLM Kind = "WebLM"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating specifies the creating state for provisioning state.
	Creating ProvisioningState = "Creating"
	// Failed specifies the failed state for provisioning state.
	Failed ProvisioningState = "Failed"
	// ResolvingDNS specifies the resolving dns state for provisioning state.
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded specifies the succeeded state for provisioning state.
	Succeeded ProvisioningState = "Succeeded"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// F0 specifies the f0 state for sku name.
	F0 SkuName = "F0"
	// S0 specifies the s0 state for sku name.
	S0 SkuName = "S0"
	// S1 specifies the s1 state for sku name.
	S1 SkuName = "S1"
	// S2 specifies the s2 state for sku name.
	S2 SkuName = "S2"
	// S3 specifies the s3 state for sku name.
	S3 SkuName = "S3"
	// S4 specifies the s4 state for sku name.
	S4 SkuName = "S4"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Free specifies the free state for sku tier.
	Free SkuTier = "Free"
	// Premium specifies the premium state for sku tier.
	Premium SkuTier = "Premium"
	// Standard specifies the standard state for sku tier.
	Standard SkuTier = "Standard"
)

// Account is cognitive Services Account is an Azure resource representing the
// provisioned account, its type, location and SKU.
type Account struct {
	autorest.Response `json:"-"`
	Etag              *string             `json:"etag,omitempty"`
	ID                *string             `json:"id,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Properties        *AccountProperties  `json:"properties,omitempty"`
	Sku               *Sku                `json:"sku,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Type              *string             `json:"type,omitempty"`
}

// AccountCreateParameters is the parameters to provide for the account.
type AccountCreateParameters struct {
	Sku        *Sku                    `json:"sku,omitempty"`
	Kind       Kind                    `json:"kind,omitempty"`
	Location   *string                 `json:"location,omitempty"`
	Tags       *map[string]*string     `json:"tags,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// AccountEnumerateSkusResult is the list of cognitive services accounts
// operation response.
type AccountEnumerateSkusResult struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceAndSku `json:"value,omitempty"`
}

// AccountKeys is the access keys for the cognitive services account.
type AccountKeys struct {
	autorest.Response `json:"-"`
	Key1              *string `json:"key1,omitempty"`
	Key2              *string `json:"key2,omitempty"`
}

// AccountListResult is the list of cognitive services accounts operation
// response.
type AccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Account `json:"value,omitempty"`
}

// AccountProperties is
type AccountProperties struct {
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	Endpoint          *string           `json:"endpoint,omitempty"`
}

// AccountUpdateParameters is the parameters to provide for the account.
type AccountUpdateParameters struct {
	Sku  *Sku                `json:"sku,omitempty"`
	Tags *map[string]*string `json:"tags,omitempty"`
}

// Error is
type Error struct {
	ErrorProperty *ErrorBody `json:"error,omitempty"`
}

// ErrorBody is
type ErrorBody struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// RegenerateKeyParameters is regenerate key parameters.
type RegenerateKeyParameters struct {
	KeyName KeyName `json:"keyName,omitempty"`
}

// ResourceAndSku is
type ResourceAndSku struct {
	ResourceType *string `json:"resourceType,omitempty"`
	Sku          *Sku    `json:"sku,omitempty"`
}

// Sku is the SKU of the cognitive services account.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
	Tier SkuTier `json:"tier,omitempty"`
}
