"""
Test that variables of type integer are displayed correctly.
"""

import AbstractBase

from lldbsuite.test.decorators import *


class IntegerTypesTestCase(AbstractBase.GenericTester):

    mydir = AbstractBase.GenericTester.compute_mydir(__file__)

    def test_int_type(self):
        """Test that int-type variables are displayed correctly."""
        self.build_and_run('int.cpp', set(['int']))

    @skipUnlessDarwin
    def test_int_type_from_block(self):
        """Test that int-type variables are displayed correctly from a block."""
        self.build_and_run('int.cpp', set(['int']))

    def test_unsigned_int_type(self):
        """Test that 'unsigned_int'-type variables are displayed correctly."""
        self.build_and_run('unsigned_int.cpp', set(['unsigned', 'int']))

    @skipUnlessDarwin
    def test_unsigned_int_type_from_block(self):
        """Test that 'unsigned int'-type variables are displayed correctly from a block."""
        self.build_and_run(
            'unsigned_int.cpp', set(['unsigned', 'int']), bc=True)
