; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX1030 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1013 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX1013 %s
; RUN: not --crash llc -global-isel -march=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s -o /dev/null 2>&1 | FileCheck -check-prefix=ERR %s

; uint4 llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(uint node_ptr, float ray_extent, float3 ray_origin, float3 ray_dir, float3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(uint node_ptr, float ray_extent, float3 ray_origin, half3 ray_dir, half3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(ulong node_ptr, float ray_extent, float3 ray_origin, float3 ray_dir, float3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(ulong node_ptr, float ray_extent, float3 ray_origin, half3 ray_dir, half3 ray_inv_dir, uint4 texture_descr)

declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32, float, <3 x float>, <3 x float>, <3 x float>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32, float, <3 x float>, <3 x half>, <3 x half>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64, float, <3 x float>, <3 x float>, <3 x float>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64, float, <3 x float>, <3 x half>, <3 x half>, <4 x i32>)
declare i32 @llvm.amdgcn.workitem.id.x()

define amdgpu_ps <4 x float> @image_bvh_intersect_ray(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh_intersect_ray:
; GCN:       ; %bb.0:
; GCN-NEXT:    image_bvh_intersect_ray v[0:3], v[0:15], s[0:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
; ERR: in function image_bvh_intersect_ray{{.*}}intrinsic not supported on subtarget
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh_intersect_ray_flat(i32 %node_ptr, float %ray_extent, float %ray_origin_x, float %ray_origin_y, float %ray_origin_z, float %ray_dir_x, float %ray_dir_y, float %ray_dir_z, float %ray_inv_dir_x, float %ray_inv_dir_y, float %ray_inv_dir_z, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh_intersect_ray_flat:
; GCN:       ; %bb.0:
; GCN-NEXT:    image_bvh_intersect_ray v[0:3], v[0:15], s[0:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
  %ray_origin0 = insertelement <3 x float> undef, float %ray_origin_x, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float %ray_origin_y, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float %ray_origin_z, i32 2
  %ray_dir0 = insertelement <3 x float> undef, float %ray_dir_x, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float %ray_dir_y, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float %ray_dir_z, i32 2
  %ray_inv_dir0 = insertelement <3 x float> undef, float %ray_inv_dir_x, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float %ray_inv_dir_y, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float %ray_inv_dir_z, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
 %r = bitcast <4 x i32> %v to <4 x float>
 ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh_intersect_ray_a16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh_intersect_ray_a16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s4, 0xffff
; GCN-NEXT:    v_lshrrev_b32_e32 v9, 16, v5
; GCN-NEXT:    v_and_b32_e32 v10, s4, v7
; GCN-NEXT:    v_and_b32_e32 v8, s4, v8
; GCN-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GCN-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GCN-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; GCN-NEXT:    v_and_or_b32 v5, v5, s4, v9
; GCN-NEXT:    v_and_or_b32 v6, v6, s4, v10
; GCN-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[0:3] a16
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh64_intersect_ray:
; GCN:       ; %bb.0:
; GCN-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[0:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray_flat(<2 x i32> %node_ptr_vec, float %ray_extent, float %ray_origin_x, float %ray_origin_y, float %ray_origin_z, float %ray_dir_x, float %ray_dir_y, float %ray_dir_z, float %ray_inv_dir_x, float %ray_inv_dir_y, float %ray_inv_dir_z, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh64_intersect_ray_flat:
; GCN:       ; %bb.0:
; GCN-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[0:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
  %node_ptr = bitcast <2 x i32> %node_ptr_vec to i64
  %ray_origin0 = insertelement <3 x float> undef, float %ray_origin_x, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float %ray_origin_y, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float %ray_origin_z, i32 2
  %ray_dir0 = insertelement <3 x float> undef, float %ray_dir_x, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float %ray_dir_y, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float %ray_dir_z, i32 2
  %ray_inv_dir0 = insertelement <3 x float> undef, float %ray_inv_dir_x, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float %ray_inv_dir_y, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float %ray_inv_dir_z, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
 %r = bitcast <4 x i32> %v to <4 x float>
 ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray_a16(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GCN-LABEL: image_bvh64_intersect_ray_a16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s4, 0xffff
; GCN-NEXT:    v_lshrrev_b32_e32 v10, 16, v6
; GCN-NEXT:    v_and_b32_e32 v11, s4, v8
; GCN-NEXT:    v_and_b32_e32 v9, s4, v9
; GCN-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GCN-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GCN-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; GCN-NEXT:    v_and_or_b32 v6, v6, s4, v10
; GCN-NEXT:    v_and_or_b32 v7, v7, s4, v11
; GCN-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[0:3] a16
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh_intersect_ray_vgpr_descr(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr) {
; GFX1030-LABEL: image_bvh_intersect_ray_vgpr_descr:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    v_mov_b32_e32 v15, v0
; GFX1030-NEXT:    v_mov_b32_e32 v16, v1
; GFX1030-NEXT:    v_mov_b32_e32 v17, v2
; GFX1030-NEXT:    v_mov_b32_e32 v18, v3
; GFX1030-NEXT:    v_mov_b32_e32 v19, v4
; GFX1030-NEXT:    v_mov_b32_e32 v20, v5
; GFX1030-NEXT:    v_mov_b32_e32 v21, v6
; GFX1030-NEXT:    v_mov_b32_e32 v22, v7
; GFX1030-NEXT:    v_mov_b32_e32 v23, v8
; GFX1030-NEXT:    v_mov_b32_e32 v24, v9
; GFX1030-NEXT:    v_mov_b32_e32 v25, v10
; GFX1030-NEXT:    s_mov_b32 s1, exec_lo
; GFX1030-NEXT:  .LBB6_1: ; =>This Inner Loop Header: Depth=1
; GFX1030-NEXT:    v_readfirstlane_b32 s4, v11
; GFX1030-NEXT:    v_readfirstlane_b32 s5, v12
; GFX1030-NEXT:    v_readfirstlane_b32 s6, v13
; GFX1030-NEXT:    v_readfirstlane_b32 s7, v14
; GFX1030-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[11:12]
; GFX1030-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[13:14]
; GFX1030-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1030-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[15:30], s[4:7]
; GFX1030-NEXT:    ; implicit-def: $vgpr11_vgpr12
; GFX1030-NEXT:    ; implicit-def: $vgpr15
; GFX1030-NEXT:    ; implicit-def: $vgpr16
; GFX1030-NEXT:    ; implicit-def: $vgpr17
; GFX1030-NEXT:    ; implicit-def: $vgpr18
; GFX1030-NEXT:    ; implicit-def: $vgpr19
; GFX1030-NEXT:    ; implicit-def: $vgpr20
; GFX1030-NEXT:    ; implicit-def: $vgpr21
; GFX1030-NEXT:    ; implicit-def: $vgpr22
; GFX1030-NEXT:    ; implicit-def: $vgpr23
; GFX1030-NEXT:    ; implicit-def: $vgpr24
; GFX1030-NEXT:    ; implicit-def: $vgpr25
; GFX1030-NEXT:    ; implicit-def: $vgpr11_vgpr12_vgpr13_vgpr14
; GFX1030-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1030-NEXT:    s_cbranch_execnz .LBB6_1
; GFX1030-NEXT:  ; %bb.2:
; GFX1030-NEXT:    s_mov_b32 exec_lo, s1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; GFX1013-LABEL: image_bvh_intersect_ray_vgpr_descr:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    v_mov_b32_e32 v16, v11
; GFX1013-NEXT:    v_mov_b32_e32 v17, v12
; GFX1013-NEXT:    v_mov_b32_e32 v18, v13
; GFX1013-NEXT:    v_mov_b32_e32 v19, v14
; GFX1013-NEXT:    s_mov_b32 s1, exec_lo
; GFX1013-NEXT:  .LBB6_1: ; =>This Inner Loop Header: Depth=1
; GFX1013-NEXT:    v_readfirstlane_b32 s4, v16
; GFX1013-NEXT:    v_readfirstlane_b32 s5, v17
; GFX1013-NEXT:    v_readfirstlane_b32 s6, v18
; GFX1013-NEXT:    v_readfirstlane_b32 s7, v19
; GFX1013-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[16:17]
; GFX1013-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[18:19]
; GFX1013-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1013-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1013-NEXT:    image_bvh_intersect_ray v[20:23], v[0:15], s[4:7]
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17
; GFX1013-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17_vgpr18_vgpr19
; GFX1013-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1013-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1013-NEXT:    s_cbranch_execnz .LBB6_1
; GFX1013-NEXT:  ; %bb.2:
; GFX1013-NEXT:    s_mov_b32 exec_lo, s1
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, v20
; GFX1013-NEXT:    v_mov_b32_e32 v1, v21
; GFX1013-NEXT:    v_mov_b32_e32 v2, v22
; GFX1013-NEXT:    v_mov_b32_e32 v3, v23
; GFX1013-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh_intersect_ray_a16_vgpr_descr(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr) {
; GFX1030-LABEL: image_bvh_intersect_ray_a16_vgpr_descr:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_mov_b32 s0, 0xffff
; GFX1030-NEXT:    v_mov_b32_e32 v13, v0
; GFX1030-NEXT:    v_mov_b32_e32 v14, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v0, 16, v5
; GFX1030-NEXT:    v_and_b32_e32 v1, s0, v7
; GFX1030-NEXT:    v_mov_b32_e32 v15, v2
; GFX1030-NEXT:    v_and_b32_e32 v2, s0, v8
; GFX1030-NEXT:    v_mov_b32_e32 v16, v3
; GFX1030-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1030-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX1030-NEXT:    v_mov_b32_e32 v17, v4
; GFX1030-NEXT:    v_alignbit_b32 v20, v2, v7, 16
; GFX1030-NEXT:    s_mov_b32 s1, exec_lo
; GFX1030-NEXT:    v_and_or_b32 v18, v5, s0, v0
; GFX1030-NEXT:    v_and_or_b32 v19, v6, s0, v1
; GFX1030-NEXT:  .LBB7_1: ; =>This Inner Loop Header: Depth=1
; GFX1030-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1030-NEXT:    v_readfirstlane_b32 s5, v10
; GFX1030-NEXT:    v_readfirstlane_b32 s6, v11
; GFX1030-NEXT:    v_readfirstlane_b32 s7, v12
; GFX1030-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX1030-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[11:12]
; GFX1030-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1030-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[13:20], s[4:7] a16
; GFX1030-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1030-NEXT:    ; implicit-def: $vgpr13
; GFX1030-NEXT:    ; implicit-def: $vgpr14
; GFX1030-NEXT:    ; implicit-def: $vgpr15
; GFX1030-NEXT:    ; implicit-def: $vgpr16
; GFX1030-NEXT:    ; implicit-def: $vgpr17
; GFX1030-NEXT:    ; implicit-def: $vgpr18
; GFX1030-NEXT:    ; implicit-def: $vgpr19
; GFX1030-NEXT:    ; implicit-def: $vgpr20
; GFX1030-NEXT:    ; implicit-def: $vgpr9_vgpr10_vgpr11_vgpr12
; GFX1030-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1030-NEXT:    s_cbranch_execnz .LBB7_1
; GFX1030-NEXT:  ; %bb.2:
; GFX1030-NEXT:    s_mov_b32 exec_lo, s1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; GFX1013-LABEL: image_bvh_intersect_ray_a16_vgpr_descr:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_mov_b32 s0, 0xffff
; GFX1013-NEXT:    v_lshrrev_b32_e32 v13, 16, v5
; GFX1013-NEXT:    v_and_b32_e32 v14, s0, v7
; GFX1013-NEXT:    v_and_b32_e32 v8, s0, v8
; GFX1013-NEXT:    s_mov_b32 s1, exec_lo
; GFX1013-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX1013-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX1013-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; GFX1013-NEXT:    v_and_or_b32 v5, v5, s0, v13
; GFX1013-NEXT:    v_and_or_b32 v6, v6, s0, v14
; GFX1013-NEXT:  .LBB7_1: ; =>This Inner Loop Header: Depth=1
; GFX1013-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1013-NEXT:    v_readfirstlane_b32 s5, v10
; GFX1013-NEXT:    v_readfirstlane_b32 s6, v11
; GFX1013-NEXT:    v_readfirstlane_b32 s7, v12
; GFX1013-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX1013-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[11:12]
; GFX1013-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1013-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1013-NEXT:    image_bvh_intersect_ray v[13:16], v[0:7], s[4:7] a16
; GFX1013-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1013-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX1013-NEXT:    ; implicit-def: $vgpr9_vgpr10_vgpr11_vgpr12
; GFX1013-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1013-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1013-NEXT:    s_cbranch_execnz .LBB7_1
; GFX1013-NEXT:  ; %bb.2:
; GFX1013-NEXT:    s_mov_b32 exec_lo, s1
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, v13
; GFX1013-NEXT:    v_mov_b32_e32 v1, v14
; GFX1013-NEXT:    v_mov_b32_e32 v2, v15
; GFX1013-NEXT:    v_mov_b32_e32 v3, v16
; GFX1013-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray_vgpr_descr(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr) {
; GFX1030-LABEL: image_bvh64_intersect_ray_vgpr_descr:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    v_mov_b32_e32 v16, v0
; GFX1030-NEXT:    v_mov_b32_e32 v17, v1
; GFX1030-NEXT:    v_mov_b32_e32 v18, v2
; GFX1030-NEXT:    v_mov_b32_e32 v19, v3
; GFX1030-NEXT:    v_mov_b32_e32 v20, v4
; GFX1030-NEXT:    v_mov_b32_e32 v21, v5
; GFX1030-NEXT:    v_mov_b32_e32 v22, v6
; GFX1030-NEXT:    v_mov_b32_e32 v23, v7
; GFX1030-NEXT:    v_mov_b32_e32 v24, v8
; GFX1030-NEXT:    v_mov_b32_e32 v25, v9
; GFX1030-NEXT:    v_mov_b32_e32 v26, v10
; GFX1030-NEXT:    v_mov_b32_e32 v27, v11
; GFX1030-NEXT:    s_mov_b32 s1, exec_lo
; GFX1030-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX1030-NEXT:    v_readfirstlane_b32 s4, v12
; GFX1030-NEXT:    v_readfirstlane_b32 s5, v13
; GFX1030-NEXT:    v_readfirstlane_b32 s6, v14
; GFX1030-NEXT:    v_readfirstlane_b32 s7, v15
; GFX1030-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[12:13]
; GFX1030-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[14:15]
; GFX1030-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1030-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[16:31], s[4:7]
; GFX1030-NEXT:    ; implicit-def: $vgpr12_vgpr13
; GFX1030-NEXT:    ; implicit-def: $vgpr16
; GFX1030-NEXT:    ; implicit-def: $vgpr17
; GFX1030-NEXT:    ; implicit-def: $vgpr18
; GFX1030-NEXT:    ; implicit-def: $vgpr19
; GFX1030-NEXT:    ; implicit-def: $vgpr20
; GFX1030-NEXT:    ; implicit-def: $vgpr21
; GFX1030-NEXT:    ; implicit-def: $vgpr22
; GFX1030-NEXT:    ; implicit-def: $vgpr23
; GFX1030-NEXT:    ; implicit-def: $vgpr24
; GFX1030-NEXT:    ; implicit-def: $vgpr25
; GFX1030-NEXT:    ; implicit-def: $vgpr26
; GFX1030-NEXT:    ; implicit-def: $vgpr27
; GFX1030-NEXT:    ; implicit-def: $vgpr12_vgpr13_vgpr14_vgpr15
; GFX1030-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1030-NEXT:    s_cbranch_execnz .LBB8_1
; GFX1030-NEXT:  ; %bb.2:
; GFX1030-NEXT:    s_mov_b32 exec_lo, s1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; GFX1013-LABEL: image_bvh64_intersect_ray_vgpr_descr:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    v_mov_b32_e32 v16, v12
; GFX1013-NEXT:    v_mov_b32_e32 v17, v13
; GFX1013-NEXT:    v_mov_b32_e32 v18, v14
; GFX1013-NEXT:    v_mov_b32_e32 v19, v15
; GFX1013-NEXT:    s_mov_b32 s1, exec_lo
; GFX1013-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX1013-NEXT:    v_readfirstlane_b32 s4, v16
; GFX1013-NEXT:    v_readfirstlane_b32 s5, v17
; GFX1013-NEXT:    v_readfirstlane_b32 s6, v18
; GFX1013-NEXT:    v_readfirstlane_b32 s7, v19
; GFX1013-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[16:17]
; GFX1013-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[18:19]
; GFX1013-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1013-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1013-NEXT:    image_bvh64_intersect_ray v[20:23], v[0:15], s[4:7]
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17
; GFX1013-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17_vgpr18_vgpr19
; GFX1013-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1013-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1013-NEXT:    s_cbranch_execnz .LBB8_1
; GFX1013-NEXT:  ; %bb.2:
; GFX1013-NEXT:    s_mov_b32 exec_lo, s1
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, v20
; GFX1013-NEXT:    v_mov_b32_e32 v1, v21
; GFX1013-NEXT:    v_mov_b32_e32 v2, v22
; GFX1013-NEXT:    v_mov_b32_e32 v3, v23
; GFX1013-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray_a16_vgpr_descr(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr) {
; GFX1030-LABEL: image_bvh64_intersect_ray_a16_vgpr_descr:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_mov_b32 s0, 0xffff
; GFX1030-NEXT:    v_mov_b32_e32 v14, v0
; GFX1030-NEXT:    v_mov_b32_e32 v15, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; GFX1030-NEXT:    v_and_b32_e32 v1, s0, v8
; GFX1030-NEXT:    v_mov_b32_e32 v16, v2
; GFX1030-NEXT:    v_and_b32_e32 v2, s0, v9
; GFX1030-NEXT:    v_mov_b32_e32 v17, v3
; GFX1030-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1030-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX1030-NEXT:    v_mov_b32_e32 v18, v4
; GFX1030-NEXT:    v_mov_b32_e32 v19, v5
; GFX1030-NEXT:    v_alignbit_b32 v22, v2, v8, 16
; GFX1030-NEXT:    v_and_or_b32 v20, v6, s0, v0
; GFX1030-NEXT:    v_and_or_b32 v21, v7, s0, v1
; GFX1030-NEXT:    s_mov_b32 s1, exec_lo
; GFX1030-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX1030-NEXT:    v_readfirstlane_b32 s4, v10
; GFX1030-NEXT:    v_readfirstlane_b32 s5, v11
; GFX1030-NEXT:    v_readfirstlane_b32 s6, v12
; GFX1030-NEXT:    v_readfirstlane_b32 s7, v13
; GFX1030-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[10:11]
; GFX1030-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[12:13]
; GFX1030-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1030-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[14:29], s[4:7] a16
; GFX1030-NEXT:    ; implicit-def: $vgpr10_vgpr11
; GFX1030-NEXT:    ; implicit-def: $vgpr14
; GFX1030-NEXT:    ; implicit-def: $vgpr15
; GFX1030-NEXT:    ; implicit-def: $vgpr16
; GFX1030-NEXT:    ; implicit-def: $vgpr17
; GFX1030-NEXT:    ; implicit-def: $vgpr18
; GFX1030-NEXT:    ; implicit-def: $vgpr19
; GFX1030-NEXT:    ; implicit-def: $vgpr20
; GFX1030-NEXT:    ; implicit-def: $vgpr21
; GFX1030-NEXT:    ; implicit-def: $vgpr22
; GFX1030-NEXT:    ; implicit-def: $vgpr10_vgpr11_vgpr12_vgpr13
; GFX1030-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1030-NEXT:    s_cbranch_execnz .LBB9_1
; GFX1030-NEXT:  ; %bb.2:
; GFX1030-NEXT:    s_mov_b32 exec_lo, s1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; GFX1013-LABEL: image_bvh64_intersect_ray_a16_vgpr_descr:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_mov_b32 s0, 0xffff
; GFX1013-NEXT:    v_mov_b32_e32 v16, v10
; GFX1013-NEXT:    v_mov_b32_e32 v17, v11
; GFX1013-NEXT:    v_lshrrev_b32_e32 v10, 16, v6
; GFX1013-NEXT:    v_and_b32_e32 v11, s0, v8
; GFX1013-NEXT:    v_and_b32_e32 v9, s0, v9
; GFX1013-NEXT:    v_mov_b32_e32 v18, v12
; GFX1013-NEXT:    v_mov_b32_e32 v19, v13
; GFX1013-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX1013-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX1013-NEXT:    v_alignbit_b32 v8, v9, v8, 16
; GFX1013-NEXT:    s_mov_b32 s1, exec_lo
; GFX1013-NEXT:    v_and_or_b32 v6, v6, s0, v10
; GFX1013-NEXT:    v_and_or_b32 v7, v7, s0, v11
; GFX1013-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX1013-NEXT:    v_readfirstlane_b32 s4, v16
; GFX1013-NEXT:    v_readfirstlane_b32 s5, v17
; GFX1013-NEXT:    v_readfirstlane_b32 s6, v18
; GFX1013-NEXT:    v_readfirstlane_b32 s7, v19
; GFX1013-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[16:17]
; GFX1013-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[18:19]
; GFX1013-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX1013-NEXT:    s_and_saveexec_b32 s0, s0
; GFX1013-NEXT:    image_bvh64_intersect_ray v[20:23], v[0:15], s[4:7] a16
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17
; GFX1013-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15
; GFX1013-NEXT:    ; implicit-def: $vgpr16_vgpr17_vgpr18_vgpr19
; GFX1013-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1013-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1013-NEXT:    s_cbranch_execnz .LBB9_1
; GFX1013-NEXT:  ; %bb.2:
; GFX1013-NEXT:    s_mov_b32 exec_lo, s1
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, v20
; GFX1013-NEXT:    v_mov_b32_e32 v1, v21
; GFX1013-NEXT:    v_mov_b32_e32 v2, v22
; GFX1013-NEXT:    v_mov_b32_e32 v3, v23
; GFX1013-NEXT:    ; return to shader part epilog
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

define amdgpu_kernel void @image_bvh_intersect_ray_nsa_reassign(i32* %p_node_ptr, float* %p_ray, <4 x i32> inreg %tdescr) {
; GFX1030-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX1030-NEXT:    v_mov_b32_e32 v6, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v7, 0x40a00000
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0x40c00000
; GFX1030-NEXT:    v_mov_b32_e32 v9, 0x40e00000
; GFX1030-NEXT:    v_mov_b32_e32 v10, 0x41000000
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_mov_b32_e32 v0, s4
; GFX1030-NEXT:    v_mov_b32_e32 v1, s5
; GFX1030-NEXT:    v_mov_b32_e32 v2, s6
; GFX1030-NEXT:    v_mov_b32_e32 v3, s7
; GFX1030-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1030-NEXT:    flat_load_dword v0, v[0:1]
; GFX1030-NEXT:    flat_load_dword v1, v[2:3]
; GFX1030-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[0:15], s[0:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX1013-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v6, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v7, 0x40a00000
; GFX1013-NEXT:    v_mov_b32_e32 v8, 0x40c00000
; GFX1013-NEXT:    v_mov_b32_e32 v9, 0x40e00000
; GFX1013-NEXT:    v_mov_b32_e32 v10, 0x41000000
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, s4
; GFX1013-NEXT:    v_mov_b32_e32 v1, s5
; GFX1013-NEXT:    v_mov_b32_e32 v2, s6
; GFX1013-NEXT:    v_mov_b32_e32 v3, s7
; GFX1013-NEXT:    v_add_co_u32 v4, vcc_lo, v0, v6
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX1013-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX1013-NEXT:    v_mov_b32_e32 v6, 4.0
; GFX1013-NEXT:    flat_load_dword v0, v[4:5]
; GFX1013-NEXT:    flat_load_dword v1, v[2:3]
; GFX1013-NEXT:    v_mov_b32_e32 v2, 0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh_intersect_ray v[0:3], v[0:15], s[8:11]
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_node_ptr = getelementptr inbounds i32, i32* %p_node_ptr, i32 %lid
  %node_ptr = load i32, i32* %gep_node_ptr, align 4
  %gep_ray = getelementptr inbounds float, float* %p_ray, i32 %lid
  %ray_extent = load float, float* %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> undef, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x float> undef, float 3.0, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float 4.0, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x float> undef, float 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float 7.0, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, <4 x i32>* undef
  ret void
}

define amdgpu_kernel void @image_bvh_intersect_ray_a16_nsa_reassign(i32* %p_node_ptr, float* %p_ray, <4 x i32> inreg %tdescr) {
; GFX1030-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX1030-NEXT:    s_movk_i32 s9, 0x4600
; GFX1030-NEXT:    s_movk_i32 s8, 0x4700
; GFX1030-NEXT:    s_bfe_u32 s8, s8, 0x100000
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_mov_b32_e32 v0, s4
; GFX1030-NEXT:    v_mov_b32_e32 v1, s5
; GFX1030-NEXT:    v_mov_b32_e32 v2, s6
; GFX1030-NEXT:    v_mov_b32_e32 v3, s7
; GFX1030-NEXT:    s_movk_i32 s5, 0x4400
; GFX1030-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    s_movk_i32 s6, 0x4200
; GFX1030-NEXT:    flat_load_dword v0, v[0:1]
; GFX1030-NEXT:    flat_load_dword v1, v[2:3]
; GFX1030-NEXT:    s_bfe_u32 s5, s5, 0x100000
; GFX1030-NEXT:    s_movk_i32 s7, 0x4800
; GFX1030-NEXT:    s_bfe_u32 s6, s6, 0x100000
; GFX1030-NEXT:    s_lshl_b32 s5, s5, 16
; GFX1030-NEXT:    s_movk_i32 s4, 0x4500
; GFX1030-NEXT:    s_or_b32 s5, s6, s5
; GFX1030-NEXT:    s_bfe_u32 s6, s9, 0x100000
; GFX1030-NEXT:    s_bfe_u32 s7, s7, 0x100000
; GFX1030-NEXT:    s_bfe_u32 s4, s4, 0x100000
; GFX1030-NEXT:    s_lshl_b32 s6, s6, 16
; GFX1030-NEXT:    s_lshl_b32 s7, s7, 16
; GFX1030-NEXT:    s_or_b32 s4, s4, s6
; GFX1030-NEXT:    s_or_b32 s6, s8, s7
; GFX1030-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1030-NEXT:    v_mov_b32_e32 v5, s5
; GFX1030-NEXT:    v_mov_b32_e32 v6, s4
; GFX1030-NEXT:    v_mov_b32_e32 v7, s6
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[0:3] a16
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX1013-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v6, 2, v0
; GFX1013-NEXT:    s_movk_i32 s1, 0x4400
; GFX1013-NEXT:    s_movk_i32 s2, 0x4200
; GFX1013-NEXT:    s_bfe_u32 s1, s1, 0x100000
; GFX1013-NEXT:    s_movk_i32 s3, 0x4800
; GFX1013-NEXT:    s_bfe_u32 s2, s2, 0x100000
; GFX1013-NEXT:    s_lshl_b32 s1, s1, 16
; GFX1013-NEXT:    s_movk_i32 s0, 0x4500
; GFX1013-NEXT:    s_or_b32 s1, s2, s1
; GFX1013-NEXT:    s_bfe_u32 s3, s3, 0x100000
; GFX1013-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX1013-NEXT:    s_lshl_b32 s3, s3, 16
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, s4
; GFX1013-NEXT:    v_mov_b32_e32 v1, s5
; GFX1013-NEXT:    v_mov_b32_e32 v2, s6
; GFX1013-NEXT:    v_mov_b32_e32 v3, s7
; GFX1013-NEXT:    s_movk_i32 s5, 0x4600
; GFX1013-NEXT:    v_add_co_u32 v4, vcc_lo, v0, v6
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX1013-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX1013-NEXT:    s_movk_i32 s4, 0x4700
; GFX1013-NEXT:    flat_load_dword v0, v[4:5]
; GFX1013-NEXT:    flat_load_dword v1, v[2:3]
; GFX1013-NEXT:    s_bfe_u32 s2, s5, 0x100000
; GFX1013-NEXT:    s_bfe_u32 s4, s4, 0x100000
; GFX1013-NEXT:    s_lshl_b32 s2, s2, 16
; GFX1013-NEXT:    v_mov_b32_e32 v2, 0
; GFX1013-NEXT:    s_or_b32 s0, s0, s2
; GFX1013-NEXT:    s_or_b32 s2, s4, s3
; GFX1013-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, s1
; GFX1013-NEXT:    v_mov_b32_e32 v6, s0
; GFX1013-NEXT:    v_mov_b32_e32 v7, s2
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[8:11] a16
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_node_ptr = getelementptr inbounds i32, i32* %p_node_ptr, i32 %lid
  %node_ptr = load i32, i32* %gep_node_ptr, align 4
  %gep_ray = getelementptr inbounds float, float* %p_ray, i32 %lid
  %ray_extent = load float, float* %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> undef, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x half> undef, half 3.0, i32 0
  %ray_dir1 = insertelement <3 x half> %ray_dir0, half 4.0, i32 1
  %ray_dir = insertelement <3 x half> %ray_dir1, half 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x half> undef, half 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x half> %ray_inv_dir0, half 7.0, i32 1
  %ray_inv_dir = insertelement <3 x half> %ray_inv_dir1, half 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, <4 x i32>* undef
  ret void
}

define amdgpu_kernel void @image_bvh64_intersect_ray_nsa_reassign(float* %p_ray, <4 x i32> inreg %tdescr) {
; GFX1030-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1030-NEXT:    v_mov_b32_e32 v6, 0x40400000
; GFX1030-NEXT:    v_mov_b32_e32 v7, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; GFX1030-NEXT:    v_mov_b32_e32 v9, 0x40c00000
; GFX1030-NEXT:    v_mov_b32_e32 v10, 0x40e00000
; GFX1030-NEXT:    v_mov_b32_e32 v11, 0x41000000
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_mov_b32_e32 v0, s4
; GFX1030-NEXT:    v_mov_b32_e32 v1, s5
; GFX1030-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1030-NEXT:    flat_load_dword v2, v[0:1]
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0xb36211c7
; GFX1030-NEXT:    v_mov_b32_e32 v1, 0x102
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[0:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX1013-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v6, 0x40400000
; GFX1013-NEXT:    v_mov_b32_e32 v7, 4.0
; GFX1013-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; GFX1013-NEXT:    v_mov_b32_e32 v9, 0x40c00000
; GFX1013-NEXT:    v_mov_b32_e32 v10, 0x40e00000
; GFX1013-NEXT:    v_mov_b32_e32 v11, 0x41000000
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, s2
; GFX1013-NEXT:    v_mov_b32_e32 v1, s3
; GFX1013-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1013-NEXT:    flat_load_dword v2, v[0:1]
; GFX1013-NEXT:    v_mov_b32_e32 v0, 0xb36211c7
; GFX1013-NEXT:    v_mov_b32_e32 v1, 0x102
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[4:7]
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_ray = getelementptr inbounds float, float* %p_ray, i32 %lid
  %ray_extent = load float, float* %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> undef, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x float> undef, float 3.0, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float 4.0, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x float> undef, float 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float 7.0, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 1111111111111, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, <4 x i32>* undef
  ret void
}

define amdgpu_kernel void @image_bvh64_intersect_ray_a16_nsa_reassign(float* %p_ray, <4 x i32> inreg %tdescr) {
; GFX1030-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1030-NEXT:    s_movk_i32 s6, 0x4200
; GFX1030-NEXT:    s_movk_i32 s7, 0x4800
; GFX1030-NEXT:    s_bfe_u32 s6, s6, 0x100000
; GFX1030-NEXT:    s_movk_i32 s9, 0x4600
; GFX1030-NEXT:    s_movk_i32 s8, 0x4700
; GFX1030-NEXT:    s_bfe_u32 s7, s7, 0x100000
; GFX1030-NEXT:    s_bfe_u32 s8, s8, 0x100000
; GFX1030-NEXT:    s_lshl_b32 s7, s7, 16
; GFX1030-NEXT:    v_mov_b32_e32 v3, 0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_mov_b32_e32 v0, s4
; GFX1030-NEXT:    v_mov_b32_e32 v1, s5
; GFX1030-NEXT:    s_movk_i32 s5, 0x4400
; GFX1030-NEXT:    s_movk_i32 s4, 0x4500
; GFX1030-NEXT:    s_bfe_u32 s5, s5, 0x100000
; GFX1030-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1030-NEXT:    s_lshl_b32 s5, s5, 16
; GFX1030-NEXT:    s_bfe_u32 s4, s4, 0x100000
; GFX1030-NEXT:    s_or_b32 s5, s6, s5
; GFX1030-NEXT:    flat_load_dword v2, v[0:1]
; GFX1030-NEXT:    s_bfe_u32 s6, s9, 0x100000
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0xb36211c6
; GFX1030-NEXT:    s_lshl_b32 s6, s6, 16
; GFX1030-NEXT:    v_mov_b32_e32 v1, 0x102
; GFX1030-NEXT:    s_or_b32 s4, s4, s6
; GFX1030-NEXT:    s_or_b32 s6, s8, s7
; GFX1030-NEXT:    v_mov_b32_e32 v6, s5
; GFX1030-NEXT:    v_mov_b32_e32 v7, s4
; GFX1030-NEXT:    v_mov_b32_e32 v8, s6
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[0:3] a16
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX1013-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX1013:       ; %bb.0:
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1013-NEXT:    s_movk_i32 s1, 0x4400
; GFX1013-NEXT:    s_movk_i32 s9, 0x4600
; GFX1013-NEXT:    s_bfe_u32 s1, s1, 0x100000
; GFX1013-NEXT:    s_movk_i32 s0, 0x4500
; GFX1013-NEXT:    s_lshl_b32 s1, s1, 16
; GFX1013-NEXT:    s_movk_i32 s8, 0x4700
; GFX1013-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX1013-NEXT:    s_bfe_u32 s8, s8, 0x100000
; GFX1013-NEXT:    v_mov_b32_e32 v3, 0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_mov_b32_e32 v0, s2
; GFX1013-NEXT:    v_mov_b32_e32 v1, s3
; GFX1013-NEXT:    s_movk_i32 s2, 0x4200
; GFX1013-NEXT:    s_movk_i32 s3, 0x4800
; GFX1013-NEXT:    s_bfe_u32 s2, s2, 0x100000
; GFX1013-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX1013-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX1013-NEXT:    s_or_b32 s1, s2, s1
; GFX1013-NEXT:    s_bfe_u32 s2, s9, 0x100000
; GFX1013-NEXT:    s_bfe_u32 s3, s3, 0x100000
; GFX1013-NEXT:    flat_load_dword v2, v[0:1]
; GFX1013-NEXT:    s_lshl_b32 s2, s2, 16
; GFX1013-NEXT:    s_lshl_b32 s3, s3, 16
; GFX1013-NEXT:    s_or_b32 s0, s0, s2
; GFX1013-NEXT:    s_or_b32 s2, s8, s3
; GFX1013-NEXT:    v_mov_b32_e32 v0, 0xb36211c6
; GFX1013-NEXT:    v_mov_b32_e32 v1, 0x102
; GFX1013-NEXT:    v_mov_b32_e32 v6, s1
; GFX1013-NEXT:    v_mov_b32_e32 v7, s0
; GFX1013-NEXT:    v_mov_b32_e32 v8, s2
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:15], s[4:7] a16
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_ray = getelementptr inbounds float, float* %p_ray, i32 %lid
  %ray_extent = load float, float* %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> undef, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x half> undef, half 3.0, i32 0
  %ray_dir1 = insertelement <3 x half> %ray_dir0, half 4.0, i32 1
  %ray_dir = insertelement <3 x half> %ray_dir1, half 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x half> undef, half 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x half> %ray_inv_dir0, half 7.0, i32 1
  %ray_inv_dir = insertelement <3 x half> %ray_inv_dir1, half 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64 1111111111110, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, <4 x i32>* undef
  ret void
}
