/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.AtomicUserDefinedValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements Comparator,
Serializable {
    private Comparator collator;

    public AtomicSortComparer(Comparator comparator) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
    }

    public int compare(Object object, Object object2) {
        if (object instanceof AtomicUserDefinedValue) {
            object = ((AtomicUserDefinedValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicUserDefinedValue) {
            object2 = ((AtomicUserDefinedValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator);
        }
        if (object instanceof DoubleValue && Double.isNaN(((DoubleValue)object).asDouble())) {
            if (object2 instanceof DoubleValue && Double.isNaN(((DoubleValue)object2).asDouble())) {
                return 0;
            }
            return -1;
        }
        if (object2 instanceof DoubleValue && Double.isNaN(((DoubleValue)object2).asDouble())) {
            return 1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ")");
    }

    public boolean comparesEqual(Object object, Object object2) {
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator) == 0;
        }
        if (object2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object2).compareTo(object, this.collator) == 0;
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue()) == 0;
        }
        if (object instanceof String) {
            return this.collator.compare(object, object2) == 0;
        }
        if (object instanceof DoubleValue && Double.isNaN(((DoubleValue)object).asDouble())) {
            return object2 instanceof DoubleValue && Double.isNaN(((DoubleValue)object).asDouble());
        }
        return object.equals(object2);
    }

    public Object getComparisonKey(Object object) {
        if (object instanceof StringValue) {
            if (this.collator instanceof Collator) {
                return ((Collator)this.collator).getCollationKey(((StringValue)object).getStringValue());
            }
            return ((StringValue)object).getStringValue();
        }
        return object;
    }
}

