// Code generated by vfsgen; DO NOT EDIT.

package config

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// internalAssets statically implements the virtual filesystem provided to vfsgen.
var internalAssets = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Date(2020, 2, 21, 10, 39, 16, 951270529, time.UTC),
		},
		"/zsys.conf": &vfsgen۰CompressedFileInfo{
			name:             "zsys.conf",
			modTime:          time.Date(2020, 2, 21, 13, 15, 44, 119110470, time.UTC),
			uncompressedSize: 1018,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x93\x4f\x8b\xdb\x40\x0c\xc5\xef\xfe\x14\x0f\x72\x69\x0f\x2d\xf9\xd3\xdd\x82\x6f\x85\xbd\xb5\x5b\x7a\x28\x94\x1e\x95\xf8\x25\x1e\xe2\x99\x31\x92\x1c\xc8\xb7\x2f\xe3\x38\x4d\xc8\xa6\xd0\xf8\x64\x8f\xf4\x7e\xf3\x24\x59\x6d\x30\xcf\x7a\xac\x2b\x60\x86\xaf\x64\x0f\x71\x74\x14\x73\x24\x4c\x41\x30\xb9\x1e\xd1\x53\x31\xa4\xe0\xc8\x5b\x78\x88\x44\xd8\x82\x29\x0f\xbb\x76\x3c\x69\x19\x21\x4a\xf4\x4a\x63\xf2\x11\xf8\xb3\x25\xb2\x36\x54\x6c\x72\x6a\x82\x87\x9c\x4a\x22\xd6\xc3\x66\x4f\x87\xb9\xa8\x43\x52\x03\xa6\x06\x8d\x38\x0d\xef\xb6\x9a\x23\x62\x36\x87\x72\xc3\xe4\xf0\x8c\xdc\x35\x34\x7f\x5f\x01\xbb\xcd\x28\x92\xad\x53\x6b\x2c\x2a\x60\x4f\xf6\x9d\x98\xd7\x58\xce\x31\xc3\x6b\x48\x21\x0e\x11\x69\x88\x6b\x6a\x71\x36\x61\x2c\x49\x6f\x6d\x76\x2b\xc0\x22\xfa\x38\x5a\x04\xf0\x01\x49\x22\x6b\x5c\x3f\x5f\xd6\xc1\x55\xf4\x38\x86\xa6\xfa\x26\xdb\x67\x19\xa6\x6f\xbb\x52\x7e\xff\x7b\xeb\x14\x43\x3e\x50\x47\x71\x48\x4e\x3d\x48\x77\x2b\xef\x98\x76\xde\x9e\x18\xdf\xc6\xf7\x22\xa7\x6c\xda\x73\x9b\x42\x42\x23\x47\xbb\x08\x4d\x62\xdf\xd1\x7a\xea\x29\xa3\xbe\xba\xb7\x11\x17\xe3\xa5\xca\xa2\xbe\x82\x8d\x2d\xd4\xa1\xa3\x95\x91\x5f\x6a\xff\xa1\x3c\x84\x3c\xd8\x8b\x1c\xab\x9b\xe2\x16\xd5\x3d\xbb\xe7\xd3\xb7\x5e\x56\x77\xc1\xbf\xc8\xfd\x2d\xf9\xe9\x41\xf2\xe2\x2e\xf9\x35\x27\x6f\x6f\xd1\x9f\xee\xa2\x3f\x3f\x88\xfe\x4d\xd1\x37\xed\x58\xde\x45\xaf\xe6\x0f\xb2\x97\x05\x6e\xff\xd7\xec\xd5\xf3\xd3\x3f\xe9\xcb\x6a\xc7\x44\x95\xae\x0c\xb4\xec\x65\x1e\xbc\xc6\xf3\x7c\x4c\x9f\xe1\x45\x18\xcb\xd6\x9d\x02\xe5\x6f\x30\x96\x65\xb4\x3f\x01\x00\x00\xff\xff\x12\xae\xc0\xe3\xfa\x03\x00\x00"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/zsys.conf"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
