/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatchSite;
import org.broadinstitute.sting.commandline.ArgumentMatchStringValue;
import org.broadinstitute.sting.commandline.ArgumentMatchValue;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.walkers.Multiplexer;

public class ArgumentMatch
implements Iterable<ArgumentMatch> {
    public final ArgumentDefinition definition;
    public final String label;
    public final SortedMap<ArgumentMatchSite, List<ArgumentMatchValue>> sites = new TreeMap<ArgumentMatchSite, List<ArgumentMatchValue>>();
    public final Tags tags;

    public ArgumentMatch() {
        this(null, null);
    }

    private ArgumentMatch(String label, ArgumentDefinition definition) {
        this.label = label;
        this.definition = definition;
        this.tags = new Tags();
    }

    public ArgumentMatch(String label, ArgumentDefinition definition, ArgumentMatchSite site, Tags tags) {
        this(label, definition, site, null, tags);
    }

    private ArgumentMatch(String label, ArgumentDefinition definition, ArgumentMatchSite site, ArgumentMatchValue value, Tags tags) {
        this.label = label;
        this.definition = definition;
        ArrayList<ArgumentMatchValue> values = new ArrayList<ArgumentMatchValue>();
        if (value != null) {
            values.add(value);
        }
        this.sites.put(site, values);
        this.tags = tags;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArgumentMatch)) {
            return false;
        }
        ArgumentMatch otherArgumentMatch = (ArgumentMatch)other;
        return this.definition.equals(otherArgumentMatch.definition) && this.label.equals(otherArgumentMatch.label) && this.sites.equals(otherArgumentMatch.sites) && this.tags.equals(otherArgumentMatch.tags);
    }

    ArgumentMatch transform(Multiplexer multiplexer, Object key) {
        TreeMap newIndices = new TreeMap();
        for (Map.Entry<ArgumentMatchSite, List<ArgumentMatchValue>> site : this.sites.entrySet()) {
            ArrayList<ArgumentMatchStringValue> newEntries = new ArrayList<ArgumentMatchStringValue>();
            for (ArgumentMatchValue entry : site.getValue()) {
                newEntries.add(new ArgumentMatchStringValue(multiplexer.transformArgument(key, entry.asString())));
            }
            newIndices.put(site.getKey(), newEntries);
        }
        ArgumentMatch newArgumentMatch = new ArgumentMatch(this.label, this.definition);
        newArgumentMatch.sites.putAll(newIndices);
        return newArgumentMatch;
    }

    public String toString() {
        return this.label;
    }

    @Override
    public Iterator<ArgumentMatch> iterator() {
        return new Iterator<ArgumentMatch>(){
            private Iterator<ArgumentMatchSite> siteIterator = null;
            private Iterator<ArgumentMatchValue> tokenIterator = null;
            ArgumentMatchSite nextSite = null;
            ArgumentMatchValue nextToken = null;
            {
                this.siteIterator = ArgumentMatch.this.sites.keySet().iterator();
                this.prepareNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextToken != null;
            }

            @Override
            public ArgumentMatch next() {
                if (this.nextSite == null || this.nextToken == null) {
                    throw new IllegalStateException("No more ArgumentMatches are available");
                }
                ArgumentMatch match = new ArgumentMatch(ArgumentMatch.this.label, ArgumentMatch.this.definition, this.nextSite, this.nextToken, ArgumentMatch.this.tags);
                this.prepareNext();
                return match;
            }

            private void prepareNext() {
                if (this.tokenIterator != null && this.tokenIterator.hasNext()) {
                    this.nextToken = this.tokenIterator.next();
                } else {
                    this.nextSite = null;
                    this.nextToken = null;
                    while (this.siteIterator.hasNext()) {
                        this.nextSite = this.siteIterator.next();
                        if (ArgumentMatch.this.sites.get(this.nextSite) == null) continue;
                        this.tokenIterator = ((List)ArgumentMatch.this.sites.get(this.nextSite)).iterator();
                        if (!this.tokenIterator.hasNext()) continue;
                        this.nextToken = this.tokenIterator.next();
                        break;
                    }
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an argument match from the collection while iterating.");
            }
        };
    }

    public void mergeInto(ArgumentMatch other) {
        this.sites.putAll(other.sites);
    }

    public void addValue(ArgumentMatchSite site, ArgumentMatchValue value) {
        if (!this.sites.containsKey(site) || this.sites.get(site) == null) {
            this.sites.put(site, new ArrayList());
        }
        ((List)this.sites.get(site)).add(value);
    }

    public boolean hasValueAtSite(ArgumentMatchSite site) {
        return this.sites.get(site) != null && ((List)this.sites.get(site)).size() >= 1 || this.isArgumentFlag();
    }

    public List<ArgumentMatchValue> values() {
        ArrayList<ArgumentMatchValue> values = new ArrayList<ArgumentMatchValue>();
        for (ArgumentMatchSite site : this.sites.keySet()) {
            if (this.sites.get(site) == null) continue;
            values.addAll((Collection)this.sites.get(site));
        }
        return values;
    }

    private boolean isArgumentFlag() {
        return this.definition != null && this.definition.isFlag;
    }
}

