/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArrayAssert
extends ArrayAssert<short[]> {
    protected ShortArrayAssert(short ... actual) {
        super(actual);
    }

    public ShortArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public ShortArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public ShortArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ShortArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ShortArrayAssert contains(short ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public ShortArrayAssert containsOnly(short ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public ShortArrayAssert excludes(short ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    private void validateIsNotNull(short[] values) {
        if (values == null) {
            throw new NullPointerException(this.formattedErrorMessage("the given array of shorts should not be null"));
        }
    }

    public ShortArrayAssert satisfies(Condition<short[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ShortArrayAssert doesNotSatisfy(Condition<short[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ShortArrayAssert is(Condition<short[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public ShortArrayAssert isNot(Condition<short[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ShortArrayAssert isNotNull() {
        this.assertThatActualIsNotNull();
        return this;
    }

    public ShortArrayAssert isNotEmpty() {
        this.assertThatActualIsNotEmpty();
        return this;
    }

    public ShortArrayAssert isEqualTo(short[] expected) {
        if (Arrays.equals((short[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ShortArrayAssert isNotEqualTo(short[] array) {
        if (!Arrays.equals((short[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public ShortArrayAssert hasSize(int expected) {
        this.assertThatActualHasSize(expected);
        return this;
    }

    public ShortArrayAssert isSameAs(short[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ShortArrayAssert isNotSameAs(short[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    public ShortArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

