/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCallConfig {
    public static final String DEFAULT_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
    private String serviceName;
    private String servicePackage;
    private String serviceUrl;
    private String serviceVersion;
    private String httpMethod;
    private String action;
    private String sigVersion;
    private String namespace;
    private String soapVersion = "1.2";
    private Boolean sslEncryptionOnly = false;
    private String privateSecretReference;
    private String publicSecretReference;
    private String userAgent = null;
    private int timeout = 10;
    private Map<String, String> parameters = null;

    public final String getServiceUrl() {
        return this.serviceUrl;
    }

    public final void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        if (StringUtils.notEmpty(this.serviceUrl) && serviceUrl.charAt(serviceUrl.length() - 1) == '/') {
            this.serviceUrl = this.serviceUrl.substring(0, serviceUrl.length() - 1);
        }
    }

    public final String getServiceVersion() {
        return this.serviceVersion;
    }

    public final void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public final String getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public final String getAction() {
        return this.action;
    }

    public final void setAction(String action) {
        this.action = action;
    }

    public final String getSigVersion() {
        return this.sigVersion;
    }

    public final void setSigVersion(String sigVersion) {
        this.sigVersion = sigVersion;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public final boolean getSslEncryptionOnly() {
        return this.sslEncryptionOnly;
    }

    public final void setSslEncryptionOnly(boolean sslEncryptionOnly) {
        this.sslEncryptionOnly = sslEncryptionOnly;
    }

    public final String getSoapVersion() {
        return this.soapVersion;
    }

    public final void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public final String getPrivateSecretReference() {
        return this.privateSecretReference;
    }

    public final void setPrivateSecretReference(String privateSecretReference) {
        this.privateSecretReference = privateSecretReference;
    }

    public final String getPublicSecretReference() {
        return this.publicSecretReference;
    }

    public final void setPublicSecretReference(String publicSecretReference) {
        this.publicSecretReference = publicSecretReference;
    }

    public final String getUserAgent() {
        if (this.userAgent == null) {
            return DEFAULT_USER_AGENT;
        }
        return this.userAgent;
    }

    public final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public final Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        return this.parameters;
    }

    public final void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public final String getServicePackage() {
        return this.servicePackage;
    }

    public final void setServicePackage(String servicePackage) {
        this.servicePackage = servicePackage;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int timeoutSeconds) {
        this.timeout = (int)TimeUnit.SECONDS.toMillis(timeoutSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Service URL       : " + this.serviceUrl + "\n");
        sb.append("Service version   : " + this.serviceVersion + "\n");
        sb.append("Service name      : " + this.serviceName + "\n");
        sb.append("Service package   : " + this.servicePackage + "\n");
        sb.append("Action            : " + this.action + "\n");
        sb.append("Signature version : " + this.sigVersion + "\n");
        sb.append("Namespace         : " + this.namespace + "\n");
        sb.append("SSL encrypt only  : " + this.sslEncryptionOnly + "\n");
        sb.append("Private key       : " + this.privateSecretReference + "\n");
        sb.append("Public key        : " + this.publicSecretReference + "\n");
        sb.append("User agent        : " + this.userAgent + "\n");
        sb.append("Connection timeout: " + this.timeout + "\n");
        sb.append("Parameters:\n");
        sb.append(StringUtils.printMap(this.parameters));
        return sb.toString();
    }
}

