/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_ProcessorProcessorCoreAccess.h"

int CPU_OpenDRIM_ProcessorProcessorCore_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(CPU_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_ManagedElement_unload(errorMessage));
	CF_assert(CPU_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_isAssociated(const Instance& PartComponent, const Instance& GroupComponent, bool& isAssociated, string& errorMessage) {
	_E_;
	// Determine if the association can be established or not
	isAssociated=false;
	string processor_device_id;
	string core_instance_id;
	GroupComponent.getProperty("DeviceID", processor_device_id);
	PartComponent.getProperty("InstanceID", core_instance_id);
	
	// processor DeviceID must be numerical
	if (!CF_isNumber(processor_device_id))
		return OK;
	unsigned int _processor_device_id = atoll(processor_device_id.c_str());
	
	// processor core InstanceID must contain 2 numerical values seperated by ':'
	vector<string> core_instance_id_elements;
	CF_splitText(core_instance_id_elements, core_instance_id, ':');
	if (core_instance_id_elements.size() != 2)
		return OK;
	if (!CF_isNumber(core_instance_id_elements[0]) || !CF_isNumber(core_instance_id_elements[1]))
		return OK;
	unsigned int first_core_instance_id_element = atoll(core_instance_id_elements[0].c_str());
	
	// the first element of the core InstanceID must match the processor DeviceID
	if (first_core_instance_id_element == _processor_device_id)
		isAssociated=true;
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorProcessorCore>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumeratePartComponents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumeratePartComponents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		CPU_OpenDRIM_ProcessorProcessorCore_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			PartComponent_classnames[0], GroupComponent_classnames[0],
			PartComponent_role.c_str(), GroupComponent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_referencePartComponentToGroupComponent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorProcessorCore& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath PartComponent_objectpath;
	instance.getPartComponent(PartComponent_objectpath);
	Instance PartComponent_instance;
	CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_getPartComponent(broker, ctx, PartComponent_objectpath, PartComponent_instance, NULL, errorMessage));
	
	Objectpath GroupComponent_objectpath;
	instance.getGroupComponent(GroupComponent_objectpath);
	Instance GroupComponent_instance;
	CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_getGroupComponent(broker, ctx, GroupComponent_objectpath, GroupComponent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_isAssociated(PartComponent_instance, GroupComponent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorProcessorCore& newInstance, const OpenDRIM_ProcessorProcessorCore& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorProcessorCore_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorProcessorCore& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorProcessorCore_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorProcessorCore& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorProcessorCore_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> GroupComponent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<GroupComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_isAssociated(PartComponent_instance, GroupComponent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			GroupComponent_associatedInstances.push_back(GroupComponent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> PartComponent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<PartComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_ProcessorProcessorCore_isAssociated(PartComponent_instances[i], GroupComponent_instance, isAssociated, errorMessage));
		if (isAssociated)
			PartComponent_associatedInstances.push_back(PartComponent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ProcessorProcessorCore>& OpenDRIM_ProcessorProcessorCore_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < GroupComponent_instances.size(); i++) {
		OpenDRIM_ProcessorProcessorCore instance;
		instance.setPartComponent(((Instance) PartComponent_instance).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instances[i]).getObjectpath());
		
		OpenDRIM_ProcessorProcessorCore_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ProcessorProcessorCore>& OpenDRIM_ProcessorProcessorCore_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < PartComponent_instances.size(); i++) {
		OpenDRIM_ProcessorProcessorCore instance;
		instance.setPartComponent(((Instance) PartComponent_instances[i]).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instance).getObjectpath());
		
		OpenDRIM_ProcessorProcessorCore_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorProcessorCore_populate(OpenDRIM_ProcessorProcessorCore& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

