/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:54:32 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GenbankStreamSequence_ESTest extends GenbankStreamSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      genbankStreamSequence0.writeToStream(charArrayWriter0);
      assertEquals("BASE COUNT        0 a      0 c      0 g      0 t\nORIGIN\n", charArrayWriter0.toString());
      assertEquals(56, charArrayWriter0.size());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("\nORIGIN\n");
      genbankStreamSequence0.setHeader("\nORIGIN\n");
      String string0 = genbankStreamSequence0.getHeader();
      assertEquals("\nORIGIN\n", string0);
      assertEquals(8, genbankStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Could not open sequence dictionary file: ");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      assertEquals(2, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("u$PcDPr}&)");
      // Undeclared exception!
      try { 
        genbankStreamSequence0.writeToStream((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      double[] doubleArray0 = new double[5];
      SymbolList symbolList0 = DoubleAlphabet.fromArray(doubleArray0);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(symbolList0);
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence(bioJavaSequence0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.BioJavaSequence cannot be cast to uk.ac.sanger.artemis.io.StreamSequence
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Genbank sequence data should begin with \"BASE COUNT\" or \"ORIGIN\"");
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      genbankStreamSequence0.writeToStream(charArrayWriter0);
      assertEquals(147, charArrayWriter0.size());
      assertEquals("BASE COUNT        3 a      1 c      1 g      2 t\nORIGIN\n        1 nnnbanknsn nunncnndat anshnundnb ngnnnwnthn nnnnnnnnnn nnnnrnnnnn\n       61 nnnn\n", charArrayWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      char[] charArray0 = new char[7];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 2402);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Genbank sequence data should begin with \"BASE COUNT\" or \"ORIGIN\"
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Genbank sequence data should begin with \"BASE COUNT\" or \"ORIGIN\"");
      int int0 = genbankStreamSequence0.getFormatType();
      assertEquals(2, int0);
      assertEquals(1, genbankStreamSequence0.getCCount());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(fastaStreamSequence0);
      // Undeclared exception!
      try { 
        genbankStreamSequence0.readHeader((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(" g");
      String string0 = genbankStreamSequence0.getHeader();
      assertNull(string0);
      assertEquals(1, genbankStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }
}
