/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.netbeans.apitest.SigtestCheck;
import org.netbeans.apitest.SigtestHandler;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public final class SigtestGenerate
extends AbstractMojo {
    @Component
    private MavenProject prj;
    @Component
    private MavenProjectHelper helper;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classes;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.sigfile")
    private File sigfile;
    @Parameter(defaultValue="")
    private String packages;
    @Parameter(defaultValue="true")
    private boolean attach;
    private String version;

    public SigtestGenerate() {
    }

    SigtestGenerate(MavenProject prj, File classes, File sigfile, String packages, String version) {
        this.prj = prj;
        this.classes = classes;
        this.sigfile = sigfile;
        this.packages = packages;
        this.version = version;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packages == null) {
            this.getLog().info((CharSequence)"No packages specified, skipping sigtest:generate");
            return;
        }
        if (this.sigfile == null) {
            throw new MojoExecutionException("Specify <sigfile>path-to-file-generated-before</sigfile> in plugin config section!");
        }
        if (this.classes == null || !this.classes.exists()) {
            throw new MojoExecutionException("Point <classes>to-directory-with-classfiles-to-test</classes> in plugin config section!");
        }
        SigtestHandler handler = new SigtestHandler(){

            protected String getPackages() {
                return SigtestGenerate.this.packages;
            }

            protected File getFileName() {
                return SigtestGenerate.this.sigfile;
            }

            protected String getAction() {
                return "generate";
            }

            protected String getVersion() {
                return SigtestGenerate.this.prj.getVersion();
            }

            protected String[] getClasspath() {
                return SigtestCheck.projectClassPath(SigtestGenerate.this.prj, SigtestGenerate.this.classes);
            }

            protected File getReport() {
                return null;
            }

            protected String getMail() {
                return null;
            }

            protected Boolean isFailOnError() {
                return null;
            }

            protected void logInfo(String message) {
                SigtestGenerate.this.getLog().info((CharSequence)message);
            }

            protected void logError(String message) {
                SigtestGenerate.this.getLog().error((CharSequence)message);
            }
        };
        try {
            int returnCode = handler.execute();
            if (returnCode != 0) {
                throw new MojoFailureException("Signature check for " + this.sigfile + " failed with " + returnCode);
            }
            this.getLog().info((CharSequence)("Signature snapshot generated at " + this.sigfile));
            if (this.sigfile.exists() && this.attach) {
                this.helper.attachArtifact(this.prj, "sigfile", this.sigfile);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

