//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Common/IntensityDataPropertyWidget.h
//! @brief     Defines class IntensityDataPropertyWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_COMMON_INTENSITYDATAPROPERTYWIDGET_H
#define BORNAGAIN_GUI_VIEW_COMMON_INTENSITYDATAPROPERTYWIDGET_H

#include "GUI/View/Common/DataPropertyWidget.h"

//! Widget to edit properties of an IntensityDataItem.

class IntensityDataPropertyWidget : public DataPropertyWidget {
    Q_OBJECT
public:
    explicit IntensityDataPropertyWidget(QWidget* parent = nullptr);

    void setFourierItem(IntensityDataItem* fftItem) override;

private:
    void unsubscribe();
    void createPanelElements() override;
};

#endif // BORNAGAIN_GUI_VIEW_COMMON_INTENSITYDATAPROPERTYWIDGET_H
