//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/ScientificSpinBox.h
//! @brief     Defines class ScientificSpinBox
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_NUMERIC_SCIENTIFICSPINBOX_H
#define BORNAGAIN_GUI_VIEW_NUMERIC_SCIENTIFICSPINBOX_H

#include <QAbstractSpinBox>

class ScientificSpinBox : public QAbstractSpinBox {
    Q_OBJECT
    Q_PROPERTY(double value MEMBER m_value READ value WRITE setValue NOTIFY valueChanged USER true)
public:
    ScientificSpinBox(QWidget* parent = nullptr, bool easyScrollable = false);
    ~ScientificSpinBox() override;

    double value() const;
    void setValue(double val);

    double singleStep() const;
    void setSingleStep(double step);

    double minimum() const;
    void setMinimum(double min);

    double maximum() const;
    void setMaximum(double max);

    void setDecimals(int);
    int decimals() const;

    void stepBy(int steps) override;
    QValidator::State validate(QString&, int&) const override { return QValidator::Acceptable; }
    void fixup(QString&) const override {}

    static QString toString(double val, int decimal_points);
    static double toDouble(QString text, const QDoubleValidator& validator, double min, double max,
                           double default_value);
    static double round(double val, int decimals);

protected:
    void wheelEvent(QWheelEvent* event) override;

signals:
    void valueChanged(double value);

private:
    QAbstractSpinBox::StepEnabled stepEnabled() const override;

    void updateValue();
    void updateText();
    bool inRange(double val) const;

    double m_value, m_min, m_max;
    double m_step;
    int m_decimals;
    bool m_easyScrollable;
    QDoubleValidator m_validator;
};

#endif // BORNAGAIN_GUI_VIEW_NUMERIC_SCIENTIFICSPINBOX_H
