//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/ExemplarySamples.h
//! @brief     includes all StandardSample headers.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_EXEMPLARYSAMPLES_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_EXEMPLARYSAMPLES_H

class MultiLayer;

#include "Sample/StandardSamples/BoxCompositionBuilder.h"
#include "Sample/StandardSamples/BoxesSquareLatticeBuilder.h"
#include "Sample/StandardSamples/CompoundBuilder.h"
#include "Sample/StandardSamples/CoreAndShellBuilder.h"
#include "Sample/StandardSamples/CustomMorphologyBuilder.h"
#include "Sample/StandardSamples/CylindersAndPrismsBuilder.h"
#include "Sample/StandardSamples/CylindersBuilder.h"
#include "Sample/StandardSamples/FeNiBilayerBuilder.h"
#include "Sample/StandardSamples/HomogeneousMultilayerBuilder.h"
#include "Sample/StandardSamples/LatticeBuilder.h"
#include "Sample/StandardSamples/LayersWithAbsorptionBuilder.h"
#include "Sample/StandardSamples/LayersWithAbsorptionBySLDBuilder.h"
#include "Sample/StandardSamples/MagneticLayersBuilder.h"
#include "Sample/StandardSamples/MagneticParticlesBuilder.h"
#include "Sample/StandardSamples/MesocrystalBuilder.h"
#include "Sample/StandardSamples/MultiLayerWithNCRoughnessBuilder.h"
#include "Sample/StandardSamples/MultipleLayoutBuilder.h"
#include "Sample/StandardSamples/ParacrystalBuilder.h"
#include "Sample/StandardSamples/ParticleDistributionsBuilder.h"
#include "Sample/StandardSamples/ParticleInVacuumBuilder.h"
#include "Sample/StandardSamples/PercusYevickBuilder.h"
#include "Sample/StandardSamples/PlainMultiLayerBySLDBuilder.h"
#include "Sample/StandardSamples/ResonatorBuilder.h"
#include "Sample/StandardSamples/RipplesBuilder.h"
#include "Sample/StandardSamples/RotatedPyramidsBuilder.h"
#include "Sample/StandardSamples/SizeDistributionModelsBuilder.h"
#include "Sample/StandardSamples/SlicedCompositionBuilder.h"
#include "Sample/StandardSamples/SlicedCylindersBuilder.h"
#include "Sample/StandardSamples/ThickAbsorptiveSampleBuilder.h"
#include "Sample/StandardSamples/TransformationsBuilder.h"
#include "Sample/StandardSamples/TwoDimLatticeBuilder.h"

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_EXEMPLARYSAMPLES_H
