/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "PropertyObject.h"

namespace camitk {

// -------------------- Constructor --------------------
PropertyObject::PropertyObject(QString name) : QObject() {
    setObjectName(name);
}

// -------------------- Destructor --------------------
PropertyObject::~PropertyObject() {
    // delete all properties
    foreach(Property* prop, propertiesMap.values())
    delete prop;
    propertiesMap.clear();
}

// -------------------- addProperty --------------------
bool PropertyObject::addProperty(Property *prop) {
    // add to the map
    propertiesMap.insert(prop->getName(), prop);

    // add a dynamic Qt Meta Object property with the same name
    return setProperty(prop->getName().toStdString().c_str(), prop->getInitialValue() );
}

// -------------------- getProperty --------------------
Property* PropertyObject::getProperty(QString name) {
    return propertiesMap.value(name);
}

// -------------------- removeProperty --------------------
void PropertyObject::removeProperty(Property *prop) {
    // remove the given property from the object by setting its value to an invalid variant
    setProperty(prop->getName().toStdString().c_str(), QVariant());
}

}
