/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/

#include <memory.h>
#include <stdio.h>
#include "HashTable.h"
#include "Scanner.h"

namespace Coco {

HashTable::HashTable(int size) {
	this->size = size;
	data = new Obj*[size];
	memset(data, 0, size * sizeof(Obj*));
}

HashTable::~HashTable() {
	for (int i = 0; i < size; ++i) {
		Obj *o = data[i];
		while (o != NULL) {
			Obj *del = o;
			o = o->next;
			delete del;
		}
	}
	delete[] data;
	data = NULL;
};

HashTable::Obj* HashTable::Get0(wchar_t *key) const {
	int k = coco_string_hash(key) % size;
	HashTable::Obj *o = data[k];
	while (o != NULL && !coco_string_equal(key, o->key)) {
		o = o->next;
	}
	return o;
}

void HashTable::Set(wchar_t *key, void *val) {
	HashTable::Obj *o = Get0(key);
	if (o == NULL) {
		// new entry
		int k = coco_string_hash(key) % size;
		o = new Obj();
		o->key = key;
		o->val = val;
		o->next = data[k];
		data[k] = o;		
	} else {
		// exist entry - overwrite
		o->val = val;
	}
}

void* HashTable::Get(wchar_t *key) const {
	HashTable::Obj *o = Get0(key);
	if (o != NULL) {
		return o->val;
	}
	return NULL;
}

Iterator* HashTable::GetIterator() {
	return new HashTable::Iter(this);
}

HashTable::Iter::Iter(HashTable *ht) {
	this->ht = ht;
	this->pos = 0;
	this->cur = NULL;
}

bool HashTable::Iter::HasNext() {
	while (cur == NULL && pos < ht->size) {
		cur = ht->data[pos];
		++pos;
	}
	return cur != NULL;
}

DictionaryEntry* HashTable::Iter::Next() {
	if (!HasNext()) {
		return NULL;
	}
	Obj *next = cur;
	cur = cur->next;
	return next;
}

}; // namespace
