--  Copyright (C) 2002-2003 David Roundy
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; see the file COPYING.  If not, write to
--  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
--  Boston, MA 02110-1301, USA.

{-# OPTIONS_GHC -fno-warn-orphans #-}

module Darcs.Patch
    ( RepoType
    , IsRepoType
    , PrimOf
    , Named
    , WrappedNamed
    , fromPrim
    , fromPrims
    , rmfile
    , addfile
    , rmdir
    , adddir
    , move
    , hunk
    , tokreplace
    , namepatch
    , anonymous
    , binary
    , description
    , showContextPatch
    , ShowPatchFor(..)
    , showPatch
    , displayPatch
    , showNicely
    , infopatch
    , changepref
    , thing
    , things
    , primIsAddfile
    , primIsHunk
    , primIsSetpref
    , merge
    , commute
    , listTouchedFiles
    , hunkMatches
    , forceTokReplace
    , PrimPatch
      -- * for PatchTest
    , resolveConflicts
    , Effect
    , effect
    , primIsBinary
    , primIsAdddir
    , invert
    , invertFL
    , invertRL
    , commuteFL
    , commuteFLorComplain
    , commuteRL
    , readPatch
    , readPatchPartial
    , canonize
    , sortCoalesceFL
    , tryToShrink
    , patchname
    , patchcontents
    , applyToFilePaths
    , apply
    , applyToTree
    , maybeApplyToTree
    , effectOnFilePaths
    , patch2patchinfo
    , summary
    , summaryFL
    , plainSummary
    , xmlSummary
    , plainSummaryPrims
    , adddeps
    , getdeps
    , listConflictedFiles
    , isInconsistent
    , module Darcs.Patch.RepoPatch
    ) where


import Darcs.Patch.Apply ( apply,applyToFilePaths, effectOnFilePaths, applyToTree,
                           maybeApplyToTree )
import Darcs.Patch.Commute ( commute, commuteFL, commuteFLorComplain, commuteRL )
import Darcs.Patch.Conflict ( listConflictedFiles, resolveConflicts )
import Darcs.Patch.Effect ( Effect(effect) )
import Darcs.Patch.Invert ( invert, invertRL, invertFL )
import Darcs.Patch.Inspect ( listTouchedFiles, hunkMatches )
import Darcs.Patch.Merge ( merge )
import Darcs.Patch.Named ( Named,
                           adddeps, namepatch,
                           anonymous,
                           getdeps,
                           infopatch,
                           patch2patchinfo, patchname, patchcontents )
import Darcs.Patch.Named.Wrapped ( WrappedNamed )
import Darcs.Patch.Prim ( fromPrims, fromPrim,
                          canonize,
                          sortCoalesceFL,
                          rmdir, rmfile, tokreplace, adddir, addfile,
                          binary, changepref, hunk, move,
                          primIsAdddir, primIsAddfile,
                          primIsHunk, primIsBinary, primIsSetpref,
                          tryToShrink,
                          PrimPatch, PrimPatchBase(..) )
import Darcs.Patch.Read ( readPatch, readPatchPartial )
import Darcs.Patch.Repair ( isInconsistent )
import Darcs.Patch.RepoPatch ( RepoPatch )
import Darcs.Patch.RepoType ( RepoType, IsRepoType )
import Darcs.Patch.Show ( description, showPatch, showNicely, displayPatch
                        , summary, summaryFL, thing, things, ShowPatchFor(..), ShowContextPatch(..) )
import Darcs.Patch.Summary ( xmlSummary, plainSummary, plainSummaryPrims )
import Darcs.Patch.TokenReplace ( forceTokReplace )
