/*
  xmms - DBMix output plugin

   Description: 
   ============
   This program is an output plugin for xmms v0.9 or greater.
   The plugin allows a data stream to be generated using xmms,
   an to be sent to the DBMix sound daemon for 
   Fourier/Additive Synthesis.  This allows a user may output multiple
   audio streams concurrently to the same audio device.
  

   Original Output Plugin code: (C) 1998-1999 Mikael Alm, Olle Hallnas,
                                Thomas Nillson and 4Front Technologies

   Modifications by Robert Michael S Dean, (c) 1999-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <dlfcn.h>
#include <xmms/configfile.h>

#include <dbaudiolib.h>
#include "dbmixout.h"
#include <dbdebug.h>

/* define cuserid function if it is not defined by stdio.h */
#ifndef __USE_XOPEN
extern char * cuserid (char *__s) __THROW;
#endif

extern int debug_level;
extern gint xmms_session_id;
extern pthread_t msg_thread;

#ifdef DBMIX_DYNAMIC_LIBRARY
DBAudioLibFunctions * dbaudiofxns;
void* dbaudiolib_handle;
#endif

DBMixConfig dbmix_cfg;


void dbmix_init(void)
{
	ConfigFile *cfgfile;
#ifdef DBMIX_DYNAMIC_LIBRARY
	void *(*get_fxns)();
#endif

#ifdef DBMIX_DEBUG
	debug_level = 1;
#else 
	debug_level = 0;
#endif

	/* determine xmms session id */
	{
		struct stat file_stat;
		struct dirent *entry;
		DIR * dir;
		time_t best_time = 0;
		char scanfstr[128];
		char * username;

		username = cuserid(NULL);

		if (username == NULL) perror("getlogin failed");
		
		sprintf(scanfstr,"xmms_%s.",username);
		strcat(scanfstr,"%d");

		if((dir = opendir("/tmp")) == NULL)
		{
			perror("DBMIX OUTPUT PLUGIN ERROR: Could not open /tmp directory. \nTo use dbmix IPC messaging, you must manually configure the xmms session id in the dbmix output plugin configuration dialog.");
		}
		else
		{
			chdir("/tmp");
			while((entry = readdir(dir)) != NULL)
			{
				if(strstr(entry->d_name,"xmms_"))
				{
					stat(entry->d_name,&file_stat);
					if (file_stat.st_ctime > best_time)
					{
						sscanf(entry->d_name,scanfstr,&xmms_session_id);
						best_time = file_stat.st_ctime;
					}
				}
			}
			
			Debug("init: xmms session id is %d\n",xmms_session_id);

			closedir(dir);
		}
	}

	/* read options from xmms config file */
	{
		dbmix_cfg.prebuffer = 25;
		dbmix_cfg.buffer_size = PIPE_BUF;
		dbmix_cfg.close_flag = FALSE;
		strcpy(dbmix_cfg.channel_name,"Xmms");
		
		if ((cfgfile = xmms_cfg_open_default_file()))
		{
			gchar* tempstr;
			
			if (!xmms_cfg_read_int(cfgfile, "DBMIX", "buffer_size", 
								   &dbmix_cfg.buffer_size))
			{
				Debug("reset buffer size");
				dbmix_cfg.buffer_size = 1500;
			}
			
#if CLOSE_FLAG
			if (!xmms_cfg_read_int(cfgfile, "DBMIX", "close_flag", &dbmix_cfg.close_flag))
			{
				Debug("reset close flag");
				dbmix_cfg.close_flag = 0;
			}
#endif
			
			if (xmms_cfg_read_string(cfgfile, "DBMIX", "channel_name", &tempstr))
			{
				strcpy(dbmix_cfg.channel_name,tempstr);
			}
			else
			{
				Debug("reset channel name");
			}
			
			if (!xmms_cfg_read_int(cfgfile, "DBMIX", "buffer_enable", 
								   &dbmix_cfg.buffer_enable))
			{
				Debug("enable buffer flag");
				dbmix_cfg.buffer_enable = 1;
			}

			xmms_cfg_free(cfgfile);
		}
	}

	/* there is a hanging problem with close_flag. Turn off option for now. */
	dbmix_cfg.close_flag = FALSE;

#ifdef DBMIX_DYNAMIC_LIBRARY

	Debug("\nUSING SHARED LIBRARY\n");

	dbaudiofxns = NULL;

	if ((dbaudiolib_handle = dlopen("libdbaudiolib.so",RTLD_NOW)) == NULL) 
	{
		printf("Failed to open DBAudioLib:: %s\n",dlerror());
		return;
	}

	if ((get_fxns = dlsym(dbaudiolib_handle,"DBAudio_Get_Functions")) == NULL)
	{
		printf("Failed to retrieve pointer to DBAudio_Get_Functions: %s\n",dlerror());
		dlclose(dbaudiolib_handle);
		return;
	}
	else
	{
		dbaudiofxns = (DBAudioLibFunctions*)get_fxns();
	}

	if (dbaudiofxns->DBAudio_Ready() == FAILURE) 
	{
		if (dbaudiofxns->DBAudio_Init(dbmix_cfg.channel_name,0,0,2,PIPE_CHANNEL,0) == FAILURE)
		{
			dbaudiofxns->DBAudio_perror("plugin init.c: failed to init dbaudiolib. \nNON FATAL to xmms, but dbmix plugin will not work... \nxmms continuing...  is dbfsd running?\n");
			/* 			exit(-1); */
		}

		dbaudiofxns->DBAudio_Set_Message_Handler(dbmix_message_handler,DBMIX_MESSAGES);
	}
#else
	if (DBAudio_Ready() == FAILURE) 
	{
		if (DBAudio_Init(dbmix_cfg.channel_name,0,0,2,PIPE_CHANNEL,0) == FAILURE)
		{
			DBAudio_perror("plugin init.c: failed to init dbaudiolib. \nNON FATAL to xmms, but dbmix plugin will not work... \nxmms continuing...  is dbfsd running?\n");
			/* 			exit(-1); */
		}

		DBAudio_Set_Message_Handler(dbmix_message_handler,DBMIX_MESSAGES);
	}
#endif

	/* start message handler thread */
#if 0
	pthread_create(&msg_thread, NULL, dbmix_message_handler_loop, NULL);
#else
	gtk_timeout_add(50,dbmix_message_handler_callback,NULL);

#endif

}
