# -*- coding: utf-8 -*-
"""The function module of dolfin"""
from dolfin.fem import form
from dolfin.fem import assembling
from dolfin.fem import norms
from dolfin.fem import projection
from dolfin.fem import interpolation
from dolfin.fem import bcs
from dolfin.fem import formmanipulations

from .form import *
from .assembling import *
from .assembling_local import *
from .solving import *
from .adaptivesolving import *
from .interpolation import *
from .norms import *
from .projection import *
from .bcs import *
from .formmanipulations import *

# NOTE: The automatic documentation system in DOLFIN requires to _not_ define
# NOTE: classes or functions within this file. Use separate modules for that
# NOTE: purpose.

__all__ = form.__all__ + \
          assembling.__all__ + \
          assembling_local.__all__ + \
          solving.__all__ + \
          adaptivesolving.__all__ + \
          norms.__all__ + \
          projection.__all__ + \
          interpolation.__all__ + \
          bcs.__all__ + \
          formmanipulations.__all__
