﻿// <auto-generated />

using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Razor.Language.Legacy;

namespace Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax;

internal abstract partial class RazorBlockSyntax : RazorSyntaxNode
{
    internal RazorBlockSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal RazorBlockSyntax(SyntaxKind kind)
        : base(kind)
    {
    }

    public abstract SyntaxList<RazorSyntaxNode> Children { get; }
}

internal sealed partial class RazorDocumentSyntax : RazorSyntaxNode
{
    internal readonly RazorBlockSyntax _document;
    internal readonly SyntaxToken _endOfFile;

    internal RazorDocumentSyntax(SyntaxKind kind, RazorBlockSyntax document, SyntaxToken endOfFile, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(document);
        _document = document;
        AdjustFlagsAndWidth(endOfFile);
        _endOfFile = endOfFile;
    }

    internal RazorDocumentSyntax(SyntaxKind kind, RazorBlockSyntax document, SyntaxToken endOfFile)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(document);
        _document = document;
        AdjustFlagsAndWidth(endOfFile);
        _endOfFile = endOfFile;
    }

    public RazorBlockSyntax Document => _document;
    public SyntaxToken EndOfFile => _endOfFile;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _document,
            1 => _endOfFile,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.RazorDocumentSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDocument(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDocument(this);

    public RazorDocumentSyntax Update(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        if (document != Document || endOfFile != EndOfFile)
        {
            var newNode = SyntaxFactory.RazorDocument(document, endOfFile);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new RazorDocumentSyntax(Kind, _document, _endOfFile, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RazorDocumentSyntax(Kind, _document, _endOfFile, GetDiagnostics(), annotations);
}

internal sealed partial class RazorCommentBlockSyntax : RazorSyntaxNode
{
    internal readonly SyntaxToken _startCommentTransition;
    internal readonly SyntaxToken _startCommentStar;
    internal readonly SyntaxToken _comment;
    internal readonly SyntaxToken _endCommentStar;
    internal readonly SyntaxToken _endCommentTransition;

    internal RazorCommentBlockSyntax(SyntaxKind kind, SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 5;
        AdjustFlagsAndWidth(startCommentTransition);
        _startCommentTransition = startCommentTransition;
        AdjustFlagsAndWidth(startCommentStar);
        _startCommentStar = startCommentStar;
        AdjustFlagsAndWidth(comment);
        _comment = comment;
        AdjustFlagsAndWidth(endCommentStar);
        _endCommentStar = endCommentStar;
        AdjustFlagsAndWidth(endCommentTransition);
        _endCommentTransition = endCommentTransition;
    }

    internal RazorCommentBlockSyntax(SyntaxKind kind, SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
        : base(kind)
    {
        SlotCount = 5;
        AdjustFlagsAndWidth(startCommentTransition);
        _startCommentTransition = startCommentTransition;
        AdjustFlagsAndWidth(startCommentStar);
        _startCommentStar = startCommentStar;
        AdjustFlagsAndWidth(comment);
        _comment = comment;
        AdjustFlagsAndWidth(endCommentStar);
        _endCommentStar = endCommentStar;
        AdjustFlagsAndWidth(endCommentTransition);
        _endCommentTransition = endCommentTransition;
    }

    public SyntaxToken StartCommentTransition => _startCommentTransition;
    public SyntaxToken StartCommentStar => _startCommentStar;
    public SyntaxToken Comment => _comment;
    public SyntaxToken EndCommentStar => _endCommentStar;
    public SyntaxToken EndCommentTransition => _endCommentTransition;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _startCommentTransition,
            1 => _startCommentStar,
            2 => _comment,
            3 => _endCommentStar,
            4 => _endCommentTransition,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.RazorCommentBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorCommentBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorCommentBlock(this);

    public RazorCommentBlockSyntax Update(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        if (startCommentTransition != StartCommentTransition || startCommentStar != StartCommentStar || comment != Comment || endCommentStar != EndCommentStar || endCommentTransition != EndCommentTransition)
        {
            var newNode = SyntaxFactory.RazorCommentBlock(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new RazorCommentBlockSyntax(Kind, _startCommentTransition, _startCommentStar, _comment, _endCommentStar, _endCommentTransition, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RazorCommentBlockSyntax(Kind, _startCommentTransition, _startCommentStar, _comment, _endCommentStar, _endCommentTransition, GetDiagnostics(), annotations);
}

internal sealed partial class RazorMetaCodeSyntax : RazorSyntaxNode
{
    internal readonly GreenNode _metaCode;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal RazorMetaCodeSyntax(SyntaxKind kind, GreenNode metaCode, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (metaCode != null)
        {
            AdjustFlagsAndWidth(metaCode);
            _metaCode = metaCode;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal RazorMetaCodeSyntax(SyntaxKind kind, GreenNode metaCode, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (metaCode != null)
        {
            AdjustFlagsAndWidth(metaCode);
            _metaCode = metaCode;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> MetaCode => new SyntaxList<SyntaxToken>(_metaCode);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._metaCode : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.RazorMetaCodeSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorMetaCode(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorMetaCode(this);

    public RazorMetaCodeSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> metaCode, ISpanChunkGenerator chunkGenerator)
    {
        if (metaCode != MetaCode)
        {
            var newNode = SyntaxFactory.RazorMetaCode(metaCode, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new RazorMetaCodeSyntax(Kind, _metaCode, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RazorMetaCodeSyntax(Kind, _metaCode, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class GenericBlockSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal GenericBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal GenericBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.GenericBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitGenericBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitGenericBlock(this);

    public GenericBlockSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.GenericBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new GenericBlockSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new GenericBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class UnclassifiedTextLiteralSyntax : RazorSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal UnclassifiedTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal UnclassifiedTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.UnclassifiedTextLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitUnclassifiedTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitUnclassifiedTextLiteral(this);

    public UnclassifiedTextLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.UnclassifiedTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new UnclassifiedTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new UnclassifiedTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal abstract partial class MarkupSyntaxNode : RazorSyntaxNode
{
    internal MarkupSyntaxNode(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal MarkupSyntaxNode(SyntaxKind kind)
        : base(kind)
    {
    }
}

internal sealed partial class MarkupBlockSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal MarkupBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal MarkupBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupBlock(this);

    public MarkupBlockSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupBlockSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTransitionSyntax : MarkupSyntaxNode
{
    internal readonly GreenNode _transitionTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTransitionSyntax(SyntaxKind kind, GreenNode transitionTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (transitionTokens != null)
        {
            AdjustFlagsAndWidth(transitionTokens);
            _transitionTokens = transitionTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupTransitionSyntax(SyntaxKind kind, GreenNode transitionTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (transitionTokens != null)
        {
            AdjustFlagsAndWidth(transitionTokens);
            _transitionTokens = transitionTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> TransitionTokens => new SyntaxList<SyntaxToken>(_transitionTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._transitionTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTransitionSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTransition(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTransition(this);

    public MarkupTransitionSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> transitionTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (transitionTokens != TransitionTokens)
        {
            var newNode = SyntaxFactory.MarkupTransition(transitionTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTransitionSyntax(Kind, _transitionTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTransitionSyntax(Kind, _transitionTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTextLiteralSyntax : MarkupSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTextLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTextLiteral(this);

    public MarkupTextLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.MarkupTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupEphemeralTextLiteralSyntax : MarkupSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupEphemeralTextLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupEphemeralTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupEphemeralTextLiteral(this);

    public MarkupEphemeralTextLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupCommentBlockSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal MarkupCommentBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal MarkupCommentBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupCommentBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupCommentBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupCommentBlock(this);

    public MarkupCommentBlockSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupCommentBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupCommentBlockSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupCommentBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupMinimizedAttributeBlockSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    internal MarkupMinimizedAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
        : base(kind)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public MarkupTextLiteralSyntax Name => _name;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _name,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupMinimizedAttributeBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedAttributeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedAttributeBlock(this);

    public MarkupMinimizedAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix, name);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupMinimizedAttributeBlockSyntax(Kind, _namePrefix, _name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupMinimizedAttributeBlockSyntax(Kind, _namePrefix, _name, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupAttributeBlockSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly MarkupTextLiteralSyntax _name;
    internal readonly MarkupTextLiteralSyntax _nameSuffix;
    internal readonly SyntaxToken _equalsToken;
    internal readonly MarkupTextLiteralSyntax _valuePrefix;
    internal readonly RazorBlockSyntax _value;
    internal readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    internal MarkupAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public MarkupTextLiteralSyntax Name => _name;
    public MarkupTextLiteralSyntax NameSuffix => _nameSuffix;
    public SyntaxToken EqualsToken => _equalsToken;
    public MarkupTextLiteralSyntax ValuePrefix => _valuePrefix;
    public RazorBlockSyntax Value => _value;
    public MarkupTextLiteralSyntax ValueSuffix => _valueSuffix;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _name,
            2 => _nameSuffix,
            3 => _equalsToken,
            4 => _valuePrefix,
            5 => _value,
            6 => _valueSuffix,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupAttributeBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupAttributeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupAttributeBlock(this);

    public MarkupAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupAttributeBlockSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupAttributeBlockSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupMiscAttributeContentSyntax : MarkupSyntaxNode
{
    internal readonly GreenNode _children;

    internal MarkupMiscAttributeContentSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal MarkupMiscAttributeContentSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupMiscAttributeContentSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMiscAttributeContent(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMiscAttributeContent(this);

    public MarkupMiscAttributeContentSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupMiscAttributeContent(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupMiscAttributeContentSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupMiscAttributeContentSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupLiteralAttributeValueSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _prefix;
    internal readonly MarkupTextLiteralSyntax _value;

    internal MarkupLiteralAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
    }

    internal MarkupLiteralAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
        : base(kind)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
    }

    public MarkupTextLiteralSyntax Prefix => _prefix;
    public MarkupTextLiteralSyntax Value => _value;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _prefix,
            1 => _value,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupLiteralAttributeValueSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupLiteralAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupLiteralAttributeValue(this);

    public MarkupLiteralAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupLiteralAttributeValue(prefix, value);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupLiteralAttributeValueSyntax(Kind, _prefix, _value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupLiteralAttributeValueSyntax(Kind, _prefix, _value, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupDynamicAttributeValueSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _prefix;
    internal readonly RazorBlockSyntax _value;

    internal MarkupDynamicAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, RazorBlockSyntax value, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
    }

    internal MarkupDynamicAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
        : base(kind)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
    }

    public MarkupTextLiteralSyntax Prefix => _prefix;
    public RazorBlockSyntax Value => _value;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _prefix,
            1 => _value,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupDynamicAttributeValueSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupDynamicAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupDynamicAttributeValue(this);

    public MarkupDynamicAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupDynamicAttributeValue(prefix, value);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupDynamicAttributeValueSyntax(Kind, _prefix, _value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupDynamicAttributeValueSyntax(Kind, _prefix, _value, GetDiagnostics(), annotations);
}

internal abstract partial class BaseMarkupStartTagSyntax : MarkupSyntaxNode
{
    internal BaseMarkupStartTagSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal BaseMarkupStartTagSyntax(SyntaxKind kind)
        : base(kind)
    {
    }

    public abstract SyntaxToken OpenAngle { get; }

    public abstract SyntaxToken Bang { get; }

    public abstract SyntaxToken Name { get; }

    public abstract SyntaxList<RazorSyntaxNode> Attributes { get; }

    public abstract SyntaxToken ForwardSlash { get; }

    public abstract SyntaxToken CloseAngle { get; }

    public abstract ISpanChunkGenerator ChunkGenerator { get; }
}

internal abstract partial class BaseMarkupEndTagSyntax : MarkupSyntaxNode
{
    internal BaseMarkupEndTagSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal BaseMarkupEndTagSyntax(SyntaxKind kind)
        : base(kind)
    {
    }

    public abstract SyntaxToken OpenAngle { get; }

    public abstract SyntaxToken ForwardSlash { get; }

    public abstract SyntaxToken Bang { get; }

    public abstract SyntaxToken Name { get; }

    public abstract MarkupMiscAttributeContentSyntax MiscAttributeContent { get; }

    public abstract SyntaxToken CloseAngle { get; }

    public abstract ISpanChunkGenerator ChunkGenerator { get; }
}

internal sealed partial class MarkupElementSyntax : MarkupSyntaxNode
{
    internal readonly MarkupStartTagSyntax _startTag;
    internal readonly GreenNode _body;
    internal readonly MarkupEndTagSyntax _endTag;

    internal MarkupElementSyntax(SyntaxKind kind, MarkupStartTagSyntax startTag, GreenNode body, MarkupEndTagSyntax endTag, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        if (startTag != null)
        {
            AdjustFlagsAndWidth(startTag);
            _startTag = startTag;
        }
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    internal MarkupElementSyntax(SyntaxKind kind, MarkupStartTagSyntax startTag, GreenNode body, MarkupEndTagSyntax endTag)
        : base(kind)
    {
        SlotCount = 3;
        if (startTag != null)
        {
            AdjustFlagsAndWidth(startTag);
            _startTag = startTag;
        }
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    public MarkupStartTagSyntax StartTag => _startTag;
    public SyntaxList<RazorSyntaxNode> Body => new SyntaxList<RazorSyntaxNode>(_body);
    public MarkupEndTagSyntax EndTag => _endTag;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _startTag,
            1 => _body,
            2 => _endTag,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupElementSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupElement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupElement(this);

    public MarkupElementSyntax Update(MarkupStartTagSyntax startTag, InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupElement(startTag, body, endTag);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupElementSyntax(Kind, _startTag, _body, _endTag, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupElementSyntax(Kind, _startTag, _body, _endTag, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupStartTagSyntax : BaseMarkupStartTagSyntax
{
    internal readonly SyntaxToken _openAngle;
    internal readonly SyntaxToken _bang;
    internal readonly SyntaxToken _name;
    internal readonly GreenNode _attributes;
    internal readonly SyntaxToken _forwardSlash;
    internal readonly SyntaxToken _closeAngle;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public override SyntaxToken OpenAngle => _openAngle;
    public override SyntaxToken Bang => _bang;
    public override SyntaxToken Name => _name;
    public override SyntaxList<RazorSyntaxNode> Attributes => new SyntaxList<RazorSyntaxNode>(_attributes);
    public override SyntaxToken ForwardSlash => _forwardSlash;
    public override SyntaxToken CloseAngle => _closeAngle;
    public override ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openAngle,
            1 => _bang,
            2 => _name,
            3 => _attributes,
            4 => _forwardSlash,
            5 => _closeAngle,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupStartTagSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupStartTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupStartTag(this);

    public MarkupStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupEndTagSyntax : BaseMarkupEndTagSyntax
{
    internal readonly SyntaxToken _openAngle;
    internal readonly SyntaxToken _forwardSlash;
    internal readonly SyntaxToken _bang;
    internal readonly SyntaxToken _name;
    internal readonly MarkupMiscAttributeContentSyntax _miscAttributeContent;
    internal readonly SyntaxToken _closeAngle;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public override SyntaxToken OpenAngle => _openAngle;
    public override SyntaxToken ForwardSlash => _forwardSlash;
    public override SyntaxToken Bang => _bang;
    public override SyntaxToken Name => _name;
    public override MarkupMiscAttributeContentSyntax MiscAttributeContent => _miscAttributeContent;
    public override SyntaxToken CloseAngle => _closeAngle;
    public override ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openAngle,
            1 => _forwardSlash,
            2 => _bang,
            3 => _name,
            4 => _miscAttributeContent,
            5 => _closeAngle,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupEndTagSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupEndTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupEndTag(this);

    public MarkupEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperElementSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTagHelperStartTagSyntax _startTag;
    internal readonly GreenNode _body;
    internal readonly MarkupTagHelperEndTagSyntax _endTag;

    internal MarkupTagHelperElementSyntax(SyntaxKind kind, MarkupTagHelperStartTagSyntax startTag, GreenNode body, MarkupTagHelperEndTagSyntax endTag, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(startTag);
        _startTag = startTag;
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    internal MarkupTagHelperElementSyntax(SyntaxKind kind, MarkupTagHelperStartTagSyntax startTag, GreenNode body, MarkupTagHelperEndTagSyntax endTag)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(startTag);
        _startTag = startTag;
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    public MarkupTagHelperStartTagSyntax StartTag => _startTag;
    public SyntaxList<RazorSyntaxNode> Body => new SyntaxList<RazorSyntaxNode>(_body);
    public MarkupTagHelperEndTagSyntax EndTag => _endTag;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _startTag,
            1 => _body,
            2 => _endTag,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperElementSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperElement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperElement(this);

    public MarkupTagHelperElementSyntax Update(MarkupTagHelperStartTagSyntax startTag, InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupTagHelperElement(startTag, body, endTag);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperElementSyntax(Kind, _startTag, _body, _endTag, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperElementSyntax(Kind, _startTag, _body, _endTag, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperStartTagSyntax : BaseMarkupStartTagSyntax
{
    internal readonly SyntaxToken _openAngle;
    internal readonly SyntaxToken _bang;
    internal readonly SyntaxToken _name;
    internal readonly GreenNode _attributes;
    internal readonly SyntaxToken _forwardSlash;
    internal readonly SyntaxToken _closeAngle;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTagHelperStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupTagHelperStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public override SyntaxToken OpenAngle => _openAngle;
    public override SyntaxToken Bang => _bang;
    public override SyntaxToken Name => _name;
    public override SyntaxList<RazorSyntaxNode> Attributes => new SyntaxList<RazorSyntaxNode>(_attributes);
    public override SyntaxToken ForwardSlash => _forwardSlash;
    public override SyntaxToken CloseAngle => _closeAngle;
    public override ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openAngle,
            1 => _bang,
            2 => _name,
            3 => _attributes,
            4 => _forwardSlash,
            5 => _closeAngle,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperStartTagSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperStartTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperStartTag(this);

    public MarkupTagHelperStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupTagHelperStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperEndTagSyntax : BaseMarkupEndTagSyntax
{
    internal readonly SyntaxToken _openAngle;
    internal readonly SyntaxToken _forwardSlash;
    internal readonly SyntaxToken _bang;
    internal readonly SyntaxToken _name;
    internal readonly MarkupMiscAttributeContentSyntax _miscAttributeContent;
    internal readonly SyntaxToken _closeAngle;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTagHelperEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    internal MarkupTagHelperEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public override SyntaxToken OpenAngle => _openAngle;
    public override SyntaxToken ForwardSlash => _forwardSlash;
    public override SyntaxToken Bang => _bang;
    public override SyntaxToken Name => _name;
    public override MarkupMiscAttributeContentSyntax MiscAttributeContent => _miscAttributeContent;
    public override SyntaxToken CloseAngle => _closeAngle;
    public override ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openAngle,
            1 => _forwardSlash,
            2 => _bang,
            3 => _name,
            4 => _miscAttributeContent,
            5 => _closeAngle,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperEndTagSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperEndTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperEndTag(this);

    public MarkupTagHelperEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupTagHelperEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperAttributeSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly MarkupTextLiteralSyntax _name;
    internal readonly MarkupTextLiteralSyntax _nameSuffix;
    internal readonly SyntaxToken _equalsToken;
    internal readonly MarkupTextLiteralSyntax _valuePrefix;
    internal readonly MarkupTagHelperAttributeValueSyntax _value;
    internal readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    internal MarkupTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public MarkupTextLiteralSyntax Name => _name;
    public MarkupTextLiteralSyntax NameSuffix => _nameSuffix;
    public SyntaxToken EqualsToken => _equalsToken;
    public MarkupTextLiteralSyntax ValuePrefix => _valuePrefix;
    public MarkupTagHelperAttributeValueSyntax Value => _value;
    public MarkupTextLiteralSyntax ValueSuffix => _valueSuffix;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _name,
            2 => _nameSuffix,
            3 => _equalsToken,
            4 => _valuePrefix,
            5 => _value,
            6 => _valueSuffix,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperAttributeSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperAttribute(this);

    public MarkupTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperAttributeSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperAttributeSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupMinimizedTagHelperAttributeSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    internal MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
        : base(kind)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public MarkupTextLiteralSyntax Name => _name;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _name,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupMinimizedTagHelperAttributeSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedTagHelperAttribute(this);

    public MarkupMinimizedTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix, name);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupMinimizedTagHelperAttributeSyntax(Kind, _namePrefix, _name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupMinimizedTagHelperAttributeSyntax(Kind, _namePrefix, _name, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperAttributeValueSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal MarkupTagHelperAttributeValueSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal MarkupTagHelperAttributeValueSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperAttributeValueSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperAttributeValue(this);

    public MarkupTagHelperAttributeValueSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttributeValue(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperAttributeValueSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperAttributeValueSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly RazorMetaCodeSyntax _transition;
    internal readonly MarkupTextLiteralSyntax _name;
    internal readonly RazorMetaCodeSyntax _colon;
    internal readonly MarkupTextLiteralSyntax _parameterName;
    internal readonly MarkupTextLiteralSyntax _nameSuffix;
    internal readonly SyntaxToken _equalsToken;
    internal readonly MarkupTextLiteralSyntax _valuePrefix;
    internal readonly MarkupTagHelperAttributeValueSyntax _value;
    internal readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 10;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    internal MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 10;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public RazorMetaCodeSyntax Transition => _transition;
    public MarkupTextLiteralSyntax Name => _name;
    public RazorMetaCodeSyntax Colon => _colon;
    public MarkupTextLiteralSyntax ParameterName => _parameterName;
    public MarkupTextLiteralSyntax NameSuffix => _nameSuffix;
    public SyntaxToken EqualsToken => _equalsToken;
    public MarkupTextLiteralSyntax ValuePrefix => _valuePrefix;
    public MarkupTagHelperAttributeValueSyntax Value => _value;
    public MarkupTextLiteralSyntax ValueSuffix => _valueSuffix;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _transition,
            2 => _name,
            3 => _colon,
            4 => _parameterName,
            5 => _nameSuffix,
            6 => _equalsToken,
            7 => _valuePrefix,
            8 => _value,
            9 => _valueSuffix,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupTagHelperDirectiveAttributeSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperDirectiveAttribute(this);

    public MarkupTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
}

internal sealed partial class MarkupMinimizedTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
{
    internal readonly MarkupTextLiteralSyntax _namePrefix;
    internal readonly RazorMetaCodeSyntax _transition;
    internal readonly MarkupTextLiteralSyntax _name;
    internal readonly RazorMetaCodeSyntax _colon;
    internal readonly MarkupTextLiteralSyntax _parameterName;

    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 5;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
    }

    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
        : base(kind)
    {
        SlotCount = 5;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix => _namePrefix;
    public RazorMetaCodeSyntax Transition => _transition;
    public MarkupTextLiteralSyntax Name => _name;
    public RazorMetaCodeSyntax Colon => _colon;
    public MarkupTextLiteralSyntax ParameterName => _parameterName;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _namePrefix,
            1 => _transition,
            2 => _name,
            3 => _colon,
            4 => _parameterName,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.MarkupMinimizedTagHelperDirectiveAttributeSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new MarkupMinimizedTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MarkupMinimizedTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, GetDiagnostics(), annotations);
}

internal abstract partial class CSharpSyntaxNode : RazorSyntaxNode
{
    internal CSharpSyntaxNode(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal CSharpSyntaxNode(SyntaxKind kind)
        : base(kind)
    {
    }
}

internal sealed partial class CSharpCodeBlockSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal CSharpCodeBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal CSharpCodeBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpCodeBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpCodeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpCodeBlock(this);

    public CSharpCodeBlockSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpCodeBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpCodeBlockSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpCodeBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpTransitionSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken _transition;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpTransitionSyntax(SyntaxKind kind, SyntaxToken transition, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        _chunkGenerator = chunkGenerator;
    }

    internal CSharpTransitionSyntax(SyntaxKind kind, SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken Transition => _transition;
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._transition : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpTransitionSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpTransition(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpTransition(this);

    public CSharpTransitionSyntax Update(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        if (transition != Transition)
        {
            var newNode = SyntaxFactory.CSharpTransition(transition, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpTransitionSyntax(Kind, _transition, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpTransitionSyntax(Kind, _transition, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpStatementLiteralSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpStatementLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal CSharpStatementLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpStatementLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatementLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatementLiteral(this);

    public CSharpStatementLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpStatementLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpStatementLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpStatementLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpExpressionLiteralSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpExpressionLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal CSharpExpressionLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpExpressionLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExpressionLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExpressionLiteral(this);

    public CSharpExpressionLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpExpressionLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpExpressionLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpExpressionLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpEphemeralTextLiteralSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode _literalTokens;
    internal readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    internal CSharpEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens => new SyntaxList<SyntaxToken>(_literalTokens);
    public ISpanChunkGenerator ChunkGenerator => _chunkGenerator;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._literalTokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpEphemeralTextLiteralSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpEphemeralTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpEphemeralTextLiteral(this);

    public CSharpEphemeralTextLiteralSyntax Update(InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpTemplateBlockSyntax : RazorBlockSyntax
{
    internal readonly GreenNode _children;

    internal CSharpTemplateBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    internal CSharpTemplateBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children => new SyntaxList<RazorSyntaxNode>(_children);

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._children : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpTemplateBlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpTemplateBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpTemplateBlock(this);

    public CSharpTemplateBlockSyntax Update(InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpTemplateBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpTemplateBlockSyntax(Kind, _children, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpTemplateBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
}

internal abstract partial class CSharpRazorBlockSyntax : CSharpSyntaxNode
{
    internal CSharpRazorBlockSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
    }

    internal CSharpRazorBlockSyntax(SyntaxKind kind)
        : base(kind)
    {
    }

    public abstract CSharpTransitionSyntax Transition { get; }

    public abstract CSharpSyntaxNode Body { get; }
}

internal sealed partial class CSharpStatementSyntax : CSharpRazorBlockSyntax
{
    internal readonly CSharpTransitionSyntax _transition;
    internal readonly CSharpSyntaxNode _body;

    internal CSharpStatementSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    internal CSharpStatementSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition => _transition;
    public override CSharpSyntaxNode Body => _body;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _transition,
            1 => _body,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatement(this);

    public CSharpStatementSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpStatement(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpStatementSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpStatementSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpStatementBodySyntax : CSharpSyntaxNode
{
    internal readonly RazorMetaCodeSyntax _openBrace;
    internal readonly CSharpCodeBlockSyntax _csharpCode;
    internal readonly RazorMetaCodeSyntax _closeBrace;

    internal CSharpStatementBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openBrace);
        _openBrace = openBrace;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
        AdjustFlagsAndWidth(closeBrace);
        _closeBrace = closeBrace;
    }

    internal CSharpStatementBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openBrace);
        _openBrace = openBrace;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
        AdjustFlagsAndWidth(closeBrace);
        _closeBrace = closeBrace;
    }

    public RazorMetaCodeSyntax OpenBrace => _openBrace;
    public CSharpCodeBlockSyntax CSharpCode => _csharpCode;
    public RazorMetaCodeSyntax CloseBrace => _closeBrace;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openBrace,
            1 => _csharpCode,
            2 => _closeBrace,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpStatementBodySyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatementBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatementBody(this);

    public CSharpStatementBodySyntax Update(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace)
    {
        if (openBrace != OpenBrace || csharpCode != CSharpCode || closeBrace != CloseBrace)
        {
            var newNode = SyntaxFactory.CSharpStatementBody(openBrace, csharpCode, closeBrace);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpStatementBodySyntax(Kind, _openBrace, _csharpCode, _closeBrace, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpStatementBodySyntax(Kind, _openBrace, _csharpCode, _closeBrace, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpExplicitExpressionSyntax : CSharpRazorBlockSyntax
{
    internal readonly CSharpTransitionSyntax _transition;
    internal readonly CSharpSyntaxNode _body;

    internal CSharpExplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    internal CSharpExplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition => _transition;
    public override CSharpSyntaxNode Body => _body;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _transition,
            1 => _body,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpExplicitExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExplicitExpression(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExplicitExpression(this);

    public CSharpExplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpression(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpExplicitExpressionSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpExplicitExpressionSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpExplicitExpressionBodySyntax : CSharpSyntaxNode
{
    internal readonly RazorMetaCodeSyntax _openParen;
    internal readonly CSharpCodeBlockSyntax _csharpCode;
    internal readonly RazorMetaCodeSyntax _closeParen;

    internal CSharpExplicitExpressionBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openParen);
        _openParen = openParen;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
        AdjustFlagsAndWidth(closeParen);
        _closeParen = closeParen;
    }

    internal CSharpExplicitExpressionBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openParen);
        _openParen = openParen;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
        AdjustFlagsAndWidth(closeParen);
        _closeParen = closeParen;
    }

    public RazorMetaCodeSyntax OpenParen => _openParen;
    public CSharpCodeBlockSyntax CSharpCode => _csharpCode;
    public RazorMetaCodeSyntax CloseParen => _closeParen;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _openParen,
            1 => _csharpCode,
            2 => _closeParen,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpExplicitExpressionBodySyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExplicitExpressionBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExplicitExpressionBody(this);

    public CSharpExplicitExpressionBodySyntax Update(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen)
    {
        if (openParen != OpenParen || csharpCode != CSharpCode || closeParen != CloseParen)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpressionBody(openParen, csharpCode, closeParen);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpExplicitExpressionBodySyntax(Kind, _openParen, _csharpCode, _closeParen, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpExplicitExpressionBodySyntax(Kind, _openParen, _csharpCode, _closeParen, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpImplicitExpressionSyntax : CSharpRazorBlockSyntax
{
    internal readonly CSharpTransitionSyntax _transition;
    internal readonly CSharpSyntaxNode _body;

    internal CSharpImplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    internal CSharpImplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition => _transition;
    public override CSharpSyntaxNode Body => _body;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _transition,
            1 => _body,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpImplicitExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpImplicitExpression(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpImplicitExpression(this);

    public CSharpImplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpression(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpImplicitExpressionSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpImplicitExpressionSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
}

internal sealed partial class CSharpImplicitExpressionBodySyntax : CSharpSyntaxNode
{
    internal readonly CSharpCodeBlockSyntax _csharpCode;

    internal CSharpImplicitExpressionBodySyntax(SyntaxKind kind, CSharpCodeBlockSyntax csharpCode, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
    }

    internal CSharpImplicitExpressionBodySyntax(SyntaxKind kind, CSharpCodeBlockSyntax csharpCode)
        : base(kind)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(csharpCode);
        _csharpCode = csharpCode;
    }

    public CSharpCodeBlockSyntax CSharpCode => _csharpCode;

    internal override GreenNode GetSlot(int index)
        => index == 0 ? this._csharpCode : null;

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.CSharpImplicitExpressionBodySyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpImplicitExpressionBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpImplicitExpressionBody(this);

    public CSharpImplicitExpressionBodySyntax Update(CSharpCodeBlockSyntax csharpCode)
    {
        if (csharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpressionBody(csharpCode);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new CSharpImplicitExpressionBodySyntax(Kind, _csharpCode, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CSharpImplicitExpressionBodySyntax(Kind, _csharpCode, GetDiagnostics(), annotations);
}

internal sealed partial class RazorDirectiveSyntax : CSharpRazorBlockSyntax
{
    internal readonly CSharpTransitionSyntax _transition;
    internal readonly CSharpSyntaxNode _body;

    internal RazorDirectiveSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    internal RazorDirectiveSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition => _transition;
    public override CSharpSyntaxNode Body => _body;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _transition,
            1 => _body,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.RazorDirectiveSyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDirective(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDirective(this);

    public RazorDirectiveSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.RazorDirective(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new RazorDirectiveSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RazorDirectiveSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
}

internal sealed partial class RazorDirectiveBodySyntax : CSharpSyntaxNode
{
    internal readonly RazorSyntaxNode _keyword;
    internal readonly CSharpCodeBlockSyntax _csharpCode;

    internal RazorDirectiveBodySyntax(SyntaxKind kind, RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(keyword);
        _keyword = keyword;
        if (csharpCode != null)
        {
            AdjustFlagsAndWidth(csharpCode);
            _csharpCode = csharpCode;
        }
    }

    internal RazorDirectiveBodySyntax(SyntaxKind kind, RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(keyword);
        _keyword = keyword;
        if (csharpCode != null)
        {
            AdjustFlagsAndWidth(csharpCode);
            _csharpCode = csharpCode;
        }
    }

    public RazorSyntaxNode Keyword => _keyword;
    public CSharpCodeBlockSyntax CSharpCode => _csharpCode;

    internal override GreenNode GetSlot(int index)
        => index switch
        {
            0 => _keyword,
            1 => _csharpCode,
            _ => null
        };

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new Syntax.RazorDirectiveBodySyntax(this, parent, position);

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDirectiveBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDirectiveBody(this);

    public RazorDirectiveBodySyntax Update(RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode)
    {
        if (keyword != Keyword || csharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.RazorDirectiveBody(keyword, csharpCode);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
        => new RazorDirectiveBodySyntax(Kind, _keyword, _csharpCode, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RazorDirectiveBodySyntax(Kind, _keyword, _csharpCode, GetDiagnostics(), annotations);
}

internal partial class SyntaxVisitor<TResult>
{
    public virtual TResult VisitRazorDocument(RazorDocumentSyntax node) => DefaultVisit(node);
    public virtual TResult VisitRazorCommentBlock(RazorCommentBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitRazorMetaCode(RazorMetaCodeSyntax node) => DefaultVisit(node);
    public virtual TResult VisitGenericBlock(GenericBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupBlock(MarkupBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTransition(MarkupTransitionSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTextLiteral(MarkupTextLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupCommentBlock(MarkupCommentBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupElement(MarkupElementSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupStartTag(MarkupStartTagSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupEndTag(MarkupEndTagSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);
    public virtual TResult VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpCodeBlock(CSharpCodeBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpTransition(CSharpTransitionSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpStatement(CSharpStatementSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpStatementBody(CSharpStatementBodySyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node) => DefaultVisit(node);
    public virtual TResult VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node) => DefaultVisit(node);
    public virtual TResult VisitRazorDirective(RazorDirectiveSyntax node) => DefaultVisit(node);
    public virtual TResult VisitRazorDirectiveBody(RazorDirectiveBodySyntax node) => DefaultVisit(node);
}

internal partial class SyntaxVisitor
{
    public virtual void VisitRazorDocument(RazorDocumentSyntax node) => DefaultVisit(node);
    public virtual void VisitRazorCommentBlock(RazorCommentBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitRazorMetaCode(RazorMetaCodeSyntax node) => DefaultVisit(node);
    public virtual void VisitGenericBlock(GenericBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupBlock(MarkupBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTransition(MarkupTransitionSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTextLiteral(MarkupTextLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupCommentBlock(MarkupCommentBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupElement(MarkupElementSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupStartTag(MarkupStartTagSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupEndTag(MarkupEndTagSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);
    public virtual void VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpCodeBlock(CSharpCodeBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpTransition(CSharpTransitionSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpStatement(CSharpStatementSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpStatementBody(CSharpStatementBodySyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node) => DefaultVisit(node);
    public virtual void VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node) => DefaultVisit(node);
    public virtual void VisitRazorDirective(RazorDirectiveSyntax node) => DefaultVisit(node);
    public virtual void VisitRazorDirectiveBody(RazorDirectiveBodySyntax node) => DefaultVisit(node);
}

internal partial class SyntaxRewriter : SyntaxVisitor<GreenNode>
{
    public override GreenNode VisitRazorDocument(RazorDocumentSyntax node)
        => node.Update((RazorBlockSyntax)Visit(node.Document), (SyntaxToken)Visit(node.EndOfFile));

    public override GreenNode VisitRazorCommentBlock(RazorCommentBlockSyntax node)
        => node.Update((SyntaxToken)Visit(node.StartCommentTransition), (SyntaxToken)Visit(node.StartCommentStar), (SyntaxToken)Visit(node.Comment), (SyntaxToken)Visit(node.EndCommentStar), (SyntaxToken)Visit(node.EndCommentTransition));

    public override GreenNode VisitRazorMetaCode(RazorMetaCodeSyntax node)
        => node.Update(VisitList(node.MetaCode), node.ChunkGenerator);

    public override GreenNode VisitGenericBlock(GenericBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitMarkupBlock(MarkupBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitMarkupTransition(MarkupTransitionSyntax node)
        => node.Update(VisitList(node.TransitionTokens), node.ChunkGenerator);

    public override GreenNode VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name));

    public override GreenNode VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)Visit(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (RazorBlockSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override GreenNode VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.Prefix), (MarkupTextLiteralSyntax)Visit(node.Value));

    public override GreenNode VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.Prefix), (RazorBlockSyntax)Visit(node.Value));

    public override GreenNode VisitMarkupElement(MarkupElementSyntax node)
        => node.Update((MarkupStartTagSyntax)Visit(node.StartTag), VisitList(node.Body), (MarkupEndTagSyntax)Visit(node.EndTag));

    public override GreenNode VisitMarkupStartTag(MarkupStartTagSyntax node)
        => node.Update((SyntaxToken)Visit(node.OpenAngle), (SyntaxToken)Visit(node.Bang), (SyntaxToken)Visit(node.Name), VisitList(node.Attributes), (SyntaxToken)Visit(node.ForwardSlash), (SyntaxToken)Visit(node.CloseAngle), node.ChunkGenerator);

    public override GreenNode VisitMarkupEndTag(MarkupEndTagSyntax node)
        => node.Update((SyntaxToken)Visit(node.OpenAngle), (SyntaxToken)Visit(node.ForwardSlash), (SyntaxToken)Visit(node.Bang), (SyntaxToken)Visit(node.Name), (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent), (SyntaxToken)Visit(node.CloseAngle), node.ChunkGenerator);

    public override GreenNode VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
        => node.Update((MarkupTagHelperStartTagSyntax)Visit(node.StartTag), VisitList(node.Body), (MarkupTagHelperEndTagSyntax)Visit(node.EndTag));

    public override GreenNode VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
        => node.Update((SyntaxToken)Visit(node.OpenAngle), (SyntaxToken)Visit(node.Bang), (SyntaxToken)Visit(node.Name), VisitList(node.Attributes), (SyntaxToken)Visit(node.ForwardSlash), (SyntaxToken)Visit(node.CloseAngle), node.ChunkGenerator);

    public override GreenNode VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
        => node.Update((SyntaxToken)Visit(node.OpenAngle), (SyntaxToken)Visit(node.ForwardSlash), (SyntaxToken)Visit(node.Bang), (SyntaxToken)Visit(node.Name), (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent), (SyntaxToken)Visit(node.CloseAngle), node.ChunkGenerator);

    public override GreenNode VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)Visit(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (MarkupTagHelperAttributeValueSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override GreenNode VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name));

    public override GreenNode VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (RazorMetaCodeSyntax)Visit(node.Transition), (MarkupTextLiteralSyntax)Visit(node.Name), (RazorMetaCodeSyntax)Visit(node.Colon), (MarkupTextLiteralSyntax)Visit(node.ParameterName), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)Visit(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (MarkupTagHelperAttributeValueSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override GreenNode VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (RazorMetaCodeSyntax)Visit(node.Transition), (MarkupTextLiteralSyntax)Visit(node.Name), (RazorMetaCodeSyntax)Visit(node.Colon), (MarkupTextLiteralSyntax)Visit(node.ParameterName));

    public override GreenNode VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitCSharpTransition(CSharpTransitionSyntax node)
        => node.Update((SyntaxToken)Visit(node.Transition), node.ChunkGenerator);

    public override GreenNode VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override GreenNode VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override GreenNode VisitCSharpStatement(CSharpStatementSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override GreenNode VisitCSharpStatementBody(CSharpStatementBodySyntax node)
        => node.Update((RazorMetaCodeSyntax)Visit(node.OpenBrace), (CSharpCodeBlockSyntax)Visit(node.CSharpCode), (RazorMetaCodeSyntax)Visit(node.CloseBrace));

    public override GreenNode VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override GreenNode VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
        => node.Update((RazorMetaCodeSyntax)Visit(node.OpenParen), (CSharpCodeBlockSyntax)Visit(node.CSharpCode), (RazorMetaCodeSyntax)Visit(node.CloseParen));

    public override GreenNode VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override GreenNode VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
        => node.Update((CSharpCodeBlockSyntax)Visit(node.CSharpCode));

    public override GreenNode VisitRazorDirective(RazorDirectiveSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override GreenNode VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
        => node.Update((RazorSyntaxNode)Visit(node.Keyword), (CSharpCodeBlockSyntax)Visit(node.CSharpCode));
}

internal static partial class SyntaxFactory
{
    public static RazorDocumentSyntax RazorDocument(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        ArgHelper.ThrowIfNull(document);
        ArgHelper.ThrowIfNull(endOfFile);
        if (endOfFile.Kind != SyntaxKind.EndOfFile)
            ThrowHelper.ThrowArgumentException(nameof(endOfFile), $"Invalid SyntaxKind. Expected 'SyntaxKind.EndOfFile', but it was {endOfFile.Kind}");

        var result = new RazorDocumentSyntax(SyntaxKind.RazorDocument, document, endOfFile);

        return result;
    }

    public static RazorCommentBlockSyntax RazorCommentBlock(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        ArgHelper.ThrowIfNull(startCommentTransition);
        if (startCommentTransition.Kind != SyntaxKind.RazorCommentTransition)
            ThrowHelper.ThrowArgumentException(nameof(startCommentTransition), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentTransition', but it was {startCommentTransition.Kind}");
        ArgHelper.ThrowIfNull(startCommentStar);
        if (startCommentStar.Kind != SyntaxKind.RazorCommentStar)
            ThrowHelper.ThrowArgumentException(nameof(startCommentStar), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentStar', but it was {startCommentStar.Kind}");
        ArgHelper.ThrowIfNull(comment);
        if (comment.Kind != SyntaxKind.RazorCommentLiteral)
            ThrowHelper.ThrowArgumentException(nameof(comment), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentLiteral', but it was {comment.Kind}");
        ArgHelper.ThrowIfNull(endCommentStar);
        if (endCommentStar.Kind != SyntaxKind.RazorCommentStar)
            ThrowHelper.ThrowArgumentException(nameof(endCommentStar), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentStar', but it was {endCommentStar.Kind}");
        ArgHelper.ThrowIfNull(endCommentTransition);
        if (endCommentTransition.Kind != SyntaxKind.RazorCommentTransition)
            ThrowHelper.ThrowArgumentException(nameof(endCommentTransition), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentTransition', but it was {endCommentTransition.Kind}");

        return new RazorCommentBlockSyntax(SyntaxKind.RazorComment, startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
    }

    public static RazorMetaCodeSyntax RazorMetaCode(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> metaCode, ISpanChunkGenerator chunkGenerator)
    {
        var result = new RazorMetaCodeSyntax(SyntaxKind.RazorMetaCode, metaCode.Node, chunkGenerator);

        return result;
    }

    public static GenericBlockSyntax GenericBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new GenericBlockSyntax(SyntaxKind.GenericBlock, children.Node);

        return result;
    }

    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new UnclassifiedTextLiteralSyntax(SyntaxKind.UnclassifiedTextLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static MarkupBlockSyntax MarkupBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new MarkupBlockSyntax(SyntaxKind.MarkupBlock, children.Node);

        return result;
    }

    public static MarkupTransitionSyntax MarkupTransition(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> transitionTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new MarkupTransitionSyntax(SyntaxKind.MarkupTransition, transitionTokens.Node, chunkGenerator);

        return result;
    }

    public static MarkupTextLiteralSyntax MarkupTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new MarkupTextLiteralSyntax(SyntaxKind.MarkupTextLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new MarkupEphemeralTextLiteralSyntax(SyntaxKind.MarkupEphemeralTextLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static MarkupCommentBlockSyntax MarkupCommentBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new MarkupCommentBlockSyntax(SyntaxKind.MarkupCommentBlock, children.Node);

        return result;
    }

    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        ArgHelper.ThrowIfNull(name);

        var result = new MarkupMinimizedAttributeBlockSyntax(SyntaxKind.MarkupMinimizedAttributeBlock, namePrefix, name);

        return result;
    }

    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(name);
        ArgHelper.ThrowIfNull(equalsToken);
        if (equalsToken.Kind != SyntaxKind.Equals)
            ThrowHelper.ThrowArgumentException(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");

        return new MarkupAttributeBlockSyntax(SyntaxKind.MarkupAttributeBlock, namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new MarkupMiscAttributeContentSyntax(SyntaxKind.MarkupMiscAttributeContent, children.Node);

        return result;
    }

    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
        var result = new MarkupLiteralAttributeValueSyntax(SyntaxKind.MarkupLiteralAttributeValue, prefix, value);

        return result;
    }

    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        ArgHelper.ThrowIfNull(value);

        var result = new MarkupDynamicAttributeValueSyntax(SyntaxKind.MarkupDynamicAttributeValue, prefix, value);

        return result;
    }

    public static MarkupElementSyntax MarkupElement(MarkupStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
        var result = new MarkupElementSyntax(SyntaxKind.MarkupElement, startTag, body.Node, endTag);

        return result;
    }

    public static MarkupStartTagSyntax MarkupStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        ArgHelper.ThrowIfNull(openAngle);
        if (openAngle.Kind != SyntaxKind.OpenAngle)
            ThrowHelper.ThrowArgumentException(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (bang is not null && bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang' or 'SyntaxKind.None', but it was {bang.Kind}");
        ArgHelper.ThrowIfNull(name);
        if (name.Kind != SyntaxKind.Text)
            ThrowHelper.ThrowArgumentException(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (forwardSlash is not null && forwardSlash.Kind is not (SyntaxKind.ForwardSlash or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash' or 'SyntaxKind.None', but it was {forwardSlash.Kind}");
        ArgHelper.ThrowIfNull(closeAngle);
        if (closeAngle.Kind != SyntaxKind.CloseAngle)
            ThrowHelper.ThrowArgumentException(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");

        return new MarkupStartTagSyntax(SyntaxKind.MarkupStartTag, openAngle, bang, name, attributes.Node, forwardSlash, closeAngle, chunkGenerator);
    }

    public static MarkupEndTagSyntax MarkupEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        ArgHelper.ThrowIfNull(openAngle);
        if (openAngle.Kind != SyntaxKind.OpenAngle)
            ThrowHelper.ThrowArgumentException(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        ArgHelper.ThrowIfNull(forwardSlash);
        if (forwardSlash.Kind != SyntaxKind.ForwardSlash)
            ThrowHelper.ThrowArgumentException(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash', but it was {forwardSlash.Kind}");
        if (bang is not null && bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang' or 'SyntaxKind.None', but it was {bang.Kind}");
        ArgHelper.ThrowIfNull(name);
        if (name.Kind != SyntaxKind.Text)
            ThrowHelper.ThrowArgumentException(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        ArgHelper.ThrowIfNull(closeAngle);
        if (closeAngle.Kind != SyntaxKind.CloseAngle)
            ThrowHelper.ThrowArgumentException(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");

        return new MarkupEndTagSyntax(SyntaxKind.MarkupEndTag, openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(MarkupTagHelperStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        ArgHelper.ThrowIfNull(startTag);

        var result = new MarkupTagHelperElementSyntax(SyntaxKind.MarkupTagHelperElement, startTag, body.Node, endTag);

        return result;
    }

    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        ArgHelper.ThrowIfNull(openAngle);
        if (openAngle.Kind != SyntaxKind.OpenAngle)
            ThrowHelper.ThrowArgumentException(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (bang is not null && bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang' or 'SyntaxKind.None', but it was {bang.Kind}");
        ArgHelper.ThrowIfNull(name);
        if (name.Kind != SyntaxKind.Text)
            ThrowHelper.ThrowArgumentException(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (forwardSlash is not null && forwardSlash.Kind is not (SyntaxKind.ForwardSlash or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash' or 'SyntaxKind.None', but it was {forwardSlash.Kind}");
        ArgHelper.ThrowIfNull(closeAngle);
        if (closeAngle.Kind != SyntaxKind.CloseAngle)
            ThrowHelper.ThrowArgumentException(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");

        return new MarkupTagHelperStartTagSyntax(SyntaxKind.MarkupTagHelperStartTag, openAngle, bang, name, attributes.Node, forwardSlash, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        ArgHelper.ThrowIfNull(openAngle);
        if (openAngle.Kind != SyntaxKind.OpenAngle)
            ThrowHelper.ThrowArgumentException(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        ArgHelper.ThrowIfNull(forwardSlash);
        if (forwardSlash.Kind != SyntaxKind.ForwardSlash)
            ThrowHelper.ThrowArgumentException(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash', but it was {forwardSlash.Kind}");
        if (bang is not null && bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None))
            ThrowHelper.ThrowArgumentException(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang' or 'SyntaxKind.None', but it was {bang.Kind}");
        ArgHelper.ThrowIfNull(name);
        if (name.Kind != SyntaxKind.Text)
            ThrowHelper.ThrowArgumentException(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        ArgHelper.ThrowIfNull(closeAngle);
        if (closeAngle.Kind != SyntaxKind.CloseAngle)
            ThrowHelper.ThrowArgumentException(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");

        return new MarkupTagHelperEndTagSyntax(SyntaxKind.MarkupTagHelperEndTag, openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(name);
        ArgHelper.ThrowIfNull(equalsToken);
        if (equalsToken.Kind != SyntaxKind.Equals)
            ThrowHelper.ThrowArgumentException(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");
        ArgHelper.ThrowIfNull(value);

        return new MarkupTagHelperAttributeSyntax(SyntaxKind.MarkupTagHelperAttribute, namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        ArgHelper.ThrowIfNull(name);

        var result = new MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind.MarkupMinimizedTagHelperAttribute, namePrefix, name);

        return result;
    }

    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new MarkupTagHelperAttributeValueSyntax(SyntaxKind.MarkupTagHelperAttributeValue, children.Node);

        return result;
    }

    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(name);
        ArgHelper.ThrowIfNull(equalsToken);
        if (equalsToken.Kind != SyntaxKind.Equals)
            ThrowHelper.ThrowArgumentException(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");
        ArgHelper.ThrowIfNull(value);

        return new MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind.MarkupTagHelperDirectiveAttribute, namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(name);

        return new MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind.MarkupMinimizedTagHelperDirectiveAttribute, namePrefix, transition, name, colon, parameterName);
    }

    public static CSharpCodeBlockSyntax CSharpCodeBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new CSharpCodeBlockSyntax(SyntaxKind.CSharpCodeBlock, children.Node);

        return result;
    }

    public static CSharpTransitionSyntax CSharpTransition(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        ArgHelper.ThrowIfNull(transition);
        if (transition.Kind != SyntaxKind.Transition)
            ThrowHelper.ThrowArgumentException(nameof(transition), $"Invalid SyntaxKind. Expected 'SyntaxKind.Transition', but it was {transition.Kind}");

        var result = new CSharpTransitionSyntax(SyntaxKind.CSharpTransition, transition, chunkGenerator);

        return result;
    }

    public static CSharpStatementLiteralSyntax CSharpStatementLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new CSharpStatementLiteralSyntax(SyntaxKind.CSharpStatementLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new CSharpExpressionLiteralSyntax(SyntaxKind.CSharpExpressionLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        var result = new CSharpEphemeralTextLiteralSyntax(SyntaxKind.CSharpEphemeralTextLiteral, literalTokens.Node, chunkGenerator);

        return result;
    }

    public static CSharpTemplateBlockSyntax CSharpTemplateBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        var result = new CSharpTemplateBlockSyntax(SyntaxKind.CSharpTemplateBlock, children.Node);

        return result;
    }

    public static CSharpStatementSyntax CSharpStatement(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);

        var result = new CSharpStatementSyntax(SyntaxKind.CSharpStatement, transition, body);

        return result;
    }

    public static CSharpStatementBodySyntax CSharpStatementBody(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace)
    {
        ArgHelper.ThrowIfNull(openBrace);
        ArgHelper.ThrowIfNull(csharpCode);
        ArgHelper.ThrowIfNull(closeBrace);

        var result = new CSharpStatementBodySyntax(SyntaxKind.CSharpStatementBody, openBrace, csharpCode, closeBrace);

        return result;
    }

    public static CSharpExplicitExpressionSyntax CSharpExplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);

        var result = new CSharpExplicitExpressionSyntax(SyntaxKind.CSharpExplicitExpression, transition, body);

        return result;
    }

    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen)
    {
        ArgHelper.ThrowIfNull(openParen);
        ArgHelper.ThrowIfNull(csharpCode);
        ArgHelper.ThrowIfNull(closeParen);

        var result = new CSharpExplicitExpressionBodySyntax(SyntaxKind.CSharpExplicitExpressionBody, openParen, csharpCode, closeParen);

        return result;
    }

    public static CSharpImplicitExpressionSyntax CSharpImplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);

        var result = new CSharpImplicitExpressionSyntax(SyntaxKind.CSharpImplicitExpression, transition, body);

        return result;
    }

    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody(CSharpCodeBlockSyntax csharpCode)
    {
        ArgHelper.ThrowIfNull(csharpCode);

        var result = new CSharpImplicitExpressionBodySyntax(SyntaxKind.CSharpImplicitExpressionBody, csharpCode);

        return result;
    }

    public static RazorDirectiveSyntax RazorDirective(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);

        var result = new RazorDirectiveSyntax(SyntaxKind.RazorDirective, transition, body);

        return result;
    }

    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode)
    {
        ArgHelper.ThrowIfNull(keyword);

        var result = new RazorDirectiveBodySyntax(SyntaxKind.RazorDirectiveBody, keyword, csharpCode);

        return result;
    }

    internal static IEnumerable<Type> GetNodeTypes()
    {
        return new Type[]
        {
            typeof(RazorDocumentSyntax),
            typeof(RazorCommentBlockSyntax),
            typeof(RazorMetaCodeSyntax),
            typeof(GenericBlockSyntax),
            typeof(UnclassifiedTextLiteralSyntax),
            typeof(MarkupBlockSyntax),
            typeof(MarkupTransitionSyntax),
            typeof(MarkupTextLiteralSyntax),
            typeof(MarkupEphemeralTextLiteralSyntax),
            typeof(MarkupCommentBlockSyntax),
            typeof(MarkupMinimizedAttributeBlockSyntax),
            typeof(MarkupAttributeBlockSyntax),
            typeof(MarkupMiscAttributeContentSyntax),
            typeof(MarkupLiteralAttributeValueSyntax),
            typeof(MarkupDynamicAttributeValueSyntax),
            typeof(MarkupElementSyntax),
            typeof(MarkupStartTagSyntax),
            typeof(MarkupEndTagSyntax),
            typeof(MarkupTagHelperElementSyntax),
            typeof(MarkupTagHelperStartTagSyntax),
            typeof(MarkupTagHelperEndTagSyntax),
            typeof(MarkupTagHelperAttributeSyntax),
            typeof(MarkupMinimizedTagHelperAttributeSyntax),
            typeof(MarkupTagHelperAttributeValueSyntax),
            typeof(MarkupTagHelperDirectiveAttributeSyntax),
            typeof(MarkupMinimizedTagHelperDirectiveAttributeSyntax),
            typeof(CSharpCodeBlockSyntax),
            typeof(CSharpTransitionSyntax),
            typeof(CSharpStatementLiteralSyntax),
            typeof(CSharpExpressionLiteralSyntax),
            typeof(CSharpEphemeralTextLiteralSyntax),
            typeof(CSharpTemplateBlockSyntax),
            typeof(CSharpStatementSyntax),
            typeof(CSharpStatementBodySyntax),
            typeof(CSharpExplicitExpressionSyntax),
            typeof(CSharpExplicitExpressionBodySyntax),
            typeof(CSharpImplicitExpressionSyntax),
            typeof(CSharpImplicitExpressionBodySyntax),
            typeof(RazorDirectiveSyntax),
            typeof(RazorDirectiveBodySyntax)
        };
    }
}
