**Elvish** is an expressive programming language and a versatile interactive
shell, combined into one seamless package. It runs on Linux, BSDs, macOS and
Windows.

<div class="no-js">
  <h1>Demos</h1>
  <p>
    Enable JavaScript to see demos as slides.
  </p>
</div>

<ul id="demo-switcher">
</ul>

<div id="demo-window"> <div id="demo-container">
  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Powerful Pipelines</h2>
      <p>
        Pipelines in Elvish can carry structured data, not just text. Stream
        lists, maps and even functions through the pipeline.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot home/pipelines
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Intuitive Control Structures</h2>
      <p>
        Control structures in Elvish have a familiar C-like syntax. Never spell
        <code>if</code> backwards again.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot home/control-structures
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Directory History</h2>
      <p>
        Press <kbd>Ctrl-L</kbd> and jump to any directory you've been to.
        Type <code>cd java/com/lorem/ipsum</code> once and only once.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot home/location-mode
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Command History</h2>
      <p>
        Press <kbd>Ctrl-R</kbd> and find that beautiful <code>ffmpeg</code>
        command you used to transcode a video file two months ago.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot home/histlist-mode
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Built-in File Manager</h2>
      <p>
        Press <kbd>Ctrl-N</kbd> to explore directories and preview files, with
        the full power of a shell still under your fingertips.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot home/navigation-mode
    </div>
  </div> </div>
</div> </div>

<div id="columns">

<div class="column">

# <i class="icon-rocket"></i> Run Elvish

-   [Download](get/) a binary

-   [Source code](https://github.com/elves/elvish) on GitHub

-   [Try Elvish](https://try.elv.sh) directly from the browser (beta)

# <i class="icon-sitemap"></i> Use this Site

Start your Elvish journey in this very website!

-   [Learn](learn/) the fundamentals and interesting topics

-   Peruse the definitive [reference](ref/) documents

-   Read the [blog](blog/) for the latest news

-   Subscribe to the [feed](feed.atom) to keep updated

</div>

<div class="column">

# <i class="icon-chat"></i> Join the Community

Join any of the following channels -- they are all bridged together thanks to
[Matrix](https://matrix.org)!

-   Telegram: [Elvish user group](https://t.me/+Pv5ZYgTXD-YaKwcP)

-   IRC: [#elvish](https://web.libera.chat/#elvish) on Libera Chat

-   Gitter: [elves/elvish](https://gitter.im/elves/elvish)

-   Matrix: [#users:elv.sh](https://matrix.to/#/#users:elv.sh)

# <i class="icon-link-ext"></i> More Resources

-   [Awesome Elvish](https://github.com/elves/awesome-elvish): Official list of
    unofficial Elvish modules

-   [@ElvishShell](https://twitter.com/elvishshell) on Twitter

</div>

</div>
