
#
# Completions for the darcs command
# This file was autogenerated by the file make_vcs_completions.fish
# which is shipped with the fish source code.
#

#
# Completions from commandline
#

complete -c darcs -n "not __fish_use_subcommand" -a "(test -f _darcs/prefs/repos; and cat _darcs/prefs/repos)" --description "Darcs repo"
complete -c darcs -a "test predist boringfile binariesfile" -n "contains setpref (commandline -poc)" --description "Set the specified option" -x

#
# subcommands
#

complete -c darcs -n '__fish_use_subcommand' -x -a help --description 'Display help about darcs and darcs commands'
complete -c darcs -n '__fish_use_subcommand' -x -a add --description 'Add one or more new files or directories'
complete -c darcs -n '__fish_use_subcommand' -x -a remove --description 'Remove files from version control'
complete -c darcs -n '__fish_use_subcommand' -x -a move --description 'Move or rename files'
complete -c darcs -n '__fish_use_subcommand' -x -a replace --description 'Substitute one word for another'
complete -c darcs -n '__fish_use_subcommand' -x -a revert --description 'Discard unrecorded changes'
complete -c darcs -n '__fish_use_subcommand' -x -a unrevert --description 'Undo the last revert (may fail if changes after the revert)'
complete -c darcs -n '__fish_use_subcommand' -x -a whatsnew --description 'List unrecorded changes in the working tree'
complete -c darcs -n '__fish_use_subcommand' -x -a record --description 'Create a patch from unrecorded changes'
complete -c darcs -n '__fish_use_subcommand' -x -a unrecord --description 'Remove recorded patches without changing the working copy'
complete -c darcs -n '__fish_use_subcommand' -x -a amend-record --description 'Improve a patch before it leaves your repository'
complete -c darcs -n '__fish_use_subcommand' -x -a mark-conflicts --description 'Mark unresolved conflicts in working tree, for manual resolution'
complete -c darcs -n '__fish_use_subcommand' -x -a tag --description 'Name the current repository state for future reference'
complete -c darcs -n '__fish_use_subcommand' -x -a setpref --description 'Set a preference (test, predist, boringfile or binariesfile)'
complete -c darcs -n '__fish_use_subcommand' -x -a diff --description 'Create a diff between two versions of the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a changes --description 'List patches in the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a annotate --description 'Display which patch last modified something'
complete -c darcs -n '__fish_use_subcommand' -x -a dist --description 'Create a distribution tarball'
complete -c darcs -n '__fish_use_subcommand' -x -a trackdown --description 'Locate the most recent version lacking an error'
complete -c darcs -n '__fish_use_subcommand' -x -a show --description 'Show information which is stored by darcs'
complete -c darcs -n '__fish_use_subcommand' -x -a pull --description 'Copy and apply patches from another repository to this one'
complete -c darcs -n '__fish_use_subcommand' -x -a obliterate --description 'Delete selected patches from the repository. (UNSAFE!)'
complete -c darcs -n '__fish_use_subcommand' -x -a rollback --description 'Record a new patch reversing some recorded changes'
complete -c darcs -n '__fish_use_subcommand' -x -a push --description 'Copy and apply patches from this repository to another one'
complete -c darcs -n '__fish_use_subcommand' -x -a send --description 'Send by email a bundle of one or more patches'
complete -c darcs -n '__fish_use_subcommand' -x -a apply --description 'Apply a patch bundle created by `darcs send\''
complete -c darcs -n '__fish_use_subcommand' -x -a get --description 'Create a local copy of a repository'
complete -c darcs -n '__fish_use_subcommand' -x -a put --description 'Makes a copy of the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a initialize --description 'Make the current directory a repository'
complete -c darcs -n '__fish_use_subcommand' -x -a optimize --description 'Optimize the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a check --description 'Check the repository for consistency'
complete -c darcs -n '__fish_use_subcommand' -x -a repair --description 'Repair a corrupted repository'
complete -c darcs -n '__fish_use_subcommand' -x -a convert --description 'Convert a repository from a legacy format'


#
# Completions for the 'help' subcommand
#

complete -c darcs -n 'contains \'help\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'add' subcommand
#

complete -c darcs -n 'contains \'add\' (commandline -poc)' -l boring --description 'Don\'t skip boring files'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-boring --description 'Skip borign files [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l case-ok --description 'Don\'t refuse to add files differing only in case'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-case-ok --description 'Refuse to add files whose name differ only in case [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l reserved-ok --description 'Don\'t refuse to add files with Windows-reserved names'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-reserved-ok --description 'Refuse to add files with Windows-reserved names [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s r -l recursive --description 'Add contents of subdirectories'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l date-trick --description 'Add files with date appended to avoid conflict [EXPERIMENTAL]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-date-trick --description 'Don\'t use experimental date appending trick [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'remove' subcommand
#

complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s r -l recursive --description 'Recurse into subdirectories'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'move' subcommand
#

complete -c darcs -n 'contains \'move\' (commandline -poc)' -l case-ok --description 'Don\'t refuse to add files differing only in case'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l no-case-ok --description 'Refuse to add files whose name differ only in case [DEFAULT]'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l reserved-ok --description 'Don\'t refuse to add files with Windows-reserved names'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l no-reserved-ok --description 'Refuse to add files with Windows-reserved names [DEFAULT]'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'move\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'replace' subcommand
#

complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l token-chars -x --description 'Define token to contain these characters'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s f -l force --description 'Proceed with replace even if \'new\' token already exists'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-force --description 'Don\'t force the replace if it looks scary'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'revert' subcommand
#

complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'unrevert' subcommand
#

complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'whatsnew' subcommand
#

complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s u -l unified --description 'Output patch in a darcs-specific format similar to diff -u'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-unified --description 'Output patch in darcs\' usual format'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s l -l look-for-adds --description 'Look for (non-boring) files that could be added'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l boring --description 'Don\'t skip boring files'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-boring --description 'Skip borign files [DEFAULT]'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'record' subcommand
#

complete -c darcs -n 'contains \'record\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l pipe --description 'Ask user interactively for the patch metadata'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l ask-deps --description 'Ask for extra dependencies'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-ask-deps --description 'Don\'t ask for extra dependencies'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l edit-long-comment --description 'Edit the long comment by default'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l skip-long-comment --description 'Don\'t give a long comment'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prompt-long-comment --description 'Prompt for whether to edit the long comment'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s l -l look-for-adds --description 'Look for (non-boring) files that could be added'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l logfile -r --description 'Give patch name and comment in file'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l delete-logfile --description 'Delete the logfile when done'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-delete-logfile --description 'Keep the logfile when done [DEFAULT]'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'unrecord' subcommand
#

complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l dont-prompt-for-dependencies --description 'Don\'t ask about patches that are depended on by matched patches (with --match or --patch)'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l prompt-for-dependencies --description 'Prompt about patches that are depended on by matched patches [DEFAULT]'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'amend-record' subcommand
#

complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l match -x --description 'Select a single patch matching PATTERN'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s p -l patch -x --description 'Select a single patch matching REGEXP'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s n -l index -x --description 'Select one patch'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l edit-long-comment --description 'Edit the long comment by default'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l skip-long-comment --description 'Don\'t give a long comment'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l prompt-long-comment --description 'Prompt for whether to edit the long comment'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s l -l look-for-adds --description 'Look for (non-boring) files that could be added'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'mark-conflicts' subcommand
#

complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'mark-conflicts\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'tag' subcommand
#

complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l pipe --description 'Ask user interactively for the patch metadata'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l edit-long-comment --description 'Edit the long comment by default'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l skip-long-comment --description 'Don\'t give a long comment'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l prompt-long-comment --description 'Prompt for whether to edit the long comment'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'setpref' subcommand
#

complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -x --description 'Shell command that runs regression tests'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -x --description 'Shell command to run before `darcs dist\''
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -x --description 'Path to a version-controlled boring file'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -x --description 'Path to a version-controlled binaries file'


#
# Completions for the 'diff' subcommand
#

complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-tag -x --description 'Select changes up to a tag matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l match -x --description 'Select a single patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s p -l patch -x --description 'Select a single patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s n -l index -x --description 'Select a range of patches'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l diff-command -x -a '(__fish_complete_command)' --description 'Specify diff command (ignores --diff-opts)'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l diff-opts -x --description 'Options to pass to diff'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s u -l unified --description 'Pass -u option to diff'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l no-unified --description 'Output patch in diff\'s dumb format'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l store-in-memory --description 'Do patch application in memory rather than on disk'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l no-store-in-memory --description 'Do patch application on disk [DEFAULT]'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'changes' subcommand
#

complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-tag -x --description 'Select changes up to a tag matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s n -l index -x --description 'Select a range of patches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l max-count -x --description 'Return only NUMBER results'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l only-to-files --description 'Show only changes to specified files'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-only-to-files --description 'Show changes to all files [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l context --description 'Give output suitable for get --context'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l human-readable --description 'Give human-readable output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l number --description 'Number the changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l count --description 'Output count of changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l reverse --description 'Show changes in reverse order'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-reverse --description 'Show changes in the usual order [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l repo -x --description 'Specify the repository URL'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'annotate' subcommand
#

complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s u -l unified --description 'Output patch in a darcs-specific format similar to diff -u'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-unified --description 'Output patch in darcs\' usual format'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l human-readable --description 'Give human-readable output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l match -x --description 'Select a single patch matching PATTERN'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s p -l patch -x --description 'Select a single patch matching REGEXP'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s t -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s n -l index -x --description 'Select one patch'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l creator-hash -x --description 'Specify hash of creator patch (see docs)'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'dist' subcommand
#

complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s d -l dist-name -x --description 'Name of version'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l match -x --description 'Select a single patch matching PATTERN'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s p -l patch -x --description 'Select a single patch matching REGEXP'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s t -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s n -l index -x --description 'Select one patch'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l store-in-memory --description 'Do patch application in memory rather than on disk'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l no-store-in-memory --description 'Do patch application on disk [DEFAULT]'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'trackdown' subcommand
#

complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'show' subcommand
#

complete -c darcs -n 'contains \'show\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'


#
# Completions for the 'pull' subcommand
#

complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l mark-conflicts --description 'Mark conflicts [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l allow-conflicts --description 'Allow conflicts, but don\'t mark them'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l skip-conflicts --description 'Filter out any patches that would create conflicts'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l external-merge -x -a '(__fish_complete_command)' --description 'Use external tool to merge conflicts'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l dont-prompt-for-dependencies --description 'Don\'t ask about patches that are depended on by matched patches (with --match or --patch)'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l prompt-for-dependencies --description 'Prompt about patches that are depended on by matched patches [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l ignore-unrelated-repos --description 'Do not check if repositories are unrelated'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l intersection --description 'Take intersection of all repositories'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l union --description 'Take union of all repositories [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l complement --description 'Take complement of repositories (in order listed)'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l nolinks --description 'Do not link repository or pristine to sibling'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l remote-repo -x --description 'Specify the remote repository URL to work with'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l restrict-paths --description 'Don\'t allow darcs to touch external files or repo metadata'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'obliterate' subcommand
#

complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l dont-prompt-for-dependencies --description 'Don\'t ask about patches that are depended on by matched patches (with --match or --patch)'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l prompt-for-dependencies --description 'Prompt about patches that are depended on by matched patches [DEFAULT]'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'rollback' subcommand
#

complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l edit-long-comment --description 'Edit the long comment by default'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l skip-long-comment --description 'Don\'t give a long comment'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l prompt-long-comment --description 'Prompt for whether to edit the long comment'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'push' subcommand
#

complete -c darcs -n 'contains \'push\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l dont-prompt-for-dependencies --description 'Don\'t ask about patches that are depended on by matched patches (with --match or --patch)'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l prompt-for-dependencies --description 'Prompt about patches that are depended on by matched patches [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign --description 'Sign the patch with your gpg key'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign-as -x --description 'Sign the patch with a given keyid'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign-ssl -x --description 'Sign the patch using openssl with a given private key'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l ignore-unrelated-repos --description 'Do not check if repositories are unrelated'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l apply-as -x -a '(__fish_complete_users)' --description 'Apply patch as another user using sudo'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-apply-as --description 'Don\'t use sudo to apply as another user [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l nolinks --description 'Do not link repository or pristine to sibling'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l remote-repo -x --description 'Specify the remote repository URL to work with'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'send' subcommand
#

complete -c darcs -n 'contains \'send\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l dont-prompt-for-dependencies --description 'Don\'t ask about patches that are depended on by matched patches (with --match or --patch)'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l prompt-for-dependencies --description 'Prompt about patches that are depended on by matched patches [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l from -x --description 'Specify email address'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l to -x --description 'Specify destination email'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l cc -x --description 'Mail results to additional EMAIL(s)'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l subject -x --description 'Specify mail subject'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l in-reply-to -x --description 'Specify in-reply-to header'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s o -l output -r --description 'Specify output filename'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign --description 'Sign the patch with your gpg key'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign-as -x --description 'Sign the patch with a given keyid'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign-ssl -x --description 'Sign the patch using openssl with a given private key'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l edit-description --description 'Edit the patch bundle description'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sendmail-command -x -a '(__fish_complete_command)' --description 'Specify sendmail command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l ignore-unrelated-repos --description 'Do not check if repositories are unrelated'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l logfile -r --description 'Give patch name and comment in file'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l delete-logfile --description 'Delete the logfile when done'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-delete-logfile --description 'Keep the logfile when done [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l remote-repo -x --description 'Specify the remote repository URL to work with'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l context -r --description 'Send to context stored in FILENAME'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'apply' subcommand
#

complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l verify -x --description 'Verify that the patch was signed by a key in PUBRING'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l verify-ssl -x --description 'Verify using openSSL with authorized keys from file KEYS'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-verify --description 'Don\'t verify patch signature'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l mark-conflicts --description 'Mark conflicts'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l allow-conflicts --description 'Allow conflicts, but don\'t mark them'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-resolve-conflicts --description 'Equivalent to --dont-allow-conflicts, for backwards compatibility'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l skip-conflicts --description 'Filter out any patches that would create conflicts'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l external-merge -x -a '(__fish_complete_command)' --description 'Use external tool to merge conflicts'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l reply -x --description 'Reply to email-based patch using FROM address'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l cc -x --description 'Mail results to additional EMAIL(s). Requires --reply'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l happy-forwarding --description 'Forward unsigned messages without extra header'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-happy-forwarding --description 'Don\'t forward unsigned messages without extra header [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l sendmail-command -x -a '(__fish_complete_command)' --description 'Specify sendmail command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l restrict-paths --description 'Don\'t allow darcs to touch external files or repo metadata'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'get' subcommand
#

complete -c darcs -n 'contains \'get\' (commandline -poc)' -l repo-name -x --description '--repodir=DIRECTORY'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l partial --description 'Get partial repository using checkpoint (old-fashioned format only)'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l lazy --description 'Get patch files only as needed'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l ephemeral --description 'Don\'t save patch files in the repository'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l complete --description 'Get a complete copy of the repository'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s t -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l context -r --description 'Version specified by the context in FILENAME'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l nolinks --description 'Do not link repository or pristine to sibling'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l hashed --description 'Convert darcs-1 format to hashed format'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l old-fashioned-inventory --description 'Convert from hashed to darcs-1 format'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'put' subcommand
#

complete -c darcs -n 'contains \'put\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s t -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l context -r --description 'Version specified by the context in FILENAME'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l hashed --description 'Convert darcs-1 format to hashed format'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l old-fashioned-inventory --description 'Convert from hashed to darcs-1 format'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l apply-as -x -a '(__fish_complete_users)' --description 'Apply patch as another user using sudo'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-apply-as --description 'Don\'t use sudo to apply as another user [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'initialize' subcommand
#

complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l hashed --description 'Some new features. Compatible with older repos'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l darcs-2 --description 'All features. Related repos must use same format [DEFAULT]'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l old-fashioned-inventory --description 'Minimal features. What older repos use'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'optimize' subcommand
#

complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l reorder-patches --description 'Reorder the patches in the repository'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l sibling -x --description 'Specify a sibling directory'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l relink --description 'Relink random internal data to a sibling'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l relink-pristine --description 'Relink pristine tree (not recommended)'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l upgrade --description 'Upgrade repository to latest compatible format'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l pristine --description 'Optimize hashed pristine layout'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l uncompress --description 'Uncompress patches'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'check' subcommand
#

complete -c darcs -n 'contains \'check\' (commandline -poc)' -l complete --description 'Get a complete copy of the repository'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l partial --description 'Get partial repository using checkpoint (old-fashioned format only)'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-ignore-times --description 'Trust modification times to find modified files [DEFAULT]'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'repair' subcommand
#

complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l umask -x --description 'Specify umask to use when writing'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'


#
# Completions for the 'convert' subcommand
#

complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l repo-name -x --description '--repodir=DIRECTORY'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l debug --description 'Give only debug output'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l debug-verbose --description 'Give debug and verbose output'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l debug-http --description 'Give debug output for libcurl'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l timings --description 'Provide debugging timings information'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l ssh-cm --description 'Use SSH ControlMaster feature'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l no-ssh-cm --description 'Don\'t use SSH ControlMaster feature [DEFAULT]'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l http-pipelining --description 'Enable HTTP pipelining [DEFAULT]'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l no-http-pipelining --description 'Disable HTTP pipelining'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l no-cache --description 'Don\'t use patch caches'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l remote-darcs -x -a '(__fish_complete_command)' --description 'Name of the darcs executable on the remote server'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l no-posthook --description 'Don\'t run posthook command'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook [DEFAULT]'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l prehook -x -a '(__fish_complete_command)' --description 'Specify command to run before this darcs command'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l no-prehook --description 'Don\'t run prehook command'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l prompt-prehook --description 'Prompt before running prehook [DEFAULT]'
complete -c darcs -n 'contains \'convert\' (commandline -poc)' -l run-prehook --description 'Run prehook command without prompting'



