create table t_lfn (
  id integer primary key,
  name varchar(500) not null,
  ref integer default 0 not null
);
create unique index t_lfn_name on t_lfn(name);

create table t_pfn (
  id integer primary key,
  name varchar(500) not null,
  ref integer default 0 not null
);
create unique index t_pfn_name on t_pfn(name);

create table t_map (
  lfn_id integer not null references t_lfn(id),
  pfn_id integer not null references t_pfn(id)
);
create unique index pk_map on t_map(lfn_id, pfn_id);
create index t_map_pfn_id on t_map(pfn_id);
create index t_map_lfn_id on t_map(lfn_id);

create table t_rli (
  id integer primary key,
  flags integer default 0 not null,
  name varchar(500) not null
);
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id integer not null references t_rli(id),
  pattern varchar(500) not null
);
create unique index pk_rlipartition on t_rlipartition(rli_id, pattern);
create index t_rlipartition_rli_id on t_rlipartition(rli_id);
create index t_rlipartition_pattern on t_rlipartition(pattern);

create table t_attribute (
  id integer primary key,
  name varchar(500) not null,
  objtype integer not null,
  type integer not null
);
create unique index t_attribute_name_objtype on t_attribute(name, objtype);

create table t_date_attr (
  obj_id integer not null,
  attr_id integer not null references t_attribute(id),
  value timestamp not null
);
create index t_date_attr_attr_id on t_date_attr(attr_id);
create index t_date_attr_value on t_date_attr(value);
create unique index t_date_obj_id_attr_id on t_date_attr(obj_id, attr_id);

create table t_flt_attr (
  obj_id integer not null,
  attr_id integer not null references t_attribute(id),
  value float not null
);
create index t_flt_attr_attr_id on t_flt_attr(attr_id);
create index t_flt_attr_value on t_flt_attr(value);
create unique index t_flt_obj_id_attr_id on t_flt_attr(obj_id, attr_id);

create table t_int_attr (
  obj_id integer not null,
  attr_id integer not null references t_attribute(id),
  value integer not null
);
create index t_int_attr_attr_id on t_int_attr(attr_id);
create index t_int_attr_value on t_int_attr(value);
create unique index t_int_obj_id_attr_id on t_int_attr(obj_id, attr_id);

create table t_str_attr (
  obj_id integer not null,
  attr_id integer not null references t_attribute(id),
  value varchar(500) not null
);
create index t_str_attr_attr_id on t_str_attr(attr_id);
create index t_str_attr_value on t_str_attr(value);
create unique index t_str_obj_id_attr_id on t_str_attr(obj_id, attr_id);
