#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "glotski.h"

int toint(char c) { /* if -1 then unsuccessful */
  if (isdigit(c)) return c - '0';
  else if (isupper(c)) return c - 'A' + 10;
  else if (islower(c)) return c - 'a' + 36; 
  else if (c == '.' || c == ' ') return 62;
  else if (c == '#') return 63;
  return -1;
}

level *loadlev(char *levname, int usepath) { /* Assumes well-formed level */
  char in;
  char modebuf[80];
  char *bufptr = modebuf;
  glot *glottable[62];
  glot *tmpglot;
  goal *tmpgoal;
  level *mylevel = NULL;
  int mode = 0;
  int x, y;
  int i, j;
  double id, jd;
  FILE *file;
  if (levname[0] == '\0') {
    printf("Filename required\n");
    return NULL;
  }
  file = fopen(levname, "r");
  if (file == NULL) {
    if (usepath) {
      if (strlen(LEVELPATH) + strlen(levname) >= 80) {
	printf("Path too long\n");
	return NULL;
      }
      strcpy(modebuf, LEVELPATH);
      strcat(modebuf, levname);
      file = fopen(modebuf, "r");
    }
    if (file == NULL) {
      printf("Invalid filename %s\n", levname); 
      return NULL;
    }
  }
  for (i = 0; i < 62; i++) glottable[i] = NULL;
  while (fgets(modebuf, 80, file)) { 
    if (modebuf[strlen(modebuf)-1] != '\n') {
      printf("Lines must be < 80 chars\n");
      if (mylevel) deletelevel(mylevel);
      return NULL;
    }
    if (modebuf[0] != ';') {
      i = 0;
      while (!isspace(modebuf[i])) i++;
      modebuf[i] = '\0';
      if (!strcmp("size", modebuf)) {
	if (mode != 0) {
	  printf("Erroneous size\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr = &(modebuf[strlen(modebuf)+1]);
	x = strtol(bufptr, &bufptr, 10);
	y = strtol(bufptr, &bufptr, 10);
	if (!y) {
	  printf("Must include X and Y size\n");
	  if (mylevel) deletelevel(mylevel); /* Actually this won't exist */
	  return NULL;
	}
	mylevel = makelevel(x, y);
	mode = 1;
      } else if (!strcmp("initial", modebuf)) {
	if (mode != 1) {
	  printf("Erroneous initial\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	for (y = 0; y < mylevel->size[Y]; y++)     /* First pass */ 
	  for (x = 0; x < mylevel->size[X]; x++) { /* Create, not fill */
	    while (isspace((in = getc(file)))) {};
	    if ((j = toint(in)) == -1) {
	      printf("Parsed invalid initial char: %c (%d)\n", in, in);
	      if (mylevel) deletelevel(mylevel);
	      return NULL;
	    }
	    if (j < 62) {
	      if (!glottable[j]) glottable[j] = makeglot(mylevel, x, y);
	      LOOKUP(mylevel, x, y) = glottable[j];
	      if (glottable[j]->size[X] < x - glottable[j]->loc[X] + 1)
		glottable[j]->size[X] = x - glottable[j]->loc[X] + 1;
	      if (glottable[j]->size[Y] < y - glottable[j]->loc[Y] + 1)
		glottable[j]->size[Y] = y - glottable[j]->loc[Y] + 1;
	      
	      if (y < glottable[j]->loc[Y]) { /* Correctors */
		glottable[j]->size[Y] += glottable[j]->loc[Y] - y;
		glottable[j]->loc[Y] = y;
	      }
	      if (x < glottable[j]->loc[X]) {
		glottable[j]->size[X] += glottable[j]->loc[X] - x;
		glottable[j]->loc[X] = x;
	      }

	      if (!(mylevel->equiv = calloc(mylevel->nextid, sizeof(int)))) {
		printf("glotski: Unable to allocate %d bytes for equiv\n",
		       mylevel->nextid*sizeof(int));
		if (mylevel) deletelevel(mylevel);
		return NULL;
	      }


	    } /* if j == 62, space will == NULL anyway so ignore */
	    else if (j == 63) { /* Make a generic blocker */
	      tmpglot = makeglot(mylevel, x, y);
	      tmpglot->type = IMMOBILE;
	      tmpglot->red = 127;
	      tmpglot->green = 127;
	      tmpglot->blue = 127;
	      tmpglot->field = (char *)malloc(sizeof(char));
	      tmpglot->field[0] = 1;
	      LOOKUP(mylevel, x, y) = tmpglot;
	    }
	  }
	for (y = 0; y < mylevel->size[Y]; y++)     /* Second pass */
	  for (x = 0; x < mylevel->size[X]; x++) { /* Fill the masks */
	    tmpglot = LOOKUP(mylevel, x, y);
	    if (tmpglot) {
	      if (!tmpglot->field && !(tmpglot->field = 
				       (char *)calloc(tmpglot->size[X]*
						      tmpglot->size[Y], 
						      sizeof(char)))) {
		printf("glotski: Unable to allocate %d bytes for mask\n", 
		       tmpglot->size[X]*tmpglot->size[Y]*sizeof(char));
		exit(1);
	      } 
	      /* This next check should literally never fail */
	      if (x - tmpglot->loc[X] < 0 || y - tmpglot->loc[Y] < 0 ||
		  x - tmpglot->loc[X] >= tmpglot->size[X] ||
		  y - tmpglot->loc[Y] >= tmpglot->size[Y]) {
		printf("glotski: Second pass sanity check failed: %d %d\n", 
		       x - tmpglot->loc[X], y - tmpglot->loc[Y]);
		exit(1);
	      }
	    LOOKUP(tmpglot, x-tmpglot->loc[X], y-tmpglot->loc[Y]) = 1;
	    }
	  }
	mode = 2;
	while (isspace((in = getc(file)))) {};
	ungetc(in, file);
      } else if (!strcmp("goal", modebuf) || !strcmp("target", modebuf)) {
	if (mode < 2) {
	  printf("Erroneous goal\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}

	tmpgoal = makegoal(mylevel);

	for (y = 0; y < mylevel->size[Y]; y++)
	  for (x = 0; x < mylevel->size[X]; x++) {
	    while (isspace((in = getc(file)))) {};
	    if ((j = toint(in)) == -1) {
	      printf("Parsed invalid goal char: %c (%d)\n", in, in);
	      if (mylevel) deletelevel(mylevel);
	      return NULL;
	    }
	    if (j < 62) LOOKUP(tmpgoal, x, y) = glottable[j];
	}
	while (isspace((in = getc(file)))) {};
	ungetc(in, file);

	mode = 3; /* Parsed at least one goal */
      } else if (!strcmp("color", modebuf)) {
	if (mode < 1) {
	  printf("Erroneous color\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr = &(modebuf[strlen(modebuf)+1]);
	in = *bufptr;
	if ((j = toint(in)) == -1) {
	  printf("Parsed invalid color char: %c (%d)\n", in, in);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	tmpglot = glottable[j];
	if (!tmpglot) {
	  printf("Color char %c does not reference existing glot\n", in);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr++; /* Unsure if += sizeof(char) would be more proper */
	tmpglot->red = strtol(bufptr, &bufptr, 10);
	tmpglot->green = strtol(bufptr, &bufptr, 10);
	tmpglot->blue = strtol(bufptr, &bufptr, 10);
	if (*bufptr == '\0') {
	  printf("Need 3 colors (red green blue) specified\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
      } else if (!strcmp("scale", modebuf)) {
	if (mode < 1) {
	  printf("Erroneous scale\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr = &(modebuf[strlen(modebuf)+1]);
	id = strtod(bufptr, &bufptr);
	jd = strtod(bufptr, &bufptr);
	if (id <= 0.0 || jd <= 0.0) {
	  printf("Erroneous scale values %f %f\n", id, jd);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	mylevel->usize[X] = id*32.0;
	mylevel->usize[Y] = jd*32.0;
	mylevel->scale[X] = id;
	mylevel->scale[Y] = jd;
      } else if (!strcmp("equiv", modebuf)) {
	if (mode < 1) {
	  printf("Erroneous equiv\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	i = strlen(modebuf)+1;
	x = toint(modebuf[i]);
	if (isspace(modebuf[i]) || x == -1 || x >= 62) {
	    printf("Parsed invalid leading equiv char: %c (%d)\n", 
		   modebuf[i], modebuf[i]);
	    if (mylevel) deletelevel(mylevel);
	    return NULL;
	}
	i++;
	while (!isspace(modebuf[i])) {
	  if ((j = toint(modebuf[i])) == -1 || j >= 62) {
	    printf("Parsed invalid equiv char: %c (%d)\n", 
		   modebuf[i], modebuf[i]);
	    if (mylevel) deletelevel(mylevel);
	    return NULL;
	  }
	  eq_unite(mylevel->equiv, &mylevel->uniteid, x, j);
	  i++;
	}
      } else if (!strcmp("type", modebuf)) {
	if (mode < 1) {
	  printf("Erroneous type\n");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr = &(modebuf[strlen(modebuf) + 1]);
	in = *bufptr;
	if ((j = toint(in)) == -1) {
	  printf("Parsed invalid type char: %c (%d)\n", in, in);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	tmpglot = glottable[j];
	if (!tmpglot) {
	  printf("Type char %c does not reference existing glot\n", in);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr += 2; /* Should be 2*sizeof(char) ? */
	switch (*bufptr) {
	case 'i':
	  tmpglot->type = IMMOBILE;
	  break;
	case 'h':
	  tmpglot->type = HORIZONTAL;
	  break;
	case 'v':
	  tmpglot->type = VERTICAL;
	  break;
	case 'b':
	  tmpglot->type = BIMOBILE;
	  break;
	default:
	  printf("Type char %c not a type\n", *bufptr);
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
      } else if (!strcmp("step", modebuf)) {
	if (mode < 1) {
	  printf("Erroneous step");
	  if (mylevel) deletelevel(mylevel);
	  return NULL;
	}
	bufptr = &(modebuf[strlen(modebuf) + 1]);
	mylevel->step = strtol(bufptr, &bufptr, 10);
      } else if (!strcmp("end", modebuf)) {
	break;
      }	else {
	printf("Invalid command string %s\n",modebuf);
	if (mylevel) deletelevel(mylevel);
	return NULL;
      }
    }
  }
  if (mode != 3) {
    printf("Requires a goal to be a valid level\n");
    if (mylevel) deletelevel(mylevel);
    return NULL;
  }
  return mylevel;
}










