#ifndef __GM_OPTIONS_H__
#define __GM_OPTIONS_H__

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_OPTIONS					(gm_options_get_type())
#define GM_OPTIONS(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
											GM_TYPE_OPTIONS, GmOptions))
#define GM_OPTIONS_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
											GM_TYPE_OPTIONS, GmOptions const))
#define GM_OPTIONS_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
											GM_TYPE_OPTIONS, GmOptionsClass))
#define GM_IS_OPTIONS(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
											GM_TYPE_OPTIONS))
#define GM_IS_OPTIONS_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
											GM_TYPE_OPTIONS))
#define GM_OPTIONS_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
											GM_TYPE_OPTIONS, GmOptionsClass))

/* Private structure type */
typedef struct _GmOptionsPrivate GmOptionsPrivate;

/*
 * Main object structure
 */
typedef struct _GmOptions GmOptions;
 
struct _GmOptions {
	GObject object;
	
	/*< private > */
	GmOptionsPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmOptionsClass 	GmOptionsClass;

struct _GmOptionsClass {
	GObjectClass parent_class;

	/* Signals */
	void (* option_changed) (GmOptions *options, gchar const *key);
};

GType gm_options_get_type(void) G_GNUC_CONST;
GmOptions *gm_options_new(void);

GmOptions *gm_options_dup(GmOptions *source);
void gm_options_set(GmOptions *options, gchar const *key, gchar const *value);
gchar const *gm_options_get(GmOptions *options, gchar const *key);
void gm_options_set_int(GmOptions *options, gchar const *key, int value);
int gm_options_get_int(GmOptions *options, gchar const *key);
void gm_options_remove(GmOptions *options, gchar const *key);

void gm_options_save(GmOptions *options);
void gm_options_save_as(GmOptions *options, gchar const *filename);
gboolean gm_options_load(GmOptions *options, gchar const *filename);

void _gm_options_check_old_options(gchar const *filename);

G_END_DECLS

#endif /* __GM_OPTIONS_H__ */
