<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * (excerpt from http://docs.hhvm.com/manual/en/class.splstack.php)
 *
 * The SplStack class provides the main functionalities of a stack
 * implemented using a doubly linked list.
 *
 */
class SplStack extends SplDoublyLinkedList
  implements \HH\Iterator, ArrayAccess, Countable {

  // This doc comment block generated by idl/sysdoc.php
  /**
   * (excerpt from http://docs.hhvm.com/manual/en/splstack.construct.php)
   *
   * This constructs a new empty stack.
   *
   * This method automatically sets the iterator mode to
   * SplDoublyLinkedList::IT_MODE_LIFO.
   *
   * @return     mixed   No value is returned.
   */
  public function __construct() {
    $this->setIteratorMode(self::IT_MODE_LIFO | self::IT_MODE_KEEP);
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * (excerpt from http://docs.hhvm.com/manual/en/splstack.setiteratormode.php)
   *
   *
   * @mode       mixed   There is only one iteration parameter you can
   *                     modify. The behavior of the iterator (either one or
   *                     the other): SplDoublyLinkedList::IT_MODE_DELETE
   *                     (Elements are deleted by the iterator)
   *                     SplDoublyLinkedList::IT_MODE_KEEP (Elements are
   *                     traversed by the iterator)
   *
   *                     The default mode is 0x2 :
   *                     SplDoublyLinkedList::IT_MODE_LIFO |
   *                     SplDoublyLinkedList::IT_MODE_KEEP Warning
   *
   *                     The direction of iteration can no longer be changed
   *                     for SplStacks. Trying to do so will result in a
   *                     RuntimeException being thrown.
   *
   * @return     mixed   No value is returned.
   */
  public function setIteratorMode($mode) {
    if (($mode & self::IT_MODE_LIFO) == 0) {
      throw new RuntimeException(
        'Iterators\' LIFO/FIFO modes for SplStack/SplQueue objects are frozen');
    }
    parent::setIteratorMode($mode);
  }
}
