/*  HomeBank -- Free, easy, personal accounting for everyone.
 *  Copyright (C) 1995-2020 Maxime DOYEN
 *
 *  This file is part of HomeBank.
 *
 *  HomeBank is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  HomeBank is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __HB_EXPORT_H__
#define __HB_EXPORT_H__

#include <cairo-pdf.h>


#define PDF_NUMCOL 6 + 1

typedef struct _pdfprintcontext		PdfPrintContext;

struct _pdfprintcontext {
	gdouble		w, h;
	gdouble		mt, mb, ml, mr;
	gdouble		column_width[PDF_NUMCOL];
	gchar		*column_txt[PDF_NUMCOL];

	PangoFontDescription *desc;
};





void hb_export_qif_account_all(gchar *filename);
void hb_export_qif_account_single(gchar *filename, Account *acc);

void hb_export_pdf_listview(GtkTreeView *treeview, gchar *filepath, gchar *accname);

#endif

