/* diskprovider.c generated by valac 0.22.1, the Vala compiler
 * generated from diskprovider.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include "glibtop/mountlist.h"
#include "glibtop/fsusage.h"
#include <float.h>
#include <math.h>


#define TYPE_PROVIDER (provider_get_type ())
#define PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROVIDER, Provider))
#define PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROVIDER, ProviderClass))
#define IS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROVIDER))
#define IS_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROVIDER))
#define PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROVIDER, ProviderClass))

typedef struct _Provider Provider;
typedef struct _ProviderClass ProviderClass;
typedef struct _ProviderPrivate ProviderPrivate;

#define TYPE_DISK_PROVIDER (disk_provider_get_type ())
#define DISK_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISK_PROVIDER, DiskProvider))
#define DISK_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISK_PROVIDER, DiskProviderClass))
#define IS_DISK_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISK_PROVIDER))
#define IS_DISK_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISK_PROVIDER))
#define DISK_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISK_PROVIDER, DiskProviderClass))

typedef struct _DiskProvider DiskProvider;
typedef struct _DiskProviderClass DiskProviderClass;
typedef struct _DiskProviderPrivate DiskProviderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Provider {
	GObject parent_instance;
	ProviderPrivate * priv;
};

struct _ProviderClass {
	GObjectClass parent_class;
	void (*update) (Provider* self);
};

struct _DiskProvider {
	Provider parent_instance;
	DiskProviderPrivate * priv;
};

struct _DiskProviderClass {
	ProviderClass parent_class;
};

struct _DiskProviderPrivate {
	guint64* lastdata;
	gint lastdata_length1;
	gint _lastdata_size_;
	guint64 lasttime;
};


static gpointer disk_provider_parent_class = NULL;

GType provider_get_type (void) G_GNUC_CONST;
GType disk_provider_get_type (void) G_GNUC_CONST;
#define DISK_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DISK_PROVIDER, DiskProviderPrivate))
enum  {
	DISK_PROVIDER_DUMMY_PROPERTY
};
DiskProvider* disk_provider_new (void);
DiskProvider* disk_provider_construct (GType object_type);
Provider* provider_construct (GType object_type, const gchar* id, gchar** keys, int keys_length1, gchar displaytype);
static gchar** disk_provider_split (DiskProvider* self, const gchar* val, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void disk_provider_real_update (Provider* base);
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle);
gdouble* provider_get_values (Provider* self, int* result_length1);
static guint64* _vala_array_dup4 (guint64* self, int length);
static void disk_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* DISK_PROVIDER_networkfs[4] = {"smbfs", "nfs", "cifs", "fuse.sshfs"};

DiskProvider* disk_provider_construct (GType object_type) {
	DiskProvider * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = g_strdup ("read");
	_tmp1_ = g_strdup ("write");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	self = (DiskProvider*) provider_construct (object_type, "disk", _tmp3_, 2, 's');
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	return self;
}


DiskProvider* disk_provider_new (void) {
	return disk_provider_construct (TYPE_DISK_PROVIDER);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** disk_provider_split (DiskProvider* self, const gchar* val, int* result_length1) {
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gchar* last = NULL;
	gchar* current = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_val_if_fail (IS_DISK_PROVIDER (self), NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_result_ = NULL;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	last = NULL;
	_tmp0_ = val;
	current = (gchar*) _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gchar* _tmp6_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gchar* _tmp3_ = NULL;
				_tmp3_ = current;
				current = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = current;
			if (!((*_tmp4_) != '\0')) {
				break;
			}
			_tmp6_ = current;
			if ((*_tmp6_) == ' ') {
				_tmp5_ = TRUE;
			} else {
				gchar* _tmp7_ = NULL;
				_tmp7_ = current;
				_tmp5_ = (*_tmp7_) == '\n';
			}
			_tmp8_ = _tmp5_;
			if (_tmp8_) {
				gchar* _tmp9_ = NULL;
				_tmp9_ = last;
				if (_tmp9_ != NULL) {
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp10_ = _result_;
					_tmp10__length1 = _result__length1;
					_tmp11_ = last;
					_tmp12_ = current;
					_tmp13_ = last;
					_tmp14_ = g_strndup (_tmp11_, _tmp12_ - _tmp13_);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp14_);
					last = NULL;
				}
			} else {
				gchar* _tmp15_ = NULL;
				_tmp15_ = last;
				if (_tmp15_ == NULL) {
					gchar* _tmp16_ = NULL;
					_tmp16_ = current;
					last = _tmp16_;
				}
			}
		}
	}
	_tmp17_ = last;
	if (_tmp17_ != NULL) {
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp18_ = _result_;
		_tmp18__length1 = _result__length1;
		_tmp19_ = last;
		_tmp20_ = current;
		_tmp21_ = last;
		_tmp22_ = g_strndup (_tmp19_, _tmp20_ - _tmp21_);
		_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp22_);
	}
	_tmp23_ = _result_;
	_tmp23__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static guint64* _vala_array_dup4 (guint64* self, int length) {
	return g_memdup (self, length * sizeof (guint64));
}


static void disk_provider_real_update (Provider* base) {
	DiskProvider * self;
	guint64* newdata = NULL;
	guint64* _tmp0_ = NULL;
	gint newdata_length1 = 0;
	gint _newdata_size_ = 0;
	guint64 newtime = 0ULL;
	guint64 _tmp1_ = 0ULL;
	guint64* _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	guint64* _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	guint64* _tmp82_ = NULL;
	gint _tmp82__length1 = 0;
	guint64 _tmp83_ = 0ULL;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DISK_PROVIDER, DiskProvider);
	_tmp0_ = g_new0 (guint64, 3);
	newdata = _tmp0_;
	newdata_length1 = 3;
	_newdata_size_ = newdata_length1;
	_tmp1_ = g_get_monotonic_time ();
	newtime = _tmp1_;
	{
		GDir* directory = NULL;
		GDir* _tmp2_ = NULL;
		gchar* entry = NULL;
		_tmp2_ = g_dir_open ("/sys/block", (guint) 0, &_inner_error_);
		directory = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		while (TRUE) {
			GDir* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gchar* stat = NULL;
			gchar** stats = NULL;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gchar** _tmp20_ = NULL;
			gint stats_length1 = 0;
			gint _stats_size_ = 0;
			gchar** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			guint64* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			guint64 _tmp25_ = 0ULL;
			guint64 _tmp26_ = 0ULL;
			guint64* _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			const gchar* _tmp29_ = NULL;
			guint64 _tmp30_ = 0ULL;
			guint64 _tmp31_ = 0ULL;
			_tmp3_ = directory;
			_tmp4_ = g_dir_read_name (_tmp3_);
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (entry);
			entry = _tmp5_;
			_tmp6_ = entry;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = entry;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = g_strconcat ("/sys/block/", _tmp8_, "/device", NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_test (_tmp10_, G_FILE_TEST_EXISTS);
			_tmp12_ = !_tmp11_;
			_g_free0 (_tmp10_);
			if (_tmp12_) {
				continue;
			}
			{
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp13_ = entry;
				_tmp14_ = string_to_string (_tmp13_);
				_tmp15_ = g_strconcat ("/sys/block/", _tmp14_, "/stat", NULL);
				_tmp16_ = _tmp15_;
				g_file_get_contents (_tmp16_, &_tmp17_, NULL, &_inner_error_);
				_g_free0 (stat);
				stat = _tmp17_;
				_g_free0 (_tmp16_);
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
				_g_free0 (stat);
				continue;
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_free0 (stat);
				_g_free0 (entry);
				_g_dir_close0 (directory);
				goto __catch1_g_error;
			}
			_tmp18_ = stat;
			_tmp20_ = disk_provider_split (self, _tmp18_, &_tmp19_);
			stats = _tmp20_;
			stats_length1 = _tmp19_;
			_stats_size_ = stats_length1;
			_tmp21_ = stats;
			_tmp21__length1 = stats_length1;
			if (_tmp21__length1 < 8) {
				stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (stat);
				continue;
			}
			_tmp22_ = newdata;
			_tmp22__length1 = newdata_length1;
			_tmp23_ = stats;
			_tmp23__length1 = stats_length1;
			_tmp24_ = _tmp23_[2];
			_tmp25_ = uint64_parse (_tmp24_);
			_tmp22_[0] += 512 * _tmp25_;
			_tmp26_ = _tmp22_[0];
			_tmp27_ = newdata;
			_tmp27__length1 = newdata_length1;
			_tmp28_ = stats;
			_tmp28__length1 = stats_length1;
			_tmp29_ = _tmp28_[6];
			_tmp30_ = uint64_parse (_tmp29_);
			_tmp27_[1] += 512 * _tmp30_;
			_tmp31_ = _tmp27_[1];
			stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (stat);
		}
		_g_free0 (entry);
		_g_dir_close0 (directory);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		glibtop_mountentry* mountentries = NULL;
		gint mountentries_length1 = 0;
		gint _mountentries_size_ = 0;
		glibtop_mountlist mountlist = {0};
		glibtop_mountlist _tmp32_ = {0};
		glibtop_mountentry* _tmp33_ = NULL;
		glibtop_mountentry* _tmp34_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = _tmp33_ = glibtop_get_mountlist (&_tmp32_, FALSE);
		mountlist = _tmp32_;
		mountentries = (g_free (mountentries), NULL);
		mountentries = _tmp34_;
		mountentries_length1 = _vala_array_length (_tmp33_);
		_mountentries_size_ = mountentries_length1;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					gboolean _tmp36_ = FALSE;
					guint _tmp38_ = 0U;
					glibtop_mountlist _tmp39_ = {0};
					guint64 _tmp40_ = 0ULL;
					glibtop_mountentry* _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					guint _tmp42_ = 0U;
					glibtop_mountentry _tmp43_ = {0};
					const gchar* _tmp44_ = NULL;
					glibtop_fsusage fsusage = {0};
					glibtop_mountentry* _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					guint _tmp46_ = 0U;
					glibtop_mountentry _tmp47_ = {0};
					const gchar* _tmp48_ = NULL;
					glibtop_fsusage _tmp49_ = {0};
					guint64* _tmp50_ = NULL;
					gint _tmp50__length1 = 0;
					glibtop_fsusage _tmp51_ = {0};
					guint32 _tmp52_ = 0U;
					glibtop_fsusage _tmp53_ = {0};
					guint64 _tmp54_ = 0ULL;
					guint64 _tmp55_ = 0ULL;
					guint64* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					glibtop_fsusage _tmp57_ = {0};
					guint32 _tmp58_ = 0U;
					glibtop_fsusage _tmp59_ = {0};
					guint64 _tmp60_ = 0ULL;
					guint64 _tmp61_ = 0ULL;
					_tmp36_ = _tmp35_;
					if (!_tmp36_) {
						guint _tmp37_ = 0U;
						_tmp37_ = i;
						i = _tmp37_ + 1;
					}
					_tmp35_ = FALSE;
					_tmp38_ = i;
					_tmp39_ = mountlist;
					_tmp40_ = _tmp39_.number;
					if (!(((guint64) _tmp38_) < _tmp40_)) {
						break;
					}
					_tmp41_ = mountentries;
					_tmp41__length1 = mountentries_length1;
					_tmp42_ = i;
					_tmp43_ = _tmp41_[_tmp42_];
					_tmp44_ = _tmp43_.type;
					if (_vala_string_array_contains (DISK_PROVIDER_networkfs, G_N_ELEMENTS (DISK_PROVIDER_networkfs), _tmp44_)) {
						continue;
					}
					_tmp45_ = mountentries;
					_tmp45__length1 = mountentries_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp45_[_tmp46_];
					_tmp48_ = _tmp47_.mountdir;
					glibtop_get_fsusage (&_tmp49_, _tmp48_);
					fsusage = _tmp49_;
					_tmp50_ = newdata;
					_tmp50__length1 = newdata_length1;
					_tmp51_ = fsusage;
					_tmp52_ = _tmp51_.block_size;
					_tmp53_ = fsusage;
					_tmp54_ = _tmp53_.read;
					_tmp50_[0] += _tmp52_ * _tmp54_;
					_tmp55_ = _tmp50_[0];
					_tmp56_ = newdata;
					_tmp56__length1 = newdata_length1;
					_tmp57_ = fsusage;
					_tmp58_ = _tmp57_.block_size;
					_tmp59_ = fsusage;
					_tmp60_ = _tmp59_.write;
					_tmp56_[1] += _tmp58_ * _tmp60_;
					_tmp61_ = _tmp56_[1];
				}
			}
		}
		mountentries = (g_free (mountentries), NULL);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		newdata = (g_free (newdata), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp62_ = self->priv->lastdata;
	_tmp62__length1 = self->priv->lastdata_length1;
	if (_tmp62__length1 != 0) {
		gdouble delta = 0.0;
		guint64 _tmp63_ = 0ULL;
		guint64 _tmp64_ = 0ULL;
		gdouble* _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		gdouble* _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		guint64* _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		guint64 _tmp68_ = 0ULL;
		guint64* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		guint64 _tmp70_ = 0ULL;
		gdouble _tmp71_ = 0.0;
		gdouble _tmp72_ = 0.0;
		gdouble* _tmp73_ = NULL;
		gint _tmp73__length1 = 0;
		gdouble* _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		guint64* _tmp75_ = NULL;
		gint _tmp75__length1 = 0;
		guint64 _tmp76_ = 0ULL;
		guint64* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		guint64 _tmp78_ = 0ULL;
		gdouble _tmp79_ = 0.0;
		gdouble _tmp80_ = 0.0;
		_tmp63_ = newtime;
		_tmp64_ = self->priv->lasttime;
		delta = (_tmp63_ - _tmp64_) / 1e6;
		_tmp65_ = provider_get_values (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROVIDER, Provider), &_tmp65__length1);
		_tmp66_ = _tmp65_;
		_tmp66__length1 = _tmp65__length1;
		_tmp67_ = newdata;
		_tmp67__length1 = newdata_length1;
		_tmp68_ = _tmp67_[0];
		_tmp69_ = self->priv->lastdata;
		_tmp69__length1 = self->priv->lastdata_length1;
		_tmp70_ = _tmp69_[0];
		_tmp71_ = delta;
		_tmp66_[0] = (_tmp68_ - _tmp70_) / _tmp71_;
		_tmp72_ = _tmp66_[0];
		_tmp73_ = provider_get_values (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROVIDER, Provider), &_tmp73__length1);
		_tmp74_ = _tmp73_;
		_tmp74__length1 = _tmp73__length1;
		_tmp75_ = newdata;
		_tmp75__length1 = newdata_length1;
		_tmp76_ = _tmp75_[1];
		_tmp77_ = self->priv->lastdata;
		_tmp77__length1 = self->priv->lastdata_length1;
		_tmp78_ = _tmp77_[1];
		_tmp79_ = delta;
		_tmp74_[1] = (_tmp76_ - _tmp78_) / _tmp79_;
		_tmp80_ = _tmp74_[1];
	}
	_tmp81_ = newdata;
	_tmp81__length1 = newdata_length1;
	_tmp82_ = (_tmp81_ != NULL) ? _vala_array_dup4 (_tmp81_, _tmp81__length1) : ((gpointer) _tmp81_);
	_tmp82__length1 = _tmp81__length1;
	self->priv->lastdata = (g_free (self->priv->lastdata), NULL);
	self->priv->lastdata = _tmp82_;
	self->priv->lastdata_length1 = _tmp82__length1;
	self->priv->_lastdata_size_ = self->priv->lastdata_length1;
	_tmp83_ = newtime;
	self->priv->lasttime = _tmp83_;
	newdata = (g_free (newdata), NULL);
}


static void disk_provider_class_init (DiskProviderClass * klass) {
	disk_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DiskProviderPrivate));
	PROVIDER_CLASS (klass)->update = disk_provider_real_update;
	G_OBJECT_CLASS (klass)->finalize = disk_provider_finalize;
}


static void disk_provider_instance_init (DiskProvider * self) {
	self->priv = DISK_PROVIDER_GET_PRIVATE (self);
}


static void disk_provider_finalize (GObject* obj) {
	DiskProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DISK_PROVIDER, DiskProvider);
	self->priv->lastdata = (g_free (self->priv->lastdata), NULL);
	G_OBJECT_CLASS (disk_provider_parent_class)->finalize (obj);
}


/******************************************************************************
 * Copyright (C) 2011-2013  Michael Hofmann <mh21@mh21.de>                    *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType disk_provider_get_type (void) {
	static volatile gsize disk_provider_type_id__volatile = 0;
	if (g_once_init_enter (&disk_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DiskProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) disk_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DiskProvider), 0, (GInstanceInitFunc) disk_provider_instance_init, NULL };
		GType disk_provider_type_id;
		disk_provider_type_id = g_type_register_static (TYPE_PROVIDER, "DiskProvider", &g_define_type_info, 0);
		g_once_init_leave (&disk_provider_type_id__volatile, disk_provider_type_id);
	}
	return disk_provider_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



