package tests::OutputFormatsPDFTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::PDF;
use Lire::PluginManager;
use File::Basename qw/dirname/;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'cfg'}{'lr_latex_include'} = '';
    $self->{'testdir'} = dirname( __FILE__ ) ;

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub create_plugin {
    return new Lire::OutputFormats::PDF();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_pdf_init";
}

sub test_missing_requirements {
    my $self = $_[0];

    my $spec = $self->lire_default_config_spec();
    $self->{'cfg'}{'lambda_path'} =
      $spec->get( 'lambda_path' )->instance( 'value' => '/bin/true' );
    $self->{'cfg'}{'odvips_path'} =
      $spec->get( 'odvips_path' )->instance( 'value' => '/bin/true' );
    $self->{'cfg'}{'ps2pdf_path'} =
      $spec->get( 'ps2pdf_path' )->instance( 'value' => '' );

    $self->test_registration_file();
    my $pdf = Lire::PluginManager->get_plugin( 'output_format', 'pdf');
    $self->assert_deep_equals( [ "missing 'ps2pdf' command" ],
                               [ $pdf->missing_requirements() ] );
}

1;
