; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK

define arm_aapcs_vfpcc <4 x i32> @add_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: add_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vaddt.i32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = add <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @add_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: add_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vaddt.i16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = add <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @add_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: add_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vaddt.i8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = add <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @sub_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: sub_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vsubt.i32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = sub <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @sub_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: sub_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vsubt.i16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = sub <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @sub_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: sub_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vsubt.i8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = sub <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @mul_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: mul_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmult.i32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = mul <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @mul_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: mul_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmult.i16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = mul <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @mul_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: mul_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmult.i8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = mul <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @and_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: and_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vandt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = and <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @and_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: and_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vandt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = and <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @and_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: and_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vandt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = and <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @or_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: or_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vorrt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = or <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @or_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: or_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vorrt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = or <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @or_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: or_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vorrt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = or <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @xor_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    veort q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = xor <4 x i32> %x, %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @xor_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    veort q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = xor <8 x i16> %x, %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @xor_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    veort q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = xor <16 x i8> %x, %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @andnot_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: andnot_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vbict q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %y1 = xor <4 x i32> %y, <i32 -1, i32 -1, i32 -1, i32 -1>
  %a = and <4 x i32> %x, %y1
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @andnot_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: andnot_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vbict q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %y1 = xor <8 x i16> %y, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %a = and <8 x i16> %x, %y1
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @andnot_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: andnot_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vbict q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %y1 = xor <16 x i8> %y, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %a = and <16 x i8> %x, %y1
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @ornot_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: ornot_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vornt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %y1 = xor <4 x i32> %y, <i32 -1, i32 -1, i32 -1, i32 -1>
  %a = or <4 x i32> %x, %y1
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @ornot_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: ornot_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vornt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %y1 = xor <8 x i16> %y, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %a = or <8 x i16> %x, %y1
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @ornot_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: ornot_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vornt q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %y1 = xor <16 x i8> %y, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %a = or <16 x i8> %x, %y1
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x float> @fadd_v4f32(<4 x float> %z, <4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vaddt.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %a = fadd <4 x float> %x, %y
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fadd_v8f16(<8 x half> %z, <8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vaddt.f16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %a = fadd <8 x half> %x, %y
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x float> @fsub_v4f32(<4 x float> %z, <4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vsubt.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %a = fsub <4 x float> %x, %y
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fsub_v8f16(<8 x half> %z, <8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: fsub_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vsubt.f16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %a = fsub <8 x half> %x, %y
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x float> @fmul_v4f32(<4 x float> %z, <4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vmult.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %a = fmul <4 x float> %x, %y
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fmul_v8f16(<8 x half> %z, <8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: fmul_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vmult.f16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %a = fmul <8 x half> %x, %y
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x i32> @icmp_slt_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: icmp_slt_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmint.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a1 = icmp slt <4 x i32> %x, %y
  %a = select <4 x i1> %a1, <4 x i32> %x, <4 x i32> %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @icmp_slt_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: icmp_slt_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmint.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a1 = icmp slt <8 x i16> %x, %y
  %a = select <8 x i1> %a1, <8 x i16> %x, <8 x i16> %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @icmp_slt_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: icmp_slt_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmint.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a1 = icmp slt <16 x i8> %x, %y
  %a = select <16 x i1> %a1, <16 x i8> %x, <16 x i8> %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @icmp_sgt_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: icmp_sgt_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmaxt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a1 = icmp sgt <4 x i32> %x, %y
  %a = select <4 x i1> %a1, <4 x i32> %x, <4 x i32> %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @icmp_sgt_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: icmp_sgt_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmaxt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a1 = icmp sgt <8 x i16> %x, %y
  %a = select <8 x i1> %a1, <8 x i16> %x, <8 x i16> %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @icmp_sgt_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: icmp_sgt_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmaxt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a1 = icmp sgt <16 x i8> %x, %y
  %a = select <16 x i1> %a1, <16 x i8> %x, <16 x i8> %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @icmp_ult_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: icmp_ult_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmint.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a1 = icmp ult <4 x i32> %x, %y
  %a = select <4 x i1> %a1, <4 x i32> %x, <4 x i32> %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @icmp_ult_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: icmp_ult_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmint.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a1 = icmp ult <8 x i16> %x, %y
  %a = select <8 x i1> %a1, <8 x i16> %x, <8 x i16> %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @icmp_ult_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: icmp_ult_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmint.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a1 = icmp ult <16 x i8> %x, %y
  %a = select <16 x i1> %a1, <16 x i8> %x, <16 x i8> %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @icmp_ugt_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: icmp_ugt_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmaxt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a1 = icmp ugt <4 x i32> %x, %y
  %a = select <4 x i1> %a1, <4 x i32> %x, <4 x i32> %y
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @icmp_ugt_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: icmp_ugt_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmaxt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a1 = icmp ugt <8 x i16> %x, %y
  %a = select <8 x i1> %a1, <8 x i16> %x, <8 x i16> %y
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @icmp_ugt_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: icmp_ugt_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmaxt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a1 = icmp ugt <16 x i8> %x, %y
  %a = select <16 x i1> %a1, <16 x i8> %x, <16 x i8> %y
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x float> @fcmp_fast_olt_v4f32(<4 x float> %z, <4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: fcmp_fast_olt_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vminnmt.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %a1 = fcmp fast olt <4 x float> %x, %y
  %a = select <4 x i1> %a1, <4 x float> %x, <4 x float> %y
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fcmp_fast_olt_v8f16(<8 x half> %z, <8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: fcmp_fast_olt_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vminnmt.f16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %a1 = fcmp fast olt <8 x half> %x, %y
  %a = select <8 x i1> %a1, <8 x half> %x, <8 x half> %y
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x float> @fcmp_fast_ogt_v4f32(<4 x float> %z, <4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: fcmp_fast_ogt_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vmaxnmt.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %a1 = fcmp fast ogt <4 x float> %x, %y
  %a = select <4 x i1> %a1, <4 x float> %x, <4 x float> %y
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fcmp_fast_ogt_v8f16(<8 x half> %z, <8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: fcmp_fast_ogt_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vmaxnmt.f16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %a1 = fcmp fast ogt <8 x half> %x, %y
  %a = select <8 x i1> %a1, <8 x half> %x, <8 x half> %y
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x i32> @sadd_sat_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: sadd_sat_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqaddt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @sadd_sat_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: sadd_sat_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqaddt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @sadd_sat_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: sadd_sat_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqaddt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @uadd_sat_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: uadd_sat_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqaddt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @uadd_sat_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: uadd_sat_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqaddt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @uadd_sat_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: uadd_sat_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqaddt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @ssub_sat_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: ssub_sat_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqsubt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @ssub_sat_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: ssub_sat_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqsubt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @ssub_sat_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: ssub_sat_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqsubt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @usub_sat_v4i32(<4 x i32> %z, <4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: usub_sat_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqsubt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %a = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @usub_sat_v8i16(<8 x i16> %z, <8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: usub_sat_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqsubt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %a = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @usub_sat_v16i8(<16 x i8> %z, <16 x i8> %x, <16 x i8> %y) {
; CHECK-LABEL: usub_sat_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqsubt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %a = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @addqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: addqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vaddt.i32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = add <4 x i32> %x, %ys
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @addqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: addqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vaddt.i16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = add <8 x i16> %x, %ys
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @addqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: addqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vaddt.i8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = add <16 x i8> %x, %ys
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @subqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: subqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vsubt.i32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = sub <4 x i32> %x, %ys
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @subqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: subqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vsubt.i16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = sub <8 x i16> %x, %ys
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @subqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: subqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vsubt.i8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = sub <16 x i8> %x, %ys
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @mulqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: mulqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vmult.i32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = mul <4 x i32> %x, %ys
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @mulqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: mulqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vmult.i16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = mul <8 x i16> %x, %ys
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @mulqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: mulqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vmult.i8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = mul <16 x i8> %x, %ys
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x float> @faddqr_v4f32(<4 x float> %z, <4 x float> %x, float %y) {
; CHECK-LABEL: faddqr_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vaddt.f32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %i = insertelement <4 x float> undef, float %y, i32 0
  %ys = shufflevector <4 x float> %i, <4 x float> undef, <4 x i32> zeroinitializer
  %a = fadd <4 x float> %x, %ys
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @faddqr_v8f16(<8 x half> %z, <8 x half> %x, half %y) {
; CHECK-LABEL: faddqr_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f16 r0, s8
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vaddt.f16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %i = insertelement <8 x half> undef, half %y, i32 0
  %ys = shufflevector <8 x half> %i, <8 x half> undef, <8 x i32> zeroinitializer
  %a = fadd <8 x half> %x, %ys
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x float> @fsubqr_v4f32(<4 x float> %z, <4 x float> %x, float %y) {
; CHECK-LABEL: fsubqr_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vsubt.f32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %i = insertelement <4 x float> undef, float %y, i32 0
  %ys = shufflevector <4 x float> %i, <4 x float> undef, <4 x i32> zeroinitializer
  %a = fsub <4 x float> %x, %ys
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fsubqr_v8f16(<8 x half> %z, <8 x half> %x, half %y) {
; CHECK-LABEL: fsubqr_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f16 r0, s8
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vsubt.f16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %i = insertelement <8 x half> undef, half %y, i32 0
  %ys = shufflevector <8 x half> %i, <8 x half> undef, <8 x i32> zeroinitializer
  %a = fsub <8 x half> %x, %ys
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x float> @fmulqr_v4f32(<4 x float> %z, <4 x float> %x, float %y) {
; CHECK-LABEL: fmulqr_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vpt.f32 eq, q0, zr
; CHECK-NEXT:    vmult.f32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <4 x float> %z, zeroinitializer
  %i = insertelement <4 x float> undef, float %y, i32 0
  %ys = shufflevector <4 x float> %i, <4 x float> undef, <4 x i32> zeroinitializer
  %a = fmul <4 x float> %x, %ys
  %b = select <4 x i1> %c, <4 x float> %a, <4 x float> %z
  ret <4 x float> %b
}

define arm_aapcs_vfpcc <8 x half> @fmulqr_v8f16(<8 x half> %z, <8 x half> %x, half %y) {
; CHECK-LABEL: fmulqr_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f16 r0, s8
; CHECK-NEXT:    vpt.f16 eq, q0, zr
; CHECK-NEXT:    vmult.f16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = fcmp oeq <8 x half> %z, zeroinitializer
  %i = insertelement <8 x half> undef, half %y, i32 0
  %ys = shufflevector <8 x half> %i, <8 x half> undef, <8 x i32> zeroinitializer
  %a = fmul <8 x half> %x, %ys
  %b = select <8 x i1> %c, <8 x half> %a, <8 x half> %z
  ret <8 x half> %b
}

define arm_aapcs_vfpcc <4 x i32> @sadd_satqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: sadd_satqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqaddt.s32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %x, <4 x i32> %ys)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @sadd_satqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: sadd_satqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqaddt.s16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %x, <8 x i16> %ys)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @sadd_satqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: sadd_satqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqaddt.s8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %x, <16 x i8> %ys)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @uadd_satqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: uadd_satqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqaddt.u32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %x, <4 x i32> %ys)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @uadd_satqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: uadd_satqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqaddt.u16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %x, <8 x i16> %ys)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @uadd_satqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: uadd_satqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqaddt.u8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %x, <16 x i8> %ys)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @ssub_satqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: ssub_satqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqsubt.s32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %x, <4 x i32> %ys)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @ssub_satqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: ssub_satqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqsubt.s16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %x, <8 x i16> %ys)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @ssub_satqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: ssub_satqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqsubt.s8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %x, <16 x i8> %ys)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

define arm_aapcs_vfpcc <4 x i32> @usub_satqr_v4i32(<4 x i32> %z, <4 x i32> %x, i32 %y) {
; CHECK-LABEL: usub_satqr_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vqsubt.u32 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <4 x i32> %z, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %y, i32 0
  %ys = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %a = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %x, <4 x i32> %ys)
  %b = select <4 x i1> %c, <4 x i32> %a, <4 x i32> %z
  ret <4 x i32> %b
}

define arm_aapcs_vfpcc <8 x i16> @usub_satqr_v8i16(<8 x i16> %z, <8 x i16> %x, i16 %y) {
; CHECK-LABEL: usub_satqr_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vqsubt.u16 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <8 x i16> %z, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %y, i32 0
  %ys = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %a = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> %x, <8 x i16> %ys)
  %b = select <8 x i1> %c, <8 x i16> %a, <8 x i16> %z
  ret <8 x i16> %b
}

define arm_aapcs_vfpcc <16 x i8> @usub_satqr_v16i8(<16 x i8> %z, <16 x i8> %x, i8 %y) {
; CHECK-LABEL: usub_satqr_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vqsubt.u8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %c = icmp eq <16 x i8> %z, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %y, i32 0
  %ys = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %a = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> %x, <16 x i8> %ys)
  %b = select <16 x i1> %c, <16 x i8> %a, <16 x i8> %z
  ret <16 x i8> %b
}

declare <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
