/*
 *  @(#)DefaultProblemManagerInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.defimpl;

import net.sourceforge.groboutils.pmti.v1.IProblemManagerInfo;
import net.sourceforge.groboutils.pmti.v1.IIssueTypeInfo;

import java.util.Hashtable;
import java.util.Enumeration;


/**
 * Information about the owning problem manager.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:59 $
 * @since      July 12, 2002
 */
public class DefaultProblemManagerInfo implements IProblemManagerInfo
{
    private String defaultType;
    private Hashtable types = new Hashtable();
    
    /**
     * There must be at least one type info, and the passed-in default type
     * (<tt>dt</tt>) must be contained within the set.
     */
    public DefaultProblemManagerInfo( String dt, IIssueTypeInfo[] t )
    {
        if (dt == null || t == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        boolean foundDT = false;
        for (int i = 0; i < t.length; ++i)
        {
            if (t[i] != null)
            {
                String name = t[i].getName();
                this.types.put( name, t[i] );
                if (dt.equals( name ))
                {
                    foundDT = true;
                }
            }
        }
        if (!foundDT)
        {
            throw new IllegalArgumentException("no such type "+dt);
        }
        this.defaultType = dt;
    }
    
    
    
    /**
     * Returns a list of all known types of issues, which can be used in
     * the creation of a new issue through <tt>createIssue( String )</tt>.
     */
    public String[] getIssueTypes()
    {
        String s[] = new String[ this.types.size() ];
        Enumeration enum = this.types.keys();
        for (int i = 0; enum.hasMoreElements(); ++i)
        {
            s[i] = (String)enum.nextElement();
        }
        return s;
    }
    
    
    /**
     * 
     */
    public String getDefaultType()
    {
        return this.defaultType;
    }
    
    
    /**
     * Returns all relevant meta-information about the issues of the given
     * type.
     */
    public IIssueTypeInfo getTypeInfo( String type )
    {
        return (IIssueTypeInfo)this.types.get( type );
    }
}

