/* Copyright (c) 2000-2001 Ben Woodard
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licence
 * as published by the Free Software Foundation; either version 2
 * of the Licence, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRENTY; without even the implied warrenty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public Licence in the COPYING file for more
 * details.
 *
 * You should have received a copy of the GNU Library General 
 * Public License along with the GNU C Library; see the file 
 * COPYING.LIB.  If not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef __printerconf_h__
#define __printerconf_h__

#include <wchar.h>
#include <stdarg.h>
#include "../../libprintsys/src/printsys.h"

/* Currently supported detection methods: */
typedef enum{
  PCONF_DETECT_PPORT,PCONF_DETECT_NETWORK,PCONF_DETECT_USB,
    //unimplemented
    PCONF_DETECT_HPMULTI, PCONF_DETECT_IRDA } pconf_detect_t;

typedef enum {
  PCONF_PRN_LOCAL,PCONF_PRN_REMOTELPR,PCONF_PRN_DIRECTTCP,
  PCONF_PRN_SAMBA,PCONF_PRN_NCP} pconf_prn_t;

typedef enum { PCONF_OK_ERR, PCONF_NOMEM_ERR, PCONF_BADNAME_ERR, 
	       PCONF_BADSYS_ERR, PCONF_MKSD_ERR } pconf_err_t;

/* Printer detection methods */
typedef struct {
  pconf_detect_t type;
  char description[50];
} pconf_detmethod_t;

/*------------------------------------------------------------------
  pconf_xref_t - a list of printer information cross-referenced by
  a unique printer ID.
------------------------------------------------------------------*/

typedef struct pconf_xref_t {
  char *id;
  char *ppd;
  char *shortdesc;
  char *longdesc;
  struct pconf_xref_t *next;
} pconf_xref_t;

/*------------------------------------------------------------------
  Function Prototypes:
------------------------------------------------------------------*/

pconf_detmethod_t *pconf_get_detection_methods(int *count);
char **pconf_detect_printer(pconf_detect_t dettype,const char *detinfo,
			    int *retval);
pconf_xref_t *pconf_read_xref_file(char *filename);
pconf_xref_t *pconf_find_xref_by_id(char *target_id);

wchar_t *pconf_s_unique_prname(LPS_System_t *sys,const char *ns);
wchar_t *pconf_unique_prname(const char *ns);

LPS_Printer_t *pconf_s_create_printer(LPS_System_t *sys,wchar_t **names,
				      pconf_prn_t type, char *spooldir,
				      pconf_err_t *err, ...);
LPS_Printer_t *pconf_create_printer(wchar_t **names,pconf_prn_t type, 
				    char *spooldir,pconf_err_t *err, ...);
LPS_Printer_t *pconf_v_create_printer(LPS_System_t *sys,wchar_t **names,
				      pconf_prn_t type, char *spooldir,
				      pconf_err_t *err,va_list args);

/* undocumented utility fucntions - 
   these will eventually migrate into a library of their own with some other
   functions from other libraries. */			    
char *_pconf_mkdir_p(const char *path, mode_t mask);

#endif
