/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  XML-level errors, warnings and other diagnostics.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * LibSBML can be configured to use any of a number of XML parsers; at the
 * time of this writing, libSBML supports Xerces versions 2.4 through 3.1,
 * Expat version 1.95.x and higher, and libxml2 version 2.6.16 and higher.
 * These parsers each report different status codes for the various
 * exceptions that can occur during XML processing.  The {@link XMLError} object
 * class abstracts away from the particular diagnostics reported by the
 * different parsers and presents a single uniform interface and set of
 * status codes, along with operations for manipulating the error objects.
 <p>
 * When the libSBML XML parser layer encounters an error in the XML content
 * being processed, or when there is something else wrong (such as an
 * out-of-memory condition), the problems are reported as {@link XMLError} objects.
 * Each {@link XMLError} object instance has an identification number that
 * identifies the nature of the problem.
 * This
 * error identifier is one of the constants listed in the next section below.
 * Applications can use the error identifiers as a means of recognizing the
 * error encountered and changing their behavior if desired.  
 <p>
 * Integer error codes are useful for software, but not so much for telling
 * humans what happened.  For this reason, {@link XMLError} also provides two text
 * messages describing the nature of the error.  These messages are
 * accessible by means of the methods {@link XMLError#getShortMessage()} and
 * {@link XMLError#getMessage()}.  The method {@link XMLError#getShortMessage()} returns
 * a very brief synopsis of the warning or error condition, whereas
 * {@link XMLError#getMessage()} returns a longer explanation.  These text strings
 * are suitable for displaying to human users.
 <p>
 * Each {@link XMLError} object also contains a category code; its value may be
 * retrieved using the method {@link XMLError#getCategory()}.  Category values
 * are drawn from a
 * set of constants whose names begin with the characters <code>LIBSBML_CAT_</code>, described below.&nbsp;Categories
 * are used by libSBML to provide more information to calling programs about
 * the nature of a given error.  
 <p>
 * In addition to category codes, each {@link XMLError} object also has a severity
 * code; its value may be retrieved using the method
 * {@link XMLError#getSeverity()}.  Severity code values are drawn from
 * a
 * set of constants whose names begin with the characters <code>LIBSBML_SEV_</code>,
 * described below. Severity levels range from informational
 * ({@link libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO}) to
 * fatal errors ({@link libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL}).
 <p>
 * Finally, {@link XMLError} objects record the line and column near where the
 * problem occurred in the XML content.  The values can be retrieved using
 * the methods {@link XMLError#getLine()} and {@link XMLError#getColumn()}.  We say 'near
 * where the problem occurred', because many factors affect how accurate
 * the line/column information ultimately is.  For example, sometimes, the
 * underlying XML parsers can only report such information for the parent
 * XML element where an error occurs, and not for the specific point where
 * the problem occurs.  In other situations, some parsers report invalid
 * line and/or column numbers altogether.  If this occurs, libSBML sets the
 * line and/or column number in the {@link XMLError} object to either
 * <code>0</code> or the value of the maximum unsigned long integer
 * representable on the platform where libSBML is running.  The probability
 * that a true line or column number in an SBML model would equal this
 * value is vanishingly small; thus, if an application encounters these
 * values in an {@link XMLError} object, it can assume no valid line/column number
 * could be provided by libSBML in that situation.
 <p>
 * <h3><a class='anchor' 
 * name='error-codes'>Error codes associated with {@link XMLError} objects</a></h3>
 <p>
 * The error and warning codes returned by the XML layer in libSBML are
 * listed in the table below.  In the libSBML Java language interface,
 * these error identifiers are currently implemented as static integer
 * constants defined in the interface class <code><a
 * href='libsbmlConstants.html'>libsbmlConstants</a></code>.  This is
 * admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error
 * identifiers. 
 <p>
 * <center>
 * <table cellspacing='1' cellpadding='1' border='0' width='95%'
          class='text-table normal-font alt-row-colors'>
 * <caption>Possible {@link XMLError} error codes.  Depending on the programming
 * language in use, the <em>Enumerator</em> values will be defined either
 * as a value from an enumeration type 
 * or as integer constants.
 * To make this table more compact, we have shortened the identifiers for
 * the category and severity codes to their essential parts.  To get the
 * actual names of the constants, prepend <code>LIBSBML_CAT_</code> to the
 * category names and <code>LIBSBML_SEV_</code> to the severity names
 * shown in the two right-hand columns.
 * </caption>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *      <th width='90' style='text-align: left'>Category</th>
 *      <th width='90' style='text-align: left'>Severity</th>
 *  </tr>
 * <tr><td>{@link libsbmlConstants#XMLUnknownError XMLUnknownError}</td><td>Unrecognized error encountered internally</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLOutOfMemory XMLOutOfMemory}</td> <td>Out of memory</td><td>SYSTEM</td><td>FATAL</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLFileUnreadable XMLFileUnreadable}</td> <td>File unreadable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLFileUnwritable XMLFileUnwritable}</td> <td>File unwritable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLFileOperationError XMLFileOperationError}</td><td>Error encountered while attempting file operation</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLNetworkAccessError XMLNetworkAccessError}</td><td>Network access error</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#InternalXMLParserError InternalXMLParserError}</td><td>Internal XML parser state error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>{@link libsbmlConstants#UnrecognizedXMLParserCode UnrecognizedXMLParserCode}</td><td>XML parser returned an unrecognized error code</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLTranscoderError XMLTranscoderError}</td><td>Character transcoder error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>{@link libsbmlConstants#MissingXMLDecl MissingXMLDecl}</td><td>Missing XML declaration at beginning of XML input</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#MissingXMLEncoding MissingXMLEncoding}</td><td>Missing encoding attribute in XML declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLDecl BadXMLDecl}</td><td>Invalid or unrecognized XML declaration or XML encoding</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLDOCTYPE BadXMLDOCTYPE}</td><td>Invalid, malformed or unrecognized XML DOCTYPE declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#InvalidCharInXML InvalidCharInXML}</td><td>Invalid character in XML content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadlyFormedXML BadlyFormedXML}</td><td>XML content is not well-formed</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#UnclosedXMLToken UnclosedXMLToken}</td><td>Unclosed XML token</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#InvalidXMLConstruct InvalidXMLConstruct}</td><td>XML construct is invalid or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLTagMismatch XMLTagMismatch}</td><td>Element tag mismatch or missing tag</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#DuplicateXMLAttribute DuplicateXMLAttribute}</td><td>Duplicate XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#UndefinedXMLEntity UndefinedXMLEntity}</td><td>Undefined XML entity</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadProcessingInstruction BadProcessingInstruction}</td><td>Invalid, malformed or unrecognized XML processing instruction</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLPrefix BadXMLPrefix}</td><td>Invalid or undefined XML namespace prefix</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLPrefixValue BadXMLPrefixValue}</td><td>Invalid XML namespace prefix value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#MissingXMLRequiredAttribute MissingXMLRequiredAttribute}</td><td>Missing a required XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLAttributeTypeMismatch XMLAttributeTypeMismatch}</td><td>Data type mismatch for the value of an attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLBadUTF8Content XMLBadUTF8Content}</td><td>Invalid UTF8 content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#MissingXMLAttributeValue MissingXMLAttributeValue}</td><td>Missing or improperly formed attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLAttributeValue BadXMLAttributeValue}</td><td>Invalid or unrecognizable attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLAttribute BadXMLAttribute}</td><td>Invalid, unrecognized or malformed attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#UnrecognizedXMLElement UnrecognizedXMLElement}</td><td>Element either not recognized or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLComment BadXMLComment}</td><td>Badly formed XML comment</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLDeclLocation BadXMLDeclLocation}</td><td>XML declaration not permitted in this location</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLUnexpectedEOF XMLUnexpectedEOF}</td><td>Reached end of input unexpectedly</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLIDValue BadXMLIDValue}</td><td>Value is invalid for XML ID, or has already been used</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLIDRef BadXMLIDRef}</td><td>XML ID value was never declared</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#UninterpretableXMLContent UninterpretableXMLContent}</td><td>Unable to interpret content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#BadXMLDocumentStructure BadXMLDocumentStructure}</td><td>Bad XML document structure</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#InvalidAfterXMLContent InvalidAfterXMLContent}</td><td>Encountered invalid content after expected content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLExpectedQuotedString XMLExpectedQuotedString}</td><td>Expected to find a quoted string</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLEmptyValueNotPermitted XMLEmptyValueNotPermitted}</td><td>An empty value is not permitted in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLBadNumber XMLBadNumber}</td><td>Invalid or unrecognized number</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLBadColon XMLBadColon}</td><td>Colon characters are invalid in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#MissingXMLElements MissingXMLElements}</td><td>One or more expected elements are missing</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>{@link libsbmlConstants#XMLContentEmpty XMLContentEmpty}</td><td>Main XML content is empty</td><td>XML</td><td>ERROR</td></tr>
 * </table>
 * </center>
 <p>
 * <h3><a class='anchor'
 * name='error-categories'>Category codes associated with {@link XMLError} objects</a></h3>
 <p>
 * As discussed above, each {@link XMLError} object contains a value for a category
 * identifier, describing the type of issue that the {@link XMLError} object represents.
 * The category can be retrieved from an {@link XMLError} object using the method
 * {@link XMLError#getCategory()}. The following table lists each possible value
 * and a brief description of its meaning.
 <p>
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file '<a
 * href='libsbmlConstants.html'>libsbmlConstants.java</a>'.
 <p>
 * <center>
 * <table width='95%' cellspacing='1' cellpadding='1' border='0'
 *        class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_INTERNAL LIBSBML_CAT_INTERNAL}</td>
 * <td>A problem involving the libSBML
 * software itself or the underlying XML parser.  This almost certainly
 * indicates a software defect (i.e., bug) in libSBML.  Please report
 * instances of this to the libSBML developers.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SYSTEM LIBSBML_CAT_SYSTEM}</td>
 * <td>A problem reported by the operating
 * system, such as an inability to read or write a file.  This indicates
 * something that is not a program error but is outside of the control of
 * libSBML.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_XML LIBSBML_CAT_XML}</td>
 * <td>A problem in the XML content itself.  This
 * usually arises from malformed XML or the use of
 * constructs not permitted in SBML.</td></tr>
 * </table>
 * </center>
 <p>
 * <h3><a class='anchor'
 * name='error-severities'>Severity codes associated with {@link XMLError} objects</a></h3>
 <p>
 * As described above, each {@link XMLError} object contains a value for a severity
 * code, describing how severe is the issue that the {@link XMLError} object
 * represents.  The severity be retrieved from an {@link XMLError} object using the
 * method {@link XMLError#getSeverity()}. The following table lists each possible
 * value and a brief description of its meaning.
 <p>
 * As is the case with the category codes, in the libSBML Java language
 * interface, these severity codes are currently
 * implemented as static integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file '<a
 * href='libsbmlConstants.html'>libsbmlConstants.java</a>'.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the severity
 * codes. 
 <p>
 * <center>
 * <table width='95%' cellspacing='1' cellpadding='1' border='0'
 *        class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO}</td>
 * <td>The error is actually informational and
 * not necessarily a serious problem.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_SEV_WARNING LIBSBML_SEV_WARNING}</td>
 * <td>The error object represents a problem
 * that is not serious enough to necessarily stop the problem, but
 * applications should take note of the problem and evaluate what its
 * implications may be.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_SEV_ERROR LIBSBML_SEV_ERROR}</td>
 * <td>The error object represents a serious
 * error.  The application may continue running but it is unlikely to be
 * able to continue processing the same XML file or data stream.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL}</td>
 * <td>A serious error occurred, such as an
 * out-of-memory condition, and the software should terminate
 * immediately.</td></tr>
 * </table>
 * </center>
 */

public class XMLError {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLError(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLError obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLError obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_XMLError(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for XMLError.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((XMLError)(sb));
  }

  /**
   * Returns a hashcode for this XMLError object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId, String details, long line, long column, long severity, long category) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_0(errorId, details, line, column, severity, category), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId, String details, long line, long column, long severity) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_1(errorId, details, line, column, severity), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId, String details, long line, long column) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_2(errorId, details, line, column), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId, String details, long line) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_3(errorId, details, line), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId, String details) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_4(errorId, details), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError(int errorId) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_5(errorId), true);
  }

  
/**
   * Creates a new {@link XMLError} to report that something occurred during XML
   * processing.
   <p>
   * {@link XMLError} objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as longeger constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the {@link XMLError} class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows {@link XMLError} to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the {@link XMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link XMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLError() throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_6(), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link XMLError}.
   <p>
   * <code>orig</code> the {@link XMLError} object to copy.
   */ public
 XMLError(XMLError orig) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLError__SWIG_7(XMLError.getCPtr(orig), orig), true);
  }

  
/**
   * Returns the identifier of this error.
   <p>
   * @return the error code for this error.
   <p>
   * @see #getMessage()
   * @see #getShortMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */ public
 long getErrorId() {
    return libsbmlJNI.XMLError_getErrorId(swigCPtr, this);
  }

  
/**
   * Returns the message text of this error.
   <p>
   * The message associated with an error object describes the nature of
   * the problem.  The message returned by this method is generally longer
   * and clearer than the message returned by {@link XMLError#getShortMessage()},
   * but not in all cases.
   <p>
   * Callers may use {@link XMLError#getCategory()} and {@link XMLError#getSeverity()} to
   * obtain additional information about the nature and severity of the
   * problem.
   <p>
   * @return the message text.
   <p>
   * @see #getErrorId()
   * @see #getShortMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */ public
 String getMessage() {
    return libsbmlJNI.XMLError_getMessage(swigCPtr, this);
  }

  
/**
   * Returns a brief message for this error.
   <p>
   * This is an alternative error message that, in general, is as short as
   * the authors could make it.  However, brevity is often inversely
   * proportional to clarity, so this short message may not be sufficiently
   * informative to understand the nature of the error.  Calling
   * applications may wish to check {@link XMLError#getMessage()} in addition or
   * instead.
   <p>
   * @return the short error message text.
   <p>
   * @see #getErrorId()
   * @see #getMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */ public
 String getShortMessage() {
    return libsbmlJNI.XMLError_getShortMessage(swigCPtr, this);
  }

  
/**
   * Returns the line number in the XML input near where the error, warning
   * or other diagnostic occurred.
   <p>
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * sometimes, the underlying XML parsers can only report such information
   * for the parent XML element where an error occurs, and not for the
   * specific point where the problem occurs.  In other situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, libSBML sets the line and/or column number in the {@link XMLError}
   * object to either <code>0</code> or the value of the maximum unsigned
   * long integer representable on the platform where libSBML is running.
   * The probability that a true line or column number in an SBML model
   * would equal this value is vanishingly small; thus, if an application
   * encounters these values in an {@link XMLError} object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   <p>
   * @return the line number.
   <p>
   * @see #getColumn()
   */ public
 long getLine() {
    return libsbmlJNI.XMLError_getLine(swigCPtr, this);
  }

  
/**
   * Returns the column number in the XML input near where the error,
   * warning or other diagnostic occurred.
   <p>
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * sometimes, the underlying XML parsers can only report such information
   * for the parent XML element where an error occurs, and not for the
   * specific point where the problem occurs.  In other situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, libSBML sets the line and/or column number in the {@link XMLError}
   * object to either <code>0</code> or the value of the maximum unsigned
   * long integer representable on the platform where libSBML is running.
   * The probability that a true line or column number in an SBML model
   * would equal this value is vanishingly small; thus, if an application
   * encounters these values in an {@link XMLError} object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   <p>
   * @return the column number.
   <p>
   * @see #getLine()
   */ public
 long getColumn() {
    return libsbmlJNI.XMLError_getColumn(swigCPtr, this);
  }

  
/**
   * Returns the severity of this error.
   <p>
   * {@link XMLError} defines an enumeration of severity codes for the XML layer.
   * Applications that build on {@link XMLError} by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   <p>
   * @return the severity of this {@link XMLError}.
   <p>
   * @see #getSeverityAsString()
   * @see #getCategory()
   */ public
 long getSeverity() {
    return libsbmlJNI.XMLError_getSeverity(swigCPtr, this);
  }

  
/**
   * Returns a string describing the severity level of this error.
   <p>
   * {@link XMLError} defines an enumeration of severity codes for the XML layer.
   * Applications that build on {@link XMLError} by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   <p>
   * @return string representing the severity of this {@link XMLError}.
   <p>
   * @see #getSeverity()
   * @see #getCategoryAsString()
   */ public
 String getSeverityAsString() {
    return libsbmlJNI.XMLError_getSeverityAsString(swigCPtr, this);
  }

  
/**
   * Returns the category of this error.
   <p>
   * {@link XMLError} defines an enumeration of category codes for the XML layer.
   * Applications that build on {@link XMLError} by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   <p>
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an {@link XMLError} by both id and category.
   <p>
   * @return the category of this {@link XMLError}.
   <p>
   * @see #getSeverity()
   * @see #getCategoryAsString()
   */ public
 long getCategory() {
    return libsbmlJNI.XMLError_getCategory(swigCPtr, this);
  }

  
/**
   * Returns a string describing the category of this error.
   <p>
   * {@link XMLError} defines an enumeration of category codes for the XML layer.
   * Applications that build on {@link XMLError} by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   <p>
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an {@link XMLError} by both id and category.
   <p>
   * @return string representing the category of this {@link XMLError}.
   <p>
   * @see #getCategory()
   * @see #getSeverityAsString()
   */ public
 String getCategoryAsString() {
    return libsbmlJNI.XMLError_getCategoryAsString(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error object is for information purposes only.
   <p>
   * This is equivalent to obtaining the severity code from an {@link XMLError}
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value {@link libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO} from the
   * set of predefined
   * severity codes.
   <p>
   * @return <code>true</code> if this {@link XMLError} is for informational purposes only,
   * <code>false</code> otherwise.
   <p>
   * @see #isWarning()
   * @see #isError()
   * @see #isFatal()
   */ public
 boolean isInfo() {
    return libsbmlJNI.XMLError_isInfo(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this error object is a warning.
   <p>
   * This is equivalent to obtaining the severity code from an {@link XMLError}
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value {@link libsbmlConstants#LIBSBML_SEV_WARNING LIBSBML_SEV_WARNING} from the
   * set of predefined
   * severity codes.
   <p>
   * @return <code>true</code> if this error is a warning, <code>false</code> otherwise.
   <p>
   * @see #isInfo()
   * @see #isError()
   * @see #isFatal()
   */ public
 boolean isWarning() {
    return libsbmlJNI.XMLError_isWarning(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error is a significant error.
   <p>
   * This is equivalent to obtaining the severity code from an {@link XMLError}
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value {@link libsbmlConstants#LIBSBML_SEV_ERROR LIBSBML_SEV_ERROR} from the
   * set of predefined
   * severity codes.
   <p>
   * @return <code>true</code> if this error is an error, <code>false</code> otherwise.
   <p>
   * @see #isInfo()
   * @see #isWarning()
   * @see #isFatal()
   */ public
 boolean isError() {
    return libsbmlJNI.XMLError_isError(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error is a fatal run-time error.
   <p>
   * This is equivalent to obtaining the severity code from an {@link XMLError}
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value {@link libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL} from the
   * set of predefined severity codes.
   <p>
   * @return <code>true</code> if this error is a fatal error, <code>false</code> otherwise.
   <p>
   * @see #isInfo()
   * @see #isWarning()
   * @see #isError()
   */ public
 boolean isFatal() {
    return libsbmlJNI.XMLError_isFatal(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error resulted from an internal program error.
   <p>
   * This is equivalent to obtaining the category identifier from an
   * {@link XMLError} object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value {@link libsbmlConstants#LIBSBML_CAT_INTERNAL LIBSBML_CAT_INTERNAL} from the
   * set of predefined category codes.
   <p>
   * @return a boolean indicating whether the error is an internal error.
   <p>
   * @see #isSystem()
   * @see #isXML()
   */ public
 boolean isInternal() {
    return libsbmlJNI.XMLError_isInternal(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error was generated by the operating system.
   <p>
   * This is equivalent to obtaining the category identifier from an
   * {@link XMLError} object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value {@link libsbmlConstants#LIBSBML_CAT_SYSTEM LIBSBML_CAT_SYSTEM} from the
   * set of predefined category codes.
   <p>
   * @return boolean indicating whether the error is a system error.
   <p>
   * @see #isInternal()
   * @see #isXML()
   */ public
 boolean isSystem() {
    return libsbmlJNI.XMLError_isSystem(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error resulted from a problem in the XML input (e.g., an XML syntax
   * error).
   <p>
   * This is equivalent to obtaining the category identifier from an
   * {@link XMLError} object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value {@link libsbmlConstants#LIBSBML_CAT_XML LIBSBML_CAT_XML} from the
   * set of predefined category codes.
   <p>
   * @return a boolean indicating whether the error is an XML catetory error.
   <p>
   * @see #isInternal()
   * @see #isSystem()
   */ public
 boolean isXML() {
    return libsbmlJNI.XMLError_isXML(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error resulted from a problem or whether it was logged as an unknown
   * error.
   <p>
   * This is equivalent to obtaining the error identifier from an
   * {@link XMLError} object (via {@link XMLError#getErrorId()}) and then comparing it to
   * the value XMLUnknownError or UnknownError from the
   * set of predefined error codes.
   <p>
   * @return a boolean indicating whether the error is a valid error (<code>true</code>) 
   * or whether it is unknown (<code>false</code>).
   */ public
 boolean isValid() {
    return libsbmlJNI.XMLError_isValid(swigCPtr, this);
  }

  
/**
   * Sets the line number where this error occurred.
   <p>
   * @param line a long integer, the line number to set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #setColumn(long column)
   */ public
 int setLine(long line) {
    return libsbmlJNI.XMLError_setLine(swigCPtr, this, line);
  }

  
/**
   * Sets the column number where this error occurred.
   <p>
   * @param column a long integer, the column number to set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #setLine(long line)
   */ public
 int setColumn(long column) {
    return libsbmlJNI.XMLError_setColumn(swigCPtr, this, column);
  }

  
/**
   * Returns a copy of the message string associated with the given
   * predefined {@link XMLError} code.
   <p>
   * @param code the error code whose message is sought; it must be a
   * predefined value from <a class='el' href='#error-codes'>the set
   * of predefined error identifiers</a>.
   */ public
 static String getStandardMessage(int code) {
    return libsbmlJNI.XMLError_getStandardMessage(code);
  }

  
/**
   * Returns the SBML Level&nbsp;3 package extension (if any) that logged
   * this error.
   <p>
   * Each error logged by an libSBML extension for SBML Level&nbsp;3 packages
   * includes a record of the package that logged it.  The field is a simple
   * text string.  If the string is empty or has the value <code>'core'</code>, then
   * the error came from libSBML core; otherwise, the string will be the
   * short-form name of the package (e.g., <code>'comp'</code> for the Hierarchical
   * {@link Model} Composition package).
   <p>
   * @return a string representing the name of the package that logged this
   * error.  If the error did not come from a package extension, the value
   * will be the empty string or <code>'core'.</code>
   */ public
 String getPackage() {
    return libsbmlJNI.XMLError_getPackage(swigCPtr, this);
  }

  
/**
   * Returns libSBML's internal numerical offset for the error code
   * associated with this error.
   <p>
   * In the SBML Level&nbsp;3 package specifications, package validation
   * rules are identified by 5-digit numbers prefixed with the nickname of
   * the package itself&mdash;e.g., &ldquo;comp-10101&rdquo;,
   * &ldquo;fbc-20301&rdquo;, etc.  Historically, libSBML reported error
   * codes as pure integers, and some application software systems make
   * decisions based on the numerical values of the error codes.  To permit
   * these applications to continue to function in this fashion, libSBML
   * internally continues to maintain error identifiers as pure integers.  To
   * handle the possibility that errors may come from package extensions,
   * libSBML uses numerical offsets added to the internal error codes.  These
   * offsets add two leading digits to the regular 5-digit error codes; for
   * example, &ldquo;comp&rdquo; error codes are stored as 1010101, 1020102,
   * etc.  The offset in this case is 1000000.  Another package will have the
   * offset 2000000, yet another will have 3000000, etc.
   <p>
   * This method returns the integer offset in this error's error code.
   * Calling applications can get the 5-digit package-specific number for a
   * given error code by subtracting the offset from the value reported by
   * getErrorId():
   * <pre class='fragment'>
 getErrorId() - getErrorIdOffset()
 </pre>
   * When libSBML produces error messages, it combines the text string
   * returned by getPackage() with the subtracted value of the error code,
   * to produce a text string of the form &ldquo;comp-10101&rdquo;.
   <p>
   * @see #getErrorId()
   * @see #getPackage()
   */ public
 long getErrorIdOffset() {
    return libsbmlJNI.XMLError_getErrorIdOffset(swigCPtr, this);
  }

}
