# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_array import DataArray


class LongLongArray(DataArray):
    r"""
    LongLongArray - dynamic, self-adjusting array of long long
    
    Superclass: DataArray
    
    LongLongArray is an array of values of type long long. It provides
    methods for insertion and retrieval of values and will automatically
    resize itself to hold new data.
    
    This class should not be used directly, as it only exists on systems
    where the long long type is defined.  If you need a 64 bit integer
    data array, use TypeInt64Array instead.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLongLongArray, obj, update, **traits)
    
    number_of_values = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the number of values (tuples * components) for this
        object to hold. Does an allocation as well as setting the max_id
        ivar. Used in conjunction with set_value() method for fast
        insertion. Preserves existing data and returns true if allocation
        succeeds, or false otherwise.
        """
    )

    def _number_of_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfValues,
                        self.number_of_values)

    def get_typed_tuple(self, *args):
        """
        get_typed_tuple(self, i:int, tuple:[int, ...]) -> None
        C++: void get_typed_tuple(IdType i, long long *tuple)"""
        ret = self._wrap_call(self._vtk_obj.GetTypedTuple, *args)
        return ret

    def set_typed_tuple(self, *args):
        """
        set_typed_tuple(self, i:int, tuple:(int, ...)) -> None
        C++: void set_typed_tuple(IdType i, const long long *tuple)"""
        ret = self._wrap_call(self._vtk_obj.SetTypedTuple, *args)
        return ret

    def get_value(self, *args):
        """
        get_value(self, id:int) -> int
        C++: long long get_value(IdType id)"""
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, id:int, value:int) -> None
        C++: void set_value(IdType id, long long value)"""
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_data_type_value_max(self):
        return self._vtk_obj.GetDataTypeValueMax()
    data_type_value_max = traits.Property(_get_data_type_value_max, desc=\
        r"""
        Get the maximum data value in its native type.
        """
    )

    def _get_data_type_value_min(self):
        return self._vtk_obj.GetDataTypeValueMin()
    data_type_value_min = traits.Property(_get_data_type_value_min, desc=\
        r"""
        Get the minimum data value in its native type.
        """
    )

    def get_pointer(self, *args):
        """
        get_pointer(self, id:int) -> Pointer
        C++: long long *get_pointer(IdType id)"""
        ret = self._wrap_call(self._vtk_obj.GetPointer, *args)
        return ret

    def _get_value_range(self):
        return self._vtk_obj.GetValueRange()
    value_range = traits.Property(_get_value_range, desc=\
        r"""
        
        """
    )

    def get_value_range(self, *args):
        """
        get_value_range(self, comp:int) -> (int, int)
        C++: long long *get_value_range(int comp)
        get_value_range(self) -> (int, int)
        C++: long long *get_value_range()"""
        ret = self._wrap_call(self._vtk_obj.GetValueRange, *args)
        return ret

    def extended_new(self):
        """
        extended_new() -> LongLongArray
        C++: static LongLongArray *extended_new()"""
        ret = wrap_vtk(self._vtk_obj.ExtendedNew())
        return ret
        

    def insert_next_typed_tuple(self, *args):
        """
        insert_next_typed_tuple(self, tuple:(int, ...)) -> int
        C++: IdType insert_next_typed_tuple(const long long *tuple)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTypedTuple, *args)
        return ret

    def insert_next_value(self, *args):
        """
        insert_next_value(self, f:int) -> int
        C++: IdType insert_next_value(long long f)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextValue, *args)
        return ret

    def insert_typed_tuple(self, *args):
        """
        insert_typed_tuple(self, i:int, tuple:(int, ...)) -> None
        C++: void insert_typed_tuple(IdType i, const long long *tuple)"""
        ret = self._wrap_call(self._vtk_obj.InsertTypedTuple, *args)
        return ret

    def insert_value(self, *args):
        """
        insert_value(self, id:int, f:int) -> None
        C++: void insert_value(IdType id, long long f)"""
        ret = self._wrap_call(self._vtk_obj.InsertValue, *args)
        return ret

    def set_array(self, *args):
        """
        set_array(self, array:Buffer, size:int, save:int) -> None
        C++: void set_array(long long *array, IdType size, int save)
        set_array(self, array:Buffer, size:int, save:int, deleteMethod:int)
             -> None
        C++: void set_array(long long *array, IdType size, int save,
            int deleteMethod)"""
        ret = self._wrap_call(self._vtk_obj.SetArray, *args)
        return ret

    def write_pointer(self, *args):
        """
        write_pointer(self, id:int, number:int) -> Pointer
        C++: long long *write_pointer(IdType id, IdType number)"""
        ret = self._wrap_call(self._vtk_obj.WritePointer, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_values', 'GetNumberOfValues'),
    ('max_discrete_values', 'GetMaxDiscreteValues'), ('name', 'GetName'),
    ('number_of_components', 'GetNumberOfComponents'),
    ('number_of_tuples', 'GetNumberOfTuples'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'max_discrete_values', 'name',
    'number_of_components', 'number_of_tuples', 'number_of_values',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LongLongArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LongLongArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['max_discrete_values', 'name', 'number_of_components',
            'number_of_tuples', 'number_of_values', 'object_name']),
            title='Edit LongLongArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LongLongArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

