/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File PageView.h
// Baudouin Raoult - ECMWF Sep 99

#ifndef PageView_H
#define PageView_H

// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif

#ifndef XPixmap_H
#include "XPixmap.h"
#endif

#ifndef Counted_H
#include "Counted.h"
#endif

#include <Paper.h>


class PageView : public Counted {
public:

// -- Exceptions
	// None

// -- Contructors

	PageView(IconObject*);

// -- Destructor

	virtual ~PageView(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void draw(Widget,PaperGraphics*);
	void edit();

	IconObject* view();


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	PageView(const PageView&);
	PageView& operator=(const PageView&);

// -- Members
	// None

	IconObjectH object_;
	XMString    name_;
	XPixmap     pixmap_;
	int         width_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const PageView& p)
	//	{ p.print(s); return s; }

};

inline void destroy(PageView**) {}

class PageViewH : public  Handle<PageView> {
public:
	PageViewH(PageView* o = 0) : Handle<PageView>(o) {}
};

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(PageView);
//#endif

#endif
