/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ScaleLine_H
#include "ScaleLine.h"
#endif

#include <Xm/Scale.h>
							  
#ifndef Request_H
#include "Request.h"
#endif


#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#ifndef XResource_H
#include "XResource.h"
#endif

#include <mars.h>





ScaleLine::ScaleLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIScaleLine_c>(owner,param)
{
      static void* translator[] = {
			XResourceTranslator("max", XmNmaximum),
			XResourceTranslator("min", XmNminimum),
			XResourceTranslator("step", XmNscaleMultiple),
			XResourceTranslator("direction", XmNprocessingDirection, 
						XEnumTranslator("max_on_left", int(XmMAX_ON_LEFT))	 +
						XEnumTranslator("max_on_right", int(XmMAX_ON_RIGHT))
					             ),
		};

}

ScaleLine::~ScaleLine()
{
}

void ScaleLine::init(Widget w)
{
	XRequestPanelLine<UIScaleLine_c>::init(w); 					  
	XResource::setValues(scale_,param_.interfaceRequest());
}

void ScaleLine::refresh(const vector<string>& values)
{
	if(values.size() == 0) return;
	long value = atol(values[0].c_str());
	XmScaleSetValue(scale_, value);
}

void ScaleLine::set(Request& r)
{
	int value = 0;
	XmScaleGetValue(scale_, &value);
	r(param_.name()) = value;
}


void ScaleLine::changedCB(Widget,XtPointer)
{
	owner_.changed(*this);
}

static LineMaker<ScaleLine> maker("slider");
