/*
 * NASPRO - The NASPRO Architecture for Sound PROcessing
 * Core library
 *
 * Copyright (C) 2007-2013 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#include "internal.h"

#include <dlfcn.h>

_NACORE_DEF nacore_dl_handle
nacore_dl_open(const char *filename, nacore_msg_context msg_context,
	       void *msg_data)
{
	nacore_dl_handle ret;

	ret = dlopen(filename, RTLD_LAZY);
	if (ret == NULL)
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not load the dynamic library (%s)",
				dlerror());

	return ret;
}

_NACORE_DEF void *
nacore_dl_sym(nacore_dl_handle handle, const char *symbol,
	      nacore_msg_context msg_context, void *msg_data)
{
	void *ret;
	char *err;

	dlerror();	// Clear any existing error

	ret = dlsym(handle, symbol);

	err = dlerror();
	if (err != NULL)
	  {
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not resolve symbol `%s' (%s)", symbol,
				err);
		errno = NACORE_EUNKNOWN;
	  }

	return ret;
}

_NACORE_DEF int
nacore_dl_close(nacore_dl_handle handle, nacore_msg_context msg_context,
		void *msg_data)
{
	int ret;

	ret = dlclose(handle);
	if (ret != 0)
		nacore_msg_text(msg_context, nacore_msg_severity_err, msg_data,
				"Could not unload the dynamic library (%s)",
				dlerror());

	return ret;
}
