/*
 * This file is auto-generated by running 'make debug_defines.h' in
 * https://github.com/riscv/riscv-debug-spec/ (d749752)
 */

#define DTM_IDCODE                          0x01
/*
 * Identifies the release version of this part.
 */
#define DTM_IDCODE_VERSION_OFFSET           0x1c
#define DTM_IDCODE_VERSION_LENGTH           4
#define DTM_IDCODE_VERSION                  0xf0000000U
/*
 * Identifies the designer's part number of this part.
 */
#define DTM_IDCODE_PARTNUMBER_OFFSET        0xc
#define DTM_IDCODE_PARTNUMBER_LENGTH        0x10
#define DTM_IDCODE_PARTNUMBER               0xffff000
/*
 * Identifies the designer/manufacturer of this part. Bits 6:0 must be
 * bits 6:0 of the designer/manufacturer's Identification Code as
 * assigned by JEDEC Standard JEP106. Bits 10:7 contain the modulo-16
 * count of the number of continuation characters (0x7f) in that same
 * Identification Code.
 */
#define DTM_IDCODE_MANUFID_OFFSET           1
#define DTM_IDCODE_MANUFID_LENGTH           0xb
#define DTM_IDCODE_MANUFID                  0xffe
#define DTM_IDCODE_1_OFFSET                 0
#define DTM_IDCODE_1_LENGTH                 1
#define DTM_IDCODE_1                        1
#define DTM_DTMCS                           0x10
/*
 * Writing 1 to this bit does a hard reset of the DTM,
 * causing the DTM to forget about any outstanding DMI transactions, and
 * returning all registers and internal state to their reset value.
 * In general this should only be used when the Debugger has
 * reason to expect that the outstanding DMI transaction will never
 * complete (e.g. a reset condition caused an inflight DMI transaction to
 * be cancelled).
 */
#define DTM_DTMCS_DMIHARDRESET_OFFSET       0x11
#define DTM_DTMCS_DMIHARDRESET_LENGTH       1
#define DTM_DTMCS_DMIHARDRESET              0x20000
/*
 * Writing 1 to this bit clears the sticky error state, but does
 * not affect outstanding DMI transactions.
 */
#define DTM_DTMCS_DMIRESET_OFFSET           0x10
#define DTM_DTMCS_DMIRESET_LENGTH           1
#define DTM_DTMCS_DMIRESET                  0x10000
/*
 * This is a hint to the debugger of the minimum number of
 * cycles a debugger should spend in
 * Run-Test/Idle after every DMI scan to avoid a `busy'
 * return code (\FdtmDtmcsDmistat of 3). A debugger must still
 * check \FdtmDtmcsDmistat when necessary.
 *
 * 0: It is not necessary to enter Run-Test/Idle at all.
 *
 * 1: Enter Run-Test/Idle and leave it immediately.
 *
 * 2: Enter Run-Test/Idle and stay there for 1 cycle before leaving.
 *
 * And so on.
 */
#define DTM_DTMCS_IDLE_OFFSET               0xc
#define DTM_DTMCS_IDLE_LENGTH               3
#define DTM_DTMCS_IDLE                      0x7000
/*
 * Read-only alias of \FdtmDmiOp.
 */
#define DTM_DTMCS_DMISTAT_OFFSET            0xa
#define DTM_DTMCS_DMISTAT_LENGTH            2
#define DTM_DTMCS_DMISTAT                   0xc00
/*
 * The size of \FdmSbaddressZeroAddress in \RdtmDmi.
 */
#define DTM_DTMCS_ABITS_OFFSET              4
#define DTM_DTMCS_ABITS_LENGTH              6
#define DTM_DTMCS_ABITS                     0x3f0
#define DTM_DTMCS_VERSION_OFFSET            0
#define DTM_DTMCS_VERSION_LENGTH            4
#define DTM_DTMCS_VERSION                   0xf
/*
 * 0.11: Version described in spec version 0.11.
 */
#define DTM_DTMCS_VERSION_0_11              0
/*
 * 1.0: Version described in spec versions 0.13 and 1.0.
 */
#define DTM_DTMCS_VERSION_1_0               1
/*
 * custom: Version not described in any available version of this spec.
 */
#define DTM_DTMCS_VERSION_CUSTOM            15
#define DTM_DMI                             0x11
/*
 * Address used for DMI access. In Update-DR this value is used
 * to access the DM over the DMI.
 */
#define DTM_DMI_ADDRESS_OFFSET              0x22
#define DTM_DMI_ADDRESS_LENGTH(abits)       abits
#define DTM_DMI_ADDRESS(abits)              ((0x400000000ULL * (1ULL<<abits)) + -0x400000000ULL)
/*
 * The data to send to the DM over the DMI during Update-DR, and
 * the data returned from the DM as a result of the previous operation.
 */
#define DTM_DMI_DATA_OFFSET                 2
#define DTM_DMI_DATA_LENGTH                 0x20
#define DTM_DMI_DATA                        0x3fffffffcULL
/*
 * When the debugger writes this field, it has the following meaning:
 */
#define DTM_DMI_OP_OFFSET                   0
#define DTM_DMI_OP_LENGTH                   2
#define DTM_DMI_OP                          3
/*
 * nop: Ignore \FdmSbdataZeroData and \FdmSbaddressZeroAddress.
 *
 * Don't send anything over the DMI during Update-DR.
 * This operation should never result in a busy or error response.
 * The address and data reported in the following Capture-DR
 * are undefined.
 */
#define DTM_DMI_OP_NOP                      0
/*
 * read: Read from \FdmSbaddressZeroAddress.
 */
#define DTM_DMI_OP_READ                     1
/*
 * write: Write \FdmSbdataZeroData to \FdmSbaddressZeroAddress.
 */
#define DTM_DMI_OP_WRITE                    2
/*
 * reserved: Reserved.
 */
/*
 * When the debugger reads this field, it means the following:
 */
/*
 * success: The previous operation completed successfully.
 */
#define DTM_DMI_OP_SUCCESS                  0
/*
 * reserved: Reserved.
 */
/*
 * failed: A previous operation failed.  The data scanned into \RdtmDmi in
 * this access will be ignored.  This status is sticky and can be
 * cleared by writing \FdtmDtmcsDmireset in \RdtmDtmcs.
 *
 * This indicates that the DM itself responded with an error.
 * There are no specified cases in which the DM would
 * respond with an error, and DMI is not required to support
 * returning errors.
 */
#define DTM_DMI_OP_FAILED                   2
/*
 * busy: An operation was attempted while a DMI request is still in
 * progress. The data scanned into \RdtmDmi in this access will be
 * ignored. This status is sticky and can be cleared by writing
 * \FdtmDtmcsDmireset in \RdtmDtmcs. If a debugger sees this status, it
 * needs to give the target more TCK edges between Update-DR and
 * Capture-DR. The simplest way to do that is to add extra transitions
 * in Run-Test/Idle.
 */
#define DTM_DMI_OP_BUSY                     3
#define CSR_DCSR                            0x7b0
#define CSR_DCSR_DEBUGVER_OFFSET            0x1c
#define CSR_DCSR_DEBUGVER_LENGTH            4
#define CSR_DCSR_DEBUGVER                   0xf0000000U
/*
 * none: There is no debug support.
 */
#define CSR_DCSR_DEBUGVER_NONE              0
/*
 * 1.0: Debug support exists as it is described in this document.
 */
#define CSR_DCSR_DEBUGVER_1_0               4
/*
 * custom: There is debug support, but it does not conform to any
 * available version of this spec.
 */
#define CSR_DCSR_DEBUGVER_CUSTOM            15
#define CSR_DCSR_EBREAKVS_OFFSET            0x11
#define CSR_DCSR_EBREAKVS_LENGTH            1
#define CSR_DCSR_EBREAKVS                   0x20000
/*
 * exception: {\tt ebreak} instructions in VS-mode behave as described in the
 * Privileged Spec.
 */
#define CSR_DCSR_EBREAKVS_EXCEPTION         0
/*
 * debug mode: {\tt ebreak} instructions in VS-mode enter Debug Mode.
 */
#define CSR_DCSR_EBREAKVS_DEBUG_MODE        1
/*
 * This bit is hardwired to 0 if the hart does not support virtualization mode.
 */
#define CSR_DCSR_EBREAKVU_OFFSET            0x10
#define CSR_DCSR_EBREAKVU_LENGTH            1
#define CSR_DCSR_EBREAKVU                   0x10000
/*
 * exception: {\tt ebreak} instructions in VU-mode behave as described in the
 * Privileged Spec.
 */
#define CSR_DCSR_EBREAKVU_EXCEPTION         0
/*
 * debug mode: {\tt ebreak} instructions in VU-mode enter Debug Mode.
 */
#define CSR_DCSR_EBREAKVU_DEBUG_MODE        1
/*
 * This bit is hardwired to 0 if the hart does not support virtualization mode.
 */
#define CSR_DCSR_EBREAKM_OFFSET             0xf
#define CSR_DCSR_EBREAKM_LENGTH             1
#define CSR_DCSR_EBREAKM                    0x8000
/*
 * exception: {\tt ebreak} instructions in M-mode behave as described in the
 * Privileged Spec.
 */
#define CSR_DCSR_EBREAKM_EXCEPTION          0
/*
 * debug mode: {\tt ebreak} instructions in M-mode enter Debug Mode.
 */
#define CSR_DCSR_EBREAKM_DEBUG_MODE         1
#define CSR_DCSR_EBREAKS_OFFSET             0xd
#define CSR_DCSR_EBREAKS_LENGTH             1
#define CSR_DCSR_EBREAKS                    0x2000
/*
 * exception: {\tt ebreak} instructions in S-mode behave as described in the
 * Privileged Spec.
 */
#define CSR_DCSR_EBREAKS_EXCEPTION          0
/*
 * debug mode: {\tt ebreak} instructions in S-mode enter Debug Mode.
 */
#define CSR_DCSR_EBREAKS_DEBUG_MODE         1
/*
 * This bit is hardwired to 0 if the hart does not support S-mode.
 */
#define CSR_DCSR_EBREAKU_OFFSET             0xc
#define CSR_DCSR_EBREAKU_LENGTH             1
#define CSR_DCSR_EBREAKU                    0x1000
/*
 * exception: {\tt ebreak} instructions in U-mode behave as described in the
 * Privileged Spec.
 */
#define CSR_DCSR_EBREAKU_EXCEPTION          0
/*
 * debug mode: {\tt ebreak} instructions in U-mode enter Debug Mode.
 */
#define CSR_DCSR_EBREAKU_DEBUG_MODE         1
/*
 * This bit is hardwired to 0 if the hart does not support U-mode.
 */
#define CSR_DCSR_STEPIE_OFFSET              0xb
#define CSR_DCSR_STEPIE_LENGTH              1
#define CSR_DCSR_STEPIE                     0x800
/*
 * interrupts disabled: Interrupts (including NMI) are disabled during single stepping.
 */
#define CSR_DCSR_STEPIE_INTERRUPTS_DISABLED 0
/*
 * interrupts enabled: Interrupts (including NMI) are enabled during single stepping.
 */
#define CSR_DCSR_STEPIE_INTERRUPTS_ENABLED  1
/*
 * Implementations may hard wire this bit to 0.
 * In that case interrupt behavior can be emulated by the debugger.
 *
 * The debugger must not change the value of this bit while the hart
 * is running.
 */
#define CSR_DCSR_STOPCOUNT_OFFSET           0xa
#define CSR_DCSR_STOPCOUNT_LENGTH           1
#define CSR_DCSR_STOPCOUNT                  0x400
/*
 * normal: Increment counters as usual.
 */
#define CSR_DCSR_STOPCOUNT_NORMAL           0
/*
 * freeze: Don't increment any hart-local counters while in Debug Mode or
 * on {\tt ebreak} instructions that cause entry into Debug Mode.
 * These counters include the {\tt instret} CSR. On single-hart cores
 * {\tt cycle} should be stopped, but on multi-hart cores it must keep
 * incrementing.
 */
#define CSR_DCSR_STOPCOUNT_FREEZE           1
/*
 * An implementation may hardwire this bit to 0 or 1.
 */
#define CSR_DCSR_STOPTIME_OFFSET            9
#define CSR_DCSR_STOPTIME_LENGTH            1
#define CSR_DCSR_STOPTIME                   0x200
/*
 * normal: Increment \Rtime as usual.
 */
#define CSR_DCSR_STOPTIME_NORMAL            0
/*
 * freeze: Don't increment \Rtime while in Debug Mode.  If all harts
 * have \FcsrDcsrStoptime=1 and are in Debug Mode then \Rmtime
 * is also allowed to stop incrementing.
 */
#define CSR_DCSR_STOPTIME_FREEZE            1
/*
 * An implementation may hardwire this bit to 0 or 1.
 */
/*
 * Explains why Debug Mode was entered.
 *
 * When there are multiple reasons to enter Debug Mode in a single
 * cycle, hardware should set \FcsrDcsrCause to the cause with the highest
 * priority.  See table~\ref{tab:dcsrcausepriority} for priorities.
 */
#define CSR_DCSR_CAUSE_OFFSET               6
#define CSR_DCSR_CAUSE_LENGTH               3
#define CSR_DCSR_CAUSE                      0x1c0
/*
 * ebreak: An {\tt ebreak} instruction was executed.
 */
#define CSR_DCSR_CAUSE_EBREAK               1
/*
 * trigger: A Trigger Module trigger fired with action=1.
 */
#define CSR_DCSR_CAUSE_TRIGGER              2
/*
 * haltreq: The debugger requested entry to Debug Mode using \FdmDmcontrolHaltreq.
 */
#define CSR_DCSR_CAUSE_HALTREQ              3
/*
 * step: The hart single stepped because \FcsrDcsrStep was set.
 */
#define CSR_DCSR_CAUSE_STEP                 4
/*
 * resethaltreq: The hart halted directly out of reset due to \Fresethaltreq. It
 * is also acceptable to report 3 when this happens.
 */
#define CSR_DCSR_CAUSE_RESETHALTREQ         5
/*
 * group: The hart halted because it's part of a halt group.
 * Harts may report 3 for this cause instead.
 */
#define CSR_DCSR_CAUSE_GROUP                6
/*
 * Other values are reserved for future use.
 */
/*
 * Extends the prv field with the virtualization mode the hart was operating
 * in when Debug Mode was entered. The encoding is described in Table
 * \ref{tab:privmode}.
 * A debugger can change this value to change the hart's virtualization mode
 * when exiting Debug Mode.
 * This bit is hardwired to 0 on harts that do not support virtualization mode.
 */
#define CSR_DCSR_V_OFFSET                   5
#define CSR_DCSR_V_LENGTH                   1
#define CSR_DCSR_V                          0x20
#define CSR_DCSR_MPRVEN_OFFSET              4
#define CSR_DCSR_MPRVEN_LENGTH              1
#define CSR_DCSR_MPRVEN                     0x10
/*
 * disabled: \FcsrMstatusMprv in \Rmstatus is ignored in Debug Mode.
 */
#define CSR_DCSR_MPRVEN_DISABLED            0
/*
 * enabled: \FcsrMstatusMprv in \Rmstatus takes effect in Debug Mode.
 */
#define CSR_DCSR_MPRVEN_ENABLED             1
/*
 * Implementing this bit is optional. It may be tied to either 0 or 1.
 */
/*
 * When set, there is a Non-Maskable-Interrupt (NMI) pending for the hart.
 *
 * Since an NMI can indicate a hardware error condition,
 * reliable debugging may no longer be possible once this bit becomes set.
 * This is implementation-dependent.
 */
#define CSR_DCSR_NMIP_OFFSET                3
#define CSR_DCSR_NMIP_LENGTH                1
#define CSR_DCSR_NMIP                       8
/*
 * When set and not in Debug Mode, the hart will only execute a single
 * instruction and then enter Debug Mode. See Section~\ref{stepBit}
 * for details.
 *
 * The debugger must not change the value of this bit while the hart
 * is running.
 */
#define CSR_DCSR_STEP_OFFSET                2
#define CSR_DCSR_STEP_LENGTH                1
#define CSR_DCSR_STEP                       4
/*
 * Contains the privilege mode the hart was operating in when Debug
 * Mode was entered. The encoding is described in Table
 * \ref{tab:privmode}.  A debugger can change this value to change
 * the hart's privilege mode when exiting Debug Mode.
 *
 * Not all privilege modes are supported on all harts. If the
 * encoding written is not supported or the debugger is not allowed to
 * change to it, the hart may change to any supported privilege mode.
 */
#define CSR_DCSR_PRV_OFFSET                 0
#define CSR_DCSR_PRV_LENGTH                 2
#define CSR_DCSR_PRV                        3
#define CSR_DPC                             0x7b1
#define CSR_DPC_DPC_OFFSET                  0
#define CSR_DPC_DPC_LENGTH(DXLEN)           DXLEN
#define CSR_DPC_DPC(DXLEN)                  ((1ULL<<DXLEN) + -1)
#define CSR_DSCRATCH0                       0x7b2
#define CSR_DSCRATCH1                       0x7b3
#define CSR_TSELECT                         0x7a0
#define CSR_TSELECT_INDEX_OFFSET            0
#define CSR_TSELECT_INDEX_LENGTH(XLEN)      XLEN
#define CSR_TSELECT_INDEX(XLEN)             ((1ULL<<XLEN) + -1)
#define CSR_TDATA1                          0x7a1
#define CSR_TDATA1_TYPE_OFFSET(XLEN)        (XLEN + -4)
#define CSR_TDATA1_TYPE_LENGTH              4
#define CSR_TDATA1_TYPE(XLEN)               (0xf * (1ULL<<(XLEN + -4)))
/*
 * none: There is no trigger at this \RcsrTselect.
 */
#define CSR_TDATA1_TYPE_NONE                0
/*
 * legacy: The trigger is a legacy SiFive address match trigger. These
 * should not be implemented and aren't further documented here.
 */
#define CSR_TDATA1_TYPE_LEGACY              1
/*
 * mcontrol: The trigger is an address/data match trigger. The remaining bits
 * in this register act as described in \RcsrMcontrol.
 */
#define CSR_TDATA1_TYPE_MCONTROL            2
/*
 * icount: The trigger is an instruction count trigger. The remaining bits
 * in this register act as described in \RcsrIcount.
 */
#define CSR_TDATA1_TYPE_ICOUNT              3
/*
 * itrigger: The trigger is an interrupt trigger. The remaining bits
 * in this register act as described in \RcsrItrigger.
 */
#define CSR_TDATA1_TYPE_ITRIGGER            4
/*
 * etrigger: The trigger is an exception trigger. The remaining bits
 * in this register act as described in \RcsrEtrigger.
 */
#define CSR_TDATA1_TYPE_ETRIGGER            5
/*
 * mcontrol6: The trigger is an address/data match trigger. The remaining bits
 * in this register act as described in \RcsrMcontrolSix. This is similar
 * to a type 2 trigger, but provides additional functionality and
 * should be used instead of type 2 in newer implementations.
 */
#define CSR_TDATA1_TYPE_MCONTROL6           6
/*
 * tmexttrigger: The trigger is a trigger source external to the TM.  The
 * remaining bits in this register act as described in \RcsrTmexttrigger.
 */
#define CSR_TDATA1_TYPE_TMEXTTRIGGER        7
/*
 * custom: These trigger types are available for non-standard use.
 */
#define CSR_TDATA1_TYPE_CUSTOM_LOW          12
#define CSR_TDATA1_TYPE_CUSTOM_HIGH         14
/*
 * disabled: This trigger is disabled. In this state, \RcsrTdataTwo and
 * \RcsrTdataThree can be written with any value that is supported for
 * any of the types this trigger implements. The remaining bits in this
 * register are ignored.
 */
#define CSR_TDATA1_TYPE_DISABLED            15
/*
 * Other values are reserved for future use.
 */
/*
 * If \FcsrTdataOneType is 0, then this bit is hard-wired to 0.
 */
#define CSR_TDATA1_DMODE_OFFSET(XLEN)       (XLEN + -5)
#define CSR_TDATA1_DMODE_LENGTH             1
#define CSR_TDATA1_DMODE(XLEN)              (1ULL<<(XLEN + -5))
/*
 * both: Both Debug and M-mode can write the {\tt tdata} registers at the
 * selected \RcsrTselect.
 */
#define CSR_TDATA1_DMODE_BOTH               0
/*
 * dmode: Only Debug Mode can write the {\tt tdata} registers at the
 * selected \RcsrTselect.  Writes from other modes are ignored.
 */
#define CSR_TDATA1_DMODE_DMODE              1
/*
 * This bit is only writable from Debug Mode.
 * In ordinary use, external debuggers will always set this bit when
 * configuring a trigger.
 * When clearing this bit, debuggers should also set the action field
 * (whose location depends on \FcsrTdataOneType) to something other
 * than 1.
 */
/*
 * If \FcsrTdataOneType is 0, then this field is hard-wired to 0.
 *
 * Trigger-specific data.
 */
#define CSR_TDATA1_DATA_OFFSET              0
#define CSR_TDATA1_DATA_LENGTH(XLEN)        (XLEN + -5)
#define CSR_TDATA1_DATA(XLEN)               ((1ULL<<(XLEN + -5)) + -1)
#define CSR_TDATA2                          0x7a2
#define CSR_TDATA2_DATA_OFFSET              0
#define CSR_TDATA2_DATA_LENGTH(XLEN)        XLEN
#define CSR_TDATA2_DATA(XLEN)               ((1ULL<<XLEN) + -1)
#define CSR_TDATA3                          0x7a3
#define CSR_TDATA3_DATA_OFFSET              0
#define CSR_TDATA3_DATA_LENGTH(XLEN)        XLEN
#define CSR_TDATA3_DATA(XLEN)               ((1ULL<<XLEN) + -1)
#define CSR_TINFO                           0x7a4
/*
 * One bit for each possible \FcsrTdataOneType enumerated in \RcsrTdataOne. Bit N
 * corresponds to type N. If the bit is set, then that type is
 * supported by the currently selected trigger.
 *
 * If the currently selected trigger doesn't exist, this field
 * contains 1.
 */
#define CSR_TINFO_INFO_OFFSET               0
#define CSR_TINFO_INFO_LENGTH               0x10
#define CSR_TINFO_INFO                      0xffff
#define CSR_TCONTROL                        0x7a5
/*
 * M-mode previous trigger enable field.
 *
 * \FcsrTcontrolMpte and \FcsrTcontrolMte provide one solution to a problem
 * regarding triggers with action=0 firing in M-mode trap handlers. See
 * Section~\ref{sec:nativetrigger} for more details.
 *
 * When a breakpoint trap into M-mode is taken, \FcsrTcontrolMpte is set to the value of
 * \FcsrTcontrolMte.
 */
#define CSR_TCONTROL_MPTE_OFFSET            7
#define CSR_TCONTROL_MPTE_LENGTH            1
#define CSR_TCONTROL_MPTE                   0x80
/*
 * M-mode trigger enable field.
 */
#define CSR_TCONTROL_MTE_OFFSET             3
#define CSR_TCONTROL_MTE_LENGTH             1
#define CSR_TCONTROL_MTE                    8
/*
 * disabled: Triggers with action=0 do not match/fire while the hart is in M-mode.
 */
#define CSR_TCONTROL_MTE_DISABLED           0
/*
 * enabled: Triggers do match/fire while the hart is in M-mode.
 */
#define CSR_TCONTROL_MTE_ENABLED            1
/*
 * When a breakpoint trap into M-mode is taken, \FcsrTcontrolMte is set to 0. When {\tt
 * mret} is executed, \FcsrTcontrolMte is set to the value of \FcsrTcontrolMpte.
 */
#define CSR_HCONTEXT                        0x6a8
/*
 * Hypervisor mode software can write a context number to this register,
 * which can be used to set triggers that only fire in that specific
 * context.
 *
 * An implementation may tie any number of upper bits in this field to
 * 0. If the H extension is not implemented, it's recommended to implement
 * no more than 6 bits on RV32 and 13 on RV64 (as visible through the
 * \RcsrMcontext register).  If the H extension is implemented,
 * it's recommended to implement no more than 7 bits on RV32
 * and 14 on RV64.
 */
#define CSR_HCONTEXT_HCONTEXT_OFFSET        0
#define CSR_HCONTEXT_HCONTEXT_LENGTH(XLEN)  XLEN
#define CSR_HCONTEXT_HCONTEXT(XLEN)         ((1ULL<<XLEN) + -1)
#define CSR_SCONTEXT                        0x5a8
/*
 * Supervisor mode software can write a context number to this
 * register, which can be used to set triggers that only fire in that
 * specific context.
 *
 * An implementation may tie any number of high bits in this field to
 * 0. It's recommended to implement no more than 16 bits on RV32, and
 * 34 on RV64.
 */
#define CSR_SCONTEXT_DATA_OFFSET            0
#define CSR_SCONTEXT_DATA_LENGTH(XLEN)      XLEN
#define CSR_SCONTEXT_DATA(XLEN)             ((1ULL<<XLEN) + -1)
#define CSR_MCONTEXT                        0x7a8
#define CSR_MSCONTEXT                       0x7aa
#define CSR_MCONTROL                        0x7a1
#define CSR_MCONTROL_TYPE_OFFSET(XLEN)      (XLEN + -4)
#define CSR_MCONTROL_TYPE_LENGTH            4
#define CSR_MCONTROL_TYPE(XLEN)             (0xf * (1ULL<<(XLEN + -4)))
#define CSR_MCONTROL_DMODE_OFFSET(XLEN)     (XLEN + -5)
#define CSR_MCONTROL_DMODE_LENGTH           1
#define CSR_MCONTROL_DMODE(XLEN)            (1ULL<<(XLEN + -5))
/*
 * Specifies the largest naturally aligned powers-of-two (NAPOT) range
 * supported by the hardware when \FcsrMcontrolMatch is 1. The value is the
 * logarithm base 2 of the number of bytes in that range.
 * A value of 0 indicates \FcsrMcontrolMatch 1 is not supported.
 * A value of 63 corresponds to the maximum NAPOT range, which is
 * $2^{63}$ bytes in size.
 */
#define CSR_MCONTROL_MASKMAX_OFFSET(XLEN)   (XLEN + -0xb)
#define CSR_MCONTROL_MASKMAX_LENGTH         6
#define CSR_MCONTROL_MASKMAX(XLEN)          (0x3f * (1ULL<<(XLEN + -0xb)))
/*
 * This field only exists when XLEN is at least 64.
 * It contains the 2 high bits of the access size. The low bits
 * come from \FcsrMcontrolSizelo. See \FcsrMcontrolSizelo for how this
 * is used.
 */
#define CSR_MCONTROL_SIZEHI_OFFSET          0x15
#define CSR_MCONTROL_SIZEHI_LENGTH          2
#define CSR_MCONTROL_SIZEHI                 0x600000
/*
 * If this bit is implemented then it must become set when this
 * trigger fires and may become set when this trigger matches.
 * The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) matched.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_MCONTROL_HIT_OFFSET             0x14
#define CSR_MCONTROL_HIT_LENGTH             1
#define CSR_MCONTROL_HIT                    0x100000
/*
 * This bit determines the contents of the XLEN-bit compare values.
 */
#define CSR_MCONTROL_SELECT_OFFSET          0x13
#define CSR_MCONTROL_SELECT_LENGTH          1
#define CSR_MCONTROL_SELECT                 0x80000
/*
 * address: There is at least one compare value and it contains the lowest
 * virtual address of the access.
 * It is recommended that there are additional compare values for
 * the other accessed virtual addresses.
 * (E.g. on a 32-bit read from 0x4000, the lowest address is 0x4000
 * and the other addresses are 0x4001, 0x4002, and 0x4003.)
 */
#define CSR_MCONTROL_SELECT_ADDRESS         0
/*
 * data: There is exactly one compare value and it contains the data
 * value loaded or stored, or the instruction executed.
 * Any bits beyond the size of the data access will contain 0.
 */
#define CSR_MCONTROL_SELECT_DATA            1
#define CSR_MCONTROL_TIMING_OFFSET          0x12
#define CSR_MCONTROL_TIMING_LENGTH          1
#define CSR_MCONTROL_TIMING                 0x40000
/*
 * before: The action for this trigger will be taken just before the
 * instruction that triggered it is committed, but after all preceding
 * instructions are committed. \Rxepc or \RcsrDpc (depending
 * on \FcsrMcontrolAction) must be set to the virtual address of the
 * instruction that matched.
 *
 * If this is combined with \FcsrMcontrolLoad and
 * \FcsrMcontrolSelect=1 then a memory access will be
 * performed (including any side effects of performing such an access) even
 * though the load will not update its destination register. Debuggers
 * should consider this when setting such breakpoints on, for example,
 * memory-mapped I/O addresses.
 */
#define CSR_MCONTROL_TIMING_BEFORE          0
/*
 * after: The action for this trigger will be taken after the instruction
 * that triggered it is committed. It should be taken before the next
 * instruction is committed, but it is better to implement triggers imprecisely
 * than to not implement them at all.  \Rxepc or
 * \RcsrDpc (depending on \FcsrMcontrolAction) must be set to
 * the virtual address of the next instruction that must be executed to
 * preserve the program flow.
 */
#define CSR_MCONTROL_TIMING_AFTER           1
/*
 * Most hardware will only implement one timing or the other, possibly
 * dependent on \FcsrMcontrolSelect, \FcsrMcontrolExecute,
 * \FcsrMcontrolLoad, and \FcsrMcontrolStore. This bit
 * primarily exists for the hardware to communicate to the debugger
 * what will happen. Hardware may implement the bit fully writable, in
 * which case the debugger has a little more control.
 *
 * Data load triggers with \FcsrMcontrolTiming of 0 will result in the same load
 * happening again when the debugger lets the hart run. For data load
 * triggers, debuggers must first attempt to set the breakpoint with
 * \FcsrMcontrolTiming of 1.
 *
 * If a trigger with \FcsrMcontrolTiming of 0 matches, it is
 * implementation-dependent whether that prevents a trigger with
 * \FcsrMcontrolTiming of 1 matching as well.
 */
/*
 * This field contains the 2 low bits of the access size. The high bits come
 * from \FcsrMcontrolSizehi. The combined value is interpreted as follows:
 */
#define CSR_MCONTROL_SIZELO_OFFSET          0x10
#define CSR_MCONTROL_SIZELO_LENGTH          2
#define CSR_MCONTROL_SIZELO                 0x30000
/*
 * any: The trigger will attempt to match against an access of any size.
 * The behavior is only well-defined if $|select|=0$, or if the access
 * size is XLEN.
 */
#define CSR_MCONTROL_SIZELO_ANY             0
/*
 * 8bit: The trigger will only match against 8-bit memory accesses.
 */
#define CSR_MCONTROL_SIZELO_8BIT            1
/*
 * 16bit: The trigger will only match against 16-bit memory accesses or
 * execution of 16-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_16BIT           2
/*
 * 32bit: The trigger will only match against 32-bit memory accesses or
 * execution of 32-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_32BIT           3
/*
 * 48bit: The trigger will only match against execution of 48-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_48BIT           4
/*
 * 64bit: The trigger will only match against 64-bit memory accesses or
 * execution of 64-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_64BIT           5
/*
 * 80bit: The trigger will only match against execution of 80-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_80BIT           6
/*
 * 96bit: The trigger will only match against execution of 96-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_96BIT           7
/*
 * 112bit: The trigger will only match against execution of 112-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_112BIT          8
/*
 * 128bit: The trigger will only match against 128-bit memory accesses or
 * execution of 128-bit instructions.
 */
#define CSR_MCONTROL_SIZELO_128BIT          9
/*
 * An implementation must support the value of 0, but all other values
 * are optional. When an implementation supports address triggers
 * (\FcsrMcontrolSelect=0), it is recommended that those triggers
 * support every access size that the hart supports, as well as for
 * every instruction size that the hart supports.
 *
 * Implementations such as RV32D or RV64V are able to perform loads
 * and stores that are wider than XLEN. Custom extensions may also
 * support instructions that are wider than XLEN. Because
 * \RcsrTdataTwo is of size XLEN, there is a known limitation that
 * data value triggers (\FcsrMcontrolSelect=1) can only be supported
 * for access sizes up to XLEN bits.  When an implementation supports
 * data value triggers (\FcsrMcontrolSelect=1), it is recommended
 * that those triggers support every access size up to XLEN that the
 * hart supports, as well as for every instruction length up to XLEN
 * that the hart supports.
 */
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_MCONTROL_ACTION_OFFSET          0xc
#define CSR_MCONTROL_ACTION_LENGTH          4
#define CSR_MCONTROL_ACTION                 0xf000
/*
 * breakpoint:
 */
#define CSR_MCONTROL_ACTION_BREAKPOINT      0
/*
 * debug mode:
 */
#define CSR_MCONTROL_ACTION_DEBUG_MODE      1
/*
 * trace on:
 */
#define CSR_MCONTROL_ACTION_TRACE_ON        2
/*
 * trace off:
 */
#define CSR_MCONTROL_ACTION_TRACE_OFF       3
/*
 * trace notify:
 */
#define CSR_MCONTROL_ACTION_TRACE_NOTIFY    4
/*
 * external0:
 */
#define CSR_MCONTROL_ACTION_EXTERNAL0       8
/*
 * external1:
 */
#define CSR_MCONTROL_ACTION_EXTERNAL1       9
#define CSR_MCONTROL_CHAIN_OFFSET           0xb
#define CSR_MCONTROL_CHAIN_LENGTH           1
#define CSR_MCONTROL_CHAIN                  0x800
/*
 * disabled: When this trigger matches, the configured action is taken.
 */
#define CSR_MCONTROL_CHAIN_DISABLED         0
/*
 * enabled: While this trigger does not match, it prevents the trigger with
 * the next index from matching.
 */
#define CSR_MCONTROL_CHAIN_ENABLED          1
/*
 * A trigger chain starts on the first trigger with $|chain|=1$ after
 * a trigger with $|chain|=0$, or simply on the first trigger if that
 * has $|chain|=1$. It ends on the first trigger after that which has
 * $|chain|=0$. This final trigger is part of the chain. The action
 * on all but the final trigger is ignored.  The action on that final
 * trigger will be taken if and only if all the triggers in the chain
 * match at the same time.
 *
 * Debuggers should not terminate a chain with a trigger with a
 * different type. It is undefined when exactly such a chain fires.
 *
 * Because \FcsrMcontrolChain affects the next trigger, hardware must zero it in
 * writes to \RcsrMcontrol that set \FcsrTdataOneDmode to 0 if the next trigger has
 * \FcsrTdataOneDmode of 1.
 * In addition hardware should ignore writes to \RcsrMcontrol that set
 * \FcsrTdataOneDmode to 1 if the previous trigger has both \FcsrTdataOneDmode of 0 and
 * \FcsrMcontrolChain of 1. Debuggers must avoid the latter case by checking
 * \FcsrMcontrolChain on the previous trigger if they're writing \RcsrMcontrol.
 *
 * Implementations that wish to limit the maximum length of a trigger
 * chain (eg. to meet timing requirements) may do so by zeroing
 * \FcsrMcontrolChain in writes to \RcsrMcontrol that would make the chain too long.
 */
#define CSR_MCONTROL_MATCH_OFFSET           7
#define CSR_MCONTROL_MATCH_LENGTH           4
#define CSR_MCONTROL_MATCH                  0x780
/*
 * equal: Matches when any compare value equals \RcsrTdataTwo.
 */
#define CSR_MCONTROL_MATCH_EQUAL            0
/*
 * napot: Matches when the top $M$ bits of any compare value match the top
 * $M$ bits of \RcsrTdataTwo.
 * $M$ is $|XLEN|-1$ minus the index of the least-significant
 * bit containing 0 in \RcsrTdataTwo. Debuggers should only write values
 * to \RcsrTdataTwo such that $M + $\FcsrMcontrolMaskmax$ \geq |XLEN|$
 * and $M\gt0$ , otherwise it's undefined on what conditions the
 * trigger will match.
 */
#define CSR_MCONTROL_MATCH_NAPOT            1
/*
 * ge: Matches when any compare value is greater than (unsigned) or
 * equal to \RcsrTdataTwo.
 */
#define CSR_MCONTROL_MATCH_GE               2
/*
 * lt: Matches when any compare value is less than (unsigned)
 * \RcsrTdataTwo.
 */
#define CSR_MCONTROL_MATCH_LT               3
/*
 * mask low: Matches when $\frac{|XLEN|}{2}-1$:$0$ of any compare value
 * equals $\frac{|XLEN|}{2}-1$:$0$ of \RcsrTdataTwo after
 * $\frac{|XLEN|}{2}-1$:$0$ of the compare value is ANDed with
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of \RcsrTdataTwo.
 */
#define CSR_MCONTROL_MATCH_MASK_LOW         4
/*
 * mask high: Matches when $|XLEN|-1$:$\frac{|XLEN|}{2}$ of any compare
 * value equals $\frac{|XLEN|}{2}-1$:$0$ of \RcsrTdataTwo after
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of the compare value is ANDed with
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of \RcsrTdataTwo.
 */
#define CSR_MCONTROL_MATCH_MASK_HIGH        5
/*
 * not equal: Matches when \FcsrMcontrolMatch$=0$ would not match.
 */
#define CSR_MCONTROL_MATCH_NOT_EQUAL        8
/*
 * not napot: Matches when \FcsrMcontrolMatch$=1$ would not match.
 */
#define CSR_MCONTROL_MATCH_NOT_NAPOT        9
/*
 * not mask low: Matches when \FcsrMcontrolMatch$=4$ would not match.
 */
#define CSR_MCONTROL_MATCH_NOT_MASK_LOW     12
/*
 * not mask high: Matches when \FcsrMcontrolMatch$=5$ would not match.
 */
#define CSR_MCONTROL_MATCH_NOT_MASK_HIGH    13
/*
 * Other values are reserved for future use.
 *
 * All comparisons only look at the lower XLEN (in the current mode)
 * bits of the compare values and of \RcsrTdataTwo.
 * When \FcsrMcontrolSelect=1 and access size is N, this is further
 * reduced, and comparisons only look at the lower N bits of the
 * compare values and of \RcsrTdataTwo.
 */
/*
 * When set, enable this trigger in M-mode.
 */
#define CSR_MCONTROL_M_OFFSET               6
#define CSR_MCONTROL_M_LENGTH               1
#define CSR_MCONTROL_M                      0x40
/*
 * When set, enable this trigger in S/HS-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * S-mode.
 */
#define CSR_MCONTROL_S_OFFSET               4
#define CSR_MCONTROL_S_LENGTH               1
#define CSR_MCONTROL_S                      0x10
/*
 * When set, enable this trigger in U-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * U-mode.
 */
#define CSR_MCONTROL_U_OFFSET               3
#define CSR_MCONTROL_U_LENGTH               1
#define CSR_MCONTROL_U                      8
/*
 * When set, the trigger fires on the virtual address or opcode of an
 * instruction that is executed.
 */
#define CSR_MCONTROL_EXECUTE_OFFSET         2
#define CSR_MCONTROL_EXECUTE_LENGTH         1
#define CSR_MCONTROL_EXECUTE                4
/*
 * When set, the trigger fires on the virtual address or data of any
 * store.
 */
#define CSR_MCONTROL_STORE_OFFSET           1
#define CSR_MCONTROL_STORE_LENGTH           1
#define CSR_MCONTROL_STORE                  2
/*
 * When set, the trigger fires on the virtual address or data of any
 * load.
 */
#define CSR_MCONTROL_LOAD_OFFSET            0
#define CSR_MCONTROL_LOAD_LENGTH            1
#define CSR_MCONTROL_LOAD                   1
#define CSR_MCONTROL6                       0x7a1
#define CSR_MCONTROL6_TYPE_OFFSET(XLEN)     (XLEN + -4)
#define CSR_MCONTROL6_TYPE_LENGTH           4
#define CSR_MCONTROL6_TYPE(XLEN)            (0xf * (1ULL<<(XLEN + -4)))
#define CSR_MCONTROL6_DMODE_OFFSET(XLEN)    (XLEN + -5)
#define CSR_MCONTROL6_DMODE_LENGTH          1
#define CSR_MCONTROL6_DMODE(XLEN)           (1ULL<<(XLEN + -5))
/*
 * When set, enable this trigger in VS-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_MCONTROL6_VS_OFFSET             0x18
#define CSR_MCONTROL6_VS_LENGTH             1
#define CSR_MCONTROL6_VS                    0x1000000
/*
 * When set, enable this trigger in VU-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_MCONTROL6_VU_OFFSET             0x17
#define CSR_MCONTROL6_VU_LENGTH             1
#define CSR_MCONTROL6_VU                    0x800000
/*
 * If this bit is implemented then it must become set when this
 * trigger fires and may become set when this trigger matches.
 * The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) matched.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_MCONTROL6_HIT_OFFSET            0x16
#define CSR_MCONTROL6_HIT_LENGTH            1
#define CSR_MCONTROL6_HIT                   0x400000
/*
 * This bit determines the contents of the XLEN-bit compare values.
 */
#define CSR_MCONTROL6_SELECT_OFFSET         0x15
#define CSR_MCONTROL6_SELECT_LENGTH         1
#define CSR_MCONTROL6_SELECT                0x200000
/*
 * address: There is at least one compare value and it contains the lowest
 * virtual address of the access.
 * In addition, it is recommended that there are additional compare
 * values for the other accessed virtual addresses match.
 * (E.g. on a 32-bit read from 0x4000, the lowest address is 0x4000
 * and the other addresses are 0x4001, 0x4002, and 0x4003.)
 */
#define CSR_MCONTROL6_SELECT_ADDRESS        0
/*
 * data: There is exactly one compare value and it contains the data
 * value loaded or stored, or the instruction executed.
 * Any bits beyond the size of the data access will contain 0.
 */
#define CSR_MCONTROL6_SELECT_DATA           1
#define CSR_MCONTROL6_TIMING_OFFSET         0x14
#define CSR_MCONTROL6_TIMING_LENGTH         1
#define CSR_MCONTROL6_TIMING                0x100000
/*
 * before: The action for this trigger will be taken just before the
 * instruction that triggered it is committed, but after all preceding
 * instructions are committed. \Rxepc or \RcsrDpc (depending
 * on \FcsrMcontrolSixAction) must be set to the virtual address of the
 * instruction that matched.
 *
 * If this is combined with \FcsrMcontrolSixLoad and
 * \FcsrMcontrolSixSelect=1 then a memory access will be
 * performed (including any side effects of performing such an access) even
 * though the load will not update its destination register. Debuggers
 * should consider this when setting such breakpoints on, for example,
 * memory-mapped I/O addresses.
 */
#define CSR_MCONTROL6_TIMING_BEFORE         0
/*
 * after: The action for this trigger will be taken after the instruction
 * that triggered it is committed. It should be taken before the next
 * instruction is committed, but it is better to implement triggers imprecisely
 * than to not implement them at all.  \Rxepc or
 * \RcsrDpc (depending on \FcsrMcontrolSixAction) must be set to
 * the virtual address of the next instruction that must be executed to
 * preserve the program flow.
 */
#define CSR_MCONTROL6_TIMING_AFTER          1
/*
 * Most hardware will only implement one timing or the other, possibly
 * dependent on \FcsrMcontrolSixSelect, \FcsrMcontrolSixExecute,
 * \FcsrMcontrolSixLoad, and \FcsrMcontrolSixStore. This bit
 * primarily exists for the hardware to communicate to the debugger
 * what will happen. Hardware may implement the bit fully writable, in
 * which case the debugger has a little more control.
 *
 * Data load triggers with \FcsrMcontrolSixTiming of 0 will result in the same load
 * happening again when the debugger lets the hart run. For data load
 * triggers, debuggers must first attempt to set the breakpoint with
 * \FcsrMcontrolSixTiming of 1.
 *
 * If a trigger with \FcsrMcontrolSixTiming of 0 matches, it is
 * implementation-dependent whether that prevents a trigger with
 * \FcsrMcontrolSixTiming of 1 matching as well.
 */
#define CSR_MCONTROL6_SIZE_OFFSET           0x10
#define CSR_MCONTROL6_SIZE_LENGTH           4
#define CSR_MCONTROL6_SIZE                  0xf0000
/*
 * any: The trigger will attempt to match against an access of any size.
 * The behavior is only well-defined if $|select|=0$, or if the access
 * size is XLEN.
 */
#define CSR_MCONTROL6_SIZE_ANY              0
/*
 * 8bit: The trigger will only match against 8-bit memory accesses.
 */
#define CSR_MCONTROL6_SIZE_8BIT             1
/*
 * 16bit: The trigger will only match against 16-bit memory accesses or
 * execution of 16-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_16BIT            2
/*
 * 32bit: The trigger will only match against 32-bit memory accesses or
 * execution of 32-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_32BIT            3
/*
 * 48bit: The trigger will only match against execution of 48-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_48BIT            4
/*
 * 64bit: The trigger will only match against 64-bit memory accesses or
 * execution of 64-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_64BIT            5
/*
 * 80bit: The trigger will only match against execution of 80-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_80BIT            6
/*
 * 96bit: The trigger will only match against execution of 96-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_96BIT            7
/*
 * 112bit: The trigger will only match against execution of 112-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_112BIT           8
/*
 * 128bit: The trigger will only match against 128-bit memory accesses or
 * execution of 128-bit instructions.
 */
#define CSR_MCONTROL6_SIZE_128BIT           9
/*
 * An implementation must support the value of 0, but all other values
 * are optional. When an implementation supports address triggers
 * (\FcsrMcontrolSixSelect=0), it is recommended that those triggers
 * support every access size that the hart supports, as well as for
 * every instruction size that the hart supports.
 *
 * Implementations such as RV32D or RV64V are able to perform loads
 * and stores that are wider than XLEN. Custom extensions may also
 * support instructions that are wider than XLEN. Because
 * \RcsrTdataTwo is of size XLEN, there is a known limitation that
 * data value triggers (\FcsrMcontrolSixSelect=1) can only be supported
 * for access sizes up to XLEN bits.  When an implementation supports
 * data value triggers (\FcsrMcontrolSixSelect=1), it is recommended
 * that those triggers support every access size up to XLEN that the
 * hart supports, as well as for every instruction length up to XLEN
 * that the hart supports.
 */
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_MCONTROL6_ACTION_OFFSET         0xc
#define CSR_MCONTROL6_ACTION_LENGTH         4
#define CSR_MCONTROL6_ACTION                0xf000
/*
 * breakpoint:
 */
#define CSR_MCONTROL6_ACTION_BREAKPOINT     0
/*
 * debug mode:
 */
#define CSR_MCONTROL6_ACTION_DEBUG_MODE     1
/*
 * trace on:
 */
#define CSR_MCONTROL6_ACTION_TRACE_ON       2
/*
 * trace off:
 */
#define CSR_MCONTROL6_ACTION_TRACE_OFF      3
/*
 * trace notify:
 */
#define CSR_MCONTROL6_ACTION_TRACE_NOTIFY   4
/*
 * external0:
 */
#define CSR_MCONTROL6_ACTION_EXTERNAL0      8
/*
 * external1:
 */
#define CSR_MCONTROL6_ACTION_EXTERNAL1      9
#define CSR_MCONTROL6_CHAIN_OFFSET          0xb
#define CSR_MCONTROL6_CHAIN_LENGTH          1
#define CSR_MCONTROL6_CHAIN                 0x800
/*
 * disabled: When this trigger matches, the configured action is taken.
 */
#define CSR_MCONTROL6_CHAIN_DISABLED        0
/*
 * enabled: While this trigger does not match, it prevents the trigger with
 * the next index from matching.
 */
#define CSR_MCONTROL6_CHAIN_ENABLED         1
/*
 * A trigger chain starts on the first trigger with $|chain|=1$ after
 * a trigger with $|chain|=0$, or simply on the first trigger if that
 * has $|chain|=1$. It ends on the first trigger after that which has
 * $|chain|=0$. This final trigger is part of the chain. The action
 * on all but the final trigger is ignored.  The action on that final
 * trigger will be taken if and only if all the triggers in the chain
 * match at the same time.
 *
 * Debuggers should not terminate a chain with a trigger with a
 * different type. It is undefined when exactly such a chain fires.
 *
 * Because \FcsrMcontrolSixChain affects the next trigger, hardware must zero it in
 * writes to \RcsrMcontrolSix that set \FcsrTdataOneDmode to 0 if the next trigger has
 * \FcsrTdataOneDmode of 1.
 * In addition hardware should ignore writes to \RcsrMcontrolSix that set
 * \FcsrTdataOneDmode to 1 if the previous trigger has both \FcsrTdataOneDmode of 0 and
 * \FcsrMcontrolSixChain of 1. Debuggers must avoid the latter case by checking
 * \FcsrMcontrolSixChain on the previous trigger if they're writing \RcsrMcontrolSix.
 *
 * Implementations that wish to limit the maximum length of a trigger
 * chain (eg. to meet timing requirements) may do so by zeroing
 * \FcsrMcontrolSixChain in writes to \RcsrMcontrolSix that would make the chain too long.
 */
#define CSR_MCONTROL6_MATCH_OFFSET          7
#define CSR_MCONTROL6_MATCH_LENGTH          4
#define CSR_MCONTROL6_MATCH                 0x780
/*
 * equal: Matches when any compare value equals \RcsrTdataTwo.
 */
#define CSR_MCONTROL6_MATCH_EQUAL           0
/*
 * napot: Matches when the top $M$ bits of any compare value match the top
 * $M$ bits of \RcsrTdataTwo.
 * $M$ is $|XLEN|-1$ minus the index of the least-significant bit
 * containing 0 in \RcsrTdataTwo.
 * \RcsrTdataTwo is WARL and if bits $|maskmax6|-1$:0 are written with all
 * ones then bit $|maskmax6|-1$ will be set to 0 while the values of bits $|maskmax6|-2$:0
 * are \unspecified.
 * Legal values for \RcsrTdataTwo require $M + |maskmax6| \geq |XLEN|$ and $M\gt0$.
 * See above for how to determine maskmax6.
 */
#define CSR_MCONTROL6_MATCH_NAPOT           1
/*
 * ge: Matches when any compare value is greater than (unsigned) or
 * equal to \RcsrTdataTwo.
 */
#define CSR_MCONTROL6_MATCH_GE              2
/*
 * lt: Matches when any compare value is less than (unsigned)
 * \RcsrTdataTwo.
 */
#define CSR_MCONTROL6_MATCH_LT              3
/*
 * mask low: Matches when $\frac{|XLEN|}{2}-1$:$0$ of any compare value
 * equals $\frac{|XLEN|}{2}-1$:$0$ of \RcsrTdataTwo after
 * $\frac{|XLEN|}{2}-1$:$0$ of the compare value is ANDed with
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of \RcsrTdataTwo.
 */
#define CSR_MCONTROL6_MATCH_MASK_LOW        4
/*
 * mask high: Matches when $|XLEN|-1$:$\frac{|XLEN|}{2}$ of any compare
 * value equals $\frac{|XLEN|}{2}-1$:$0$ of \RcsrTdataTwo after
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of the compare value is ANDed with
 * $|XLEN|-1$:$\frac{|XLEN|}{2}$ of \RcsrTdataTwo.
 */
#define CSR_MCONTROL6_MATCH_MASK_HIGH       5
/*
 * not equal: Matches when \FcsrMcontrolSixMatch$=0$ would not match.
 */
#define CSR_MCONTROL6_MATCH_NOT_EQUAL       8
/*
 * not napot: Matches when \FcsrMcontrolSixMatch$=1$ would not match.
 */
#define CSR_MCONTROL6_MATCH_NOT_NAPOT       9
/*
 * not mask low: Matches when \FcsrMcontrolSixMatch$=4$ would not match.
 */
#define CSR_MCONTROL6_MATCH_NOT_MASK_LOW    12
/*
 * not mask high: Matches when \FcsrMcontrolSixMatch$=5$ would not match.
 */
#define CSR_MCONTROL6_MATCH_NOT_MASK_HIGH   13
/*
 * Other values are reserved for future use.
 *
 * All comparisons only look at the lower XLEN (in the current mode)
 * bits of the compare values and of \RcsrTdataTwo.
 * When \FcsrMcontrolSelect=1 and access size is N, this is further
 * reduced, and comparisons only look at the lower N bits of the
 * compare values and of \RcsrTdataTwo.
 */
/*
 * When set, enable this trigger in M-mode.
 */
#define CSR_MCONTROL6_M_OFFSET              6
#define CSR_MCONTROL6_M_LENGTH              1
#define CSR_MCONTROL6_M                     0x40
/*
 * When set, enable this trigger in S/HS-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * S-mode.
 */
#define CSR_MCONTROL6_S_OFFSET              4
#define CSR_MCONTROL6_S_LENGTH              1
#define CSR_MCONTROL6_S                     0x10
/*
 * When set, enable this trigger in U-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * U-mode.
 */
#define CSR_MCONTROL6_U_OFFSET              3
#define CSR_MCONTROL6_U_LENGTH              1
#define CSR_MCONTROL6_U                     8
/*
 * When set, the trigger fires on the virtual address or opcode of an
 * instruction that is executed.
 */
#define CSR_MCONTROL6_EXECUTE_OFFSET        2
#define CSR_MCONTROL6_EXECUTE_LENGTH        1
#define CSR_MCONTROL6_EXECUTE               4
/*
 * When set, the trigger fires on the virtual address or data of any
 * store.
 */
#define CSR_MCONTROL6_STORE_OFFSET          1
#define CSR_MCONTROL6_STORE_LENGTH          1
#define CSR_MCONTROL6_STORE                 2
/*
 * When set, the trigger fires on the virtual address or data of any
 * load.
 */
#define CSR_MCONTROL6_LOAD_OFFSET           0
#define CSR_MCONTROL6_LOAD_LENGTH           1
#define CSR_MCONTROL6_LOAD                  1
#define CSR_ICOUNT                          0x7a1
#define CSR_ICOUNT_TYPE_OFFSET(XLEN)        (XLEN + -4)
#define CSR_ICOUNT_TYPE_LENGTH              4
#define CSR_ICOUNT_TYPE(XLEN)               (0xf * (1ULL<<(XLEN + -4)))
#define CSR_ICOUNT_DMODE_OFFSET(XLEN)       (XLEN + -5)
#define CSR_ICOUNT_DMODE_LENGTH             1
#define CSR_ICOUNT_DMODE(XLEN)              (1ULL<<(XLEN + -5))
/*
 * When set, enable this trigger in VS-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ICOUNT_VS_OFFSET                0x1a
#define CSR_ICOUNT_VS_LENGTH                1
#define CSR_ICOUNT_VS                       0x4000000
/*
 * When set, enable this trigger in VU-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ICOUNT_VU_OFFSET                0x19
#define CSR_ICOUNT_VU_LENGTH                1
#define CSR_ICOUNT_VU                       0x2000000
/*
 * If this bit is implemented, the hardware sets it when this
 * trigger fires. The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) fires.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_ICOUNT_HIT_OFFSET               0x18
#define CSR_ICOUNT_HIT_LENGTH               1
#define CSR_ICOUNT_HIT                      0x1000000
/*
 * The trigger will generally fire after \FcsrIcountCount instructions
 * in enabled modes have been executed. See above for the precise behavior.
 */
#define CSR_ICOUNT_COUNT_OFFSET             0xa
#define CSR_ICOUNT_COUNT_LENGTH             0xe
#define CSR_ICOUNT_COUNT                    0xfffc00
/*
 * When set, enable this trigger in M-mode.
 */
#define CSR_ICOUNT_M_OFFSET                 9
#define CSR_ICOUNT_M_LENGTH                 1
#define CSR_ICOUNT_M                        0x200
/*
 * This bit becomes set when \FcsrIcountCount is decremented from 1
 * to 0. It is cleared when the trigger fires, which will happen just
 * before executing the next instruction in one of the enabled modes.
 */
#define CSR_ICOUNT_PENDING_OFFSET           8
#define CSR_ICOUNT_PENDING_LENGTH           1
#define CSR_ICOUNT_PENDING                  0x100
/*
 * When set, enable this trigger in S/HS-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * S-mode.
 */
#define CSR_ICOUNT_S_OFFSET                 7
#define CSR_ICOUNT_S_LENGTH                 1
#define CSR_ICOUNT_S                        0x80
/*
 * When set, enable this trigger in U-mode.
 * This bit is hard-wired to 0 if the hart does not support
 * U-mode.
 */
#define CSR_ICOUNT_U_OFFSET                 6
#define CSR_ICOUNT_U_LENGTH                 1
#define CSR_ICOUNT_U                        0x40
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_ICOUNT_ACTION_OFFSET            0
#define CSR_ICOUNT_ACTION_LENGTH            6
#define CSR_ICOUNT_ACTION                   0x3f
/*
 * breakpoint:
 */
#define CSR_ICOUNT_ACTION_BREAKPOINT        0
/*
 * debug mode:
 */
#define CSR_ICOUNT_ACTION_DEBUG_MODE        1
/*
 * trace on:
 */
#define CSR_ICOUNT_ACTION_TRACE_ON          2
/*
 * trace off:
 */
#define CSR_ICOUNT_ACTION_TRACE_OFF         3
/*
 * trace notify:
 */
#define CSR_ICOUNT_ACTION_TRACE_NOTIFY      4
/*
 * external0:
 */
#define CSR_ICOUNT_ACTION_EXTERNAL0         8
/*
 * external1:
 */
#define CSR_ICOUNT_ACTION_EXTERNAL1         9
#define CSR_ITRIGGER                        0x7a1
#define CSR_ITRIGGER_TYPE_OFFSET(XLEN)      (XLEN + -4)
#define CSR_ITRIGGER_TYPE_LENGTH            4
#define CSR_ITRIGGER_TYPE(XLEN)             (0xf * (1ULL<<(XLEN + -4)))
#define CSR_ITRIGGER_DMODE_OFFSET(XLEN)     (XLEN + -5)
#define CSR_ITRIGGER_DMODE_LENGTH           1
#define CSR_ITRIGGER_DMODE(XLEN)            (1ULL<<(XLEN + -5))
/*
 * If this bit is implemented, the hardware sets it when this
 * trigger matches. The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) matched.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_ITRIGGER_HIT_OFFSET(XLEN)       (XLEN + -6)
#define CSR_ITRIGGER_HIT_LENGTH             1
#define CSR_ITRIGGER_HIT(XLEN)              (1ULL<<(XLEN + -6))
/*
 * When set, enable this trigger for interrupts that are taken from VS
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ITRIGGER_VS_OFFSET              0xc
#define CSR_ITRIGGER_VS_LENGTH              1
#define CSR_ITRIGGER_VS                     0x1000
/*
 * When set, enable this trigger for interrupts that are taken from VU
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ITRIGGER_VU_OFFSET              0xb
#define CSR_ITRIGGER_VU_LENGTH              1
#define CSR_ITRIGGER_VU                     0x800
/*
 * When set, non-maskable interrupts cause this
 * trigger to fire if the trigger is enabled for the current mode.
 */
#define CSR_ITRIGGER_NMI_OFFSET             0xa
#define CSR_ITRIGGER_NMI_LENGTH             1
#define CSR_ITRIGGER_NMI                    0x400
/*
 * When set, enable this trigger for interrupts that are taken from M
 * mode.
 */
#define CSR_ITRIGGER_M_OFFSET               9
#define CSR_ITRIGGER_M_LENGTH               1
#define CSR_ITRIGGER_M                      0x200
/*
 * When set, enable this trigger for interrupts that are taken from S/HS
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * S-mode.
 */
#define CSR_ITRIGGER_S_OFFSET               7
#define CSR_ITRIGGER_S_LENGTH               1
#define CSR_ITRIGGER_S                      0x80
/*
 * When set, enable this trigger for interrupts that are taken from U
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * U-mode.
 */
#define CSR_ITRIGGER_U_OFFSET               6
#define CSR_ITRIGGER_U_LENGTH               1
#define CSR_ITRIGGER_U                      0x40
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_ITRIGGER_ACTION_OFFSET          0
#define CSR_ITRIGGER_ACTION_LENGTH          6
#define CSR_ITRIGGER_ACTION                 0x3f
/*
 * breakpoint:
 */
#define CSR_ITRIGGER_ACTION_BREAKPOINT      0
/*
 * debug mode:
 */
#define CSR_ITRIGGER_ACTION_DEBUG_MODE      1
/*
 * trace on:
 */
#define CSR_ITRIGGER_ACTION_TRACE_ON        2
/*
 * trace off:
 */
#define CSR_ITRIGGER_ACTION_TRACE_OFF       3
/*
 * trace notify:
 */
#define CSR_ITRIGGER_ACTION_TRACE_NOTIFY    4
/*
 * external0:
 */
#define CSR_ITRIGGER_ACTION_EXTERNAL0       8
/*
 * external1:
 */
#define CSR_ITRIGGER_ACTION_EXTERNAL1       9
#define CSR_ETRIGGER                        0x7a1
#define CSR_ETRIGGER_TYPE_OFFSET(XLEN)      (XLEN + -4)
#define CSR_ETRIGGER_TYPE_LENGTH            4
#define CSR_ETRIGGER_TYPE(XLEN)             (0xf * (1ULL<<(XLEN + -4)))
#define CSR_ETRIGGER_DMODE_OFFSET(XLEN)     (XLEN + -5)
#define CSR_ETRIGGER_DMODE_LENGTH           1
#define CSR_ETRIGGER_DMODE(XLEN)            (1ULL<<(XLEN + -5))
/*
 * If this bit is implemented, the hardware sets it when this
 * trigger matches. The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) matched.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_ETRIGGER_HIT_OFFSET(XLEN)       (XLEN + -6)
#define CSR_ETRIGGER_HIT_LENGTH             1
#define CSR_ETRIGGER_HIT(XLEN)              (1ULL<<(XLEN + -6))
/*
 * When set, enable this trigger for exceptions that are taken from VS
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ETRIGGER_VS_OFFSET              0xc
#define CSR_ETRIGGER_VS_LENGTH              1
#define CSR_ETRIGGER_VS                     0x1000
/*
 * When set, enable this trigger for exceptions that are taken from VU
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * virtualization mode.
 */
#define CSR_ETRIGGER_VU_OFFSET              0xb
#define CSR_ETRIGGER_VU_LENGTH              1
#define CSR_ETRIGGER_VU                     0x800
/*
 * When set, enable this trigger for exceptions that are taken from M
 * mode.
 */
#define CSR_ETRIGGER_M_OFFSET               9
#define CSR_ETRIGGER_M_LENGTH               1
#define CSR_ETRIGGER_M                      0x200
/*
 * When set, enable this trigger for exceptions that are taken from S/HS
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * S-mode.
 */
#define CSR_ETRIGGER_S_OFFSET               7
#define CSR_ETRIGGER_S_LENGTH               1
#define CSR_ETRIGGER_S                      0x80
/*
 * When set, enable this trigger for exceptions that are taken from U
 * mode.
 * This bit is hard-wired to 0 if the hart does not support
 * U-mode.
 */
#define CSR_ETRIGGER_U_OFFSET               6
#define CSR_ETRIGGER_U_LENGTH               1
#define CSR_ETRIGGER_U                      0x40
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_ETRIGGER_ACTION_OFFSET          0
#define CSR_ETRIGGER_ACTION_LENGTH          6
#define CSR_ETRIGGER_ACTION                 0x3f
/*
 * breakpoint:
 */
#define CSR_ETRIGGER_ACTION_BREAKPOINT      0
/*
 * debug mode:
 */
#define CSR_ETRIGGER_ACTION_DEBUG_MODE      1
/*
 * trace on:
 */
#define CSR_ETRIGGER_ACTION_TRACE_ON        2
/*
 * trace off:
 */
#define CSR_ETRIGGER_ACTION_TRACE_OFF       3
/*
 * trace notify:
 */
#define CSR_ETRIGGER_ACTION_TRACE_NOTIFY    4
/*
 * external0:
 */
#define CSR_ETRIGGER_ACTION_EXTERNAL0       8
/*
 * external1:
 */
#define CSR_ETRIGGER_ACTION_EXTERNAL1       9
#define CSR_TMEXTTRIGGER                    0x7a1
#define CSR_TMEXTTRIGGER_TYPE_OFFSET(XLEN)  (XLEN + -4)
#define CSR_TMEXTTRIGGER_TYPE_LENGTH        4
#define CSR_TMEXTTRIGGER_TYPE(XLEN)         (0xf * (1ULL<<(XLEN + -4)))
#define CSR_TMEXTTRIGGER_DMODE_OFFSET(XLEN) (XLEN + -5)
#define CSR_TMEXTTRIGGER_DMODE_LENGTH       1
#define CSR_TMEXTTRIGGER_DMODE(XLEN)        (1ULL<<(XLEN + -5))
/*
 * If this bit is implemented, the hardware sets it when this
 * trigger matches. The trigger's user can set or clear it at any
 * time. It is used to determine which
 * trigger(s) matched.  If the bit is not implemented, it is always 0
 * and writing it has no effect.
 */
#define CSR_TMEXTTRIGGER_HIT_OFFSET(XLEN)   (XLEN + -6)
#define CSR_TMEXTTRIGGER_HIT_LENGTH         1
#define CSR_TMEXTTRIGGER_HIT(XLEN)          (1ULL<<(XLEN + -6))
/*
 * This optional bit, when set, causes this trigger to fire whenever an attached
 * interrupt controller signals a trigger.
 */
#define CSR_TMEXTTRIGGER_INTCTL_OFFSET      0x16
#define CSR_TMEXTTRIGGER_INTCTL_LENGTH      1
#define CSR_TMEXTTRIGGER_INTCTL             0x400000
/*
 * Selects any combination of up to 16 external debug trigger inputs
 * that cause this trigger to fire.
 */
#define CSR_TMEXTTRIGGER_SELECT_OFFSET      6
#define CSR_TMEXTTRIGGER_SELECT_LENGTH      0x10
#define CSR_TMEXTTRIGGER_SELECT             0x3fffc0
/*
 * The action to take when the trigger fires. The values are explained
 * in Table~\ref{tab:action}.
 */
#define CSR_TMEXTTRIGGER_ACTION_OFFSET      0
#define CSR_TMEXTTRIGGER_ACTION_LENGTH      6
#define CSR_TMEXTTRIGGER_ACTION             0x3f
/*
 * breakpoint:
 */
#define CSR_TMEXTTRIGGER_ACTION_BREAKPOINT  0
/*
 * debug mode:
 */
#define CSR_TMEXTTRIGGER_ACTION_DEBUG_MODE  1
/*
 * trace on:
 */
#define CSR_TMEXTTRIGGER_ACTION_TRACE_ON    2
/*
 * trace off:
 */
#define CSR_TMEXTTRIGGER_ACTION_TRACE_OFF   3
/*
 * trace notify:
 */
#define CSR_TMEXTTRIGGER_ACTION_TRACE_NOTIFY 4
/*
 * external0:
 */
#define CSR_TMEXTTRIGGER_ACTION_EXTERNAL0   8
/*
 * external1:
 */
#define CSR_TMEXTTRIGGER_ACTION_EXTERNAL1   9
#define CSR_TEXTRA32                        0x7a3
/*
 * Data used together with \FcsrTextraThirtytwoMhselect.
 */
#define CSR_TEXTRA32_MHVALUE_OFFSET         0x1a
#define CSR_TEXTRA32_MHVALUE_LENGTH         6
#define CSR_TEXTRA32_MHVALUE                0xfc000000U
#define CSR_TEXTRA32_MHSELECT_OFFSET        0x17
#define CSR_TEXTRA32_MHSELECT_LENGTH        3
#define CSR_TEXTRA32_MHSELECT               0x3800000
/*
 * ignore: Ignore \FcsrTextraThirtytwoMhvalue.
 */
#define CSR_TEXTRA32_MHSELECT_IGNORE        0
/*
 * mcontext: This trigger will only match if the low bits of
 * \RcsrMcontext/\RcsrHcontext equal \FcsrTextraThirtytwoMhvalue.
 */
#define CSR_TEXTRA32_MHSELECT_MCONTEXT      4
/*
 * 1, 5 (mcontext\_select): This trigger will only match if the low bits of
 * \RcsrMcontext/\RcsrHcontext equal \{\FcsrTextraThirtytwoMhvalue, mhselect[2]\}.
 *
 * 2, 6 (vmid\_select): This trigger will only match if VMID in hgatp equals the lower VMIDMAX
 * (defined in the Privileged Spec) bits of \{\FcsrTextraThirtytwoMhvalue, mhselect[2]\}.
 *
 * 3, 7 (reserved): Reserved.
 *
 * If the H extension is not supported, the only legal values are 0 and 4.
 */
/*
 * When the least significant bit of this field is 1, it causes bits 7:0
 * in the comparison to be ignored, when \FcsrTextraThirtytwoSselect=1.
 * When the next most significant bit of this field is 1, it causes bits 15:8
 * to be ignored in the comparison, when \FcsrTextraThirtytwoSselect=1.
 */
#define CSR_TEXTRA32_SBYTEMASK_OFFSET       0x12
#define CSR_TEXTRA32_SBYTEMASK_LENGTH       2
#define CSR_TEXTRA32_SBYTEMASK              0xc0000
/*
 * Data used together with \FcsrTextraThirtytwoSselect.
 *
 * This field should be tied to 0 when S-mode is not supported.
 */
#define CSR_TEXTRA32_SVALUE_OFFSET          2
#define CSR_TEXTRA32_SVALUE_LENGTH          0x10
#define CSR_TEXTRA32_SVALUE                 0x3fffc
#define CSR_TEXTRA32_SSELECT_OFFSET         0
#define CSR_TEXTRA32_SSELECT_LENGTH         2
#define CSR_TEXTRA32_SSELECT                3
/*
 * ignore: Ignore \FcsrTextraThirtytwoSvalue.
 */
#define CSR_TEXTRA32_SSELECT_IGNORE         0
/*
 * scontext: This trigger will only match if the low bits of
 * \RcsrScontext equal \FcsrTextraThirtytwoSvalue.
 */
#define CSR_TEXTRA32_SSELECT_SCONTEXT       1
/*
 * asid: This trigger will only match if:
 * \begin{itemize}[noitemsep,nolistsep]
 * \item the mode is VS-mode or VU-mode and ASID in \Rvsatp
 * equals the lower ASIDMAX (defined in the Privileged Spec) bits
 * of \FcsrTextraThirtytwoSvalue.
 * \item in all other modes, ASID in \Rsatp equals the lower
 * ASIDMAX (defined in the Privileged Spec) bits of
 * \FcsrTextraThirtytwoSvalue.
 * \end{itemize}
 */
#define CSR_TEXTRA32_SSELECT_ASID           2
/*
 * This field should be tied to 0 when S-mode is not supported.
 */
#define CSR_TEXTRA64                        0x7a3
#define CSR_TEXTRA64_MHVALUE_OFFSET         0x33
#define CSR_TEXTRA64_MHVALUE_LENGTH         0xd
#define CSR_TEXTRA64_MHVALUE                0xfff8000000000000ULL
#define CSR_TEXTRA64_MHSELECT_OFFSET        0x30
#define CSR_TEXTRA64_MHSELECT_LENGTH        3
#define CSR_TEXTRA64_MHSELECT               0x7000000000000ULL
/*
 * When the least significant bit of this field is 1, it causes bits 7:0
 * in the comparison to be ignored, when \FcsrTextraSixtyfourSselect=1.
 * Likewise, the second bit controls the comparison of bits 15:8,
 * third bit controls the comparison of bits 23:16,
 * fourth bit controls the comparison of bits 31:24, and
 * fifth bit controls the comparison of bits 33:32.
 */
#define CSR_TEXTRA64_SBYTEMASK_OFFSET       0x24
#define CSR_TEXTRA64_SBYTEMASK_LENGTH       5
#define CSR_TEXTRA64_SBYTEMASK              0x1f000000000ULL
#define CSR_TEXTRA64_SVALUE_OFFSET          2
#define CSR_TEXTRA64_SVALUE_LENGTH          0x22
#define CSR_TEXTRA64_SVALUE                 0xffffffffcULL
#define CSR_TEXTRA64_SSELECT_OFFSET         0
#define CSR_TEXTRA64_SSELECT_LENGTH         2
#define CSR_TEXTRA64_SSELECT                3
#define DM_DMSTATUS                         0x11
#define DM_DMSTATUS_NDMRESETPENDING_OFFSET  0x18
#define DM_DMSTATUS_NDMRESETPENDING_LENGTH  1
#define DM_DMSTATUS_NDMRESETPENDING         0x1000000
/*
 * false: Unimplemented, or \FdmDmcontrolNdmreset is zero and no ndmreset is currently
 * in progress.
 */
#define DM_DMSTATUS_NDMRESETPENDING_FALSE   0
/*
 * true: \FdmDmcontrolNdmreset is currently nonzero, or there is an ndmreset in progress.
 */
#define DM_DMSTATUS_NDMRESETPENDING_TRUE    1
#define DM_DMSTATUS_STICKYUNAVAIL_OFFSET    0x17
#define DM_DMSTATUS_STICKYUNAVAIL_LENGTH    1
#define DM_DMSTATUS_STICKYUNAVAIL           0x800000
/*
 * current: The per-hart {\tt unavail} bits reflect the current state of the hart.
 */
#define DM_DMSTATUS_STICKYUNAVAIL_CURRENT   0
/*
 * sticky: The per-hart {\tt unavail} bits are sticky. Once they are set, they will
 * not clear until the debugger acknowledges them using \FdmDmcontrolAckunavail.
 */
#define DM_DMSTATUS_STICKYUNAVAIL_STICKY    1
/*
 * If 1, then there is an implicit {\tt ebreak} instruction at the
 * non-existent word immediately after the Program Buffer. This saves
 * the debugger from having to write the {\tt ebreak} itself, and
 * allows the Program Buffer to be one word smaller.
 *
 * This must be 1 when \FdmAbstractcsProgbufsize is 1.
 */
#define DM_DMSTATUS_IMPEBREAK_OFFSET        0x16
#define DM_DMSTATUS_IMPEBREAK_LENGTH        1
#define DM_DMSTATUS_IMPEBREAK               0x400000
/*
 * This field is 1 when all currently selected harts have been reset
 * and reset has not been acknowledged for any of them.
 */
#define DM_DMSTATUS_ALLHAVERESET_OFFSET     0x13
#define DM_DMSTATUS_ALLHAVERESET_LENGTH     1
#define DM_DMSTATUS_ALLHAVERESET            0x80000
/*
 * This field is 1 when at least one currently selected hart has been
 * reset and reset has not been acknowledged for that hart.
 */
#define DM_DMSTATUS_ANYHAVERESET_OFFSET     0x12
#define DM_DMSTATUS_ANYHAVERESET_LENGTH     1
#define DM_DMSTATUS_ANYHAVERESET            0x40000
/*
 * This field is 1 when all currently selected harts have their
 * resume ack bit\index{resume ack bit} set.
 */
#define DM_DMSTATUS_ALLRESUMEACK_OFFSET     0x11
#define DM_DMSTATUS_ALLRESUMEACK_LENGTH     1
#define DM_DMSTATUS_ALLRESUMEACK            0x20000
/*
 * This field is 1 when any currently selected hart has its
 * resume ack bit\index{resume ack bit} set.
 */
#define DM_DMSTATUS_ANYRESUMEACK_OFFSET     0x10
#define DM_DMSTATUS_ANYRESUMEACK_LENGTH     1
#define DM_DMSTATUS_ANYRESUMEACK            0x10000
/*
 * This field is 1 when all currently selected harts do not exist in
 * this hardware platform.
 */
#define DM_DMSTATUS_ALLNONEXISTENT_OFFSET   0xf
#define DM_DMSTATUS_ALLNONEXISTENT_LENGTH   1
#define DM_DMSTATUS_ALLNONEXISTENT          0x8000
/*
 * This field is 1 when any currently selected hart does not exist in
 * this hardware platform.
 */
#define DM_DMSTATUS_ANYNONEXISTENT_OFFSET   0xe
#define DM_DMSTATUS_ANYNONEXISTENT_LENGTH   1
#define DM_DMSTATUS_ANYNONEXISTENT          0x4000
/*
 * This field is 1 when all currently selected harts are
 * unavailable, or (if \FdmDmstatusStickyunavail is 1) were
 * unavailable without that being acknowledged.
 */
#define DM_DMSTATUS_ALLUNAVAIL_OFFSET       0xd
#define DM_DMSTATUS_ALLUNAVAIL_LENGTH       1
#define DM_DMSTATUS_ALLUNAVAIL              0x2000
/*
 * This field is 1 when any currently selected hart is unavailable,
 * or (if \FdmDmstatusStickyunavail is 1) was unavailable without
 * that being acknowledged.
 */
#define DM_DMSTATUS_ANYUNAVAIL_OFFSET       0xc
#define DM_DMSTATUS_ANYUNAVAIL_LENGTH       1
#define DM_DMSTATUS_ANYUNAVAIL              0x1000
/*
 * This field is 1 when all currently selected harts are running.
 */
#define DM_DMSTATUS_ALLRUNNING_OFFSET       0xb
#define DM_DMSTATUS_ALLRUNNING_LENGTH       1
#define DM_DMSTATUS_ALLRUNNING              0x800
/*
 * This field is 1 when any currently selected hart is running.
 */
#define DM_DMSTATUS_ANYRUNNING_OFFSET       0xa
#define DM_DMSTATUS_ANYRUNNING_LENGTH       1
#define DM_DMSTATUS_ANYRUNNING              0x400
/*
 * This field is 1 when all currently selected harts are halted.
 */
#define DM_DMSTATUS_ALLHALTED_OFFSET        9
#define DM_DMSTATUS_ALLHALTED_LENGTH        1
#define DM_DMSTATUS_ALLHALTED               0x200
/*
 * This field is 1 when any currently selected hart is halted.
 */
#define DM_DMSTATUS_ANYHALTED_OFFSET        8
#define DM_DMSTATUS_ANYHALTED_LENGTH        1
#define DM_DMSTATUS_ANYHALTED               0x100
#define DM_DMSTATUS_AUTHENTICATED_OFFSET    7
#define DM_DMSTATUS_AUTHENTICATED_LENGTH    1
#define DM_DMSTATUS_AUTHENTICATED           0x80
/*
 * false: Authentication is required before using the DM.
 */
#define DM_DMSTATUS_AUTHENTICATED_FALSE     0
/*
 * true: The authentication check has passed.
 */
#define DM_DMSTATUS_AUTHENTICATED_TRUE      1
/*
 * On components that don't implement authentication, this bit must be
 * preset as 1.
 */
#define DM_DMSTATUS_AUTHBUSY_OFFSET         6
#define DM_DMSTATUS_AUTHBUSY_LENGTH         1
#define DM_DMSTATUS_AUTHBUSY                0x40
/*
 * ready: The authentication module is ready to process the next
 * read/write to \RdmAuthdata.
 */
#define DM_DMSTATUS_AUTHBUSY_READY          0
/*
 * busy: The authentication module is busy. Accessing \RdmAuthdata results
 * in unspecified behavior.
 */
#define DM_DMSTATUS_AUTHBUSY_BUSY           1
/*
 * \FdmDmstatusAuthbusy only becomes set in immediate response to an access to
 * \RdmAuthdata.
 */
/*
 * 1 if this Debug Module supports halt-on-reset functionality
 * controllable by the \FdmDmcontrolSetresethaltreq and \FdmDmcontrolClrresethaltreq bits.
 * 0 otherwise.
 */
#define DM_DMSTATUS_HASRESETHALTREQ_OFFSET  5
#define DM_DMSTATUS_HASRESETHALTREQ_LENGTH  1
#define DM_DMSTATUS_HASRESETHALTREQ         0x20
#define DM_DMSTATUS_CONFSTRPTRVALID_OFFSET  4
#define DM_DMSTATUS_CONFSTRPTRVALID_LENGTH  1
#define DM_DMSTATUS_CONFSTRPTRVALID         0x10
/*
 * invalid: \RdmConfstrptrZero--\RdmConfstrptrThree hold information which
 * is not relevant to the configuration structure.
 */
#define DM_DMSTATUS_CONFSTRPTRVALID_INVALID 0
/*
 * valid: \RdmConfstrptrZero--\RdmConfstrptrThree hold the address of the
 * configuration structure.
 */
#define DM_DMSTATUS_CONFSTRPTRVALID_VALID   1
#define DM_DMSTATUS_VERSION_OFFSET          0
#define DM_DMSTATUS_VERSION_LENGTH          4
#define DM_DMSTATUS_VERSION                 0xf
/*
 * none: There is no Debug Module present.
 */
#define DM_DMSTATUS_VERSION_NONE            0
/*
 * 0.11: There is a Debug Module and it conforms to version 0.11 of this
 * specification.
 */
#define DM_DMSTATUS_VERSION_0_11            1
/*
 * 0.13: There is a Debug Module and it conforms to version 0.13 of this
 * specification.
 */
#define DM_DMSTATUS_VERSION_0_13            2
/*
 * 1.0: There is a Debug Module and it conforms to version 1.0 of this
 * specification.
 */
#define DM_DMSTATUS_VERSION_1_0             3
/*
 * custom: There is a Debug Module but it does not conform to any
 * available version of this spec.
 */
#define DM_DMSTATUS_VERSION_CUSTOM          15
#define DM_DMCONTROL                        0x10
/*
 * Writing 0 clears the halt request bit for all currently selected
 * harts. This may cancel outstanding halt requests for those harts.
 *
 * Writing 1 sets the halt request bit for all currently selected
 * harts. Running harts will halt whenever their halt request bit is
 * set.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_HALTREQ_OFFSET         0x1f
#define DM_DMCONTROL_HALTREQ_LENGTH         1
#define DM_DMCONTROL_HALTREQ                0x80000000U
/*
 * Writing 1 causes the currently selected harts to resume once, if
 * they are halted when the write occurs. It also clears the resume
 * ack bit for those harts.
 *
 * \FdmDmcontrolResumereq is ignored if \FdmDmcontrolHaltreq is set.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_RESUMEREQ_OFFSET       0x1e
#define DM_DMCONTROL_RESUMEREQ_LENGTH       1
#define DM_DMCONTROL_RESUMEREQ              0x40000000
/*
 * This optional field writes the reset bit for all the currently
 * selected harts.  To perform a reset the debugger writes 1, and then
 * writes 0 to deassert the reset signal.
 *
 * While this bit is 1, the debugger must not change which harts are
 * selected.
 *
 * If this feature is not implemented, the bit always stays 0, so
 * after writing 1 the debugger can read the register back to see if
 * the feature is supported.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_HARTRESET_OFFSET       0x1d
#define DM_DMCONTROL_HARTRESET_LENGTH       1
#define DM_DMCONTROL_HARTRESET              0x20000000
#define DM_DMCONTROL_ACKHAVERESET_OFFSET    0x1c
#define DM_DMCONTROL_ACKHAVERESET_LENGTH    1
#define DM_DMCONTROL_ACKHAVERESET           0x10000000
/*
 * nop: No effect.
 */
#define DM_DMCONTROL_ACKHAVERESET_NOP       0
/*
 * ack: Clears {\tt havereset} for any selected harts.
 */
#define DM_DMCONTROL_ACKHAVERESET_ACK       1
/*
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_ACKUNAVAIL_OFFSET      0x1b
#define DM_DMCONTROL_ACKUNAVAIL_LENGTH      1
#define DM_DMCONTROL_ACKUNAVAIL             0x8000000
/*
 * nop: No effect.
 */
#define DM_DMCONTROL_ACKUNAVAIL_NOP         0
/*
 * ack: Clears {\tt unavail} for any selected harts that are currently available.
 */
#define DM_DMCONTROL_ACKUNAVAIL_ACK         1
/*
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
/*
 * Selects the definition of currently selected harts.
 */
#define DM_DMCONTROL_HASEL_OFFSET           0x1a
#define DM_DMCONTROL_HASEL_LENGTH           1
#define DM_DMCONTROL_HASEL                  0x4000000
/*
 * single: There is a single currently selected hart, that is selected by \Fhartsel.
 */
#define DM_DMCONTROL_HASEL_SINGLE           0
/*
 * multiple: There may be multiple currently selected harts -- the hart
 * selected by \Fhartsel, plus those selected by the hart array mask
 * register.
 */
#define DM_DMCONTROL_HASEL_MULTIPLE         1
/*
 * An implementation which does not implement the hart array mask register
 * must tie this field to 0. A debugger which wishes to use the hart array
 * mask register feature should set this bit and read back to see if the functionality
 * is supported.
 */
/*
 * The low 10 bits of \Fhartsel: the DM-specific index of the hart to
 * select. This hart is always part of the currently selected harts.
 */
#define DM_DMCONTROL_HARTSELLO_OFFSET       0x10
#define DM_DMCONTROL_HARTSELLO_LENGTH       0xa
#define DM_DMCONTROL_HARTSELLO              0x3ff0000
/*
 * The high 10 bits of \Fhartsel: the DM-specific index of the hart to
 * select. This hart is always part of the currently selected harts.
 */
#define DM_DMCONTROL_HARTSELHI_OFFSET       6
#define DM_DMCONTROL_HARTSELHI_LENGTH       0xa
#define DM_DMCONTROL_HARTSELHI              0xffc0
/*
 * This optional field sets \Fkeepalive for all currently selected
 * harts, unless \FdmDmcontrolClrkeepalive is simultaneously set to
 * 1.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_SETKEEPALIVE_OFFSET    5
#define DM_DMCONTROL_SETKEEPALIVE_LENGTH    1
#define DM_DMCONTROL_SETKEEPALIVE           0x20
/*
 * This optional field clears \Fkeepalive for all currently selected
 * harts.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_CLRKEEPALIVE_OFFSET    4
#define DM_DMCONTROL_CLRKEEPALIVE_LENGTH    1
#define DM_DMCONTROL_CLRKEEPALIVE           0x10
/*
 * This optional field writes the halt-on-reset request bit for all
 * currently selected harts, unless \FdmDmcontrolClrresethaltreq is
 * simultaneously set to 1.
 * When set to 1, each selected hart will halt upon the next deassertion
 * of its reset. The halt-on-reset request bit is not automatically
 * cleared. The debugger must write to \FdmDmcontrolClrresethaltreq to clear it.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 *
 * If \FdmDmstatusHasresethaltreq is 0, this field is not implemented.
 */
#define DM_DMCONTROL_SETRESETHALTREQ_OFFSET 3
#define DM_DMCONTROL_SETRESETHALTREQ_LENGTH 1
#define DM_DMCONTROL_SETRESETHALTREQ        8
/*
 * This optional field clears the halt-on-reset request bit for all
 * currently selected harts.
 *
 * Writes apply to the new value of \Fhartsel and \FdmDmcontrolHasel.
 */
#define DM_DMCONTROL_CLRRESETHALTREQ_OFFSET 2
#define DM_DMCONTROL_CLRRESETHALTREQ_LENGTH 1
#define DM_DMCONTROL_CLRRESETHALTREQ        4
/*
 * This bit controls the reset signal from the DM to the rest of the
 * hardware platform. The signal should reset every part of the hardware platform, including
 * every hart, except for the DM and any logic required to access the
 * DM.
 * To perform a hardware platform reset the debugger writes 1,
 * and then writes 0
 * to deassert the reset.
 */
#define DM_DMCONTROL_NDMRESET_OFFSET        1
#define DM_DMCONTROL_NDMRESET_LENGTH        1
#define DM_DMCONTROL_NDMRESET               2
/*
 * This bit serves as a reset signal for the Debug Module itself.
 * After changing the value of this bit, the debugger must poll
 * \RdmDmcontrol until \FdmDmcontrolDmactive has taken the requested value
 * before performing any action that assumes the requested \FdmDmcontrolDmactive
 * state change has completed.  Hardware may
 * take an arbitrarily long time to complete activation or deactivation and will
 * indicate completion by setting \FdmDmcontrolDmactive to the requested value.
 */
#define DM_DMCONTROL_DMACTIVE_OFFSET        0
#define DM_DMCONTROL_DMACTIVE_LENGTH        1
#define DM_DMCONTROL_DMACTIVE               1
/*
 * inactive: The module's state, including authentication mechanism,
 * takes its reset values (the \FdmDmcontrolDmactive bit is the only bit which can
 * be written to something other than its reset value). Any accesses
 * to the module may fail. Specifically, \FdmDmstatusVersion might not return
 * correct data.
 */
#define DM_DMCONTROL_DMACTIVE_INACTIVE      0
/*
 * active: The module functions normally.
 */
#define DM_DMCONTROL_DMACTIVE_ACTIVE        1
/*
 * No other mechanism should exist that may result in resetting the
 * Debug Module after power up.
 *
 * To place the Debug Module into a known state, a debugger may write 0 to \FdmDmcontrolDmactive,
 * poll until \FdmDmcontrolDmactive is observed 0, write 1 to \FdmDmcontrolDmactive, and
 * poll until \FdmDmcontrolDmactive is observed 1.
 *
 * Implementations may pay attention to this bit to further aid
 * debugging, for example by preventing the Debug Module from being
 * power gated while debugging is active.
 */
#define DM_HARTINFO                         0x12
/*
 * Number of {\tt dscratch} registers available for the debugger
 * to use during program buffer execution, starting from \RcsrDscratchZero.
 * The debugger can make no assumptions about the contents of these
 * registers between commands.
 */
#define DM_HARTINFO_NSCRATCH_OFFSET         0x14
#define DM_HARTINFO_NSCRATCH_LENGTH         4
#define DM_HARTINFO_NSCRATCH                0xf00000
#define DM_HARTINFO_DATAACCESS_OFFSET       0x10
#define DM_HARTINFO_DATAACCESS_LENGTH       1
#define DM_HARTINFO_DATAACCESS              0x10000
/*
 * csr: The {\tt data} registers are shadowed in the hart by CSRs.
 * Each CSR is DXLEN bits in size, and corresponds
 * to a single argument, per Table~\ref{tab:datareg}.
 */
#define DM_HARTINFO_DATAACCESS_CSR          0
/*
 * memory: The {\tt data} registers are shadowed in the hart's memory map.
 * Each register takes up 4 bytes in the memory map.
 */
#define DM_HARTINFO_DATAACCESS_MEMORY       1
/*
 * If \FdmHartinfoDataaccess is 0: Number of CSRs dedicated to
 * shadowing the {\tt data} registers.
 *
 * If \FdmHartinfoDataaccess is 1: Number of 32-bit words in the memory map
 * dedicated to shadowing the {\tt data} registers.
 *
 * If this value is non-zero, then the {tt data} registers must go
 * beyond being MRs and guarantee they each store a single value, that is
 * readable/writable by either side.
 *
 * Since there are at most 12 {\tt data} registers, the value in this
 * register must be 12 or smaller.
 */
#define DM_HARTINFO_DATASIZE_OFFSET         0xc
#define DM_HARTINFO_DATASIZE_LENGTH         4
#define DM_HARTINFO_DATASIZE                0xf000
/*
 * If \FdmHartinfoDataaccess is 0: The number of the first CSR dedicated to
 * shadowing the {\tt data} registers.
 *
 * If \FdmHartinfoDataaccess is 1: Address of RAM where the data
 * registers are shadowed. This address is sign extended giving a
 * range of -2048 to 2047, easily addressed with a load or store using
 * \Xzero as the address register.
 */
#define DM_HARTINFO_DATAADDR_OFFSET         0
#define DM_HARTINFO_DATAADDR_LENGTH         0xc
#define DM_HARTINFO_DATAADDR                0xfff
#define DM_HAWINDOWSEL                      0x14
/*
 * The high bits of this field may be tied to 0, depending on how large
 * the array mask register is.  E.g.\ on a hardware platform with 48 harts only bit 0
 * of this field may actually be writable.
 */
#define DM_HAWINDOWSEL_HAWINDOWSEL_OFFSET   0
#define DM_HAWINDOWSEL_HAWINDOWSEL_LENGTH   0xf
#define DM_HAWINDOWSEL_HAWINDOWSEL          0x7fff
#define DM_HAWINDOW                         0x15
#define DM_HAWINDOW_MASKDATA_OFFSET         0
#define DM_HAWINDOW_MASKDATA_LENGTH         0x20
#define DM_HAWINDOW_MASKDATA                0xffffffffU
#define DM_ABSTRACTCS                       0x16
/*
 * Size of the Program Buffer, in 32-bit words. Valid sizes are 0 - 16.
 */
#define DM_ABSTRACTCS_PROGBUFSIZE_OFFSET    0x18
#define DM_ABSTRACTCS_PROGBUFSIZE_LENGTH    5
#define DM_ABSTRACTCS_PROGBUFSIZE           0x1f000000
#define DM_ABSTRACTCS_BUSY_OFFSET           0xc
#define DM_ABSTRACTCS_BUSY_LENGTH           1
#define DM_ABSTRACTCS_BUSY                  0x1000
/*
 * ready: There is no abstract command currently being executed.
 */
#define DM_ABSTRACTCS_BUSY_READY            0
/*
 * busy: An abstract command is currently being executed.
 */
#define DM_ABSTRACTCS_BUSY_BUSY             1
/*
 * This bit is set as soon as \RdmCommand is written, and is
 * not cleared until that command has completed.
 */
/*
 * This optional bit controls whether program buffer and abstract
 * memory accesses are performed with the exact and full set of
 * permission checks that apply based on the current architectural
 * state of the hart performing the access, or with a relaxed set of
 * permission checks (e.g. PMP restrictions are ignored).  The
 * details of the latter are implementation-specific.  When set to 0,
 * full permissions apply; when set to 1, relaxed permissions apply.
 */
#define DM_ABSTRACTCS_RELAXEDPRIV_OFFSET    0xb
#define DM_ABSTRACTCS_RELAXEDPRIV_LENGTH    1
#define DM_ABSTRACTCS_RELAXEDPRIV           0x800
/*
 * Gets set if an abstract command fails. The bits in this field remain set until
 * they are cleared by writing 1 to them. No abstract command is
 * started until the value is reset to 0.
 *
 * This field only contains a valid value if \FdmAbstractcsBusy is 0.
 */
#define DM_ABSTRACTCS_CMDERR_OFFSET         8
#define DM_ABSTRACTCS_CMDERR_LENGTH         3
#define DM_ABSTRACTCS_CMDERR                0x700
/*
 * none: No error.
 */
#define DM_ABSTRACTCS_CMDERR_NONE           0
/*
 * busy: An abstract command was executing while \RdmCommand,
 * \RdmAbstractcs, or \RdmAbstractauto was written, or when one
 * of the {\tt data} or {\tt progbuf} registers was read or written.
 * This status is only written if \FdmAbstractcsCmderr contains 0.
 */
#define DM_ABSTRACTCS_CMDERR_BUSY           1
/*
 * not supported: The command in \RdmCommand is not supported.  It
 * may be supported with different options set, but it will not be
 * supported at a later time when the hart or system state are
 * different.
 */
#define DM_ABSTRACTCS_CMDERR_NOT_SUPPORTED  2
/*
 * exception: An exception occurred while executing the command
 * (e.g.\ while executing the Program Buffer).
 */
#define DM_ABSTRACTCS_CMDERR_EXCEPTION      3
/*
 * halt/resume: The abstract command couldn't execute because the
 * hart wasn't in the required state (running/halted), or unavailable.
 */
#define DM_ABSTRACTCS_CMDERR_HALT_RESUME    4
/*
 * bus: The abstract command failed due to a bus error (e.g.\
 * alignment, access size, or timeout).
 */
#define DM_ABSTRACTCS_CMDERR_BUS            5
/*
 * reserved: Reserved for future use.
 */
#define DM_ABSTRACTCS_CMDERR_RESERVED       6
/*
 * other: The command failed for another reason.
 */
#define DM_ABSTRACTCS_CMDERR_OTHER          7
/*
 * Number of {\tt data} registers that are implemented as part of the
 * abstract command interface. Valid sizes are 1 -- 12.
 */
#define DM_ABSTRACTCS_DATACOUNT_OFFSET      0
#define DM_ABSTRACTCS_DATACOUNT_LENGTH      4
#define DM_ABSTRACTCS_DATACOUNT             0xf
#define DM_COMMAND                          0x17
/*
 * The type determines the overall functionality of this
 * abstract command.
 */
#define DM_COMMAND_CMDTYPE_OFFSET           0x18
#define DM_COMMAND_CMDTYPE_LENGTH           8
#define DM_COMMAND_CMDTYPE                  0xff000000U
/*
 * This field is interpreted in a command-specific manner,
 * described for each abstract command.
 */
#define DM_COMMAND_CONTROL_OFFSET           0
#define DM_COMMAND_CONTROL_LENGTH           0x18
#define DM_COMMAND_CONTROL                  0xffffff
#define DM_ABSTRACTAUTO                     0x18
/*
 * When a bit in this field is 1, read or write accesses to the
 * corresponding {\tt progbuf} word cause the DM to act as if the
 * current value in \RdmCommand was written there again after the
 * access to {\tt progbuf} completes.
 */
#define DM_ABSTRACTAUTO_AUTOEXECPROGBUF_OFFSET 0x10
#define DM_ABSTRACTAUTO_AUTOEXECPROGBUF_LENGTH 0x10
#define DM_ABSTRACTAUTO_AUTOEXECPROGBUF     0xffff0000U
/*
 * When a bit in this field is 1, read or write accesses to the
 * corresponding {\tt data} word cause the DM to act as if the current
 * value in \RdmCommand was written there again after the
 * access to {\tt data} completes.
 */
#define DM_ABSTRACTAUTO_AUTOEXECDATA_OFFSET 0
#define DM_ABSTRACTAUTO_AUTOEXECDATA_LENGTH 0xc
#define DM_ABSTRACTAUTO_AUTOEXECDATA        0xfff
#define DM_CONFSTRPTR0                      0x19
#define DM_CONFSTRPTR0_ADDR_OFFSET          0
#define DM_CONFSTRPTR0_ADDR_LENGTH          0x20
#define DM_CONFSTRPTR0_ADDR                 0xffffffffU
#define DM_CONFSTRPTR1                      0x1a
#define DM_CONFSTRPTR1_ADDR_OFFSET          0
#define DM_CONFSTRPTR1_ADDR_LENGTH          0x20
#define DM_CONFSTRPTR1_ADDR                 0xffffffffU
#define DM_CONFSTRPTR2                      0x1b
#define DM_CONFSTRPTR2_ADDR_OFFSET          0
#define DM_CONFSTRPTR2_ADDR_LENGTH          0x20
#define DM_CONFSTRPTR2_ADDR                 0xffffffffU
#define DM_CONFSTRPTR3                      0x1c
#define DM_CONFSTRPTR3_ADDR_OFFSET          0
#define DM_CONFSTRPTR3_ADDR_LENGTH          0x20
#define DM_CONFSTRPTR3_ADDR                 0xffffffffU
#define DM_NEXTDM                           0x1d
#define DM_NEXTDM_ADDR_OFFSET               0
#define DM_NEXTDM_ADDR_LENGTH               0x20
#define DM_NEXTDM_ADDR                      0xffffffffU
#define DM_DATA0                            0x04
#define DM_DATA0_DATA_OFFSET                0
#define DM_DATA0_DATA_LENGTH                0x20
#define DM_DATA0_DATA                       0xffffffffU
#define DM_DATA1                            0x05
#define DM_DATA2                            0x06
#define DM_DATA3                            0x07
#define DM_DATA4                            0x08
#define DM_DATA5                            0x09
#define DM_DATA6                            0x0a
#define DM_DATA7                            0x0b
#define DM_DATA8                            0x0c
#define DM_DATA9                            0x0d
#define DM_DATA10                           0x0e
#define DM_DATA11                           0x0f
#define DM_PROGBUF0                         0x20
#define DM_PROGBUF0_DATA_OFFSET             0
#define DM_PROGBUF0_DATA_LENGTH             0x20
#define DM_PROGBUF0_DATA                    0xffffffffU
#define DM_PROGBUF1                         0x21
#define DM_PROGBUF2                         0x22
#define DM_PROGBUF3                         0x23
#define DM_PROGBUF4                         0x24
#define DM_PROGBUF5                         0x25
#define DM_PROGBUF6                         0x26
#define DM_PROGBUF7                         0x27
#define DM_PROGBUF8                         0x28
#define DM_PROGBUF9                         0x29
#define DM_PROGBUF10                        0x2a
#define DM_PROGBUF11                        0x2b
#define DM_PROGBUF12                        0x2c
#define DM_PROGBUF13                        0x2d
#define DM_PROGBUF14                        0x2e
#define DM_PROGBUF15                        0x2f
#define DM_AUTHDATA                         0x30
#define DM_AUTHDATA_DATA_OFFSET             0
#define DM_AUTHDATA_DATA_LENGTH             0x20
#define DM_AUTHDATA_DATA                    0xffffffffU
#define DM_DMCS2                            0x32
#define DM_DMCS2_GROUPTYPE_OFFSET           0xb
#define DM_DMCS2_GROUPTYPE_LENGTH           1
#define DM_DMCS2_GROUPTYPE                  0x800
/*
 * halt: The remaining fields in this register configure halt groups.
 */
#define DM_DMCS2_GROUPTYPE_HALT             0
/*
 * resume: The remaining fields in this register configure resume groups.
 */
#define DM_DMCS2_GROUPTYPE_RESUME           1
/*
 * This field contains the currently selected DM external trigger.
 *
 * If a non-existent trigger value is written here, the hardware will
 * change it to a valid one or 0 if no DM external triggers exist.
 */
#define DM_DMCS2_DMEXTTRIGGER_OFFSET        7
#define DM_DMCS2_DMEXTTRIGGER_LENGTH        4
#define DM_DMCS2_DMEXTTRIGGER               0x780
/*
 * When \FdmDmcsTwoHgselect is 0, contains the group of the hart
 * specified by \Fhartsel.
 *
 * When \FdmDmcsTwoHgselect is 1, contains the group of the DM external
 * trigger selected by \FdmDmcsTwoDmexttrigger.
 *
 * The value written to this field is ignored unless \FdmDmcsTwoHgwrite
 * is also written 1.
 *
 * Group numbers are contiguous starting at 0, with the highest number
 * being implementation-dependent, and possibly different between
 * different group types. Debuggers should read back this field after
 * writing to confirm they are using a hart group that is supported.
 *
 * If groups aren't implemented, then this entire field is 0.
 */
#define DM_DMCS2_GROUP_OFFSET               2
#define DM_DMCS2_GROUP_LENGTH               5
#define DM_DMCS2_GROUP                      0x7c
/*
 * When 1 is written and \FdmDmcsTwoHgselect is 0, for every selected
 * hart the DM will change its group to the value written to \FdmDmcsTwoGroup,
 * if the hardware supports that group for that hart.
 * Implementations may also change the group of a minimal set of
 * unselected harts in the same way, if that is necessary due to
 * a hardware limitation.
 *
 * When 1 is written and \FdmDmcsTwoHgselect is 1, the DM will change
 * the group of the DM external trigger selected by \FdmDmcsTwoDmexttrigger
 * to the value written to \FdmDmcsTwoGroup, if the hardware supports
 * that group for that trigger.
 *
 * Writing 0 has no effect.
 */
#define DM_DMCS2_HGWRITE_OFFSET             1
#define DM_DMCS2_HGWRITE_LENGTH             1
#define DM_DMCS2_HGWRITE                    2
#define DM_DMCS2_HGSELECT_OFFSET            0
#define DM_DMCS2_HGSELECT_LENGTH            1
#define DM_DMCS2_HGSELECT                   1
/*
 * harts: Operate on harts.
 */
#define DM_DMCS2_HGSELECT_HARTS             0
/*
 * triggers: Operate on DM external triggers.
 */
#define DM_DMCS2_HGSELECT_TRIGGERS          1
/*
 * If there are no DM external triggers, this field must be tied to 0.
 */
#define DM_HALTSUM0                         0x40
#define DM_HALTSUM0_HALTSUM0_OFFSET         0
#define DM_HALTSUM0_HALTSUM0_LENGTH         0x20
#define DM_HALTSUM0_HALTSUM0                0xffffffffU
#define DM_HALTSUM1                         0x13
#define DM_HALTSUM1_HALTSUM1_OFFSET         0
#define DM_HALTSUM1_HALTSUM1_LENGTH         0x20
#define DM_HALTSUM1_HALTSUM1                0xffffffffU
#define DM_HALTSUM2                         0x34
#define DM_HALTSUM2_HALTSUM2_OFFSET         0
#define DM_HALTSUM2_HALTSUM2_LENGTH         0x20
#define DM_HALTSUM2_HALTSUM2                0xffffffffU
#define DM_HALTSUM3                         0x35
#define DM_HALTSUM3_HALTSUM3_OFFSET         0
#define DM_HALTSUM3_HALTSUM3_LENGTH         0x20
#define DM_HALTSUM3_HALTSUM3                0xffffffffU
#define DM_SBCS                             0x38
#define DM_SBCS_SBVERSION_OFFSET            0x1d
#define DM_SBCS_SBVERSION_LENGTH            3
#define DM_SBCS_SBVERSION                   0xe0000000U
/*
 * legacy: The System Bus interface conforms to mainline drafts of this
 * spec older than 1 January, 2018.
 */
#define DM_SBCS_SBVERSION_LEGACY            0
/*
 * 1.0: The System Bus interface conforms to this version of the spec.
 */
#define DM_SBCS_SBVERSION_1_0               1
/*
 * Other values are reserved for future versions.
 */
/*
 * Set when the debugger attempts to read data while a read is in
 * progress, or when the debugger initiates a new access while one is
 * already in progress (while \FdmSbcsSbbusy is set). It remains set until
 * it's explicitly cleared by the debugger.
 *
 * While this field is set, no more system bus accesses can be
 * initiated by the Debug Module.
 */
#define DM_SBCS_SBBUSYERROR_OFFSET          0x16
#define DM_SBCS_SBBUSYERROR_LENGTH          1
#define DM_SBCS_SBBUSYERROR                 0x400000
/*
 * When 1, indicates the system bus master is busy. (Whether the
 * system bus itself is busy is related, but not the same thing.) This
 * bit goes high immediately when a read or write is requested for any
 * reason, and does not go low until the access is fully completed.
 *
 * Writes to \RdmSbcs while \FdmSbcsSbbusy is high result in undefined
 * behavior.  A debugger must not write to \RdmSbcs until it reads
 * \FdmSbcsSbbusy as 0.
 */
#define DM_SBCS_SBBUSY_OFFSET               0x15
#define DM_SBCS_SBBUSY_LENGTH               1
#define DM_SBCS_SBBUSY                      0x200000
/*
 * When 1, every write to \RdmSbaddressZero automatically triggers a
 * system bus read at the new address.
 */
#define DM_SBCS_SBREADONADDR_OFFSET         0x14
#define DM_SBCS_SBREADONADDR_LENGTH         1
#define DM_SBCS_SBREADONADDR                0x100000
/*
 * Select the access size to use for system bus accesses.
 */
#define DM_SBCS_SBACCESS_OFFSET             0x11
#define DM_SBCS_SBACCESS_LENGTH             3
#define DM_SBCS_SBACCESS                    0xe0000
/*
 * 8bit: 8-bit
 */
#define DM_SBCS_SBACCESS_8BIT               0
/*
 * 16bit: 16-bit
 */
#define DM_SBCS_SBACCESS_16BIT              1
/*
 * 32bit: 32-bit
 */
#define DM_SBCS_SBACCESS_32BIT              2
/*
 * 64bit: 64-bit
 */
#define DM_SBCS_SBACCESS_64BIT              3
/*
 * 128bit: 128-bit
 */
#define DM_SBCS_SBACCESS_128BIT             4
/*
 * If \FdmSbcsSbaccess has an unsupported value when the DM starts a bus
 * access, the access is not performed and \FdmSbcsSberror is set to 4.
 */
/*
 * When 1, {\tt sbaddress} is incremented by the access size (in
 * bytes) selected in \FdmSbcsSbaccess after every system bus access.
 */
#define DM_SBCS_SBAUTOINCREMENT_OFFSET      0x10
#define DM_SBCS_SBAUTOINCREMENT_LENGTH      1
#define DM_SBCS_SBAUTOINCREMENT             0x10000
/*
 * When 1, every read from \RdmSbdataZero automatically triggers a
 * system bus read at the (possibly auto-incremented) address.
 */
#define DM_SBCS_SBREADONDATA_OFFSET         0xf
#define DM_SBCS_SBREADONDATA_LENGTH         1
#define DM_SBCS_SBREADONDATA                0x8000
/*
 * When the Debug Module's system bus
 * master encounters an error, this field gets set. The bits in this
 * field remain set until they are cleared by writing 1 to them.
 * While this field is non-zero, no more system bus accesses can be
 * initiated by the Debug Module.
 *
 * An implementation may report ``Other'' (7) for any error condition.
 */
#define DM_SBCS_SBERROR_OFFSET              0xc
#define DM_SBCS_SBERROR_LENGTH              3
#define DM_SBCS_SBERROR                     0x7000
/*
 * none: There was no bus error.
 */
#define DM_SBCS_SBERROR_NONE                0
/*
 * timeout: There was a timeout.
 */
#define DM_SBCS_SBERROR_TIMEOUT             1
/*
 * address: A bad address was accessed.
 */
#define DM_SBCS_SBERROR_ADDRESS             2
/*
 * alignment: There was an alignment error.
 */
#define DM_SBCS_SBERROR_ALIGNMENT           3
/*
 * size: An access of unsupported size was requested.
 */
#define DM_SBCS_SBERROR_SIZE                4
/*
 * other: Other.
 */
#define DM_SBCS_SBERROR_OTHER               7
/*
 * Width of system bus addresses in bits. (0 indicates there is no bus
 * access support.)
 */
#define DM_SBCS_SBASIZE_OFFSET              5
#define DM_SBCS_SBASIZE_LENGTH              7
#define DM_SBCS_SBASIZE                     0xfe0
/*
 * 1 when 128-bit system bus accesses are supported.
 */
#define DM_SBCS_SBACCESS128_OFFSET          4
#define DM_SBCS_SBACCESS128_LENGTH          1
#define DM_SBCS_SBACCESS128                 0x10
/*
 * 1 when 64-bit system bus accesses are supported.
 */
#define DM_SBCS_SBACCESS64_OFFSET           3
#define DM_SBCS_SBACCESS64_LENGTH           1
#define DM_SBCS_SBACCESS64                  8
/*
 * 1 when 32-bit system bus accesses are supported.
 */
#define DM_SBCS_SBACCESS32_OFFSET           2
#define DM_SBCS_SBACCESS32_LENGTH           1
#define DM_SBCS_SBACCESS32                  4
/*
 * 1 when 16-bit system bus accesses are supported.
 */
#define DM_SBCS_SBACCESS16_OFFSET           1
#define DM_SBCS_SBACCESS16_LENGTH           1
#define DM_SBCS_SBACCESS16                  2
/*
 * 1 when 8-bit system bus accesses are supported.
 */
#define DM_SBCS_SBACCESS8_OFFSET            0
#define DM_SBCS_SBACCESS8_LENGTH            1
#define DM_SBCS_SBACCESS8                   1
#define DM_SBADDRESS0                       0x39
/*
 * Accesses bits 31:0 of the physical address in {\tt sbaddress}.
 */
#define DM_SBADDRESS0_ADDRESS_OFFSET        0
#define DM_SBADDRESS0_ADDRESS_LENGTH        0x20
#define DM_SBADDRESS0_ADDRESS               0xffffffffU
#define DM_SBADDRESS1                       0x3a
/*
 * Accesses bits 63:32 of the physical address in {\tt sbaddress} (if
 * the system address bus is that wide).
 */
#define DM_SBADDRESS1_ADDRESS_OFFSET        0
#define DM_SBADDRESS1_ADDRESS_LENGTH        0x20
#define DM_SBADDRESS1_ADDRESS               0xffffffffU
#define DM_SBADDRESS2                       0x3b
/*
 * Accesses bits 95:64 of the physical address in {\tt sbaddress} (if
 * the system address bus is that wide).
 */
#define DM_SBADDRESS2_ADDRESS_OFFSET        0
#define DM_SBADDRESS2_ADDRESS_LENGTH        0x20
#define DM_SBADDRESS2_ADDRESS               0xffffffffU
#define DM_SBADDRESS3                       0x37
/*
 * Accesses bits 127:96 of the physical address in {\tt sbaddress} (if
 * the system address bus is that wide).
 */
#define DM_SBADDRESS3_ADDRESS_OFFSET        0
#define DM_SBADDRESS3_ADDRESS_LENGTH        0x20
#define DM_SBADDRESS3_ADDRESS               0xffffffffU
#define DM_SBDATA0                          0x3c
/*
 * Accesses bits 31:0 of {\tt sbdata}.
 */
#define DM_SBDATA0_DATA_OFFSET              0
#define DM_SBDATA0_DATA_LENGTH              0x20
#define DM_SBDATA0_DATA                     0xffffffffU
#define DM_SBDATA1                          0x3d
/*
 * Accesses bits 63:32 of {\tt sbdata} (if the system bus is that
 * wide).
 */
#define DM_SBDATA1_DATA_OFFSET              0
#define DM_SBDATA1_DATA_LENGTH              0x20
#define DM_SBDATA1_DATA                     0xffffffffU
#define DM_SBDATA2                          0x3e
/*
 * Accesses bits 95:64 of {\tt sbdata} (if the system bus is that
 * wide).
 */
#define DM_SBDATA2_DATA_OFFSET              0
#define DM_SBDATA2_DATA_LENGTH              0x20
#define DM_SBDATA2_DATA                     0xffffffffU
#define DM_SBDATA3                          0x3f
/*
 * Accesses bits 127:96 of {\tt sbdata} (if the system bus is that
 * wide).
 */
#define DM_SBDATA3_DATA_OFFSET              0
#define DM_SBDATA3_DATA_LENGTH              0x20
#define DM_SBDATA3_DATA                     0xffffffffU
#define DM_CUSTOM                           0x1f
#define DM_CUSTOM0                          0x70
#define DM_CUSTOM1                          0x71
#define DM_CUSTOM2                          0x72
#define DM_CUSTOM3                          0x73
#define DM_CUSTOM4                          0x74
#define DM_CUSTOM5                          0x75
#define DM_CUSTOM6                          0x76
#define DM_CUSTOM7                          0x77
#define DM_CUSTOM8                          0x78
#define DM_CUSTOM9                          0x79
#define DM_CUSTOM10                         0x7a
#define DM_CUSTOM11                         0x7b
#define DM_CUSTOM12                         0x7c
#define DM_CUSTOM13                         0x7d
#define DM_CUSTOM14                         0x7e
#define DM_CUSTOM15                         0x7f
#define SHORTNAME                           0x123
/*
 * Description of what this field is used for.
 */
#define SHORTNAME_FIELD_OFFSET              0
#define SHORTNAME_FIELD_LENGTH              8
#define SHORTNAME_FIELD                     0xff
/*
 * This is 0 to indicate Access Register Command.
 */
#define AC_ACCESS_REGISTER_CMDTYPE_OFFSET   0x18
#define AC_ACCESS_REGISTER_CMDTYPE_LENGTH   8
#define AC_ACCESS_REGISTER_CMDTYPE          0xff000000U
#define AC_ACCESS_REGISTER_AARSIZE_OFFSET   0x14
#define AC_ACCESS_REGISTER_AARSIZE_LENGTH   3
#define AC_ACCESS_REGISTER_AARSIZE          0x700000
/*
 * 32bit: Access the lowest 32 bits of the register.
 */
#define AC_ACCESS_REGISTER_AARSIZE_32BIT    2
/*
 * 64bit: Access the lowest 64 bits of the register.
 */
#define AC_ACCESS_REGISTER_AARSIZE_64BIT    3
/*
 * 128bit: Access the lowest 128 bits of the register.
 */
#define AC_ACCESS_REGISTER_AARSIZE_128BIT   4
/*
 * If \FacAccessregisterAarsize specifies a size larger than the register's actual size,
 * then the access must fail. If a register is accessible, then reads of \FacAccessregisterAarsize
 * less than or equal to the register's actual size must be supported.
 * Writing less than the full register may be supported, but what
 * happens to the high bits in that case is \unspecified.
 *
 * This field controls the Argument Width as referenced in
 * Table~\ref{tab:datareg}.
 */
#define AC_ACCESS_REGISTER_AARPOSTINCREMENT_OFFSET 0x13
#define AC_ACCESS_REGISTER_AARPOSTINCREMENT_LENGTH 1
#define AC_ACCESS_REGISTER_AARPOSTINCREMENT 0x80000
/*
 * disabled: No effect. This variant must be supported.
 */
#define AC_ACCESS_REGISTER_AARPOSTINCREMENT_DISABLED 0
/*
 * enabled: After a successful register access, \FacAccessregisterRegno is
 * incremented. Incrementing past the highest supported value
 * causes \FacAccessregisterRegno to become \unspecified.  Supporting
 * this variant is optional. It is undefined whether the increment
 * happens when \FacAccessregisterTransfer is 0.
 */
#define AC_ACCESS_REGISTER_AARPOSTINCREMENT_ENABLED 1
#define AC_ACCESS_REGISTER_POSTEXEC_OFFSET  0x12
#define AC_ACCESS_REGISTER_POSTEXEC_LENGTH  1
#define AC_ACCESS_REGISTER_POSTEXEC         0x40000
/*
 * disabled: No effect. This variant must be supported, and is the only
 * supported one if \FdmAbstractcsProgbufsize is 0.
 */
#define AC_ACCESS_REGISTER_POSTEXEC_DISABLED 0
/*
 * enabled: Execute the program in the Program Buffer exactly once after
 * performing the transfer, if any. Supporting this variant is
 * optional.
 */
#define AC_ACCESS_REGISTER_POSTEXEC_ENABLED 1
#define AC_ACCESS_REGISTER_TRANSFER_OFFSET  0x11
#define AC_ACCESS_REGISTER_TRANSFER_LENGTH  1
#define AC_ACCESS_REGISTER_TRANSFER         0x20000
/*
 * disabled: Don't do the operation specified by \FacAccessregisterWrite.
 */
#define AC_ACCESS_REGISTER_TRANSFER_DISABLED 0
/*
 * enabled: Do the operation specified by \FacAccessregisterWrite.
 */
#define AC_ACCESS_REGISTER_TRANSFER_ENABLED 1
/*
 * This bit can be used to just execute the Program Buffer without
 * having to worry about placing valid values into \FacAccessregisterAarsize or \FacAccessregisterRegno.
 */
/*
 * When \FacAccessregisterTransfer is set:
 */
#define AC_ACCESS_REGISTER_WRITE_OFFSET     0x10
#define AC_ACCESS_REGISTER_WRITE_LENGTH     1
#define AC_ACCESS_REGISTER_WRITE            0x10000
/*
 * arg0: Copy data from the specified register into {\tt arg0} portion
 * of {\tt data}.
 */
#define AC_ACCESS_REGISTER_WRITE_ARG0       0
/*
 * register: Copy data from {\tt arg0} portion of {\tt data} into the
 * specified register.
 */
#define AC_ACCESS_REGISTER_WRITE_REGISTER   1
/*
 * Number of the register to access, as described in
 * Table~\ref{tab:regno}.
 * \RcsrDpc may be used as an alias for PC if this command is
 * supported on a non-halted hart.
 */
#define AC_ACCESS_REGISTER_REGNO_OFFSET     0
#define AC_ACCESS_REGISTER_REGNO_LENGTH     0x10
#define AC_ACCESS_REGISTER_REGNO            0xffff
/*
 * This is 1 to indicate Quick Access command.
 */
#define AC_QUICK_ACCESS_CMDTYPE_OFFSET      0x18
#define AC_QUICK_ACCESS_CMDTYPE_LENGTH      8
#define AC_QUICK_ACCESS_CMDTYPE             0xff000000U
/*
 * This is 2 to indicate Access Memory Command.
 */
#define AC_ACCESS_MEMORY_CMDTYPE_OFFSET     0x18
#define AC_ACCESS_MEMORY_CMDTYPE_LENGTH     8
#define AC_ACCESS_MEMORY_CMDTYPE            0xff000000U
/*
 * An implementation does not have to implement both virtual and
 * physical accesses, but it must fail accesses that it doesn't
 * support.
 */
#define AC_ACCESS_MEMORY_AAMVIRTUAL_OFFSET  0x17
#define AC_ACCESS_MEMORY_AAMVIRTUAL_LENGTH  1
#define AC_ACCESS_MEMORY_AAMVIRTUAL         0x800000
/*
 * physical: Addresses are physical (to the hart they are performed on).
 */
#define AC_ACCESS_MEMORY_AAMVIRTUAL_PHYSICAL 0
/*
 * virtual: Addresses are virtual, and translated the way they would be from
 * M-mode, with \FcsrMstatusMprv set.
 */
#define AC_ACCESS_MEMORY_AAMVIRTUAL_VIRTUAL 1
/*
 * Debug Modules on systems without address translation (i.e. virtual addresses equal physical)
 * may optionally allow \FacAccessmemoryAamvirtual set to 1, which would produce the same result as
 * that same abstract command with \FacAccessmemoryAamvirtual cleared.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_OFFSET     0x14
#define AC_ACCESS_MEMORY_AAMSIZE_LENGTH     3
#define AC_ACCESS_MEMORY_AAMSIZE            0x700000
/*
 * 8bit: Access the lowest 8 bits of the memory location.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_8BIT       0
/*
 * 16bit: Access the lowest 16 bits of the memory location.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_16BIT      1
/*
 * 32bit: Access the lowest 32 bits of the memory location.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_32BIT      2
/*
 * 64bit: Access the lowest 64 bits of the memory location.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_64BIT      3
/*
 * 128bit: Access the lowest 128 bits of the memory location.
 */
#define AC_ACCESS_MEMORY_AAMSIZE_128BIT     4
/*
 * After a memory access has completed, if this bit is 1, increment
 * {\tt arg1} (which contains the address used) by the number of bytes
 * encoded in \FacAccessmemoryAamsize.
 *
 * Supporting this variant is optional, but highly recommended for
 * performance reasons.
 */
#define AC_ACCESS_MEMORY_AAMPOSTINCREMENT_OFFSET 0x13
#define AC_ACCESS_MEMORY_AAMPOSTINCREMENT_LENGTH 1
#define AC_ACCESS_MEMORY_AAMPOSTINCREMENT   0x80000
#define AC_ACCESS_MEMORY_WRITE_OFFSET       0x10
#define AC_ACCESS_MEMORY_WRITE_LENGTH       1
#define AC_ACCESS_MEMORY_WRITE              0x10000
/*
 * arg0: Copy data from the memory location specified in {\tt arg1} into
 * the low bits of {\tt arg0}. The value of the remaining bits of
 * {\tt arg0} are \unspecified.
 */
#define AC_ACCESS_MEMORY_WRITE_ARG0         0
/*
 * memory: Copy data from the low bits of {\tt arg0} into the memory
 * location specified in {\tt arg1}.
 */
#define AC_ACCESS_MEMORY_WRITE_MEMORY       1
/*
 * These bits are reserved for target-specific uses.
 */
#define AC_ACCESS_MEMORY_TARGET_SPECIFIC_OFFSET 0xe
#define AC_ACCESS_MEMORY_TARGET_SPECIFIC_LENGTH 2
#define AC_ACCESS_MEMORY_TARGET_SPECIFIC    0xc000
#define VIRT_PRIV                           virtual
/*
 * Contains the virtualization mode the hart was operating in when Debug
 * Mode was entered. The encoding is described in Table \ref{tab:privmode},
 * and matches the virtualization mode encoding from the Privileged Spec.
 * A user can write this value to change the hart's virtualization mode
 * when exiting Debug Mode.
 */
#define VIRT_PRIV_V_OFFSET                  2
#define VIRT_PRIV_V_LENGTH                  1
#define VIRT_PRIV_V                         4
/*
 * Contains the privilege mode the hart was operating in when Debug
 * Mode was entered. The encoding is described in Table
 * \ref{tab:privmode}, and matches the privilege mode encoding from
 * the Privileged Spec. A user can write this
 * value to change the hart's privilege mode when exiting Debug Mode.
 */
#define VIRT_PRIV_PRV_OFFSET                0
#define VIRT_PRIV_PRV_LENGTH                2
#define VIRT_PRIV_PRV                       3
#define DMI_SERCS                           0x34
/*
 * Number of supported serial ports.
 */
#define DMI_SERCS_SERIALCOUNT_OFFSET        0x1c
#define DMI_SERCS_SERIALCOUNT_LENGTH        4
#define DMI_SERCS_SERIALCOUNT               0xf0000000U
/*
 * Select which serial port is accessed by \RdmiSerrx and \RdmiSertx.
 */
#define DMI_SERCS_SERIAL_OFFSET             0x18
#define DMI_SERCS_SERIAL_LENGTH             3
#define DMI_SERCS_SERIAL                    0x7000000
#define DMI_SERCS_ERROR7_OFFSET             0x17
#define DMI_SERCS_ERROR7_LENGTH             1
#define DMI_SERCS_ERROR7                    0x800000
#define DMI_SERCS_VALID7_OFFSET             0x16
#define DMI_SERCS_VALID7_LENGTH             1
#define DMI_SERCS_VALID7                    0x400000
#define DMI_SERCS_FULL7_OFFSET              0x15
#define DMI_SERCS_FULL7_LENGTH              1
#define DMI_SERCS_FULL7                     0x200000
#define DMI_SERCS_ERROR6_OFFSET             0x14
#define DMI_SERCS_ERROR6_LENGTH             1
#define DMI_SERCS_ERROR6                    0x100000
#define DMI_SERCS_VALID6_OFFSET             0x13
#define DMI_SERCS_VALID6_LENGTH             1
#define DMI_SERCS_VALID6                    0x80000
#define DMI_SERCS_FULL6_OFFSET              0x12
#define DMI_SERCS_FULL6_LENGTH              1
#define DMI_SERCS_FULL6                     0x40000
#define DMI_SERCS_ERROR5_OFFSET             0x11
#define DMI_SERCS_ERROR5_LENGTH             1
#define DMI_SERCS_ERROR5                    0x20000
#define DMI_SERCS_VALID5_OFFSET             0x10
#define DMI_SERCS_VALID5_LENGTH             1
#define DMI_SERCS_VALID5                    0x10000
#define DMI_SERCS_FULL5_OFFSET              0xf
#define DMI_SERCS_FULL5_LENGTH              1
#define DMI_SERCS_FULL5                     0x8000
#define DMI_SERCS_ERROR4_OFFSET             0xe
#define DMI_SERCS_ERROR4_LENGTH             1
#define DMI_SERCS_ERROR4                    0x4000
#define DMI_SERCS_VALID4_OFFSET             0xd
#define DMI_SERCS_VALID4_LENGTH             1
#define DMI_SERCS_VALID4                    0x2000
#define DMI_SERCS_FULL4_OFFSET              0xc
#define DMI_SERCS_FULL4_LENGTH              1
#define DMI_SERCS_FULL4                     0x1000
#define DMI_SERCS_ERROR3_OFFSET             0xb
#define DMI_SERCS_ERROR3_LENGTH             1
#define DMI_SERCS_ERROR3                    0x800
#define DMI_SERCS_VALID3_OFFSET             0xa
#define DMI_SERCS_VALID3_LENGTH             1
#define DMI_SERCS_VALID3                    0x400
#define DMI_SERCS_FULL3_OFFSET              9
#define DMI_SERCS_FULL3_LENGTH              1
#define DMI_SERCS_FULL3                     0x200
#define DMI_SERCS_ERROR2_OFFSET             8
#define DMI_SERCS_ERROR2_LENGTH             1
#define DMI_SERCS_ERROR2                    0x100
#define DMI_SERCS_VALID2_OFFSET             7
#define DMI_SERCS_VALID2_LENGTH             1
#define DMI_SERCS_VALID2                    0x80
#define DMI_SERCS_FULL2_OFFSET              6
#define DMI_SERCS_FULL2_LENGTH              1
#define DMI_SERCS_FULL2                     0x40
#define DMI_SERCS_ERROR1_OFFSET             5
#define DMI_SERCS_ERROR1_LENGTH             1
#define DMI_SERCS_ERROR1                    0x20
#define DMI_SERCS_VALID1_OFFSET             4
#define DMI_SERCS_VALID1_LENGTH             1
#define DMI_SERCS_VALID1                    0x10
#define DMI_SERCS_FULL1_OFFSET              3
#define DMI_SERCS_FULL1_LENGTH              1
#define DMI_SERCS_FULL1                     8
/*
 * 1 when the debugger-to-core queue for serial port 0 has
 * over or underflowed. This bit will remain set until it is reset by
 * writing 1 to this bit.
 */
#define DMI_SERCS_ERROR0_OFFSET             2
#define DMI_SERCS_ERROR0_LENGTH             1
#define DMI_SERCS_ERROR0                    4
/*
 * 1 when the core-to-debugger queue for serial port 0 is not empty.
 */
#define DMI_SERCS_VALID0_OFFSET             1
#define DMI_SERCS_VALID0_LENGTH             1
#define DMI_SERCS_VALID0                    2
/*
 * 1 when the debugger-to-core queue for serial port 0 is full.
 */
#define DMI_SERCS_FULL0_OFFSET              0
#define DMI_SERCS_FULL0_LENGTH              1
#define DMI_SERCS_FULL0                     1
#define DMI_SERTX                           0x35
#define DMI_SERTX_DATA_OFFSET               0
#define DMI_SERTX_DATA_LENGTH               0x20
#define DMI_SERTX_DATA                      0xffffffffU
#define DMI_SERRX                           0x36
#define DMI_SERRX_DATA_OFFSET               0
#define DMI_SERRX_DATA_LENGTH               0x20
#define DMI_SERRX_DATA                      0xffffffffU
