# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 113-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53842);
 script_bugtraq_id(2116);
 script_cve_id("CVE-2002-0062");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 113-1 (ncurses)";
 script_name(name);

 desc = "The remote host is missing an update to ncurses
announced via advisory DSA 113-1.

Several buffer overflows were fixed in the 'ncurses' library in November
2000.  Unfortunately, one was missed.  This can lead to crashes when using
ncurses applications in large windows.

The Common Vulnerabilities and Exposures project (cve.mitre.org) has
assigned the name CVE-2002-0062 to this issue.

This problem has been fixed for the stable release of Debian in version
5.0-6.0potato2.  The testing and unstable releases contain ncurses 5.2,
which is not affected by this problem.

There are no known exploits for this problem, but we recommend that all
users upgrade ncurses immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20113-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 113-1 (ncurses)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ncurses-base", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ncurses-term", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libncurses5-dbg", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libncurses5-dev", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libncurses5", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ncurses-bin", ver:"5.0-6.0potato2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
