###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ston3d_prdts_detect_lin.nasl 2571 2009-06-02 09:53:29Z jun $
#
# StoneTrip Ston3D Standalone Player Version Detection (Lin)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800575);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("StoneTrip Ston3D Standalone Player Version Detection (Lin)");
  desc = "
  Overview: This script detects the installed version of StoneTrip Ston3D
  Standalone Player and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of StoneTrip Ston3D Standalone Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("Standalone Engine [0-9.]\\+");

# Set KB for Standalone Engine
sapName = find_file(file_name:"S3DEngine_Linux", file_path:"/",
                      useregex:TRUE, regexpar:"$", sock:sock);
if(sapName != NULL)
{
  foreach binaryName (sapName)
  {
    binaryName = chomp(binaryName);
    if(islocalhost())
    {
      garg[4] = binaryName;
      arg = garg;
    }
    else
    {
      arg = garg[0]+" "+garg[1]+" "+garg[2]+" "+
            raw_string(0x22)+garg[3]+raw_string(0x22)+" "+binaryName;
    }

    sapVer = get_bin_version(full_prog_name:grep, version_argv:arg, sock:sock,
                               ver_pattern:"([0-9.]+)");
    if(sapVer[1] != NULL)
    {
      set_kb_item(name:"Ston3D/Standalone/Player/Lin/Ver", value:sapVer[1]);
      security_note(data:"StoneTrip Ston3D Standalone Player version " + sapVer[1] + 
                    " running at location " + binaryName + " was detected on the host");
      break;
    }
  }
}
