/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AxisAttributes.h>
#include <DataNode.h>

// Type map format string
const char *AxisAttributes::TypeMapFormatString = "aaab";

// ****************************************************************************
// Method: AxisAttributes::AxisAttributes
//
// Purpose: 
//   Constructor for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAttributes::AxisAttributes() : 
    AttributeSubject(AxisAttributes::TypeMapFormatString)
{
    grid = false;
}

// ****************************************************************************
// Method: AxisAttributes::AxisAttributes
//
// Purpose: 
//   Copy constructor for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAttributes::AxisAttributes(const AxisAttributes &obj) : 
    AttributeSubject(AxisAttributes::TypeMapFormatString)
{
    title = obj.title;
    label = obj.label;
    tickMarks = obj.tickMarks;
    grid = obj.grid;

    SelectAll();
}

// ****************************************************************************
// Method: AxisAttributes::~AxisAttributes
//
// Purpose: 
//   Destructor for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAttributes::~AxisAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AxisAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAttributes& 
AxisAttributes::operator = (const AxisAttributes &obj)
{
    if (this == &obj) return *this;
    title = obj.title;
    label = obj.label;
    tickMarks = obj.tickMarks;
    grid = obj.grid;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AxisAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAttributes::operator == (const AxisAttributes &obj) const
{
    // Create the return value
    return ((title == obj.title) &&
            (label == obj.label) &&
            (tickMarks == obj.tickMarks) &&
            (grid == obj.grid));
}

// ****************************************************************************
// Method: AxisAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAttributes::operator != (const AxisAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxisAttributes::TypeName
//
// Purpose: 
//   Type name method for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AxisAttributes::TypeName() const
{
    return "AxisAttributes";
}

// ****************************************************************************
// Method: AxisAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxisAttributes *tmp = (const AxisAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxisAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxisAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AxisAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AxisAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxisAttributes(*this);
    else
        retval = new AxisAttributes;

    return retval;
}

// ****************************************************************************
// Method: AxisAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisAttributes::SelectAll()
{
    Select(ID_title,     (void *)&title);
    Select(ID_label,     (void *)&label);
    Select(ID_tickMarks, (void *)&tickMarks);
    Select(ID_grid,      (void *)&grid);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxisAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AxisAttributes.
    DataNode *node = new DataNode("AxisAttributes");

    if(completeSave || !FieldsEqual(ID_title, &defaultObject))
    {
        DataNode *titleNode = new DataNode("title");
        if(title.CreateNode(titleNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(titleNode);
        }
        else
            delete titleNode;
    }

    if(completeSave || !FieldsEqual(ID_label, &defaultObject))
    {
        DataNode *labelNode = new DataNode("label");
        if(label.CreateNode(labelNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(labelNode);
        }
        else
            delete labelNode;
    }

    if(completeSave || !FieldsEqual(ID_tickMarks, &defaultObject))
    {
        DataNode *tickMarksNode = new DataNode("tickMarks");
        if(tickMarks.CreateNode(tickMarksNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(tickMarksNode);
        }
        else
            delete tickMarksNode;
    }

    if(completeSave || !FieldsEqual(ID_grid, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("grid", grid));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxisAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxisAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("title")) != 0)
        title.SetFromNode(node);
    if((node = searchNode->GetNode("label")) != 0)
        label.SetFromNode(node);
    if((node = searchNode->GetNode("tickMarks")) != 0)
        tickMarks.SetFromNode(node);
    if((node = searchNode->GetNode("grid")) != 0)
        SetGrid(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisAttributes::SetTitle(const AxisTitles &title_)
{
    title = title_;
    Select(ID_title, (void *)&title);
}

void
AxisAttributes::SetLabel(const AxisLabels &label_)
{
    label = label_;
    Select(ID_label, (void *)&label);
}

void
AxisAttributes::SetTickMarks(const AxisTickMarks &tickMarks_)
{
    tickMarks = tickMarks_;
    Select(ID_tickMarks, (void *)&tickMarks);
}

void
AxisAttributes::SetGrid(bool grid_)
{
    grid = grid_;
    Select(ID_grid, (void *)&grid);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AxisTitles &
AxisAttributes::GetTitle() const
{
    return title;
}

AxisTitles &
AxisAttributes::GetTitle()
{
    return title;
}

const AxisLabels &
AxisAttributes::GetLabel() const
{
    return label;
}

AxisLabels &
AxisAttributes::GetLabel()
{
    return label;
}

const AxisTickMarks &
AxisAttributes::GetTickMarks() const
{
    return tickMarks;
}

AxisTickMarks &
AxisAttributes::GetTickMarks()
{
    return tickMarks;
}

bool
AxisAttributes::GetGrid() const
{
    return grid;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisAttributes::SelectTitle()
{
    Select(ID_title, (void *)&title);
}

void
AxisAttributes::SelectLabel()
{
    Select(ID_label, (void *)&label);
}

void
AxisAttributes::SelectTickMarks()
{
    Select(ID_tickMarks, (void *)&tickMarks);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_title:     return "title";
    case ID_label:     return "label";
    case ID_tickMarks: return "tickMarks";
    case ID_grid:      return "grid";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AxisAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_title:     return FieldType_att;
    case ID_label:     return FieldType_att;
    case ID_tickMarks: return FieldType_att;
    case ID_grid:      return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxisAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_title:     return "att";
    case ID_label:     return "att";
    case ID_tickMarks: return "att";
    case ID_grid:      return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxisAttributes &obj = *((const AxisAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_title:
        {  // new scope
        retval = (title == obj.title);
        }
        break;
    case ID_label:
        {  // new scope
        retval = (label == obj.label);
        }
        break;
    case ID_tickMarks:
        {  // new scope
        retval = (tickMarks == obj.tickMarks);
        }
        break;
    case ID_grid:
        {  // new scope
        retval = (grid == obj.grid);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

