<?php
/**
 * Copyright 2007-2013 Horde LLC (http://www.horde.org/)
 *
 * @category   Horde
 * @package    Http
 * @subpackage UnitTests
 * @license    http://www.horde.org/licenses/bsd
 */

/**
 * @category   Horde
 * @package    Http
 * @subpackage UnitTests
 * @license    http://www.horde.org/licenses/bsd
 */
class Horde_Http_FopenTest extends Horde_Test_Case
{
    private $_server;

    public function setUp()
    {
        $config = self::getConfig('HTTP_TEST_CONFIG');
        if ($config && !empty($config['http']['server'])) {
            $this->_server = $config['http']['server'];
        }
    }

    /**
     * @expectedException Horde_Http_Exception
     */
    public function testThrowsOnBadUri()
    {
        $client = new Horde_Http_Client(array('request' => new Horde_Http_Request_Fopen()));
        $client->get('http://doesntexist/');
    }

    /**
     * @expectedException Horde_Http_Exception
     */
    public function testThrowsOnInvalidProxyType()
    {
        $client = new Horde_Http_Client(
            array(
                'request' => new Horde_Http_Request_Fopen(
                    array(
                        'proxyServer' => 'localhost',
                        'proxyType' => Horde_Http::PROXY_SOCKS4
                    )
                )
            )
        );
        $client->get('http://www.example.com/');
    }

    /**
     * fopen requires a special stream context setting to be able to avoid just
     * throwing an exception after a 4xx or 5xx. Make sure that we're providing
     * access to the real request data.
     */
    public function testReturnsResponseInsteadOfExceptionOn404()
    {
        $this->_skipMissingConfig();
        $client = new Horde_Http_Client(array('request' => new Horde_Http_Request_Fopen()));
        $response = $client->get('http://' . $this->_server . '/doesntexist');
        $this->assertEquals(404, $response->code);
    }

    /**
     * fopen requires a special stream context setting to be able to avoid just
     * throwing an exception after a 4xx or 5xx. Make sure that we're providing
     * access to the real request data.
     */
    public function testGetBodyAfter404()
    {
        $this->_skipMissingConfig();
        $client = new Horde_Http_Client(array('request' => new Horde_Http_Request_Fopen()));
        $response = $client->get('http://' . $this->_server . '/doesntexist');
        $body = $response->getBody();
        $this->assertTrue(strlen($body) > 0);
    }

    private function _skipMissingConfig()
    {
        if (empty($this->_server)) {
            $this->markTestSkipped('Missing configuration!');
        }
    }
}
