<? $page = 2; include './header.inc' ?>
<u>About php_imlib</u>
<p>
The general idea behind php_imlib is to mimick the function names and their
parameters as closely as possible at the extension level.  However since
Imlib2 uses a singleton context that I'd rather not duplicate in the
extension, most functions will require extra parameters to establish context.
As we've developed php_imlib, a few needs have also come up which Imlib2
doesn't address.  In those cases we've defined functions in php_imlib which
aren't present in Imlib2.  So far we've added three functions:
<a href="documentation.php#imlib_dump_image">imlib_dump_image</a>, for
outputting an image to stdout (Comporable to GD's
<a href="http://www.php.net/manual/function.imagepng.php">ImagePng($im)</a>),
<a href="documentation.php#imlib_image_modify_alpha">imlib_image_modify_alpha</a>, and
<a href="documentation.php#imlib_create_scaled_image">imlib_create_scaled_image</a>,
a shortcut of imlib_create_cropped_scaled_image, which is ideal for creating a
scaled copy of the whole image quickly, such as for generating thumbnails.
</p><p>
To combat the need to have a large number parameters for some of the more
complex functions, I had written a single PHP class to wrap the extension in   
version 0.1. However as I developed 0.2, that clearly became insufficent.
So, starting with 0.2 I've included a handful of more reasonably sized classes
that spread things out nicely.  I'm fairly pleased with how they've turned out, but as
always, <a href="mailto:cardinal at dodds.net">feedback</a> is encouraged.
More extensive documentation on the classes is available in the
<a href="phpdoc/phpdoc_classtree.html">phpdoc</a> directory.
</p><p>
In the first release, I had also included an abstract image class that
allowed the use of GD and php_imlib with the same class.  At least for the
time being, that's been scrapped, since it was never implemented fully at
the time, and would've occupied far more time than it was worth this time
around.  So, I filed that one away under "bad idea".
</p>

<u>What's Wrong With GD?</u>
<p>
There's nothing wrong with <a href="http://www.boutell.com/gd/">GD</a>, I just
wanted an alternative.  Aside from that, Imlib2 is a faster, more powerful
library.
</p>

<u>Caveats</u>
<p>
Imlib2 is not thread safe.  While this isn't a large concern at the
moment, it will become a more important issue as Apache 2 develops and
threaded httpd installations become more common.
</p>
