# WebSocket programming with Autobahn on Twisted

This folder contains complete working code examples that demonstrate [WebSocket](http://crossbario.com/blog/post/websocket-why-what-can-i-use-it/) programming with **Autobahn**|Python on [Twisted](http://www.twistedmatrix.com/):

 1. [WebSocket Echo](echo)
 1. [Slow Square](slowsquare)
 1. [Testee](testee)

and

 1. [Broadcasting over WebSocket](broadcast)
 1. [WebSocket Compression](echo_compressed)
 1. [WebSocket over Twisted Endpoints](echo_endpoints)
 1. [Using HTTP Headers with WebSocket](echo_httpheaders)
 1. [WebSocket on Multicore](echo_multicore)
 1. [WebSocket as a Twisted Service](echo_service)
 1. [Running WebSocket under Twisted Web](echo_site)
 1. [Running secure WebSocket under Twisted Web](echo_site_tls)
 1. [WebSocket Echo over secure WebSocket](echo_tls)
 1. [WebSocket Echo Variants](echo_variants)
 1. [WebSocket Fallbacks](echo_wsfallbacks)
 1. [WebSocket and WSGI/Flask](echo_wsgi)
 1. [Using multiple WebSocket Protocols](multiproto)
 1. [WebSocket Pings/Pongs](ping)
 1. [Streaming WebSocket](streaming)
 1. [Wrapping Twisted Protocol/Factories over WebSocket](wrapping)
