# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SchemaContract(Resource):
    """Schema Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param content_type: Required. Must be a valid a media type used in a
     Content-Type header as defined in the RFC 2616. Media type of the schema
     document (e.g. application/json, application/xml). </br> - `Swagger`
     Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br>
     - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> -
     `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> -
     `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
    :type content_type: str
    :param document: Properties of the Schema Document.
    :type document: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'content_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'document': {'key': 'properties.document', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(SchemaContract, self).__init__(**kwargs)
        self.content_type = kwargs.get('content_type', None)
        self.document = kwargs.get('document', None)
