from typing import Any as _Any

class error(Exception):
    msg: _Any
    pattern: _Any
    pos: _Any
    lineno: _Any
    colno: _Any
    def __init__(
        self, message, pattern: _Any | None = ..., pos: _Any | None = ...
    ) -> None: ...

class _UnscopedFlagSet(Exception): ...
class ParseError(Exception): ...
class _FirstSetError(Exception): ...

A: int

ASCII: int
B: int
BESTMATCH: int
D: int
DEBUG: int
E: int
ENHANCEMATCH: int
F: int
FULLCASE: int
I: int
IGNORECASE: int
L: int
LOCALE: int
M: int
MULTILINE: int
P: int
POSIX: int
R: int
REVERSE: int
S: int
DOTALL: int
U: int
UNICODE: int
V0: int
VERSION0: int
V1: int
VERSION1: int
W: int
WORD: int
X: int
VERBOSE: int
T: int
TEMPLATE: int
DEFAULT_VERSION = VERSION1

class Namespace: ...

class RegexBase:
    def __init__(self) -> None: ...
    def with_flags(
        self,
        positive: _Any | None = ...,
        case_flags: _Any | None = ...,
        zerowidth: _Any | None = ...,
    ): ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse) -> None: ...
    def has_simple_start(self): ...
    def compile(self, reverse: bool = ..., fuzzy: bool = ...): ...
    def is_empty(self): ...
    def __hash__(self): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def get_required_string(self, reverse): ...

class ZeroWidthBase(RegexBase):
    positive: _Any
    def __init__(self, positive: bool = ...) -> None: ...
    def get_firstset(self, reverse): ...
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...

class Any(RegexBase):
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...

class AnyAll(Any): ...
class AnyU(Any): ...

class Atomic(RegexBase):
    subpattern: _Any
    def __init__(self, subpattern) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...

class Boundary(ZeroWidthBase): ...

class Branch(RegexBase):
    branches: _Any
    def __init__(self, branches) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...

class CallGroup(RegexBase):
    info: _Any
    group: _Any
    position: _Any
    def __init__(self, info, group, position) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def remove_captures(self) -> None: ...
    def dump(self, indent, reverse) -> None: ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def __del__(self) -> None: ...

class CallRef(RegexBase):
    ref: _Any
    parsed: _Any
    def __init__(self, ref, parsed) -> None: ...

class Character(RegexBase):
    value: _Any
    positive: _Any
    case_flags: _Any
    zerowidth: _Any
    folded: _Any
    def __init__(
        self,
        value,
        positive: bool = ...,
        case_flags=...,
        zerowidth: bool = ...,
    ) -> None: ...
    def rebuild(self, positive, case_flags, zerowidth): ...
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def matches(self, ch): ...
    def max_width(self): ...
    folded_characters: _Any
    def get_required_string(self, reverse): ...

class Conditional(RegexBase):
    info: _Any
    group: _Any
    yes_item: _Any
    no_item: _Any
    position: _Any
    def __init__(self, info, group, yes_item, no_item, position) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self) -> None: ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def __del__(self) -> None: ...

class DefaultBoundary(ZeroWidthBase): ...
class DefaultEndOfWord(ZeroWidthBase): ...
class DefaultStartOfWord(ZeroWidthBase): ...
class EndOfLine(ZeroWidthBase): ...
class EndOfLineU(EndOfLine): ...
class EndOfString(ZeroWidthBase): ...
class EndOfStringLine(ZeroWidthBase): ...
class EndOfStringLineU(EndOfStringLine): ...
class EndOfWord(ZeroWidthBase): ...
class Failure(ZeroWidthBase): ...

class Fuzzy(RegexBase):
    subpattern: _Any
    constraints: _Any
    def __init__(self, subpattern, constraints: _Any | None = ...) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def contains_group(self): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...

class Grapheme(RegexBase):
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...

class GraphemeBoundary:
    def compile(self, reverse, fuzzy): ...

class GreedyRepeat(RegexBase):
    subpattern: _Any
    min_count: _Any
    max_count: _Any
    def __init__(self, subpattern, min_count, max_count) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...

class PossessiveRepeat(GreedyRepeat):
    def is_atomic(self): ...
    def dump(self, indent, reverse) -> None: ...

class Group(RegexBase):
    info: _Any
    group: _Any
    subpattern: _Any
    call_ref: _Any
    def __init__(self, info, group, subpattern) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...
    def __del__(self) -> None: ...

class Keep(ZeroWidthBase): ...
class LazyRepeat(GreedyRepeat): ...

class LookAround(RegexBase):
    behind: _Any
    positive: _Any
    subpattern: _Any
    def __init__(self, behind, positive, subpattern) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...

class LookAroundConditional(RegexBase):
    behind: _Any
    positive: _Any
    subpattern: _Any
    yes_item: _Any
    no_item: _Any
    def __init__(
        self, behind, positive, subpattern, yes_item, no_item
    ) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self) -> None: ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...

class PrecompiledCode(RegexBase):
    code: _Any
    def __init__(self, code) -> None: ...

class Property(RegexBase):
    value: _Any
    positive: _Any
    case_flags: _Any
    zerowidth: _Any
    def __init__(
        self,
        value,
        positive: bool = ...,
        case_flags=...,
        zerowidth: bool = ...,
    ) -> None: ...
    def rebuild(self, positive, case_flags, zerowidth): ...
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def matches(self, ch): ...
    def max_width(self): ...

class Prune(ZeroWidthBase): ...

class Range(RegexBase):
    lower: _Any
    upper: _Any
    positive: _Any
    case_flags: _Any
    zerowidth: _Any
    def __init__(
        self,
        lower,
        upper,
        positive: bool = ...,
        case_flags=...,
        zerowidth: bool = ...,
    ) -> None: ...
    def rebuild(self, positive, case_flags, zerowidth): ...
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def dump(self, indent, reverse) -> None: ...
    def matches(self, ch): ...
    def max_width(self): ...

class RefGroup(RegexBase):
    info: _Any
    group: _Any
    position: _Any
    case_flags: _Any
    def __init__(self, info, group, position, case_flags=...) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def remove_captures(self) -> None: ...
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...
    def __del__(self) -> None: ...

class SearchAnchor(ZeroWidthBase): ...

class Sequence(RegexBase):
    items: _Any
    def __init__(self, items: _Any | None = ...) -> None: ...
    def fix_groups(self, pattern, reverse, fuzzy) -> None: ...
    def optimise(self, info, reverse): ...
    def pack_characters(self, info): ...
    def remove_captures(self): ...
    def is_atomic(self): ...
    def can_be_affix(self): ...
    def contains_group(self): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def is_empty(self): ...
    def __eq__(self, other): ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...

class SetBase(RegexBase):
    info: _Any
    items: _Any
    positive: _Any
    case_flags: _Any
    zerowidth: _Any
    char_width: int
    def __init__(
        self,
        info,
        items,
        positive: bool = ...,
        case_flags=...,
        zerowidth: bool = ...,
    ) -> None: ...
    def rebuild(self, positive, case_flags, zerowidth): ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...
    def __del__(self) -> None: ...

class SetDiff(SetBase):
    items: _Any
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def matches(self, ch): ...

class SetInter(SetBase):
    items: _Any
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def matches(self, ch): ...

class SetSymDiff(SetBase):
    items: _Any
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def matches(self, ch): ...

class SetUnion(SetBase):
    items: _Any
    def optimise(self, info, reverse, in_set: bool = ...): ...
    def matches(self, ch): ...

class Skip(ZeroWidthBase): ...
class StartOfLine(ZeroWidthBase): ...
class StartOfLineU(StartOfLine): ...
class StartOfString(ZeroWidthBase): ...
class StartOfWord(ZeroWidthBase): ...

class String(RegexBase):
    characters: _Any
    case_flags: _Any
    folded_characters: _Any
    required: bool
    def __init__(self, characters, case_flags=...) -> None: ...
    def get_firstset(self, reverse): ...
    def has_simple_start(self): ...
    def dump(self, indent, reverse) -> None: ...
    def max_width(self): ...
    def get_required_string(self, reverse): ...

class Literal(String):
    def dump(self, indent, reverse) -> None: ...

class StringSet(Branch):
    info: _Any
    name: _Any
    case_flags: _Any
    set_key: _Any
    branches: _Any
    def __init__(self, info, name, case_flags=...) -> None: ...
    def dump(self, indent, reverse) -> None: ...
    def __del__(self) -> None: ...

class Source:
    string: _Any
    char_type: _Any
    pos: int
    ignore_space: bool
    sep: _Any
    def __init__(self, string): ...
    def get(self, override_ignore: bool = ...): ...
    def get_many(self, count: int = ...): ...
    def get_while(self, test_set, include: bool = ...): ...
    def skip_while(self, test_set, include: bool = ...) -> None: ...
    def match(self, substring): ...
    def expect(self, substring) -> None: ...
    def at_end(self): ...

class Info:
    flags: _Any
    global_flags: _Any
    inline_locale: bool
    kwargs: _Any
    group_count: int
    group_index: _Any
    group_name: _Any
    char_type: _Any
    named_lists_used: _Any
    open_groups: _Any
    open_group_count: _Any
    defined_groups: _Any
    group_calls: _Any
    private_groups: _Any
    def __init__(
        self, flags: int = ..., char_type: _Any | None = ..., kwargs=...
    ) -> None: ...
    def open_group(self, name: _Any | None = ...): ...
    def close_group(self) -> None: ...
    def is_open_group(self, name): ...

class Scanner:
    lexicon: _Any
    scanner: _Any
    def __init__(self, lexicon, flags: int = ...) -> None: ...
    match: _Any
    def scan(self, string): ...
