#
# PySNMP MIB module IPV6-TCP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/IPV6-TCP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:18:45 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint", "ConstraintsUnion")
( Ipv6IfIndexOrZero, Ipv6Address, ) = mibBuilder.importSymbols("IPV6-TC", "Ipv6IfIndexOrZero", "Ipv6Address")
( ObjectGroup, ModuleCompliance, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
( mib_2, IpAddress, Bits, Gauge32, MibIdentifier, ModuleIdentity, ObjectIdentity, iso, TimeTicks, Integer32, Counter64, Counter32, MibScalar, MibTable, MibTableRow, MibTableColumn, NotificationType, experimental, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "IpAddress", "Bits", "Gauge32", "MibIdentifier", "ModuleIdentity", "ObjectIdentity", "iso", "TimeTicks", "Integer32", "Counter64", "Counter32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "NotificationType", "experimental", "Unsigned32")
( DisplayString, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention")
ipv6TcpMIB = ModuleIdentity((1, 3, 6, 1, 3, 86))
if mibBuilder.loadTexts: ipv6TcpMIB.setLastUpdated('9801290000Z')
if mibBuilder.loadTexts: ipv6TcpMIB.setOrganization('IETF IPv6 MIB Working Group')
if mibBuilder.loadTexts: ipv6TcpMIB.setContactInfo('       Mike Daniele\n    \n                    Postal: Compaq Computer Corporation\n                            110 Spitbrook Rd\n                            Nashua, NH 03062.\n                            US\n    \n                    Phone:  +1 603 884 1423\n                    Email:  daniele@zk3.dec.com')
if mibBuilder.loadTexts: ipv6TcpMIB.setDescription('The MIB module for entities implementing TCP over IPv6.')
tcp = MibIdentifier((1, 3, 6, 1, 2, 1, 6))
ipv6TcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 6, 16), )
if mibBuilder.loadTexts: ipv6TcpConnTable.setDescription('A table containing TCP connection-specific information,\n            for only those connections whose endpoints are IPv6 addresses.')
ipv6TcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 16, 1), ).setIndexNames((0, "IPV6-TCP-MIB", "ipv6TcpConnLocalAddress"), (0, "IPV6-TCP-MIB", "ipv6TcpConnLocalPort"), (0, "IPV6-TCP-MIB", "ipv6TcpConnRemAddress"), (0, "IPV6-TCP-MIB", "ipv6TcpConnRemPort"), (0, "IPV6-TCP-MIB", "ipv6TcpConnIfIndex"))
if mibBuilder.loadTexts: ipv6TcpConnEntry.setDescription('A conceptual row of the ipv6TcpConnTable containing\n            information about a particular current TCP connection.\n            Each row of this table is transient, in that it ceases to\n            exist when (or soon after) the connection makes the transition\n            to the CLOSED state.\n    \n            Note that conceptual rows in this table require an additional\n            index object compared to tcpConnTable, since IPv6 addresses\n            are not guaranteed to be unique on the managed node.')
ipv6TcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 1), Ipv6Address())
if mibBuilder.loadTexts: ipv6TcpConnLocalAddress.setDescription('The local IPv6 address for this TCP connection. In\n            the case of a connection in the listen state which\n            is willing to accept connections for any IPv6\n            address associated with the managed node, the value\n            ::0 is used.')
ipv6TcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: ipv6TcpConnLocalPort.setDescription('The local port number for this TCP connection.')
ipv6TcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 3), Ipv6Address())
if mibBuilder.loadTexts: ipv6TcpConnRemAddress.setDescription('The remote IPv6 address for this TCP connection.')
ipv6TcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: ipv6TcpConnRemPort.setDescription('The remote port number for this TCP connection.')
ipv6TcpConnIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 5), Ipv6IfIndexOrZero())
if mibBuilder.loadTexts: ipv6TcpConnIfIndex.setDescription("An index object used to disambiguate conceptual rows in\n            the table, since the connection 4-tuple may not be unique.\n    \n            If the connection's remote address (ipv6TcpConnRemAddress)\n            is a link-local address and the connection's local address\n            (ipv6TcpConnLocalAddress) is not a link-local address, this\n            object identifies a local interface on the same link as\n            the connection's remote link-local address.\n    \n            Otherwise, this object identifies the local interface that\n            is associated with the ipv6TcpConnLocalAddress for this\n            TCP connection.  If such a local interface cannot be determined,\n            this object should take on the value 0.  (A possible example\n            of this would be if the value of ipv6TcpConnLocalAddress is ::0.)\n    \n            The interface identified by a particular non-0 value of this\n            index is the same interface as identified by the same value\n            of ipv6IfIndex.\n    \n            The value of this object must remain constant during the life\n            of the TCP connection.")
ipv6TcpConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 16, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,))).clone(namedValues=NamedValues(("closed", 1), ("listen", 2), ("synSent", 3), ("synReceived", 4), ("established", 5), ("finWait1", 6), ("finWait2", 7), ("closeWait", 8), ("lastAck", 9), ("closing", 10), ("timeWait", 11), ("deleteTCB", 12),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6TcpConnState.setDescription("The state of this TCP connection.\n    \n            The only value which may be set by a management station is\n            deleteTCB(12).  Accordingly, it is appropriate for an agent\n            to return an error response (`badValue' for SNMPv1, 'wrongValue'\n            for SNMPv2) if a management station attempts to set this\n            object to any other value.\n    \n            If a management station sets this object to the value\n            deleteTCB(12), then this has the effect of deleting the TCB\n            (as defined in RFC 793) of the corresponding connection on\n            the managed node, resulting in immediate termination of the\n            connection.\n    \n            As an implementation-specific option, a RST segment may be\n            sent from the managed node to the other TCP endpoint (note\n            however that RST segments are not sent reliably).")
ipv6TcpConformance = MibIdentifier((1, 3, 6, 1, 3, 86, 2))
ipv6TcpCompliances = MibIdentifier((1, 3, 6, 1, 3, 86, 2, 1))
ipv6TcpGroups = MibIdentifier((1, 3, 6, 1, 3, 86, 2, 2))
ipv6TcpCompliance = ModuleCompliance((1, 3, 6, 1, 3, 86, 2, 1, 1)).setObjects(*(("IPV6-TCP-MIB", "ipv6TcpGroup"),))
if mibBuilder.loadTexts: ipv6TcpCompliance.setDescription('The compliance statement for SNMPv2 entities which\n            implement TCP over IPv6.')
ipv6TcpGroup = ObjectGroup((1, 3, 6, 1, 3, 86, 2, 2, 1)).setObjects(*(("IPV6-TCP-MIB", "ipv6TcpConnState"),))
if mibBuilder.loadTexts: ipv6TcpGroup.setDescription('The group of objects providing management of\n            TCP over IPv6.')
mibBuilder.exportSymbols("IPV6-TCP-MIB", ipv6TcpConformance=ipv6TcpConformance, ipv6TcpMIB=ipv6TcpMIB, ipv6TcpCompliance=ipv6TcpCompliance, ipv6TcpConnRemAddress=ipv6TcpConnRemAddress, PYSNMP_MODULE_ID=ipv6TcpMIB, ipv6TcpConnState=ipv6TcpConnState, ipv6TcpConnTable=ipv6TcpConnTable, ipv6TcpConnLocalPort=ipv6TcpConnLocalPort, tcp=tcp, ipv6TcpConnRemPort=ipv6TcpConnRemPort, ipv6TcpConnLocalAddress=ipv6TcpConnLocalAddress, ipv6TcpGroup=ipv6TcpGroup, ipv6TcpConnIfIndex=ipv6TcpConnIfIndex, ipv6TcpCompliances=ipv6TcpCompliances, ipv6TcpConnEntry=ipv6TcpConnEntry, ipv6TcpGroups=ipv6TcpGroups)
