% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_to_bigwig.R
\name{bam_to_bigwig}
\alias{bam_to_bigwig}
\title{Convert a BAM file to a BigWig}
\usage{
bam_to_bigwig(
  bam_file,
  prefix = file.path(tempdir(), basename(bam_file)),
  min_unique_qual = FALSE,
  double_count = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{bam_file}{A \code{character(1)} with the path to the input BAM file.}

\item{prefix}{A \code{character(1)} specifying the output file prefix. This
function creates a BigWig file called \verb{\{prefix\}.all.bw}. By default, the
prefix is the BAM file name and the file is created in the \code{tempdir()} and
will be deleted after you close your R session.}

\item{min_unique_qual}{A \code{integer(1)} specifying a mapping quality threshold
and only bases above this will be used to generate the BigWig. If set to
\code{FALSE} this argument is not used by Megadepth. Otherwise it will generate
files \verb{\{prefix\}.unique.bw} and \verb{\{prefix\}.unique.tsv}.}

\item{double_count}{A \code{logical(1)} determining whether to count the
overlapping ends of paired ends reads twice.}

\item{overwrite}{A \code{logical(1)} specifying whether to overwrite the output
file(s), if they exist already.}
}
\value{
A \code{character()} with the path to the output files(s).
}
\description{
Given an input BAM file, convert this to the BigWig format which can then be
used in \code{get_coverage()}.
}
\details{
Note that this functionality is currently not supported on Windows by
Megadepth.
}
\examples{

## Install the latest version if necessary
install_megadepth(force = TRUE)

## Find the example BAM file
example_bam <- system.file("tests", "test.bam",
    package = "megadepth", mustWork = TRUE
)

## Create the BigWig file
## Currently Megadepth does not support this on Windows
if (!xfun::is_windows()) {
    example_bw <- bam_to_bigwig(example_bam, overwrite = TRUE)

    ## Path to the output file(s) generated by bam_to_bigwig()
    example_bw

    ## Use the all.bw file in get_coverage(), first find an annotation file
    annotation_file <- system.file("tests", "testbw2.bed",
        package = "megadepth", mustWork = TRUE
    )

    ## Compute the coverage
    bw_cov <- get_coverage(
        example_bw["all.bw"],
        op = "mean",
        annotation = annotation_file
    )
    bw_cov
}
}
